//
// FIFOBufferStream.h
//
// $Id: //poco/1.4/Foundation/include/Poco/FIFOBufferStream.h#1 $
//
// Library: Foundation
// Package: Streams
// Module:  FIFOBufferStream
//
// Definition of the FIFOBufferStream class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_FIFOBufferStream_INCLUDED
#define Foundation_FIFOBufferStream_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/FIFOBuffer.h"
#include "Poco/BufferedBidirectionalStreamBuf.h"
#include <istream>
#include <ostream>


namespace Poco {


class Foundation_API FIFOBufferStreamBuf: public BufferedBidirectionalStreamBuf
	/// This is the streambuf class used for reading from and writing to a FIFOBuffer.
	/// FIFOBuffer is enabled for emtpy/non-empty/full state transitions notifications.
{
public:
	
	FIFOBufferStreamBuf();
		/// Creates a FIFOBufferStreamBuf.

	explicit FIFOBufferStreamBuf(FIFOBuffer& fifoBuffer);
		/// Creates a FIFOBufferStreamBuf and assigns the given buffer to it.

	explicit FIFOBufferStreamBuf(char* pBuffer, std::size_t length);
		/// Creates a FIFOBufferStreamBuf and assigns the given buffer to it.

	explicit FIFOBufferStreamBuf(const char* pBuffer, std::size_t length);
		/// Creates a FIFOBufferStreamBuf and assigns the given buffer to it.

	explicit FIFOBufferStreamBuf(std::size_t length);
		/// Creates a FIFOBufferStreamBuf of the given length.

	~FIFOBufferStreamBuf();
		/// Destroys the FIFOBufferStreamBuf.

	FIFOBuffer& fifoBuffer();
		/// Returns the underlying FIFO buffer reference.

protected:
	int readFromDevice(char* buffer, std::streamsize length);
	int writeToDevice(const char* buffer, std::streamsize length);

private:
	enum 
	{
		STREAM_BUFFER_SIZE = 1024
	};

	FIFOBuffer* _pFIFOBuffer;
	FIFOBuffer& _fifoBuffer;
};


class Foundation_API FIFOIOS: public virtual std::ios
	/// The base class for FIFOBufferInputStream and
	/// FIFOBufferStream.
	///
	/// This class is needed to ensure the correct initialization
	/// order of the stream buffer and base classes.
{
public:
	explicit FIFOIOS(FIFOBuffer& buffer);
		/// Creates a FIFOIOS and assigns the given buffer to it.

	explicit FIFOIOS(char* pBuffer, std::size_t length);
		/// Creates a FIFOIOS and assigns the given buffer to it.

	explicit FIFOIOS(const char* pBuffer, std::size_t length);
		/// Creates a FIFOIOS and assigns the given buffer to it.

	explicit FIFOIOS(std::size_t length);
		/// Creates a FIFOIOS of the given length.
		
	~FIFOIOS();
		/// Destroys the FIFOIOS.
		///
		/// Flushes the buffer.
		
	FIFOBufferStreamBuf* rdbuf();
		/// Returns a pointer to the internal FIFOBufferStreamBuf.
		
	void close();
		/// Flushes the stream.

protected:
	FIFOBufferStreamBuf _buf;
};


class Foundation_API FIFOBufferStream: public FIFOIOS, public std::iostream
	/// An output stream for writing to a FIFO.
{
public:
	Poco::BasicEvent<bool>& readable;
	Poco::BasicEvent<bool>& writable;

	explicit FIFOBufferStream(FIFOBuffer& buffer);
		/// Creates the FIFOBufferStream with supplied buffer as initial value.

	explicit FIFOBufferStream(char* pBuffer, std::size_t length);
		/// Creates a FIFOBufferStream and assigns the given buffer to it.

	explicit FIFOBufferStream(const char* pBuffer, std::size_t length);
		/// Creates a FIFOBufferStream and assigns the given buffer to it.

	explicit FIFOBufferStream(std::size_t length);
		/// Creates a FIFOBufferStream of the given length.

	~FIFOBufferStream();
		/// Destroys the FIFOBufferStream.
		///
		/// Flushes the buffer.

private:
	FIFOBufferStream();
	FIFOBufferStream(const FIFOBufferStream& other);
	FIFOBufferStream& operator =(const FIFOBufferStream& other);
};


///
/// inlines
///


inline FIFOBuffer& FIFOBufferStreamBuf::fifoBuffer()
{
	return _fifoBuffer;
}


} // namespace Poco


#endif // Foundation_FIFOBufferStream_INCLUDED
