float4x4 WorldViewProj;        // [h~r[~ˉeϊs
float4   ViewPos;              // _(f)
float4   LightPos;             // ̈ʒu(f)
float    LightBrightness;      // ̋Px
float    ModelScale;           // fԂ̃XP[
float4   Diffuse;              // fBt[YF
float4   BlendMapDiffuse;      // }bvƃfBt[YF̊

// _VF[_
void TVertexShader(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inNormal   : NORMAL0,     // [] @xNg
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outDiff    : COLOR0,      // [o] F
    out float4 outTexture : TEXCOORD0,       // [o] eNX`W
    out float4 outCubeTexture : TEXCOORD1)   // [o] eNX`W(}bvp)
{
    // _r[Ԃɕϊ
    outPos  = mul(inPos, WorldViewProj);

    // fBt[YFvZ(_)
    float4 vL = LightPos - inPos;            // xNg
    float  lengL = length(vL) * ModelScale;  // xNg̒(ւ̋)
    float4 normL = normalize(vL);            // xNg(PʃxNg)
    float4 normN = normalize(inNormal);      // @xNg(PʃxNg)
    float  L = LightBrightness * dot(normN, normL) / (lengL * lengL);  // ̋
    outDiff = Diffuse * max(0, L);           // fBt[YF

    // eNX`W͂̂܂
    outTexture  = inTexture;

    // L[u}bvpeNX`W
    float4 vI = normalize(ViewPos - inPos);   // xNg
    outCubeTexture = reflect(vI, normN);      // ˃xNgvZ
}

texture Tex;              // sNZVF[_ŎgeNX`
sampler TexSampler = sampler_state      // eNX`ETv
{
    Texture   = (Tex);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

texture CubeTex;         // }bvpeNX`
sampler CubeTexSampler = sampler_state
{
    Texture = (CubeTex);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

// sNZEVF[_(eNX`)
void TPixelShader_Texture(
    in  float4 inDiff     : COLOR0,        // [] F
    in  float2 inTexture     : TEXCOORD0,  // [] eNX`W
    in  float3 inCubeTexture : TEXCOORD1,  // [] eNX`W(}bv)

    out float4 outDiff    : COLOR0)        // [o] F
{
    float4 Diff = inDiff * tex2D(TexSampler, inTexture);      // eNX`ǂݍ(fBt[YFvZ)
    float4 CubeMap = texCUBE(CubeTexSampler, inCubeTexture);  // }bvǂݍ
    outDiff = lerp(Diff, CubeMap, BlendMapDiffuse);
}

// sNZEVF[_(eNX`Ȃ)
void TPixelShader_NoTexture(
    in  float4 inDiff     : COLOR0,        // [] F
    in  float3 inCubeTexture : TEXCOORD1,  // [] eNX`W(}bv)

    out float4 outDiff    : COLOR0)        // [o] F
{
    float4 CubeMap = texCUBE(CubeTexSampler, inCubeTexture);  // }bvǂݍ
    outDiff = lerp(inDiff, CubeMap, BlendMapDiffuse);
}

// sNZEVF[_(}bv̂)
void TPixelShader_CubeTextureOnly(
    in  float3 inCubeTexture : TEXCOORD1,  // [] eNX`W(}bv)

    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = texCUBE(CubeTexSampler, inCubeTexture);  // }bvǂݍ
}

// eNjbN̒`
technique Texter_Tech        // eNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader_Texture();   // sNZEVF[_̐ݒ
    }
}

technique NoTexter_Tech        // eNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
       VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 TPixelShader_NoTexture();   // sNZEVF[_̐ݒ
    }
}

technique CubeTexterOnly_Tech        // eNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
       VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 TPixelShader_CubeTextureOnly();   // sNZEVF[_̐ݒ
    }
}
