float4x4 WorldViewProj;        // [h~r[~ˉeϊs

// _VF[_
void TVertexShader(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outTexture : TEXCOORD0)   // [o] eNX`W
{
    // _r[Ԃɕϊ
    outPos  = mul(inPos, WorldViewProj);

    // eNX`W͂̂܂
    outTexture  = inTexture;
}

texture Tex;              // sNZVF[_ŎgeNX`
sampler TexSampler = sampler_state      // eNX`ETv
{
    Texture   = (Tex);
};

// sNZEVF[_
void TPixelShader(
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = tex2D(TexSampler, inTexture);  // eNX`ǂݍ
}

// eNjbN̒`
technique Normal            // eNjbN
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        Wrap0 = 0;                    // bsOE[hȂ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}

technique WRAP_U            // eNjbN(bv)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        Wrap0 = U;                // bsOE[h

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}

technique WRAP_V            // eNjbN(bv)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        Wrap0 = V;                    // bsOE[h

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}

technique WRAP_UV            // eNjbN(bv)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        Wrap0 = U | V;                // bsOE[h

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}
