float4x4 WorldViewProj;        // [h~r[~ˉeϊs
float4   LightPos;             // ̈ʒu(f)
float    LightBrightness;      // ̋Px
float    ModelScale;           // fԂ̃XP[
float4   Diffuse;              // fBt[YF

// _VF[_(_)
void VertexShader_Point(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inNormal   : NORMAL0,     // [] @xNg
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outDiff    : COLOR0,      // [o] F
    out float4 outTexture : TEXCOORD0)   // [o] eNX`W
{
    // _r[Ԃɕϊ
    outPos  = mul(inPos, WorldViewProj);

    // fBt[YFvZ(_)
    float4 vL = LightPos - inPos;            // xNg
    float  lengL = length(vL) * ModelScale;  // xNg̒(ւ̋)
    float4 normL = normalize(vL);            // xNg(PʃxNg)
    float4 normN = normalize(inNormal);      // @xNg(PʃxNg)
    float  L = LightBrightness * dot(normN, normL) / (lengL * lengL);  // ̋
    outDiff = Diffuse * max(0, L);           // fBt[YF

    // eNX`W͂̂܂
    outTexture  = inTexture;
}

// _VF[_(s)
void VertexShader_Directional(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inNormal   : NORMAL0,     // [] @xNg
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outDiff    : COLOR0,      // [o] F
    out float4 outTexture : TEXCOORD0)   // [o] eNX`W
{
    // _r[Ԃɕϊ
    outPos  = mul(inPos, WorldViewProj);

    // fBt[YFvZ(s)
    float4 normL = normalize(LightPos); // xNg(PʃxNg)
    float4 normN = normalize(inNormal); // @xNg(PʃxNg)
    float  L = dot(normN, normL);       // ̋
    outDiff = Diffuse * max(0, L);      // fBt[YF

    // eNX`W͂̂܂
    outTexture  = inTexture;
}

texture Tex;              // sNZVF[_ŎgeNX`
sampler TexSampler = sampler_state      // eNX`ETv
{
    Texture   = (Tex);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

// sNZEVF[_(eNX`)
void PixelShader_Texture(
    in  float4 inDiff     : COLOR0,        // [] F
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = inDiff * tex2D(TexSampler, inTexture);  // eNX`ǂݍ
}

// sNZEVF[_(eNX`Ȃ)
void PixelShader_NoTexture(
    in  float4 inDiff     : COLOR0,        // [] F
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = inDiff;
}

// eNjbN̒`
technique Point            // eNjbN(_BeNX`Ȃ)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
       VertexShader = compile vs_2_0 VertexShader_Point();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 PixelShader_NoTexture();   // sNZEVF[_̐ݒ
    }
}

technique Point_Texture        // eNjbN(_BeNX`)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
       VertexShader = compile vs_2_0 VertexShader_Point();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 PixelShader_Texture();   // sNZEVF[_̐ݒ
    }
}

technique Directional        // eNjbN(sBeNX`Ȃ)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
       VertexShader = compile vs_2_0 VertexShader_Directional();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 PixelShader_NoTexture();   // sNZEVF[_̐ݒ
    }
}

technique Directional_Texture        // eNjbN(sBeNX`)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        // VF[_ݒ
       VertexShader = compile vs_2_0 VertexShader_Directional();  // _VF[_̐ݒ
       PixelShader  = compile ps_2_0 PixelShader_Texture();   // sNZEVF[_̐ݒ
    }
}
