// ******************************** |CgEXvCgp *******************
float4x4 WorldViewProj;        // [h~r[~ˉeϊs
float    fTime;                // oߎ

// _VF[_()
void TVertexShader(
    in  float4 inPos      : POSITION,    // [] 
    in  float  inCycle    : BLENDWEIGHT, // [] 

    out float2 outTexture : TEXCOORD0,   // [] eNX`W
    out float4 outPos     : POSITION)    // [o] W(ˉe)
{
    // WvZ
    float t = fmod(fTime, inCycle);
    float4 p;
    p.x = inPos.x * t;
    p.y = (inPos.y - 0.5f * 0.98f * t) * t;
    p.z = inPos.z * t;
    p.w = inPos.w;

    // _r[Ԃɕϊ
    outPos = mul(p, WorldViewProj);
    
    // G[̂߂ɃeNX`Wo͂
    outTexture = float2(1.0f,1.0f);
}

// _VF[_(e)
void TVertexShader2(
    in  float4 inPos      : POSITION,    // [] 
    in  float  inCycle    : BLENDWEIGHT, // [] 

    out float2 outTexture : TEXCOORD0,   // [] eNX`W
    out float4 outPos     : POSITION)    // [o] W(ˉe)
{
    // WvZ
    float t = fmod(fTime, inCycle);
    float4 p;
    p.x = inPos.x * t;
    p.y = 0.0f;
    p.z = inPos.z * t;
    p.w = inPos.w;

    // _r[Ԃɕϊ
    outPos = mul(p, WorldViewProj);
    
    // G[̂߂ɃeNX`Wo͂
    outTexture = float2(1.0f,1.0f);
}

texture Tex;              // sNZVF[_ŎgeNX`
sampler TexSampler = sampler_state      // eNX`ETv
{
    Texture   = (Tex);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

// sNZEVF[_
void TPixelShader(
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W

    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = tex2D(TexSampler, inTexture);  // eNX`ǂݍ
}

// ******************************** `p *******************
//float4x4 WorldViewProj;      // [h~r[~ˉeϊs(`ς)
float4   LightPos;             // ̈ʒu(f)
float    LightBrightness;      // ̋Px
float    ModelScale;           // fԂ̃XP[
float4   Diffuse;              // fBt[YF

// _VF[_(_)
void TVertexShaderFloor(
    in  float4 inPos      : POSITION,    // [] W(f)
    in  float4 inNormal   : NORMAL0,     // [] @xNg
    in  float4 inTexture  : TEXCOORD0,   // [] eNX`W

    out float4 outPos     : POSITION,    // [o] W(ˉe)
    out float4 outDiff    : COLOR0,      // [o] F
    out float4 outTexture : TEXCOORD0)   // [o] eNX`W
{
    // _r[Ԃɕϊ
    outPos  = mul(inPos, WorldViewProj);

    // fBt[YFvZ(_)
    float4 vL = LightPos - inPos;            // xNg
    float  lengL = length(vL) * ModelScale;  // xNg̒(ւ̋)
    float4 normL = normalize(vL);            // xNg(PʃxNg)
    float4 normN = normalize(inNormal);      // @xNg(PʃxNg)
    float  L = LightBrightness * dot(normN, normL) / (lengL * lengL);  // ̋
    outDiff = Diffuse * max(0, L);           // fBt[YF

    // eNX`W͂̂܂
    outTexture  = inTexture;
}

texture TexFloor;              // sNZVF[_ŎgeNX`
sampler TexFloorSampler = sampler_state      // eNX`ETv
{
    Texture   = (TexFloor);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

// sNZEVF[_
void TPixelShaderFloor(
    in  float4 inDiff     : COLOR0,        // [] F
    in  float2 inTexture  : TEXCOORD0,     // [] eNX`W
    out float4 outDiff    : COLOR0)        // [o] F
{
    outDiff = inDiff * tex2D(TexFloorSampler, inTexture);  // eNX`ǂݍ
}

// ************************** eNjbN̒` *******************
technique PointList_Tech        // eNjbN(|CgEXvCg`p)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = FALSE;              // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        PointSpriteEnable = TRUE;     // |CgEXvCgL(ꖇ̃eNX`Ŝ\)
        PointScaleEnable = TRUE;      // JԂ̃TCY
        PointSize = 16.0f;            // |CgEXvCg̑傫

        AlphaBlendEnable = TRUE;      // At@EufBOLɂ
        SrcBlend = ONE;               // `挳(|S)At@EufBO̐ݒ
        DestBlend = ONE;              // `(t[obt@)At@EufBOݒ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}

technique PointList2_Tech        // eNjbN(|CgEXvCg`p)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = FALSE;              // Zobt@̐ݒ
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        PointSpriteEnable = TRUE;     // |CgEXvCgL(ꖇ̃eNX`Ŝ\)
        PointScaleEnable = TRUE;      // JԂ̃TCY
        PointSize = 16.0f;            // |CgEXvCg̑傫

        AlphaBlendEnable = TRUE;      // At@EufBOLɂ
        SrcBlend = ZERO;              // `挳(|S)At@EufBO̐ݒ
        DestBlend = INVSRCCOLOR;     // `(t[obt@)At@EufBOݒ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShader2();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShader();   // sNZEVF[_̐ݒ
    }
}

technique Floor_Tech        // eNjbN(f𕁒ʂɕ`悷)
{
    pass Pass0             // 1Ԗڂ̃pX
    {
        // Xe[gݒ
        ZEnable = TRUE;               // Zobt@̐ݒ
        ZWriteEnable = TRUE;          // Zobt@֏
        MultiSampleAntialias = TRUE;  // }`ETvO̐ݒ
        CullMode = CCW;               // wʃJO
        ShadeMode = GOURAUD;          // O[[EVF[fBOɐݒ

        PointSpriteEnable = FALSE;     // |CgEXvCg
        AlphaBlendEnable = FALSE;      // At@EufBO𖳌ɂ

        // VF[_ݒ
        VertexShader = compile vs_2_0 TVertexShaderFloor();  // _VF[_̐ݒ
        PixelShader  = compile ps_2_0 TPixelShaderFloor();   // sNZEVF[_̐ݒ
    }
}
