/*----------------------------------------------------------
	DirectSoundTv
		EMicrosoft DirectX SDK (February 2007)
		EVisual Studio 2005 Standard
		EWindows XP or Windows Vista
		Ή

	DSSample05.cpp
		uDXUTDirectSoundT|[gNXgp(1)@X^eBbNEobt@v
--------------------------------------------------------------*/

// rand_s̎gp
#define _CRT_RAND_S
#include <stdlib.h>
#include <crtdbg.h>

// DirectSoundpt@CCN[h
#define STRICT
#include <windows.h>
#include <crtdbg.h>
#include <mmsystem.h>
#include <mmreg.h>
#include <dsound.h>
#include <dxerr.h>

#pragma warning( disable : 4996 ) // disable deprecated warning 
#include <strsafe.h>
#pragma warning( default : 4996 ) 

#define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }

// DirectSoundpCũN
#pragma comment( lib, "dsound.lib" )
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "winmm.lib" )

// DXUT OptionalCSoundNXCWaveFileNXgp
#define DXUT_AUTOLIB    // Direct3DpCũNw
#include "DXUT.h"
#include "SDKsound.h"
#include "SDKwavefile.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// \[X
#include "resource.h"

#define WAVEFILENAME_1	L"..\\..\\Media\\Life1.wav"
#define WAVEFILENAME_2	L"..\\..\\Media\\Rock1.wav"

/*-------------------------------------------
	Oϐ
--------------------------------------------*/
HINSTANCE hInstApp;
HWND hwndApp;

WCHAR szAppName[] = L"DirectSound Sample 5";

// DXUTDirectSoundT|[gNX
CSoundManager *pSoundManager = NULL;
CSound *pSound1 = NULL;
CSound *pSound2 = NULL;

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[V
--------------------------------------------*/
bool InitApp(HINSTANCE hInst,int nCmdShow)
{
	WNDCLASS wndclass;

	hInstApp=hInst;

	/*EBhENX̓o^*/
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.hInstance		= hInst;
	wndclass.style			= CS_BYTEALIGNCLIENT|CS_VREDRAW|CS_HREDRAW;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;

	if(!RegisterClass(&wndclass))
		return FALSE;

	/*CEBhE*/
	hwndApp = CreateWindowEx(0, szAppName, szAppName,
							WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION,
							CW_USEDEFAULT,CW_USEDEFAULT,640,480,
							(HWND)NULL,(HMENU)NULL,
							hInst,(LPSTR)NULL);
	ShowWindow(hwndApp,nCmdShow);
	UpdateWindow(hwndApp);

	return TRUE;
}

/*-------------------------------------------
	DirectSound 
--------------------------------------------*/
bool InitDSound(void)
{
	HRESULT hr;

	// CSoundManageȑ
	pSoundManager = new CSoundManager();
	hr = pSoundManager->Initialize(hwndApp, DSSCL_PRIORITY);
	if (FAILED(hr)) {
		DXTRACE_ERR(L"CSoundManageȑɎs", hr);
		return false;
	}

	// vC}Eobt@̃tH[}bgݒ
	hr = pSoundManager->SetPrimaryBufferFormat(2, 44100, 16);
	if (FAILED(hr)) {
		DXTRACE_ERR(L"vC}Eobt@̃tH[}bgݒɎs", hr);
		return false;
	}

	return true;
}

/*-------------------------------------------
	TEhEobt@
--------------------------------------------*/
bool InitSoundBuffer(void)
{
	HRESULT hr;

	// WAVEFILENAME_1ǂݍŁAX^eBbNEobt@쐬
	hr = pSoundManager->Create(&pSound1, WAVEFILENAME_1, DSBCAPS_LOCDEFER, GUID_NULL, 5);
	if (FAILED(hr)) {
		DXTRACE_ERR(L"X^eBbNEobt@1̍쐬Ɏs", hr);
		return false;
	}

	// WAVEFILENAME_2ǂݍŁAX^eBbNEobt@쐬
	hr = pSoundManager->Create(&pSound2, WAVEFILENAME_2, DSBCAPS_CTRL3D | DSBCAPS_LOCDEFER, DS3DALG_DEFAULT, 5);
	if (FAILED(hr)) {
		DXTRACE_ERR(L"X^eBbNEobt@2̍쐬Ɏs", hr);
		return false;
	}

	return true;
}

/*-------------------------------------------
	TEhEobt@̉
--------------------------------------------*/
bool ReleaseSoundBuffer(void)
{
	// CSound̉
	SAFE_DELETE(pSound1);
	SAFE_DELETE(pSound2);

	return true;
}

/*-------------------------------------------
	DirectSound̉
--------------------------------------------*/
bool ReleaseDSound(void)
{
	//CSoundManager̉
	SAFE_DELETE(pSoundManager);

	return true;
}

/*-------------------------------------------
	AvP[V̏I
--------------------------------------------*/
bool EndApp(void)
{
	return true;
}


/*-------------------------------------------
	EBhE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam)
{
	HRESULT hr;

	switch(msg){
		case WM_KEYDOWN:
			switch(wParam){
				case VK_ESCAPE:
					DestroyWindow(hWnd);
					break;

				// TEh1̍Đ
				case '1':
					if (pSound1 != NULL) {
						 hr = pSound1->Play(0, DSBPLAY_LOOPING);
						 if (FAILED(hr))
							 DXTRACE_ERR(L"X^eBbNEobt@1̍ĐɎs", hr);
					}
					break;

				// TEh2̍Đ
				case '2':
					if (pSound2 != NULL) {
						unsigned int rx, rz;
						rand_s(&rx);
						rand_s(&rz);

						DS3DBUFFER DS3DBuffer;
						ZeroMemory(&DS3DBuffer, sizeof(DS3DBUFFER));
						DS3DBuffer.dwSize    = sizeof(DS3DBUFFER);
						DS3DBuffer.vPosition.x = ((rx * 10.0f) / UINT_MAX) - 5.0f;
						DS3DBuffer.vPosition.x = 0.0f;
						DS3DBuffer.vPosition.z = ((rz * 10.0f) / UINT_MAX) - 5.0f;
						DS3DBuffer.vVelocity.x = 0.0f;
						DS3DBuffer.vVelocity.y = 0.0f;
						DS3DBuffer.vVelocity.z = 0.0f;
						DS3DBuffer.dwInsideConeAngle  = DS3D_DEFAULTCONEANGLE;
						DS3DBuffer.dwOutsideConeAngle = DS3D_DEFAULTCONEANGLE;
						DS3DBuffer.vConeOrientation.x = 0.0f;
						DS3DBuffer.vConeOrientation.y = 0.0f;
						DS3DBuffer.vConeOrientation.z = 1.0f;
						DS3DBuffer.lConeOutsideVolume = 0;
						DS3DBuffer.flMinDistance = DS3D_DEFAULTMINDISTANCE;
						DS3DBuffer.flMaxDistance = DS3D_DEFAULTMAXDISTANCE;
						DS3DBuffer.dwMode        = DS3DMODE_NORMAL;

						hr = pSound2->Play3D(&DS3DBuffer, 0, DSBPLAY_LOOPING);
						if (FAILED(hr))
							DXTRACE_ERR(L"X^eBbNEobt@2̍ĐɎs", hr);
					}
					break;

				// TEh1,2̒~
				case '3':
					if (pSound1 != NULL)
						pSound1->Stop();
					if (pSound2 != NULL)
						pSound2->Stop();

				default:
					break;
			}
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		case WM_PAINT:
			{
				PAINTSTRUCT ps;
				HDC hDC = BeginPaint(hWnd, &ps);

				EndPaint(hWnd, &ps);
			}

		default:
			return DefWindowProc(hWnd,msg,wParam,lParam);
	}

	return 0L;
}

/*--------------------------------------------
	ACh̏
--------------------------------------------*/
bool AppIdle(void)
{
	return true;
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI WinMain(HINSTANCE hInst,HINSTANCE /*hPrevInst*/,LPSTR /*lpCmdLine*/,int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// AvP[VɊւ鏉
	bool flag = InitApp(hInst,nCmdShow);

	// DirectSoundɊւ鏉
	if (flag) flag = InitDSound();

	// TEhEobt@Ɋւ鏉
	if (flag) flag = InitSoundBuffer();

	MSG msg;
	msg.wParam = 0;
	while(flag){
		if(PeekMessage(&msg,0,0,0,PM_REMOVE)){
			if(msg.message == WM_QUIT)
				break;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else{
			// AChiʕ`j
			if (!AppIdle())
				// G[ꍇCAvP[VI
				PostQuitMessage(0);
		}
	}

	// TEhEobt@J
	ReleaseSoundBuffer();

	// DirectSound̏I
	ReleaseDSound();

	// AvP[V̏I
	EndApp();

	return (int)msg.wParam;
}
