/*----------------------------------------------------------
	DirectSoundTv
		EMicrosoft DirectX SDK (February 2007)
		EVisual Studio 2005 Standard
		EWindows XP or Windows Vista
		Ή

	DSSample04.cpp
		uGtFNggTEhĐv
--------------------------------------------------------------*/

// DirectSoundpt@CCN[h
#define STRICT
#include <windows.h>
#include <crtdbg.h>
#include <mmsystem.h>
#include <mmreg.h>
#include <dsound.h>
#include <dxerr.h>

#pragma warning( disable : 4996 ) // disable deprecated warning 
#include <strsafe.h>
#pragma warning( default : 4996 ) 

#define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }

// DirectSoundpCũN
#pragma comment( lib, "dsound.lib" )
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "winmm.lib" )

// DXUT OptionalCWaveFileNXgp
#define DXUT_AUTOLIB    // Direct3DpCũNw
#include "DXUT.h"
#include "SDKwavefile.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// \[X
#include "resource.h"

#define WAVEFILENAME	L"..\\..\\Media\\Life1.wav"

//#define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }

/*-------------------------------------------
	Oϐ
--------------------------------------------*/
HINSTANCE hInstApp;
HWND hwndApp;

WCHAR szAppName[] = L"DirectSound Sample 4";

WCHAR szEffectMessage[256] = L"";					// \镶
WCHAR szEffectLevelMessage[256] = L"";				//

LPDIRECTSOUND8       pDSound = NULL;
LPDIRECTSOUNDBUFFER  pDSPrimary = NULL; // vC}Eobt@IDirectSoundBufferC^[tFCXg
LPDIRECTSOUNDBUFFER8 pDSData = NULL;

// ݐݒ肳ĂGtFNg
enum EFFECT_TYPE { NONE,CHORUS,COMPRESSOR,
		DISTORTION,ECHO,FLANGER,GARGLE,PARAMEQ
} EffectType = NONE;

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[V
--------------------------------------------*/
bool InitApp(HINSTANCE hInst,int nCmdShow)
{
	HRESULT hr;
	WNDCLASS wndclass;

	hInstApp = hInst;

	// COM̏(DMOpɕKv)
	hr = CoInitialize(NULL);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"COM̏Ɏs", hr);
		return false;
	}

	/*EBhENX̓o^*/
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.hInstance		= hInst;
	wndclass.style			= CS_BYTEALIGNCLIENT|CS_VREDRAW|CS_HREDRAW;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;

	if(!RegisterClass(&wndclass))
		return FALSE;

	/*CEBhE*/
	hwndApp = CreateWindowEx(0, szAppName, szAppName,
							WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION,
							CW_USEDEFAULT,CW_USEDEFAULT,640,480,
							(HWND)NULL,(HMENU)NULL,
							hInst,(LPSTR)NULL);
	ShowWindow(hwndApp,nCmdShow);
	UpdateWindow(hwndApp);

	return TRUE;
}

/*-------------------------------------------
	WAVEt@CɃZJ_Eobt@
--------------------------------------------*/
bool CreateSoundData(LPTSTR pName)
{
	if (pDSound == NULL)
		return false;

	HRESULT hr;

	if (pDSData != NULL) {
		pDSData->Stop();
		SAFE_RELEASE(pDSData);
	}

	// WAVEt@CJ
	CWaveFile WaveFile;
	hr = WaveFile.Open(pName, NULL, WAVEFILE_READ);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"Wavet@C̃I[vɎs", hr);
		return false;
	}

	// ZJ_Eobt@쐬
	// DSBUFFERDESC\̂ݒ
	DSBUFFERDESC dsbdesc; 
	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = sizeof(DSBUFFERDESC); 
	dsbdesc.dwFlags = DSBCAPS_LOCDEFER | DSBCAPS_CTRLFX;	// GtFNgg
	dsbdesc.dwBufferBytes = WaveFile.GetSize();
	dsbdesc.lpwfxFormat = WaveFile.GetFormat();

	// obt@
	LPDIRECTSOUNDBUFFER pDSB;
	hr = pDSound->CreateSoundBuffer(&dsbdesc, &pDSB, NULL); 
	if (FAILED(hr))
	{ 
	    DXTRACE_ERR(L"obt@̍쐬Ɏs", hr);
		return false;
	}
	hr = pDSB->QueryInterface(IID_IDirectSoundBuffer8, (LPVOID*)&pDSData);
	SAFE_RELEASE(pDSB);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"IDirectSoundBuffer8C^[tFCX̎擾Ɏs", hr);
		return false;
	}

	// ZJ_Eobt@Wavef[^
	LPVOID lpvPtr1; 	// ŏ̃ubÑ|C^
	DWORD dwBytes1; 	// ŏ̃ubÑTCY
	LPVOID lpvPtr2; 	// QԖڂ̃ubÑ|C^
	DWORD dwBytes2; 	// QԖڂ̃ubÑTCY

	hr = pDSData->Lock(0, WaveFile.GetSize(), &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0); 

	// DSERR_BUFFERLOSTԂꂽꍇCRestore\bhgăobt@𕜌
	if(DSERR_BUFFERLOST == hr)
	{
		pDSData->Restore();
		hr = pDSData->Lock(0, WaveFile.GetSize(), &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
	} 
	if (SUCCEEDED(hr))
	{
	    // bN

	    // ŁCobt@ɏ
		// obt@Ƀf[^Rs[
		DWORD rsize;
		WaveFile.Read((LPBYTE)lpvPtr1, dwBytes1, &rsize);
		if ( 0 != dwBytes2 )
			WaveFile.Read((LPBYTE)lpvPtr2, dwBytes2, &rsize);

	   // ݂I炷UnlockD
	    hr = pDSData->Unlock(lpvPtr1, dwBytes1, lpvPtr2, dwBytes2); 
	}

	// ɍĐJn
	pDSData->Play(0, 0, DSBPLAY_LOOPING);

	return true;
}

/*-------------------------------------------
	DirectSound 
--------------------------------------------*/
bool InitDSound(void)
{
	HRESULT hr;

	// IDirectSound8C^[tFCX̎擾
	hr = DirectSoundCreate8(NULL, &pDSound, NULL);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"IDirectSound8C^[tFCX̎擾Ɏs", hr);
		return false;
	}

	//ŋxݒ
	hr = pDSound->SetCooperativeLevel(hwndApp, DSSCL_PRIORITY);
	if (FAILED(hr))
	{
	    // x̐ݒɎs
		DXTRACE_ERR(L"x̐ݒɎs", hr);
		return false;
	}

	// vC}Eobt@̍쐬
	// DSBUFFERDESC\̂ݒ
	DSBUFFERDESC dsbdesc; 
	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = sizeof(DSBUFFERDESC); 
	dsbdesc.dwFlags = DSBCAPS_PRIMARYBUFFER; 	// vC}Eobt@w
	dsbdesc.dwBufferBytes = 0;
	dsbdesc.lpwfxFormat = NULL;

	// obt@
	hr = pDSound->CreateSoundBuffer(&dsbdesc, &pDSPrimary, NULL); 
	if (FAILED(hr))
	{
	    // obt@̍쐬Ɏs
		DXTRACE_ERR(L"vC}Eobt@̍쐬Ɏs", hr);
		return false;
	}

	// vC}Eobt@WavetH[}bgݒ
	// @@@D拦xȏ̋xݒ肳ĂKv܂D
	WAVEFORMATEX pcmwf; 
	ZeroMemory(&pcmwf, sizeof(WAVEFORMATEX)); 
	pcmwf.wFormatTag = WAVE_FORMAT_PCM; 
	pcmwf.nChannels = 2;			// Q`liXeIj
	pcmwf.nSamplesPerSec = 44100;	// TvOE[g@44.1kHz
	pcmwf.nBlockAlign = 4;
	pcmwf.nAvgBytesPerSec = pcmwf.nSamplesPerSec * pcmwf.nBlockAlign; 
	pcmwf.wBitsPerSample = 16;		// 16rbg
	hr = pDSPrimary->SetFormat(&pcmwf);
	if(FAILED(hr))
	    DXTRACE_ERR(L"vC}Eobt@̃tH[}bgݒɎs", hr);

	return true;
}

/*-------------------------------------------
	TEhEobt@
--------------------------------------------*/
bool InitSoundBuffer(void)
{
	// WAVEt@CɃZJ_Eobt@쐬
	bool  f = CreateSoundData(WAVEFILENAME);
	if(!f)
	{
	    DXTRACE_MSG(L"ZJ_Eobt@̍쐬Ɏs");
		return false;
	}

	return true;
}

/*-------------------------------------------
	GtFNg̐ݒ菈
--------------------------------------------*/
bool InitDMEffect(GUID guidEffect, EFFECT_TYPE effect_type)
{
	if (pDSData==NULL)
		return false;

	HRESULT hr;

	//GtFNg̐ݒ̂߁AĐ~
	pDSData->Stop();

	// DirectSoundBufferɃGtFNgݒ肷
	DSEFFECTDESC dsEffect[1];
	dsEffect[0].dwSize = sizeof(DSEFFECTDESC);
	dsEffect[0].dwFlags = 0;
	dsEffect[0].guidDSFXClass = guidEffect;
	dsEffect[0].dwReserved1 = 0;
	dsEffect[0].dwReserved2 = 0;

	// GtFNgݒ肷
	DWORD dwResults[1];
	hr = pDSData->SetFX(1, dsEffect, dwResults);
	if (FAILED(hr))
		DXTRACE_ERR(L"GtFNg̐ݒɎs", hr);
	else
		EffectType = effect_type;

	switch (dwResults[0])
	{
	case DSFXR_LOCHARDWARE:
		StringCbCat(szEffectMessage, sizeof(szEffectMessage), L"DSFXR_LOCHARDWARE"); break;
	case DSFXR_LOCSOFTWARE:
		StringCbCat(szEffectMessage, sizeof(szEffectMessage), L"DSFXR_LOCSOFTWARE"); break;
	case DSFXR_UNALLOCATED:
		StringCbCat(szEffectMessage, sizeof(szEffectMessage), L"DSFXR_UNALLOCATED"); break;
	case DSFXR_FAILED:
		StringCbCat(szEffectMessage, sizeof(szEffectMessage), L"DSFXR_FAILED"); break;
	case DSFXR_PRESENT:
		StringCbCat(szEffectMessage, sizeof(szEffectMessage), L"DSFXR_PRESENT"); break;
	case DSFXR_UNKNOWN:
		StringCbCat(szEffectMessage, sizeof(szEffectMessage), L"DSFXR_UNKNOWN"); break;
	default:
		StringCbCat(szEffectMessage, sizeof(szEffectMessage), L"??????"); break;
	}
	StringCbCat(szEffectMessage, sizeof(szEffectMessage), L"@@@@@");

	// ĐĊJ
	pDSData->Play(0, 0, DSBPLAY_LOOPING);

	return SUCCEEDED(hr);
}

/*-------------------------------------------
	GtFNg̒~
--------------------------------------------*/
bool ReleaseDMEffect(void)
{
	if (pDSData==NULL)
		return false;

	HRESULT hr;

	//GtFNg̐ݒ̂߁AĐ~
	pDSData->Stop();

	// obt@ׂ̂ẴGtFNg폜
	hr = pDSData->SetFX(0, NULL, NULL);
	if (FAILED(hr))
		DXTRACE_ERR(L"obt@GtFNĝɎs", hr);
	EffectType = NONE;

	// ĐĊJ
	pDSData->Play(0, 0, DSBPLAY_LOOPING);

	return SUCCEEDED(hr);
}

/*-------------------------------------------
	TEhEobt@̊J
--------------------------------------------*/
bool ReleaseSoundBuffer(void)
{
	// Đ~
	if(pDSData)	pDSData->Stop();

	// TEhEobt@J
	SAFE_RELEASE(pDSData);

	return true;
}

/*-------------------------------------------
	DirectSound̊J
--------------------------------------------*/
bool ReleaseDSound(void)
{
	// DirectSound̃IuWFNgJ
	SAFE_RELEASE(pDSPrimary);
	SAFE_RELEASE(pDSound);

	return true;
}

/*-------------------------------------------
	AvP[V̏I
--------------------------------------------*/
bool EndApp(void)
{
	// COMI
	CoUninitialize( );

	return true;
}


/*-------------------------------------------
	EBhE
--------------------------------------------*/
void SetCHORUSParam(FLOAT level);
void SetCOMPRESSORParam(FLOAT level);
void SetDISTORTIONParam(FLOAT level);
void SetECHOParam(FLOAT level);
void SetFLANGERParam(FLOAT level);
void SetGARGLEParam(DWORD type);
void SetPARAMEQParam(FLOAT level);

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam)
{
	int effect_level = 0, effect_level2 = 2;

	switch(msg){
		case WM_KEYDOWN:
			switch(wParam){
				case VK_ESCAPE:
					DestroyWindow(hWnd);
					break;

				// R[X
				case '1':
				case VK_NUMPAD1:
					StringCbCopy(szEffectMessage, sizeof(szEffectMessage), L"GUID_DSFX_STANDARD_CHORUS@");
					InitDMEffect(GUID_DSFX_STANDARD_CHORUS, CHORUS);
					break;
				// RvbV
				case '2':
				case VK_NUMPAD2:
					StringCbCopy(szEffectMessage, sizeof(szEffectMessage), L"GUID_DSFX_STANDARD_COMPRESSOR@");
					InitDMEffect(GUID_DSFX_STANDARD_COMPRESSOR, COMPRESSOR);
					break;
				// fBXg[V
				case '3':
				case VK_NUMPAD3:
					StringCbCopy(szEffectMessage, sizeof(szEffectMessage), L"GUID_DSFX_STANDARD_DISTORTION@");
					InitDMEffect(GUID_DSFX_STANDARD_DISTORTION, DISTORTION);
					break;
				// GR[
				case '4':
				case VK_NUMPAD4:
					StringCbCopy(szEffectMessage, sizeof(szEffectMessage), L"GUID_DSFX_STANDARD_ECHO@");
					InitDMEffect(GUID_DSFX_STANDARD_ECHO, ECHO);
					break;
				// tW
				case '5':
				case VK_NUMPAD5:
					StringCbCopy(szEffectMessage, sizeof(szEffectMessage), L"GUID_DSFX_STANDARD_FLANGER@");
					InitDMEffect(GUID_DSFX_STANDARD_FLANGER, FLANGER);
					break;
				// K[O
				case '6':
				case VK_NUMPAD6:
					StringCbCopy(szEffectMessage, sizeof(szEffectMessage), L"GUID_DSFX_STANDARD_GARGLE@");
					InitDMEffect(GUID_DSFX_STANDARD_GARGLE, GARGLE);
					break;
				// pgbN CRCU
				case '7':
				case VK_NUMPAD7:
					StringCbCopy(szEffectMessage, sizeof(szEffectMessage), L"GUID_DSFX_STANDARD_PARAMEQ@");
					InitDMEffect(GUID_DSFX_STANDARD_PARAMEQ, PARAMEQ);
					break;
				// ׂẴGtFNg폜
				case '0':
				case VK_NUMPAD0:
					ReleaseDMEffect();
					StringCbCopy(szEffectMessage,      sizeof(szEffectMessage),      L"");
					StringCbCopy(szEffectLevelMessage, sizeof(szEffectLevelMessage), L"");
					break;

				// GtFNg̐ݒőlɂ
				case 'R':
					++effect_level;
				// GtFNg̐ݒŏlƍől̒Ԃɂ
				case 'E':
					++effect_level;
				// GtFNg̐ݒŏlɂ
				case 'W':

					if (pDSData == NULL)
						break;

					// GtFNg̃p[^ݒ肷
					effect_level2 = 2 - effect_level;
					switch (EffectType)
					{
						case CHORUS:
							SetCHORUSParam((effect_level*DSFXCHORUS_FEEDBACK_MAX + effect_level2*DSFXCHORUS_FEEDBACK_MIN)/2.0f);
							break;
						case COMPRESSOR:
							SetCOMPRESSORParam((effect_level*DSFXCOMPRESSOR_RATIO_MAX + effect_level2*DSFXCOMPRESSOR_RATIO_MIN)/2.0f);
							break;
						case DISTORTION:
							SetDISTORTIONParam((effect_level*DSFXDISTORTION_EDGE_MAX + effect_level2*DSFXDISTORTION_EDGE_MIN)/2.0f);
							break;
						case ECHO:
							SetECHOParam((effect_level*DSFXECHO_FEEDBACK_MAX + effect_level2*DSFXECHO_FEEDBACK_MIN)/2.0f);
							break;
						case FLANGER:
							SetFLANGERParam((effect_level*DSFXFLANGER_FEEDBACK_MAX + effect_level2*DSFXFLANGER_FEEDBACK_MIN)/2.0f);
							break;
						case GARGLE:
							SetGARGLEParam(effect_level==0 ? DSFXGARGLE_WAVE_TRIANGLE : DSFXGARGLE_WAVE_SQUARE);
							break;
						case PARAMEQ:
							SetPARAMEQParam((effect_level*DSFXPARAMEQ_GAIN_MAX + effect_level2*DSFXPARAMEQ_GAIN_MIN)/2.0f);
							break;
						default:
							break;
					}
					break;

				default:
					break;
			}

			// ʍXV
			InvalidateRect(hwndApp, NULL, TRUE);
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		case WM_PAINT:
			{
				PAINTSTRUCT ps;
				HDC hDC = BeginPaint(hWnd, &ps);
				TextOut(hDC, 0, 40, szEffectMessage, lstrlen(szEffectMessage));
				TextOut(hDC, 0, 60, szEffectLevelMessage, lstrlen(szEffectLevelMessage));
				EndPaint(hWnd, &ps);
			}

		default:
			return DefWindowProc(hWnd,msg,wParam,lParam);
	}

	return 0L;
}

void SetCHORUSParam(FLOAT level)
{
	HRESULT hr;
	// ݒ肵GtFNgEIuWFNg擾
	IDirectSoundFXChorus8* pEffectDMO = NULL;
	hr = pDSData->GetObjectInPath(
				GUID_All_Objects, 0, IID_IDirectSoundFXChorus8,
				(LPVOID*)&pEffectDMO);
	if (FAILED(hr))
		DXTRACE_ERR(L"IDirectSoundFXChorus8̎擾Ɏs", hr);
	else
	{
		// GtFNg̃p[^擾
		DSFXChorus FXParams;
		hr = pEffectDMO->GetAllParameters(&FXParams);
		if (FAILED(hr))
			DXTRACE_ERR(L"GtFNgEp[^̎擾Ɏs", hr);
		else
		{
			// GtFNg̃p[^ݒ肷
			FXParams.fFeedback = level;
			hr = pEffectDMO->SetAllParameters(&FXParams);
			if (FAILED(hr))
				DXTRACE_ERR(L"GtFNgEp[^̐ݒɎs", hr);
			else
				StringCbPrintf(szEffectLevelMessage, sizeof(szEffectLevelMessage), L"DSFXChorus.fFeedback = %f      ", level);
		}
		SAFE_RELEASE(pEffectDMO);
	}
}
void SetCOMPRESSORParam(FLOAT level)
{
	HRESULT hr;
	// ݒ肵GtFNgEIuWFNg擾
	IDirectSoundFXCompressor8* pEffectDMO = NULL;
	hr = pDSData->GetObjectInPath(
				GUID_All_Objects, 0, IID_IDirectSoundFXCompressor8,
				(LPVOID*)&pEffectDMO);
	if (FAILED(hr))
		DXTRACE_ERR(L"IDirectSoundFXCompressor8̎擾Ɏs", hr);
	else
	{
		// GtFNg̃p[^擾
		DSFXCompressor FXParams;
		hr = pEffectDMO->GetAllParameters(&FXParams);
		if (FAILED(hr))
			DXTRACE_ERR(L"GtFNgEp[^̎擾Ɏs", hr);
		else
		{
			// GtFNg̃p[^ݒ肷
			FXParams.fRatio = level;
			hr = pEffectDMO->SetAllParameters(&FXParams);
			if (FAILED(hr))
				DXTRACE_ERR(L"GtFNgEp[^̐ݒɎs", hr);
			else
				StringCbPrintf(szEffectLevelMessage, sizeof(szEffectLevelMessage), L"DSFXCompressor.fRatio = %f      ", level);
		}
		SAFE_RELEASE(pEffectDMO);
	}
}
void SetDISTORTIONParam(FLOAT level)
{
	HRESULT hr;
	// ݒ肵GtFNgEIuWFNg擾
	IDirectSoundFXDistortion8* pEffectDMO = NULL;
	hr = pDSData->GetObjectInPath(
				GUID_All_Objects, 0, IID_IDirectSoundFXDistortion8,
				(LPVOID*)&pEffectDMO);
	if (FAILED(hr))
		DXTRACE_ERR(L"IDirectSoundFXDistortion8̎擾Ɏs", hr);
	else
	{
		// GtFNg̃p[^擾
		DSFXDistortion FXParams;
		hr = pEffectDMO->GetAllParameters(&FXParams);
		if (FAILED(hr))
			DXTRACE_ERR(L"GtFNgEp[^̎擾Ɏs", hr);
		else
		{
			// GtFNg̃p[^ݒ肷
			FXParams.fEdge = level;
			hr = pEffectDMO->SetAllParameters(&FXParams);
			if (FAILED(hr))
				DXTRACE_ERR(L"GtFNgEp[^̐ݒɎs", hr);
			else
				StringCbPrintf(szEffectLevelMessage, sizeof(szEffectLevelMessage), L"DSFXDistortion.fEdge = %f      ", level);
		}
		SAFE_RELEASE(pEffectDMO);
	}
}
void SetECHOParam(FLOAT level)
{
	HRESULT hr;
	// ݒ肵GtFNgEIuWFNg擾
	IDirectSoundFXEcho8* pEffectDMO = NULL;
	hr = pDSData->GetObjectInPath(
				GUID_All_Objects, 0, IID_IDirectSoundFXEcho8,
				(LPVOID*)&pEffectDMO);
	if (FAILED(hr))
		DXTRACE_ERR(L"IDirectSoundFXEcho8̎擾Ɏs", hr);
	else
	{
		// GtFNg̃p[^擾
		DSFXEcho FXParams;
		hr = pEffectDMO->GetAllParameters(&FXParams);
		if (FAILED(hr))
			DXTRACE_ERR(L"GtFNgEp[^̎擾Ɏs", hr);
		else
		{
			// GtFNg̃p[^ݒ肷
			FXParams.fFeedback = level;
			hr = pEffectDMO->SetAllParameters(&FXParams);
			if (FAILED(hr))
				DXTRACE_ERR(L"GtFNgEp[^̐ݒɎs", hr);
			else
				StringCbPrintf(szEffectLevelMessage, sizeof(szEffectLevelMessage), L"DSFXEcho.fFeedback = %f      ", level);
		}
		SAFE_RELEASE(pEffectDMO);
	}
}
void SetFLANGERParam(FLOAT level)
{
	HRESULT hr;
	// ݒ肵GtFNgEIuWFNg擾
	IDirectSoundFXFlanger8* pEffectDMO = NULL;
	hr = pDSData->GetObjectInPath(
				GUID_All_Objects, 0, IID_IDirectSoundFXFlanger8,
				(LPVOID*)&pEffectDMO);
	if (FAILED(hr))
		DXTRACE_ERR(L"IDirectSoundFXFlanger8̎擾Ɏs", hr);
	else
	{
		// GtFNg̃p[^擾
		DSFXFlanger FXParams;
		hr = pEffectDMO->GetAllParameters(&FXParams);
		if (FAILED(hr))
			DXTRACE_ERR(L"GtFNgEp[^̎擾Ɏs", hr);
		else
		{
			// GtFNg̃p[^ݒ肷
			FXParams.fFeedback = level;
			hr = pEffectDMO->SetAllParameters(&FXParams);
			if (FAILED(hr))
				DXTRACE_ERR(L"GtFNgEp[^̐ݒɎs", hr);
			else
				StringCbPrintf(szEffectLevelMessage, sizeof(szEffectLevelMessage), L"DSFXFlanger.fFeedback = %f      ", level);
		}
		SAFE_RELEASE(pEffectDMO);
	}
}
void SetGARGLEParam(DWORD type)
{
	HRESULT hr;
	// ݒ肵GtFNgEIuWFNg擾
	IDirectSoundFXGargle8* pEffectDMO = NULL;
	hr = pDSData->GetObjectInPath(
				GUID_All_Objects, 0, IID_IDirectSoundFXGargle8,
				(LPVOID*)&pEffectDMO);
	if (FAILED(hr))
		DXTRACE_ERR(L"IDirectSoundFXGargle8̎擾Ɏs", hr);
	else
	{
		// GtFNg̃p[^擾
		DSFXGargle FXParams;
		hr = pEffectDMO->GetAllParameters(&FXParams);
		if (FAILED(hr))
			DXTRACE_ERR(L"GtFNgEp[^̎擾Ɏs", hr);
		else
		{
			// GtFNg̃p[^ݒ肷
			FXParams.dwWaveShape = type;
			hr = pEffectDMO->SetAllParameters(&FXParams);
			if (FAILED(hr))
				DXTRACE_ERR(L"GtFNgEp[^̐ݒɎs", hr);
		}
		SAFE_RELEASE(pEffectDMO);
	}
}
void SetPARAMEQParam(FLOAT level)
{
	HRESULT hr;
	// ݒ肵GtFNgEIuWFNg擾
	IDirectSoundFXParamEq8* pEffectDMO = NULL;
	hr = pDSData->GetObjectInPath(
				GUID_All_Objects, 0, IID_IDirectSoundFXParamEq8,
				(LPVOID*)&pEffectDMO);
	if (FAILED(hr))
		DXTRACE_ERR(L"IDirectSoundFXParamEq8̎擾Ɏs", hr);
	else
	{
		// GtFNg̃p[^擾
		DSFXParamEq FXParams;
		hr = pEffectDMO->GetAllParameters(&FXParams);
		if (FAILED(hr))
			DXTRACE_ERR(L"GtFNgEp[^̎擾Ɏs", hr);
		else
		{
			// GtFNg̃p[^ݒ肷
			FXParams.fGain = level;
			hr = pEffectDMO->SetAllParameters(&FXParams);
			if (FAILED(hr))
				DXTRACE_ERR(L"GtFNgEp[^̐ݒɎs", hr);
			else
				StringCbPrintf(szEffectLevelMessage, sizeof(szEffectLevelMessage), L"DSFXParamEq.fGain = %f      ", level);
		}
		SAFE_RELEASE(pEffectDMO);
	}
}

/*--------------------------------------------
	ACh̏
--------------------------------------------*/
bool AppIdle(void)
{
	return true;
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI WinMain(HINSTANCE hInst,HINSTANCE /*hPrevInst*/,LPSTR /*lpCmdLine*/,int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// AvP[VɊւ鏉
	bool flag = InitApp(hInst,nCmdShow);

	// DirectSoundɊւ鏉
	if (flag) flag = InitDSound();

	// TEhEobt@Ɋւ鏉
	if (flag) flag = InitSoundBuffer();

	MSG msg;
	msg.wParam = 0;
	while(flag){
		if(PeekMessage(&msg,0,0,0,PM_REMOVE)){
			if(msg.message == WM_QUIT)
				break;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else{
			// AChiʕ`j
			if (!AppIdle())
				// G[ꍇCAvP[VI
				PostQuitMessage(0);
		}
	}

	// TEhEobt@J
	ReleaseSoundBuffer();

	// DirectSound̏I
	ReleaseDSound();

	// AvP[V̏I
	EndApp();

	return (int)msg.wParam;
}
