/*----------------------------------------------------------
	DirectSoundTv
		EMicrosoft DirectX SDK (February 2007)
		EVisual Studio 2005 Standard
		EWindows XP or Windows Vista
		Ή

	DSSample01.cpp
		u{IȃTEhĐv
--------------------------------------------------------------*/

// DirectSoundpt@CCN[h
#define STRICT
#include <windows.h>
#include <crtdbg.h>
#include <mmsystem.h>
#include <mmreg.h>
#include <dsound.h>
#include <dxerr.h>

#pragma warning( disable : 4996 ) // disable deprecated warning 
#include <strsafe.h>
#pragma warning( default : 4996 ) 

#define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }

// DirectSoundpCũN
#pragma comment( lib, "dsound.lib" )
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "winmm.lib" )

// DXUT OptionalCWaveFileNXgp
#define DXUT_AUTOLIB    // Direct3DpCũNw
#include "DXUT.h"
#include "SDKwavefile.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// \[X
#include "resource.h"

#define WAVEFILENAME_1	L"..\\..\\Media\\Life1.wav"
#define WAVEFILENAME_2	L"..\\..\\Media\\Rock1.wav"

/*-------------------------------------------
	Oϐ
--------------------------------------------*/
HINSTANCE hInstApp;
HWND hwndApp;

WCHAR szAppName[] = L"DirectSound Sample 1";

LPDIRECTSOUND8       pDSound = NULL;
LPDIRECTSOUNDBUFFER  pDSPrimary = NULL; // vC}Eobt@IDirectSoundBufferC^[tFCXg
LPDIRECTSOUNDBUFFER8 pDSData1 = NULL;
LPDIRECTSOUNDBUFFER8 pDSData2 = NULL;

BOOL data1Play = FALSE;
BOOL data2Play = FALSE;

LONG primaryVolume;
LONG data1Volume;
LONG data2Volume;

LONG primaryPan;
LONG data1Pan;
LONG data2Pan;

LONG primaryFrequency;
LONG data1Frequency;
LONG data2Frequency;

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[V
--------------------------------------------*/
bool InitApp(HINSTANCE hInst,int nCmdShow)
{
	WNDCLASS wndclass;

	hInstApp=hInst;

	/*EBhENX̓o^*/
	wndclass.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.hInstance		= hInst;
	wndclass.style			= CS_BYTEALIGNCLIENT|CS_VREDRAW|CS_HREDRAW;
	wndclass.lpfnWndProc	= (WNDPROC)MainWndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;

	if(!RegisterClass(&wndclass))
		return FALSE;

	/*CEBhE*/
	hwndApp = CreateWindowEx(0, szAppName, szAppName,
							WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION,
							CW_USEDEFAULT,CW_USEDEFAULT,640,480,
							(HWND)NULL,(HMENU)NULL,
							hInst,(LPSTR)NULL);
	ShowWindow(hwndApp,nCmdShow);
	UpdateWindow(hwndApp);

	return TRUE;
}

/*-------------------------------------------
	WAVEt@CɃZJ_Eobt@
--------------------------------------------*/
bool CreateSoundData(LPTSTR pName, LPDIRECTSOUNDBUFFER8 &pDSData)
{
	HRESULT hr;

	// WAVEt@CJ
	CWaveFile WaveFile;
	hr = WaveFile.Open(pName, NULL, WAVEFILE_READ);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"Wavet@C̃I[vɎs", hr);
		return false;
	}

	// ZJ_Eobt@쐬
	// DSBUFFERDESC\̂ݒ
	DSBUFFERDESC dsbdesc; 
	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = sizeof(DSBUFFERDESC); 
	dsbdesc.dwFlags = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS |
						DSBCAPS_LOCDEFER | DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLPAN | DSBCAPS_CTRLFREQUENCY;
	dsbdesc.dwBufferBytes = WaveFile.GetSize();
	dsbdesc.lpwfxFormat = WaveFile.GetFormat();

	// obt@
	LPDIRECTSOUNDBUFFER pDSB;
	hr = pDSound->CreateSoundBuffer(&dsbdesc, &pDSB, NULL); 
	if (FAILED(hr))
	{ 
	    DXTRACE_ERR(L"obt@̍쐬Ɏs", hr);
		return false;
	}
	hr = pDSB->QueryInterface(IID_IDirectSoundBuffer8, (LPVOID*)&pDSData);
	SAFE_RELEASE(pDSB);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"IDirectSoundBuffer8C^[tFCX̎擾Ɏs", hr);
		return false;
	}

	// ZJ_Eobt@Wavef[^
	LPVOID lpvPtr1; 	// ŏ̃ubÑ|C^
	DWORD dwBytes1; 	// ŏ̃ubÑTCY
	LPVOID lpvPtr2; 	// QԖڂ̃ubÑ|C^
	DWORD dwBytes2; 	// QԖڂ̃ubÑTCY

	hr = pDSData->Lock(0, WaveFile.GetSize(), &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0); 

	// DSERR_BUFFERLOSTԂꂽꍇCRestore\bhgăobt@𕜌
	if(DSERR_BUFFERLOST == hr)
	{
		pDSData->Restore();
		hr = pDSData->Lock(0, WaveFile.GetSize(), &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
	} 
	if (SUCCEEDED(hr))
	{
	    // bN

	    // ŁCobt@ɏ
		// obt@Ƀf[^Rs[
		DWORD rsize;
		WaveFile.Read((LPBYTE)lpvPtr1, dwBytes1, &rsize);
		if ( 0 != dwBytes2 )
			WaveFile.Read((LPBYTE)lpvPtr2, dwBytes2, &rsize);

	   // ݂I炷UnlockD
	    hr = pDSData->Unlock(lpvPtr1, dwBytes1, lpvPtr2, dwBytes2); 
	}

	return true;
}

/*-------------------------------------------
	DirectSound 
--------------------------------------------*/
bool InitDSound(void)
{
	HRESULT hr;

	// IDirectSound8C^[tFCX̎擾
	hr = DirectSoundCreate8(NULL, &pDSound, NULL);
	if (FAILED(hr))
	{
	    DXTRACE_ERR(L"IDirectSound8C^[tFCX̎擾Ɏs", hr);
		return false;
	}

	//ŋxݒ
	hr = pDSound->SetCooperativeLevel(hwndApp, DSSCL_PRIORITY);
	if (FAILED(hr))
	{
	    // x̐ݒɎs
		DXTRACE_ERR(L"x̐ݒɎs", hr);
		return false;
	}

	// vC}Eobt@̍쐬
	// DSBUFFERDESC\̂ݒ
	DSBUFFERDESC dsbdesc; 
	ZeroMemory(&dsbdesc, sizeof(DSBUFFERDESC));
	dsbdesc.dwSize = sizeof(DSBUFFERDESC); 
	// vC}Eobt@w
	dsbdesc.dwFlags = DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLPAN | DSBCAPS_PRIMARYBUFFER; 
	dsbdesc.dwBufferBytes = 0;
	dsbdesc.lpwfxFormat = NULL;

	// obt@
	hr = pDSound->CreateSoundBuffer(&dsbdesc, &pDSPrimary, NULL); 
	if (FAILED(hr))
	{
	    // obt@̍쐬Ɏs
		DXTRACE_ERR(L"vC}Eobt@̍쐬Ɏs", hr);
		return false;
	}

	// vC}Eobt@WavetH[}bgݒ
	// @@@D拦xȏ̋xݒ肳ĂKv܂D
	WAVEFORMATEX pcmwf; 
	ZeroMemory(&pcmwf, sizeof(WAVEFORMATEX)); 
	pcmwf.wFormatTag = WAVE_FORMAT_PCM; 
	pcmwf.nChannels = 2;			// Q`liXeIj
	pcmwf.nSamplesPerSec = 44100;	// TvOE[g@44.1kHz
	pcmwf.nBlockAlign = 4;
	pcmwf.nAvgBytesPerSec = pcmwf.nSamplesPerSec * pcmwf.nBlockAlign; 
	pcmwf.wBitsPerSample = 16;		// 16rbg
	hr = pDSPrimary->SetFormat(&pcmwf);
	if(FAILED(hr))
	    DXTRACE_ERR(L"vC}Eobt@̃tH[}bgݒɎs", hr);

	// {[Ȃǂ̒l擾
	pDSPrimary->GetVolume(&primaryVolume);
	pDSPrimary->GetPan(&primaryPan);
	pDSPrimary->GetFrequency((DWORD*)&primaryFrequency);

	return true;
}

/*-------------------------------------------
	TEhEobt@
--------------------------------------------*/
bool InitSoundBuffer(void)
{
	// WAVEt@CɃZJ_Eobt@쐬
	bool  f = CreateSoundData(WAVEFILENAME_1, pDSData1);
	if(f) f = CreateSoundData(WAVEFILENAME_2, pDSData2);
	if(!f)
		return false;

	// {[Ȃǂ̒l擾
	pDSData1->GetVolume(&data1Volume);
	pDSData2->GetVolume(&data2Volume);
	pDSData1->GetPan(&data1Pan);
	pDSData2->GetPan(&data2Pan);
	pDSData1->GetFrequency((DWORD*)&data1Frequency);
	pDSData2->GetFrequency((DWORD*)&data2Frequency);

	return true;
}

/*-------------------------------------------
	TEhEobt@̊J
--------------------------------------------*/
bool ReleaseSoundBuffer(void)
{
	// Đ~
	if(pDSData2)	pDSData2->Stop();
	if(pDSData1)	pDSData1->Stop();

	// TEhEobt@J
	SAFE_RELEASE(pDSData2);
	SAFE_RELEASE(pDSData1);

	return true;
}

/*-------------------------------------------
	DirectSound̊J
--------------------------------------------*/
bool ReleaseDSound(void)
{
	// DirectSound̃IuWFNgJ
	SAFE_RELEASE(pDSPrimary);
	SAFE_RELEASE(pDSound);

	return true;
}

/*-------------------------------------------
	AvP[V̏I
--------------------------------------------*/
bool EndApp(void)
{
	return true;
}


/*-------------------------------------------
	EBhE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam)
{
	HRESULT hr;
	BOOL bChange = FALSE;

	switch(msg){
		case WM_KEYDOWN:
			bChange = TRUE;
			switch(wParam){
				case VK_ESCAPE:
					bChange = FALSE;
					DestroyWindow(hWnd);
					break;

				case VK_UP:
					primaryVolume += (DSBVOLUME_MAX - DSBVOLUME_MIN) / 100; break;
				case VK_DOWN:
					primaryVolume -= (DSBVOLUME_MAX - DSBVOLUME_MIN) / 100; break;
				case VK_LEFT:
					primaryPan += (DSBPAN_LEFT - DSBPAN_RIGHT) / 100; break;
				case VK_RIGHT:
					primaryPan -= (DSBPAN_LEFT - DSBPAN_RIGHT) / 100; break;
				case 'I':
					bChange = FALSE;
					if(data1Play)	pDSData1->Stop();
					else pDSData1->Play(0, 0, DSBPLAY_LOOPING);
					data1Play = !data1Play;
					break;
				case 'K':
					bChange = FALSE;
					if(data2Play)	pDSData2->Stop();
					else pDSData2->Play(0, 0, DSBPLAY_LOOPING);
					data2Play = !data2Play;
					break;
				case 'Q':
					data1Volume += (DSBVOLUME_MAX - DSBVOLUME_MIN) / 100; break;
				case 'W':
					data1Volume -= (DSBVOLUME_MAX - DSBVOLUME_MIN) / 100; break;
				case 'A':
					data2Volume += (DSBVOLUME_MAX - DSBVOLUME_MIN) / 100; break;
				case 'S':
					data2Volume -= (DSBVOLUME_MAX - DSBVOLUME_MIN) / 100; break;
				case 'E':
					data1Pan += (DSBPAN_LEFT - DSBPAN_RIGHT) / 100; break;
				case 'R':
					data1Pan -= (DSBPAN_LEFT - DSBPAN_RIGHT) / 100; break;
				case 'D':
					data2Pan += (DSBPAN_LEFT - DSBPAN_RIGHT) / 100; break;
				case 'F':
					data2Pan -= (DSBPAN_LEFT - DSBPAN_RIGHT) / 100; break;
				case 'T':
					data1Frequency += (DSBFREQUENCY_MAX - DSBFREQUENCY_MIN) / 100; break;
				case 'Y':
					data1Frequency -= (DSBFREQUENCY_MAX - DSBFREQUENCY_MIN) / 100; break;
				case 'G':
					data2Frequency += (DSBFREQUENCY_MAX - DSBFREQUENCY_MIN) / 100; break;
				case 'H':
					data2Frequency -= (DSBFREQUENCY_MAX - DSBFREQUENCY_MIN) / 100; break;
				case 'U':
					data1Frequency = DSBFREQUENCY_ORIGINAL; break;
				case 'J':
					data2Frequency = DSBFREQUENCY_ORIGINAL; break;

				default:
					bChange = FALSE;
					break;
			}
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		case WM_PAINT:
			{
				PAINTSTRUCT ps;
				HDC hDC = BeginPaint(hWnd, &ps);

				WCHAR CData[200];
				hr = StringCbPrintf(CData, sizeof(CData), L"Primary Volume[%d] Pan[%d] Frequency[%d]", primaryVolume, primaryPan, primaryFrequency);
				if (SUCCEEDED(hr))
					TextOut(hDC, 0, 0, CData, lstrlen(CData));
				hr = StringCbPrintf(CData, sizeof(CData), L"SoundData1 Volume[%d] Pan[%d] Frequency[%d]", data1Volume, data1Pan, data1Frequency);
				if (SUCCEEDED(hr))
					TextOut(hDC, 0, 20, CData, lstrlen(CData));
				hr = StringCbPrintf(CData, sizeof(CData), L"SoundData2 Volume[%d] Pan[%d] Frequency[%d]", data2Volume, data2Pan, data2Frequency);
				if (SUCCEEDED(hr))
					TextOut(hDC, 0, 40, CData, lstrlen(CData));

				EndPaint(hWnd, &ps);
			}

		default:
			return DefWindowProc(hWnd,msg,wParam,lParam);
	}

	if(bChange)
	{
		if(primaryVolume > DSBVOLUME_MAX)	primaryVolume = DSBVOLUME_MAX;
		else if(primaryVolume < DSBVOLUME_MIN)	primaryVolume = DSBVOLUME_MIN;
		if(data1Volume > DSBVOLUME_MAX)	data1Volume = DSBVOLUME_MAX;
		else if(data1Volume < DSBVOLUME_MIN)	data1Volume = DSBVOLUME_MIN;
		if(data2Volume > DSBVOLUME_MAX)	data2Volume = DSBVOLUME_MAX;
		else if(data2Volume < DSBVOLUME_MIN)	data2Volume = DSBVOLUME_MIN;
		if(data1Volume > DSBVOLUME_MAX)	data1Volume = DSBVOLUME_MAX;
		else if(data1Volume < DSBVOLUME_MIN)	data1Volume = DSBVOLUME_MIN;
		if(data2Volume > DSBVOLUME_MAX)	data2Volume = DSBVOLUME_MAX;
		else if(data2Volume < DSBVOLUME_MIN)	data2Volume = DSBVOLUME_MIN;

		if(primaryPan > DSBPAN_RIGHT)	primaryPan = DSBPAN_RIGHT;
		else if(primaryPan < DSBPAN_LEFT)	primaryPan = DSBPAN_LEFT;
		if(data1Pan > DSBPAN_RIGHT)	data1Pan = DSBPAN_RIGHT;
		else if(data1Pan < DSBPAN_LEFT)	data1Pan = DSBPAN_LEFT;
		if(data2Pan > DSBPAN_RIGHT)	data2Pan = DSBPAN_RIGHT;
		else if(data2Pan < DSBPAN_LEFT)	data2Pan = DSBPAN_LEFT;

		if(data1Frequency != DSBFREQUENCY_ORIGINAL)
		{
			if(data1Frequency > DSBFREQUENCY_MAX)	data1Frequency = DSBFREQUENCY_MAX;
			else if(data1Frequency < DSBFREQUENCY_MIN)	data1Frequency = DSBFREQUENCY_MIN;
		}
		if(data2Frequency != DSBFREQUENCY_ORIGINAL)
		{
			if(data2Frequency > DSBFREQUENCY_MAX)	data2Frequency = DSBFREQUENCY_MAX;
			else if(data2Frequency < DSBFREQUENCY_MIN)	data2Frequency = DSBFREQUENCY_MIN;
		}

		pDSPrimary->SetVolume(primaryVolume);
		pDSData1->SetVolume(data1Volume);
		pDSData2->SetVolume(data2Volume);
		pDSPrimary->SetPan(primaryPan);
		pDSData1->SetPan(data1Pan);
		pDSData2->SetPan(data2Pan);
		pDSData1->SetFrequency((DWORD)data1Frequency);
		pDSData2->SetFrequency((DWORD)data2Frequency);

		InvalidateRect(hwndApp, NULL, TRUE);
	}
	return 0L;
}


/*--------------------------------------------
	ACh̏
--------------------------------------------*/
bool AppIdle(void)
{
	return true;
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI WinMain(HINSTANCE hInst,HINSTANCE /*hPrevInst*/,LPSTR /*lpCmdLine*/,int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// AvP[VɊւ鏉
	bool flag = InitApp(hInst,nCmdShow);

	// DirectSoundɊւ鏉
	if (flag) flag = InitDSound();

	// TEhEobt@Ɋւ鏉
	if (flag) flag = InitSoundBuffer();

	MSG msg;
	msg.wParam = 0;
	while(flag){
		if(PeekMessage(&msg,0,0,0,PM_REMOVE)){
			if(msg.message == WM_QUIT)
				break;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else{
			// AChiʕ`j
			if (!AppIdle())
				// G[ꍇCAvP[VI
				PostQuitMessage(0);
		}
	}

	// TEhEobt@J
	ReleaseSoundBuffer();

	// DirectSound̏I
	ReleaseDSound();

	// AvP[V̏I
	EndApp();

	return (int)msg.wParam;
}



