/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample29.cpp
		uHDR_ÕTvv
--------------------------------------------------------------*/

#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓn
#define DXUT_AUTOLIB		// DXUTŕKvȃCu(dsound.libȊO)IɃN
#include "DXUT.h"			// DXUTg
#include "SDKmisc.h"		// DXUT Optionalg
#include "DXUTgui.h"		// DXUT OptionalGUIg
#include "DXUTSettingsDlg.h"	//DXUT OptionalCD3DSettingsDlgNXg
#include "SDKmesh.h"		// DXUT OptionalCDXUTXFileMeshNXg
#include <stdlib.h>			// qsourt֐g
#include "resource.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// *****************************************
// **** O[oϐ

// GtFNg
LPD3DXEFFECT g_pD3DXEffect = NULL;			// `ɎgGtFNg

D3DXHANDLE g_hRenderGroundTech = NULL;		// nʂ̕`ɎgeNjbN
D3DXHANDLE g_hRenderTunnelTech = NULL;		// gl̕`ɎgeNjbN
D3DXHANDLE g_hMinimizeTech = NULL;			// 摜̏kɎgeNjbN
D3DXHANDLE g_hToneMappingTech = NULL;		// g[E}bsOɎgeNjbN

D3DXHANDLE g_hWorldViewProj = NULL;			// [h~r[~ϊsݒ肷ϐ̃nh
D3DXHANDLE g_hLight1Pos = NULL;				// s̕(f)ݒ肷ϐ̃nh
D3DXHANDLE g_hLight1Brightness = NULL;		// s̋ݒ肷ϐ̃nh
D3DXHANDLE g_hLight2Pos = NULL;				// _̈ʒu(f)ݒ肷ϐ̃nh
D3DXHANDLE g_hLight2Brightness = NULL;		// _̋ݒ肷ϐ̃nh
D3DXHANDLE g_hBackLightBrightnessMax = NULL;	// \Px͈̔(ől)ݒ肷ϐ̃nh
D3DXHANDLE g_hBackLightBrightnessMin = NULL;	// \Px͈̔(ŏl)ݒ肷ϐ̃nh
D3DXHANDLE g_hMeshTexture = NULL;			// eNX`ݒ肷ϐ̃nh
D3DXHANDLE g_hToneTexture = NULL;			// eNX`ݒ肷ϐ̃nh

// J
D3DXVECTOR3 g_vEye(0.0f, 2.5f, -300.0f);	// J̍W
D3DXVECTOR3 g_vAt(0.0f, 0.0f, -250.0f);		// _
D3DXVECTOR3 g_vUp(0.0f, 1.0f, 0.0f);		// J̏xNg

D3DXMATRIX g_matWorldViewProj;				// [h~r[~ϊs
float g_Aspect;								// ʂ̃AXyNg

// 
D3DXVECTOR4 g_vLight1(2.0, 2.0f, -2.0f, 0.0f);	// s̕(n)
float       g_fLight1Brightness = 0.5f;			// ̋

D3DXVECTOR4 g_vLight2[5] = {					// _̈ʒu(gl)
	D3DXVECTOR4(0.0f, 9.8f, -90.0f, 1.0f),
	D3DXVECTOR4(0.0f, 9.8f, -45.0f, 1.0f),
	D3DXVECTOR4(0.0f, 9.8f,   0.0f, 1.0f),
	D3DXVECTOR4(0.0f, 9.8f,  45.0f, 1.0f),
	D3DXVECTOR4(0.0f, 9.8f,  90.0f, 1.0f) };
float       g_fLight2Brightness = 5.5f;			// ̋

float       g_fBackLightBrightnessMax = 1.0f;  // \Px͈̔(ől)
float       g_fBackLightBrightnessMin = 0.0f;  // \Px͈̔(ŏl)

// bV
CDXUTXFileMesh  *g_pMeshGround = NULL;			// bV̊ǗNX(nʂƃglAH)
CDXUTXFileMesh  *g_pMeshTunnel = NULL;			// bV̊ǗNX(gl)

// g[E}bsOȂǂɂbVEf[^
struct strVBScreen			// _obt@Ɏ߂f[^
{
	FLOAT x, y, z;			// _W
	FLOAT tx, ty;			// eNX`W
};

D3DVERTEXELEMENT9 g_DeclScreen[] = // _vf
{
	{ 0,  0,              D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },
	{ 0, sizeof(FLOAT)*3, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0 },
	D3DDECL_END()   // z̏I
};

LPDIRECT3DVERTEXDECLARATION9 g_pVertexDeclScreen = NULL;	// _錾IuWFNg
LPDIRECT3DVERTEXBUFFER9      g_pD3DVBScreen = NULL;			// _obt@
LPDIRECT3DINDEXBUFFER9       g_pD3DIBScreen = NULL;			// CfbNXEobt@

// _O\eNX`
LPDIRECT3DTEXTURE9 g_pRenderTarget = NULL;			// HDRCeBOpeNX`
LPDIRECT3DTEXTURE9 g_pRenderTargetMini = NULL;		// HDR摜keNX`
LPDIRECT3DTEXTURE9 g_pSurfaceMini = NULL;			// k摜̓]eNX`
const int RTS_WIDTH = 32, RTS_HEIGHT = 32;			// k摜̃TCY

// *****************************************
// **** O[oϐ(GUI@\)
CDXUTDialogResourceManager	g_DialogResourceManager; // _CAÕ\[XǗ
CD3DSettingsDlg				g_SettingsDlg;           // foCXݒ_CAO

// foCX֘Aݒ_CAO(E)
enum { ID_DISPLAYMODE = 0, ID_HALREF, ID_CHANGEDEVICE, ID_PAUSE }; // Rg[ID
CDXUTDialog  g_DeviceUI;    // _CAO

// Xe[^X\_CAO()
enum { ID_DEVICESTATUS = 50, ID_FRAMESTATUS }; // Rg[ID
CDXUTDialog  g_StatusUI;    // _CAO

// _CAO@(ݒBE)
enum {  ID_CHECKBOX1 = 100 }; // Rg[ID
CDXUTDialog  g_SampleUI;   // _CAO@

// *****************************************
// **** GUI֘Å֐
// _CAOĂяoR[obN֐
void CALLBACK DXUTCallbackGUIEvent(UINT nEvent, int nControlID, CDXUTControl* pControl, void* pUserContext)
{
	switch (nControlID)
	{
	// foCX֘Aݒ_CAO
	case ID_DISPLAYMODE:	// ʃ[h؂ւ(EChEE[hƃtXN[E[h)
		DXUTToggleFullScreen();
		break;
	case ID_HALREF:			// foCX؂ւ(REFHAL)
		DXUTToggleREF();
		break;
	case ID_CHANGEDEVICE:	// foCXݒʂ̕\
		g_SettingsDlg.SetActive(!g_SettingsDlg.IsActive());
		break;
	case ID_PAUSE:			// ꎞ~
		DXUTPause(!DXUTIsTimePaused(), false);
		break;
	}
}

// *****************************************
// **** foCX쐬֘ÃR[obN֐

// p\ȃfoCX̗(R[obN֐)
bool CALLBACK DXUTCallbackIsDeviceAcceptable(
		D3DCAPS9 *pCaps, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, bool bWindowed, void* pUserContext)

{
	if (pCaps->MaxPrimitiveCount < 0xFFFF)		// v~eBu
		return false;
	if (pCaps->MaxVertexIndex < 0xFFF0)			// CfbNX
		return false;
	if (pCaps->PixelShaderVersion < D3DPS_VERSION(2, 0))	// sNZEVF[_
		return false;

	return true;	// ̃foCX̎gpe
}

// 쐬foCXݒ̕ύX(R[obN֐)
bool CALLBACK DXUTCallbackModifyDeviceSettings(
		DXUTDeviceSettings *pDeviceSettings, void* pUserContext)
{
	// Direct3D 9foCXg邱ƂmF
	if( pDeviceSettings->ver == DXUT_D3D9_DEVICE )
	{
		HRESULT hr;

		if (pDeviceSettings->d3d9.DeviceType == D3DDEVTYPE_HAL) {
			IDirect3D9* pD3D =  DXUTGetD3D9Object();

			// ̃foCXŕ_obt@g邩ǂ𒲂ׂ
			hr = pD3D->CheckDeviceFormat(
					pDeviceSettings->d3d9.AdapterOrdinal,	// fBXvCEA_v^ԍ
					pDeviceSettings->d3d9.DeviceType,		// foCX̎
					pDeviceSettings->d3d9.AdapterFormat,		// fBXvCEtH[}bg
					D3DUSAGE_RENDERTARGET,				// ړÍu_OE^[Qbgv
					D3DRTYPE_TEXTURE,					// ʂ́ueNX`v
					D3DFMT_A16B16G16R16F);				// uD3DFMT_A16B16G16R16FvtH[}bg̃T|[g
			if (FAILED(hr))
				pDeviceSettings->d3d9.DeviceType = D3DDEVTYPE_REF;	// s̏ꍇt@XEX^CUg

			hr = pD3D->CheckDeviceFormat(
					pDeviceSettings->d3d9.AdapterOrdinal,	// fBXvCEA_v^ԍ
					pDeviceSettings->d3d9.DeviceType,		// foCX̎
					pDeviceSettings->d3d9.AdapterFormat,		// fBXvCEtH[}bg
					D3DUSAGE_RENDERTARGET,				// ړÍu_OE^[Qbgv
					D3DRTYPE_TEXTURE,					// ʂ́ueNX`v
					D3DFMT_R32F);						// uR32FvtH[}bg̃T|[g
			if (FAILED(hr))
				pDeviceSettings->d3d9.DeviceType = D3DDEVTYPE_REF;	// s̏ꍇt@XEX^CUg
		}

		// D3D9foCX̔\͂擾
		D3DCAPS9 caps;
		DXUTGetD3D9DeviceCaps( pDeviceSettings, &caps );

		// ŏɃt@X foCXIꂽƂɁAx\
		static bool s_bFirstTime = true;
		if( s_bFirstTime )
		{
			s_bFirstTime = false;
			if( pDeviceSettings->d3d9.DeviceType == D3DDEVTYPE_REF )
				DXUTDisplaySwitchingToREFWarning(pDeviceSettings->ver);
		}

		// o[W2.0̒_VF[_n[hEFAŃT|[gĂȂꍇ́A\tgEFAg
		if ((caps.DevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) == 0 ||
				caps.VertexShaderVersion < D3DVS_VERSION(2, 0))
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_HARDWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_PUREDEVICE;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_SOFTWARE_VERTEXPROCESSING;	// \tgEFA_
		}
		else
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_SOFTWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_HARDWARE_VERTEXPROCESSING;	//n[hEFA_
		}

		// Avdouble^g(x͒ቺ)
		pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_FPU_PRESERVE;
	}

	return true;
}

// foCX쐬̏(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceCreated(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9CreateDevice( pd3dDevice ) );
	V_RETURN( g_SettingsDlg.OnD3D9CreateDevice( pd3dDevice ) );

	// **** g[E}bsOpIuWFNg̍쐬 ****
	// _錾IuWFNg̍쐬
	V_RETURN(pd3dDevice->CreateVertexDeclaration(g_DeclScreen, &g_pVertexDeclScreen));

	// _obt@̍쐬
	V_RETURN(pd3dDevice->CreateVertexBuffer(
			sizeof(strVBScreen)*24,		// obt@ETCY(̂̒_)
			0,							// gp@
			0,							// FVF_obt@
			D3DPOOL_MANAGED,			// Direct3DŃǗ
			&g_pD3DVBScreen,			// _obt@󂯎ϐ
			NULL));

	// _obt@ւ̏
	strVBScreen *pVBuffer;
	V_RETURN(g_pD3DVBScreen->Lock(
			0, 0,             // ŜbN
			(LPVOID*)&pVBuffer, 0));
	pVBuffer[0].x = -1.0f; pVBuffer[0].y = 1.0f; pVBuffer[0].z = 0.0f; pVBuffer[0].tx = 0.0f; pVBuffer[0].ty = 0.0f;
	pVBuffer[1].x =  1.0f; pVBuffer[1].y = 1.0f; pVBuffer[1].z = 0.0f; pVBuffer[1].tx = 1.0f; pVBuffer[1].ty = 0.0f;
	pVBuffer[2].x = -1.0f; pVBuffer[2].y = -1.0f; pVBuffer[2].z = 0.0f; pVBuffer[2].tx = 0.0f; pVBuffer[2].ty = 1.0f;
	pVBuffer[3].x =  1.0f; pVBuffer[3].y = -1.0f; pVBuffer[3].z = 0.0f; pVBuffer[3].tx = 1.0f; pVBuffer[3].ty = 1.0f;
	g_pD3DVBScreen->Unlock(); // AbN

	// CfbNXEobt@̍쐬
	V_RETURN(pd3dDevice->CreateIndexBuffer(
			6 * 2,					// 6_16rbgECfbNXEobt@
			0,						// gp@
			D3DFMT_INDEX16,			// 16rbgECfbNXEobt@
			D3DPOOL_MANAGED,		// Direct3DŃǗ
			&g_pD3DIBScreen,		// CfbNXEobt@󂯎ϐ
			NULL));

	// CfbNXEobt@ւ̏
	WORD *pIBuffer;
	V_RETURN(g_pD3DIBScreen->Lock(0, 0, (LPVOID*)&pIBuffer, 0));  // bN
	pIBuffer[0] = 0; pIBuffer[1] = 1; pIBuffer[2] = 2;
	pIBuffer[3] = 2; pIBuffer[4] = 1; pIBuffer[5] = 3;
	g_pD3DIBScreen->Unlock();    // AbN

	// **** GtFNg̍쐬 ****
	// fxt@Č
	WCHAR fxFileName[MAX_PATH];
	DXUTFindDXSDKMediaFileCch(fxFileName, MAX_PATH, L"Shader13.fx");

	// ID3DXEffectC^[tFCX̍쐬
	V_RETURN(D3DXCreateEffectFromFile(
		pd3dDevice,				// GtFNgfoCX
		fxFileName,				// GtFNgEt@C
		NULL,
		NULL,
		0,						// RpCEIvV
		NULL,
		&g_pD3DXEffect,			// GtFNg󂯎ϐ
		NULL));

	// nh̎擾
	g_hRenderGroundTech  = g_pD3DXEffect->GetTechniqueByName("RenderGround_Tech");
	g_hRenderTunnelTech  = g_pD3DXEffect->GetTechniqueByName("RenderTunnel_Tech");
	g_hMinimizeTech      = g_pD3DXEffect->GetTechniqueByName("Minimize_Tech");
	g_hToneMappingTech   = g_pD3DXEffect->GetTechniqueByName("ToneMapping_Tech");

	g_hWorldViewProj          = g_pD3DXEffect->GetParameterByName(NULL, "WorldViewProj");
	g_hLight1Pos              = g_pD3DXEffect->GetParameterByName(NULL, "Light1Pos");
	g_hLight1Brightness       = g_pD3DXEffect->GetParameterByName(NULL, "Light1Brightness");
	g_hLight2Pos              = g_pD3DXEffect->GetParameterByName(NULL, "Light2Pos");
	g_hLight2Brightness       = g_pD3DXEffect->GetParameterByName(NULL, "Light2Brightness");
	g_hBackLightBrightnessMax = g_pD3DXEffect->GetParameterByName(NULL, "BackLightBrightnessMax");
	g_hBackLightBrightnessMin = g_pD3DXEffect->GetParameterByName(NULL, "BackLightBrightnessMin");
	g_hMeshTexture            = g_pD3DXEffect->GetParameterByName(NULL, "MeshTexture");
	g_hToneTexture            = g_pD3DXEffect->GetParameterByName(NULL, "ToneTexture");

	return hr;
}

// *****************************************
// **** bZ[W֘ÃR[obN֐

// EChEEbZ[W̏(R[obN֐)
LRESULT CALLBACK DXUTCallbackMsgProc(
			HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, bool *pbNoFurtherProcessing, void* pUserContext)
{
	// GUI\[XǗ
	*pbNoFurtherProcessing = g_DialogResourceManager.MsgProc( hWnd, uMsg, wParam, lParam );
	if( *pbNoFurtherProcessing )
		return 0;

	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.MsgProc( hWnd, uMsg, wParam, lParam );
		return 0;
	}

	// foCX֘A_CAÕbZ[W
	*pbNoFurtherProcessing = g_DeviceUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// Xe[^X\_CAÕbZ[W
	*pbNoFurtherProcessing = g_StatusUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// _CAO@̃bZ[W
	*pbNoFurtherProcessing = g_SampleUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	*pbNoFurtherProcessing = false;  // t[[NŃbZ[W
	return 0;
}

// *****************************************
// **** V[`֘ÃR[obN֐

// V[̍XV(R[obN֐)
void CALLBACK DXUTCallbackFrameMove(
		double fTime, float fElapsedTime, void* pUserContext)
{
	// Xe[^X̕\
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->SetText(DXUTGetDeviceStats());
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->SetText(DXUTGetFrameStats(true));

	// J̌vZ
	float t = fmodf((float)fTime, 20.0f);
	g_vEye.z = t < 10.0f ? t * 30.0f - 150.0f : 150.0f - (t - 10.0f) * 30.0f;
	g_vAt.z = g_vEye.z + 50.0f;

	// V[̕`pϊs
	D3DXMATRIX matView, matProj;
	D3DXMatrixLookAtLH(&matView, &g_vEye, &g_vAt, &g_vUp);	// r[ϊs

	D3DXMatrixPerspectiveFovLH(&matProj,				// eϊ
				D3DX_PI/1.5f,							// p120x
				g_Aspect,	// AXyNg
				0.1f,		// Oeʂ܂ł̋
				800.0f);	// eʂ܂ł̋

	g_matWorldViewProj = matView * matProj;
}

// V[̕`(R[obN֐)
void RenderHDRTexture(LPDIRECT3DDEVICE9 pd3dDevice);
void RenderHDRTextureMinimize(LPDIRECT3DDEVICE9 pd3dDevice);
void CalcBackLightBrightness(LPDIRECT3DDEVICE9 pd3dDevice, float fElapsedTime);
void RenderToneMapping(LPDIRECT3DDEVICE9 pd3dDevice);

void CALLBACK DXUTCallbackFrameRender(
		LPDIRECT3DDEVICE9 pd3dDevice, double fTime, float fElapsedTime, void* pUserContext)
{
	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.OnRender( fElapsedTime );
		return;
	}

	// V[̕`Jn
	if (SUCCEEDED(pd3dDevice->BeginScene()))
	{
		// HDRCeBOpeNX`ɃV[`
		RenderHDRTexture(pd3dDevice);
		// HDRCeBOpeNX`k
		RenderHDRTextureMinimize(pd3dDevice);
		// VwiPxvZ
		CalcBackLightBrightness(pd3dDevice, fElapsedTime);
		// g[E}bsO
		RenderToneMapping(pd3dDevice);

		// _CAO`
		g_DeviceUI.OnRender(fElapsedTime);
		g_StatusUI.OnRender(fElapsedTime);
		g_SampleUI.OnRender(fElapsedTime);

		// V[̕`I
		pd3dDevice->EndScene();
	}
}

// HDRCeBOpeNX`ɃV[`
void RenderHDRTexture(LPDIRECT3DDEVICE9 pd3dDevice)
{
	// _Oݒ
	LPDIRECT3DSURFACE9 pRenderTarget;
	g_pRenderTarget->GetSurfaceLevel(0, &pRenderTarget);  // `T[tFX擾

	LPDIRECT3DSURFACE9 pOldRenderTarget;
	pd3dDevice->GetRenderTarget(0, &pOldRenderTarget);  // ݂̕`ۑ
	pd3dDevice->SetRenderTarget(0, pRenderTarget);      // V`I

	// `eNX`̃NA
	pd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0, 50, 128), 1.0f, 0);

	D3DXHANDLE handleNULL = NULL;
	// bV̕`
	if (g_pMeshGround)
	{
		g_pD3DXEffect->SetTechnique(g_hRenderGroundTech);                  // eNjbNI
		g_pD3DXEffect->SetMatrix(g_hWorldViewProj, &g_matWorldViewProj);   // ϊs̐ݒ
		g_pD3DXEffect->SetVector(g_hLight1Pos, &g_vLight1);                // s̕
		g_pD3DXEffect->SetFloat(g_hLight1Brightness, g_fLight1Brightness); // s̋
		g_pMeshGround->Render(g_pD3DXEffect, g_hMeshTexture, handleNULL, handleNULL, handleNULL, handleNULL, handleNULL, true, true);
	}
	if (g_pMeshTunnel)
	{
		g_pD3DXEffect->SetTechnique(g_hRenderTunnelTech);                  // eNjbNI
		g_pD3DXEffect->SetMatrix(g_hWorldViewProj, &g_matWorldViewProj);   // ϊs̐ݒ
		g_pD3DXEffect->SetVectorArray(g_hLight2Pos, g_vLight2, 5);         // _̈ʒu
		g_pD3DXEffect->SetFloat(g_hLight2Brightness, g_fLight2Brightness); // _̋
		g_pMeshTunnel->Render(g_pD3DXEffect, g_hMeshTexture, handleNULL, handleNULL, handleNULL, handleNULL, handleNULL, true, true);
	}

	// eNX`ւ̕`I
	pd3dDevice->SetRenderTarget(0, pOldRenderTarget);  // `ɖ߂
	SAFE_RELEASE(pOldRenderTarget);
	SAFE_RELEASE(pRenderTarget);
}

// HDRCeBOpeNX`k
void RenderHDRTextureMinimize(LPDIRECT3DDEVICE9 pd3dDevice)
{
	// _Oݒ
	LPDIRECT3DSURFACE9 pRenderTarget;
	g_pRenderTargetMini->GetSurfaceLevel(0, &pRenderTarget);  // `T[tFX擾

	LPDIRECT3DSURFACE9 pOldRenderTarget;
	pd3dDevice->GetRenderTarget(0, &pOldRenderTarget);  // ݂̕`ۑ
	pd3dDevice->SetRenderTarget(0, pRenderTarget);      // V`I

	// r[|[g̕ۑƕύX
	D3DVIEWPORT9 OldViewport;
	pd3dDevice->GetViewport(&OldViewport);
	D3DVIEWPORT9 Viewport = {0,0, RTS_WIDTH, RTS_HEIGHT, 0.0f, 1.0f};
	pd3dDevice->SetViewport(&Viewport);

	// _錾̓o^
	pd3dDevice->SetVertexDeclaration(g_pVertexDeclScreen);
	// _Xg[̓o^
	pd3dDevice->SetStreamSource(0, g_pD3DVBScreen, 0, sizeof(strVBScreen));
	// CfbNXEobt@̓o^
	pd3dDevice->SetIndices(g_pD3DIBScreen);

	// GtFNg̃eNX`ϐɁAeNX`ݒ
	g_pD3DXEffect->SetTexture(g_hToneTexture, g_pRenderTarget);

	// eNjbNI
	g_pD3DXEffect->SetTechnique(g_hMinimizeTech);

	// eNjbN̊Jn
	UINT numPass;
	g_pD3DXEffect->Begin(&numPass, 0);      //eNjbN̊Jn(Xe[gۑ)

	// eNjbÑpXs
	for (UINT iPass = 0; iPass < numPass; iPass++)
	{
		g_pD3DXEffect->BeginPass(iPass);     // iPassԖڂ̃pX̎sJn

		// bV`
		pd3dDevice->DrawIndexedPrimitive(
			D3DPT_TRIANGLELIST,		// v~eBu^ƂāAOp`Xgw
			0, 0, 4, 0, 2);

		g_pD3DXEffect->EndPass();	// pX̎sI
	}

	// eNjbN̏I
	g_pD3DXEffect->End();		// eNjbN̏I(ۑXe[g𕜌)

	// eNX`ւ̕`I
	pd3dDevice->SetViewport(&OldViewport);
	pd3dDevice->SetRenderTarget(0, pOldRenderTarget);  // `ɖ߂
	SAFE_RELEASE(pOldRenderTarget);
	SAFE_RELEASE(pRenderTarget);
}

// VwiPxvZ
int compare_float(const float *a, const float *b) { return (*a < *b) ? -1 : (*a > *b) ? 1 : 0; }

void CalcBackLightBrightness(LPDIRECT3DDEVICE9 pd3dDevice, float fElapsedTime)
{
	HRESULT hr;

	// eNX`̃T[tFX擾
	LPDIRECT3DSURFACE9 pRenderTarget;
	V(g_pRenderTargetMini->GetSurfaceLevel(0, &pRenderTarget));
	LPDIRECT3DSURFACE9 pCopyTarget;
	V(g_pSurfaceMini->GetSurfaceLevel(0, &pCopyTarget));

	// _OeNX`̓eT[tFXɓ]
	V(pd3dDevice->GetRenderTargetData(pRenderTarget, pCopyTarget));
	SAFE_RELEASE(pRenderTarget);

	// T[tFXbNăRs[
	D3DLOCKED_RECT LockedRect;
	V(pCopyTarget->LockRect(&LockedRect, NULL, D3DLOCK_READONLY));

	float buffer[RTS_WIDTH * RTS_HEIGHT];
	for (int y=0; y<RTS_HEIGHT; y++)
		CopyMemory(&buffer[RTS_WIDTH * y], (char*)LockedRect.pBits + LockedRect.Pitch * y, RTS_WIDTH * sizeof(float));

	pCopyTarget->UnlockRect();
	SAFE_RELEASE(pCopyTarget);

	// \[g
	qsort(buffer, RTS_WIDTH * RTS_HEIGHT, sizeof(float), (int (*)(const void*, const void*))compare_float);

	// lȂǂɁA`͈(Px)߂
	if (g_SampleUI.GetCheckBox(ID_CHECKBOX1)->GetChecked())
	{
		float m_max      = buffer[RTS_WIDTH * RTS_HEIGHT * 90 / 100];
		float m_median   = buffer[RTS_WIDTH * RTS_HEIGHT / 2];
		float m_min      = buffer[RTS_WIDTH * RTS_HEIGHT * 10 / 100];
		float m_band   = (m_max - m_min);

		g_fBackLightBrightnessMax = m_median + m_band;
		g_fBackLightBrightnessMin = m_median - m_band;
		if (g_fBackLightBrightnessMax < 0.05f)
			g_fBackLightBrightnessMax = 0.05f;
		if (g_fBackLightBrightnessMin < 0.0f)
			g_fBackLightBrightnessMin = 0.0f;
		else if (0.2f < g_fBackLightBrightnessMin)
			g_fBackLightBrightnessMin = 0.2f;
	}
}

// g[E}bsO
void RenderToneMapping(LPDIRECT3DDEVICE9 pd3dDevice)
{
	// _錾̓o^
	pd3dDevice->SetVertexDeclaration(g_pVertexDeclScreen);
	// _Xg[̓o^
	pd3dDevice->SetStreamSource(0, g_pD3DVBScreen, 0, sizeof(strVBScreen));
	// CfbNXEobt@̓o^
	pd3dDevice->SetIndices(g_pD3DIBScreen);

	// GtFNg̃eNX`ϐɁAeNX`ݒ
	g_pD3DXEffect->SetTexture(g_hToneTexture, g_pRenderTarget);
	g_pD3DXEffect->SetFloat(g_hBackLightBrightnessMax, g_fBackLightBrightnessMax);
	g_pD3DXEffect->SetFloat(g_hBackLightBrightnessMin, g_fBackLightBrightnessMin);

	// eNjbNI
	g_pD3DXEffect->SetTechnique(g_hToneMappingTech);

	// eNjbN̊Jn
	UINT numPass;
	g_pD3DXEffect->Begin(&numPass, 0);      //eNjbN̊Jn(Xe[gۑ)

	// eNjbÑpXs
	for (UINT iPass = 0; iPass < numPass; iPass++)
	{
		g_pD3DXEffect->BeginPass(iPass);     // iPassԖڂ̃pX̎sJn

		// bV`
		pd3dDevice->DrawIndexedPrimitive(
			D3DPT_TRIANGLELIST,		// v~eBu^ƂāAOp`Xgw
			0, 0, 4, 0, 2);

		g_pD3DXEffect->EndPass();	// pX̎sI
	}

	// eNjbN̏I
	g_pD3DXEffect->End();		// eNjbN̏I(ۑXe[g𕜌)
}

// *****************************************
// **** foCX̏֘ÃR[obN֐

// foCX̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceLost(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9LostDevice();
	g_SettingsDlg.OnD3D9LostDevice();

	// bV̏
	if (g_pMeshGround)
		g_pMeshGround->InvalidateDeviceObjects();
	if (g_pMeshTunnel)
		g_pMeshTunnel->InvalidateDeviceObjects();

	// GtFNg̏
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnLostDevice();

	// _O\eNX`̏
	SAFE_RELEASE(g_pRenderTarget);
	SAFE_RELEASE(g_pRenderTargetMini);
	SAFE_RELEASE(g_pSurfaceMini);
}

// foCX̃XgA(R[obN֐)
void LoadMesh(LPDIRECT3DDEVICE9 pD3DDevice, LPCTSTR pFileName, CDXUTXFileMesh **ppMesh);

HRESULT CALLBACK DXUTCallbackDeviceReset(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr = S_OK;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9ResetDevice() );
	V_RETURN( g_SettingsDlg.OnD3D9ResetDevice() );

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= pBackBufferSurfaceDesc->Width;
	vp.Height	= pBackBufferSurfaceDesc->Height;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	V_RETURN(pd3dDevice->SetViewport(&vp));

	// ʂ̃AXyNg
	g_Aspect = (float)pBackBufferSurfaceDesc->Width / (float)pBackBufferSurfaceDesc->Height;

	// GtFNg̃XgA
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnResetDevice();

	// bṼXgA
	if (g_pMeshGround)
		g_pMeshGround->RestoreDeviceObjects(pd3dDevice);
	else
		LoadMesh(pd3dDevice, L"Ground2.x", &g_pMeshGround);
	if (g_pMeshTunnel)
		g_pMeshTunnel->RestoreDeviceObjects(pd3dDevice);
	else
		LoadMesh(pd3dDevice, L"Tunnel.x", &g_pMeshTunnel);

	// _O\eNX`̍쐬
	V_RETURN(D3DXCreateTexture(pd3dDevice, pBackBufferSurfaceDesc->Width, pBackBufferSurfaceDesc->Height,
					1, D3DUSAGE_RENDERTARGET, D3DFMT_A16B16G16R16F, D3DPOOL_DEFAULT, &g_pRenderTarget));
	V_RETURN(D3DXCreateTexture(pd3dDevice, RTS_WIDTH, RTS_HEIGHT,
					1, D3DUSAGE_RENDERTARGET, D3DFMT_R32F, D3DPOOL_DEFAULT, &g_pRenderTargetMini));
	V_RETURN(D3DXCreateTexture(pd3dDevice, RTS_WIDTH, RTS_HEIGHT,
					1, 0, D3DFMT_R32F, D3DPOOL_SYSTEMMEM, &g_pSurfaceMini));

	// _CAO̔zu
	g_DeviceUI.SetLocation(pBackBufferSurfaceDesc->Width - 150, 0);     // _CAO̍W(-150, 0)
	g_DeviceUI.SetSize(150, 110);     // _CAȎ傫(150~110)

	g_StatusUI.SetLocation(0, 0);     // _CAO̍W(0, 0)
	g_StatusUI.SetSize(500, 50);      // _CAȎ傫(500~50)

	g_SampleUI.SetLocation(pBackBufferSurfaceDesc->Width  - 150, 
							pBackBufferSurfaceDesc->Height - 30);      // _CAO̍W(-150, -30)
	g_SampleUI.SetSize(150, 30);     // _CAȎ傫(150~30)

	return hr;	// I
}

// bV̓ǂݍ݁A_`̐ݒ
void LoadMesh(LPDIRECT3DDEVICE9 pD3DDevice, LPCTSTR pFileName, CDXUTXFileMesh **ppMesh)
{
	HRESULT hr;

	if (pD3DDevice == NULL)
		pD3DDevice = DXUTGetD3D9Device();	// D3DfoCX̎擾

	// VbV̒_vf
	D3DVERTEXELEMENT9 decl[] = 
	{
		{ 0,  0, D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },
		{ 0, 12, D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_NORMAL,   0 },
		{ 0, 24, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0 },
		D3DDECL_END()   // z̏I
	};

	// ̃bV̍폜
	SAFE_DELETE(*ppMesh);

	// Xt@C̓ǂݍ
	(*ppMesh) = new CDXUTXFileMesh();
	hr = (*ppMesh)->Create(pD3DDevice, pFileName);	// Xt@C
	if (FAILED(hr))
	{
		SAFE_DELETE(*ppMesh);
		return;
	}

	// _tH[}bg̐ݒ
	hr = (*ppMesh)->SetVertexDecl(pD3DDevice, decl);
	if (FAILED(hr))
	{
		SAFE_DELETE(*ppMesh);
		return;
	}

	// `pbV̍쐬
	hr = (*ppMesh)->RestoreDeviceObjects(pD3DDevice);
	if (FAILED(hr)) {
		SAFE_DELETE(*ppMesh);
		return;
	}
}

// *****************************************
// **** foCX폜֘ÃR[obN֐

// foCX폜̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceDestroyed(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9DestroyDevice();
	g_SettingsDlg.OnD3D9DestroyDevice();

	// bV̊J
	SAFE_DELETE(g_pMeshGround);
	SAFE_DELETE(g_pMeshTunnel);

	// 擾IuWFNg̊J
	SAFE_RELEASE(g_pVertexDeclScreen);
	SAFE_RELEASE(g_pD3DVBScreen);
	SAFE_RELEASE(g_pD3DIBScreen);
	SAFE_RELEASE(g_pD3DXEffect);
}

// *****************************************
// WinMain֐ƃAvP[V֘Ȁ

// AvP[V֘Ȁ
void InitApp(void)
{
	// GUI\[XǗ(_CAȌ)
	g_SettingsDlg.Init( &g_DialogResourceManager );
	g_DeviceUI.Init( &g_DialogResourceManager );
	g_StatusUI.Init( &g_DialogResourceManager );
	g_SampleUI.Init( &g_DialogResourceManager );

	// Windows 2000pɓ{tHgݒ(Vista,XPł͕sv)B
	g_DeviceUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );
	g_SampleUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );

	// GUIRg[̃bZ[W󂯎R[obN֐_CAOɓo^
	g_DeviceUI.SetCallback(DXUTCallbackGUIEvent);
	g_SampleUI.SetCallback(DXUTCallbackGUIEvent);

	// GUIRg[_CAOɓo^
	int iY = 10;
	g_DeviceUI.AddButton(ID_DISPLAYMODE,  L"ʃ[h",   10, iY,       125, 22);
	g_DeviceUI.AddButton(ID_HALREF,       L"foCX",     10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_CHANGEDEVICE, L"foCXݒ", 10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_PAUSE,        L"ꎞ~",     10, iY += 24, 125, 22);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_StatusUI.AddStatic(ID_DEVICESTATUS, L"", 10, iY,       490, 22);
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,255,0,255), DT_LEFT | DT_VCENTER);
	g_StatusUI.AddStatic(ID_FRAMESTATUS,  L"", 10, iY += 24, 490, 22);
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,0,255,255), DT_LEFT | DT_VCENTER);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_SampleUI.AddCheckBox(ID_CHECKBOX1, L"wiPxύX", 10, iY, 125, 22, true);
}

// **** WinMain֐
int WINAPI wWinMain(HINSTANCE, HINSTANCE, LPWSTR, int)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// ** R[obN֐̓o^ **
	// foCX쐬̏
	DXUTSetCallbackD3D9DeviceCreated(DXUTCallbackDeviceCreated);
	// EChEEbZ[W̏
	DXUTSetCallbackMsgProc(DXUTCallbackMsgProc);
	// V[̍XV
	DXUTSetCallbackFrameMove(DXUTCallbackFrameMove);
	// V[̕`
	DXUTSetCallbackD3D9FrameRender(DXUTCallbackFrameRender);
	// foCX̏
	DXUTSetCallbackD3D9DeviceLost(DXUTCallbackDeviceLost);
	// foCX̃XgA
	DXUTSetCallbackD3D9DeviceReset(DXUTCallbackDeviceReset);
	// foCX폜̏
	DXUTSetCallbackD3D9DeviceDestroyed(DXUTCallbackDeviceDestroyed);

	// p\ȃfoCX̗
	DXUTSetCallbackD3D9DeviceAcceptable(DXUTCallbackIsDeviceAcceptable);
	// 쐬foCXݒ̕ύX
	DXUTSetCallbackDeviceChanging(DXUTCallbackModifyDeviceSettings);

	// tXN[E[hŃ}EXEJ[\\
	DXUTSetCursorSettings(true, true);

	// **  **
	InitApp();				// AvP[V֘Ȁ

	DXUTInit(true, true);                     // TvEt[[N̏
	DXUTSetHotkeyHandling(true);              // zbgEL[̐ݒ
	DXUTCreateWindow(L"Direct3D 9 Sample29"); // EChE̍쐬

	DXUTCreateDevice(true, 640, 480);  // foCX̍쐬(R[obN֐̎s)

	// ** CE[v **
	DXUTMainLoop();    // bZ[WE[vs

	return DXUTGetExitCode();  // I
}
