/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample28.cpp
		uVhEE}bṽTvv
--------------------------------------------------------------*/

#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓnȂ
#define DXUT_AUTOLIB		// DXUTŕKvȃCu(dsound.libȊO)IɃN
#include "DXUT.h"			// DXUTg
#include "SDKmisc.h"		// DXUT Optionalg
#include "DXUTgui.h"		// DXUT OptionalGUIg
#include "DXUTSettingsDlg.h"	//DXUT OptionalCD3DSettingsDlgNXg
#include "SDKmesh.h"		// DXUT OptionalCDXUTXFileMeshNXg
#include <strsafe.h>		// StringCbCat֐g
#include "resource.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// *****************************************
// **** O[oϐ

// J
D3DXVECTOR3 g_vEye(0.0f, 1.0f, -2.0f);		// J̍W
D3DXVECTOR3 g_vAt(0.0f, 0.0f, 0.0f);		// _
D3DXVECTOR3 g_vUp(0.0f, 1.0f, 0.0f);		// J̏xNg

D3DXMATRIX g_matWorldViewProj;				// [h~r[~ϊs
D3DXMATRIX g_matWorldViewProjGround;		// [h~r[~ϊs(n)
float g_Aspect;								// ʂ̃AXyNg

D3DXMATRIX g_matShadow;						// VhEE}bvp[h~r[~ϊs
D3DXMATRIX g_matShadowGround;				// VhEE}bvp[h~r[~ϊs(n)

// 
D3DXVECTOR3 g_vLight(2.0, 2.0f, -2.0f);		// ̍W
D3DXVECTOR3 g_vLightAt(0.0f, 0.0f, 0.0f);	// _(VhEE}bvp)
D3DXVECTOR3 g_vLightUp(0.0f, 1.0f, 0.0f);	// xNg(VhEE}bvp)
float       g_fLightBrightness = 25.0f;		// ̋Px

D3DXVECTOR4 g_vLightModel;					// ̍W(f)
D3DXVECTOR4 g_vLightModelGround;			// ̍W(fԁBnʗp)

// GtFNg
LPD3DXEFFECT g_pD3DXEffect = NULL;			// `ɎgGtFNg

D3DXHANDLE  g_hShadowMap_Tech = NULL;		// eNjbN"ShadowMap_Tech"̃nh
D3DXHANDLE  g_hNormal_Tech = NULL;			// eNjbN"Normal_Tech"̃nh
D3DXHANDLE  g_hNoShadow_Tech = NULL;		// eNjbN"NoShadow_Tech"̃nh

D3DXHANDLE  g_hTexShadow = NULL;			// ϐ"TexShadow"̃nh
D3DXHANDLE  g_hWorldViewProj = NULL;		// ϐ"WorldViewProj"̃nh
D3DXHANDLE  g_hWorldViewProjShadow = NULL;	// ϐ"WorldViewProjShadow"̃nh
D3DXHANDLE  g_hLightPos = NULL;				// ϐ"LightPos"̃nh
D3DXHANDLE  g_hLightBrightness = NULL;		// ϐ"LightBrightness"̃nh
D3DXHANDLE  g_hModelScale = NULL;			// ϐ"ModelScale"̃nh
D3DXHANDLE  g_hTex = NULL;					// ϐ"Tex"̃nh
D3DXHANDLE  g_hDiffuse = NULL;				// ϐ"Diffuse"̃nh

// bV
CDXUTXFileMesh *g_pMesh = NULL;				// bV̊ǗNX
D3DXVECTOR3 g_BSCenter(0.0f, 0.0f, 0.0f);	// E̒SW
float       g_BSRadius = 1.0f;				// E̔a
float       g_fMeshScale = 1.0f;			// bṼXP[

CDXUTXFileMesh *g_pMeshGround = NULL;				// bV̊ǗNX(n)
D3DXVECTOR3 g_BSCenterGround(0.0f, 0.0f, 0.0f);		// E̒SW
float       g_BSRadiusGround = 1.0f;				// E̔a
float       g_fMeshGroundScale = 1.0f;				// bṼXP[(n)

// VhE}bvp̃_O\eNX`
LPDIRECT3DTEXTURE9 g_pShadowMap = NULL;
LPDIRECT3DSURFACE9 g_pShadowMapDepth = NULL;		// VhE}bsOp̐[xobt@

// *****************************************
// **** O[oϐ(GUI@\)

// GUI\[XǗ
CDXUTDialogResourceManager	g_DialogResourceManager; // _CAÕ\[XǗ
CD3DSettingsDlg				g_SettingsDlg;           // foCXݒ_CAO

// foCX֘Aݒ_CAO(E)
enum { ID_DISPLAYMODE = 0, ID_HALREF, ID_CHANGEDEVICE, ID_PAUSE }; // Rg[ID
CDXUTDialog  g_DeviceUI;    // _CAO

// Xe[^X\_CAO()
enum { ID_DEVICESTATUS = 50, ID_FRAMESTATUS }; // Rg[ID
CDXUTDialog  g_StatusUI;    // _CAO

// _CAO@(ݒBE)
enum {  ID_EDIT1 = 100, ID_BUTTON1, ID_BUTTON2, ID_BUTTON3, ID_CHECKBOX1 }; // Rg[ID
CDXUTDialog  g_SampleUI;   // _CAO@

// *****************************************
// **** GUI֘Å֐
void LoadMesh(LPDIRECT3DDEVICE9 pD3DDevice, LPCTSTR pFileName, CDXUTXFileMesh **ppMesh, D3DXVECTOR3 *pBSCenter, FLOAT *pBSRadius);

// _CAOĂяoR[obN֐
void CALLBACK DXUTCallbackGUIEvent(UINT nEvent, int nControlID, CDXUTControl* pControl, void* pUserContext)
{
	switch (nControlID)
	{
	// foCX֘Aݒ_CAO
	case ID_DISPLAYMODE:	// ʃ[h؂ւ(EChEE[hƃtXN[E[h)
		DXUTToggleFullScreen();
		break;
	case ID_HALREF:			// foCX؂ւ(REFHAL)
		DXUTToggleREF();
		break;
	case ID_CHANGEDEVICE:	// foCXݒʂ̕\
		g_SettingsDlg.SetActive(!g_SettingsDlg.IsActive());
		break;
	case ID_PAUSE:			// ꎞ~
		DXUTPause(!DXUTIsTimePaused(), false);
		break;

	case ID_BUTTON1:		// Xt@C̓ǂݍ
		LoadMesh(NULL, g_SampleUI.GetEditBox(ID_EDIT1)->GetText(), &g_pMesh, &g_BSCenter, &g_BSRadius);
		break;
	case ID_BUTTON2:		// VhEE}bv̕ۑ
		D3DXSaveTextureToFile(L"Save.jpg",D3DXIFF_JPG, g_pShadowMap, NULL);
		break;
	case ID_BUTTON3:		// XN[Vbg̕ۑ
		DXUTSnapD3D9Screenshot(L"Screenshot.bmp");
		break;
	}
}

// bV̓ǂݍ݁A_`̐ݒAĚvZ
void LoadMesh(LPDIRECT3DDEVICE9 pD3DDevice, LPCTSTR pFileName, CDXUTXFileMesh **ppMesh, D3DXVECTOR3 *pBSCenter, FLOAT *pBSRadius)
{
	HRESULT hr;
	if (pD3DDevice == NULL)
		pD3DDevice = DXUTGetD3D9Device();	// D3DfoCX̎擾

	// VbV̒_vf
	D3DVERTEXELEMENT9 decl[] = 
	{
		{ 0,  0, D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },
		{ 0, 12, D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_NORMAL,   0 },
		{ 0, 24, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0 },
		D3DDECL_END()   // z̏I
	};
	LPVOID pBuffer;
	LPD3DXMESH pMesh;

	// ̃bV̍폜
	SAFE_DELETE(*ppMesh);

	// Xt@C̓ǂݍ
	(*ppMesh) = new CDXUTXFileMesh();
	hr = (*ppMesh)->Create(pD3DDevice, pFileName);	// Xt@C
	if (FAILED(hr))
	{
		SAFE_DELETE(*ppMesh);
		return;
	}

	// _tH[}bg̐ݒ
	hr = (*ppMesh)->SetVertexDecl(pD3DDevice, decl);
	if (FAILED(hr))
	{
		SAFE_DELETE(*ppMesh);
		return;
	}

	// `pbV̍쐬
	hr = (*ppMesh)->RestoreDeviceObjects(pD3DDevice);
	if (FAILED(hr)) {
		SAFE_DELETE(*ppMesh);
	    return;
	}

	// ĚvZ
	pMesh = (*ppMesh)->GetMesh();		// CDXUTXFileMeshNXǗĂ郁bV擾
	pMesh->LockVertexBuffer(D3DLOCK_READONLY, &pBuffer);		// bV̒_obt@bN

	// bV̋E߂
	D3DXComputeBoundingSphere(
		(D3DXVECTOR3 *)pBuffer,        // ŏ̒_Wf[^̈ʒu
		pMesh->GetNumVertices(),       // bV̒_
		pMesh->GetNumBytesPerVertex(), // bV̒_f[^̑傫
		pBSCenter, pBSRadius);

	pMesh->UnlockVertexBuffer();		// bN_obt@AbN
}

// *****************************************
// **** foCX쐬֘ÃR[obN֐

// p\ȃfoCX̗(R[obN֐)
bool CALLBACK DXUTCallbackIsDeviceAcceptable(
		D3DCAPS9 *pCaps, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, bool bWindowed, void* pUserContext)

{
	if (pCaps->MaxPrimitiveCount < 0xFFFF)		// v~eBu
		return false;
	if (pCaps->MaxVertexIndex < 0xFFF0)			// CfbNX
		return false;
	if (pCaps->PixelShaderVersion < D3DPS_VERSION(2, 0))	// sNZEVF[_
		return false;

	return true;	// ̃foCX̎gpe
}

// 쐬foCXݒ̕ύX(R[obN֐)
bool CALLBACK DXUTCallbackModifyDeviceSettings(
		DXUTDeviceSettings *pDeviceSettings, void* pUserContext)
{
	// Direct3D 9foCXg邱ƂmF
	if( pDeviceSettings->ver == DXUT_D3D9_DEVICE )
	{
		// D3D9foCX̔\͂擾
		D3DCAPS9 caps;
		DXUTGetD3D9DeviceCaps( pDeviceSettings, &caps );

		// ŏɃt@X foCXIꂽƂɁAx\
		static bool s_bFirstTime = true;
		if( s_bFirstTime )
		{
			s_bFirstTime = false;
			if( pDeviceSettings->d3d9.DeviceType == D3DDEVTYPE_REF )
				DXUTDisplaySwitchingToREFWarning(pDeviceSettings->ver);
		}

		// o[W2.0̒_VF[_n[hEFAŃT|[gĂȂꍇ́A\tgEFAg
		if ((caps.DevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) == 0 ||
				caps.VertexShaderVersion < D3DVS_VERSION(2, 0))
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_HARDWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_PUREDEVICE;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_SOFTWARE_VERTEXPROCESSING;	// \tgEFA_
		}
		else
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_SOFTWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_HARDWARE_VERTEXPROCESSING;	//n[hEFA_
		}

		// Avdouble^g(x͒ቺ)
		pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_FPU_PRESERVE;
	}

	return true;
}

// foCX쐬̏(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceCreated(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9CreateDevice( pd3dDevice ) );
	V_RETURN( g_SettingsDlg.OnD3D9CreateDevice( pd3dDevice ) );

	// **** GtFNg̍쐬 ****
	// fxt@Č
	WCHAR fxFileName[MAX_PATH];
	DXUTFindDXSDKMediaFileCch(fxFileName, MAX_PATH, L"Shader12.fx");

	// ID3DXEffectC^[tFCX̍쐬
	V_RETURN(D3DXCreateEffectFromFile(
		pd3dDevice,				// GtFNgfoCX
		fxFileName,				// GtFNgEt@C
		NULL,
		NULL,
		0,						// RpCEIvV
		NULL,
		&g_pD3DXEffect,			// GtFNg󂯎ϐ
		NULL));

	g_hShadowMap_Tech = g_pD3DXEffect->GetTechniqueByName("ShadowMap_Tech");
	g_hNormal_Tech    = g_pD3DXEffect->GetTechniqueByName("Normal_Tech");
	g_hNoShadow_Tech  = g_pD3DXEffect->GetTechniqueByName("NoShadow_Tech");

	g_hTexShadow           = g_pD3DXEffect->GetParameterByName(NULL, "TexShadow");
	g_hWorldViewProj       = g_pD3DXEffect->GetParameterByName(NULL, "WorldViewProj");
	g_hWorldViewProjShadow = g_pD3DXEffect->GetParameterByName(NULL, "WorldViewProjShadow");
	g_hLightPos            = g_pD3DXEffect->GetParameterByName(NULL, "LightPos");
	g_hLightBrightness     = g_pD3DXEffect->GetParameterByName(NULL, "LightBrightness");
	g_hModelScale          = g_pD3DXEffect->GetParameterByName(NULL, "ModelScale");
	g_hTex                 = g_pD3DXEffect->GetParameterByName(NULL, "Tex");
	g_hDiffuse             = g_pD3DXEffect->GetParameterByName(NULL, "Diffuse");

	return hr;
}

// *****************************************
// **** bZ[W֘ÃR[obN֐

// EChEEbZ[W̏(R[obN֐)
LRESULT CALLBACK DXUTCallbackMsgProc(
			HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, bool *pbNoFurtherProcessing, void* pUserContext)
{
	// GUI\[XǗ
	*pbNoFurtherProcessing = g_DialogResourceManager.MsgProc( hWnd, uMsg, wParam, lParam );
	if( *pbNoFurtherProcessing )
		return 0;

	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.MsgProc( hWnd, uMsg, wParam, lParam );
		return 0;
	}

	// foCX֘A_CAÕbZ[W
	*pbNoFurtherProcessing = g_DeviceUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// Xe[^X\_CAÕbZ[W
	*pbNoFurtherProcessing = g_StatusUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// _CAO@̃bZ[W
	*pbNoFurtherProcessing = g_SampleUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	*pbNoFurtherProcessing = false;  // t[[NŃbZ[W
	return 0;
}

// *****************************************
// **** V[`֘ÃR[obN֐

// V[̍XV(R[obN֐)
void CALLBACK DXUTCallbackFrameMove(
		double fTime, float fElapsedTime, void* pUserContext)
{
	// Xe[^X̕\
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->SetText(DXUTGetDeviceStats());
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->SetText(DXUTGetFrameStats(true));

	// ********** V[̕`pϊs **********
	D3DXMATRIX mat1, mat2, mat3;

	// ̗p[hϊs
	D3DXMatrixTranslation(&mat1, -g_BSCenter.x, -g_BSCenter.y, -g_BSCenter.z); // bV̒S֕sړ
	g_fMeshScale = 1.0f / g_BSRadius;
	D3DXMatrixScaling(&mat2, g_fMeshScale, g_fMeshScale, g_fMeshScale);		// bV̑傫ɍ킹ăXP[O
	FLOAT ry = (float)fTime * D3DX_PI;					// ]px(2b1])
	D3DXMatrixRotationY(&mat3, ry);						// [hϊs(Y𒆐Sɉ])
	g_matWorldViewProj = mat1 * mat2 * mat3;
	g_matShadow = g_matWorldViewProj;

	D3DXMatrixInverse(&mat1, NULL, &g_matWorldViewProj);	// ts
	D3DXVec3Transform(&g_vLightModel, &g_vLight, &mat1);	// fԂł̌ʒu

	// nʗp[hϊs
	D3DXMatrixTranslation(&mat1, -g_BSCenterGround.x, -(g_BSCenterGround.y + g_BSRadiusGround / 3.0f), -g_BSCenterGround.z); // bV̒S֕sړ
	g_fMeshGroundScale = 2.0f / g_BSRadiusGround;
	D3DXMatrixScaling(&mat2, g_fMeshGroundScale, g_fMeshGroundScale, g_fMeshGroundScale);		// bV̑傫ɍ킹ăXP[O
	g_matWorldViewProjGround = mat1 * mat2 * mat3;
	g_matShadowGround = g_matWorldViewProjGround;

	D3DXMatrixInverse(&mat1, NULL, &g_matWorldViewProjGround);	// ts
	D3DXVec3Transform(&g_vLightModelGround, &g_vLight, &mat1);	// fԂł̌ʒu(n)

	// r[ϊs
	D3DXMatrixLookAtLH(&mat1, &g_vEye, &g_vAt, &g_vUp);	// r[ϊs
	g_matWorldViewProj *= mat1;
	g_matWorldViewProjGround *= mat1;

	// ϊs
	D3DXMatrixPerspectiveFovLH(&mat1,				// eϊ
				D3DX_PI/3.0f,						// p60x
				g_Aspect,	// AXyNg
				1.0f,		// Oeʂ܂ł̋
				4.0f);		// eʂ܂ł̋
	g_matWorldViewProj *= mat1;
	g_matWorldViewProjGround *= mat1;

	// ********** VhEE}bv̕`pϊs **********
	// r[ϊs
	D3DXMatrixLookAtLH(&mat2, &g_vLight, &g_vLightAt, &g_vLightUp);
	// eϊ
	D3DXMatrixPerspectiveFovLH(&mat3,
				D3DX_PI/5.5f,						// p33x
				1.0f,		// AXyNg
				3.0f,		// Oeʂ܂ł̋
				5.5f);		// eʂ܂ł̋
	// [h~r[~ϊs
	g_matShadow       *= mat2 * mat3;
	g_matShadowGround *= mat2 * mat3;
}

// V[̕`(R[obN֐)
void CALLBACK DXUTCallbackFrameRender(
		LPDIRECT3DDEVICE9 pd3dDevice, double fTime, float fElapsedTime, void* pUserContext)
{
	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.OnRender( fElapsedTime );
		return;
	}

	if (SUCCEEDED(pd3dDevice->BeginScene()))
	{
		// *********** VhEE}bv̕` **********
		LPDIRECT3DSURFACE9 pRenderTarget;
		g_pShadowMap->GetSurfaceLevel(0, &pRenderTarget);  // VhEE}bṽT[tFX擾

		LPDIRECT3DSURFACE9 pOldRenderTarget, pOldDepth;
		pd3dDevice->GetRenderTarget(0, &pOldRenderTarget);  // ݂̕`ۑ
		pd3dDevice->SetRenderTarget(0, pRenderTarget);      // V`I
		pd3dDevice->GetDepthStencilSurface(&pOldDepth);        // ݂̐[xobt@ۑ
		pd3dDevice->SetDepthStencilSurface(g_pShadowMapDepth); // V[xobt@I

		// r[|[g̕ۑƕύX
		D3DVIEWPORT9 OldViewport;
		pd3dDevice->GetViewport(&OldViewport);
		D3DVIEWPORT9 Viewport = {0,0, 512, 512, 0.0f, 1.0f};
		pd3dDevice->SetViewport(&Viewport);

		// VhEE}bṽNA
		pd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(255, 0, 0), 1.0f, 0);

		// VhEE}bv̕`Jn
		g_pD3DXEffect->SetTechnique(g_hShadowMap_Tech);

		// bV`
		if (g_pMesh) {
			g_pD3DXEffect->SetMatrix(g_hWorldViewProjShadow, &g_matShadow);  // ϊs̐ݒ
			g_pMesh->Render(g_pD3DXEffect, NULL, NULL, NULL, NULL, NULL, NULL, TRUE, TRUE);
		}

		// VhEE}bv̕`I
		pd3dDevice->SetViewport(&OldViewport);
		pd3dDevice->SetRenderTarget(0, pOldRenderTarget);  // `ɖ߂
		pd3dDevice->SetDepthStencilSurface(pOldDepth);     // [xobt@ɖ߂

		SAFE_RELEASE(pOldRenderTarget);
		SAFE_RELEASE(pOldDepth);
		SAFE_RELEASE(pRenderTarget);

		// *********** V[̕` **********
		// V[̃NA
		pd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0, 0, 255), 1.0f, 0);

		// VF[_ŎgeNjbNI
		if (g_SampleUI.GetCheckBox(ID_CHECKBOX1)->GetChecked())
			g_pD3DXEffect->SetTechnique(g_hNormal_Tech);
		else
			g_pD3DXEffect->SetTechnique(g_hNoShadow_Tech);
		g_pD3DXEffect->SetTexture(g_hTexShadow, g_pShadowMap);

		// bV`
		if (g_pMesh) {
			g_pD3DXEffect->SetMatrix(g_hWorldViewProj, &g_matWorldViewProj);		// ϊs̐ݒ
			g_pD3DXEffect->SetMatrix(g_hWorldViewProjShadow, &g_matShadow);
			g_pD3DXEffect->SetVector(g_hLightPos, &g_vLightModel);					// ̈ʒu
			g_pD3DXEffect->SetFloat(g_hLightBrightness, g_fLightBrightness);		// ̋Px
			g_pD3DXEffect->SetFloat(g_hModelScale, g_fMeshScale);					// fԂ̃XP[
			g_pMesh->Render(g_pD3DXEffect, g_hTex, g_hDiffuse, NULL, NULL, NULL, NULL, TRUE, TRUE);
		}
		if (g_pMeshGround) {
			g_pD3DXEffect->SetMatrix(g_hWorldViewProj, &g_matWorldViewProjGround);	// ϊs̐ݒ
			g_pD3DXEffect->SetMatrix(g_hWorldViewProjShadow, &g_matShadowGround);
			g_pD3DXEffect->SetVector(g_hLightPos, &g_vLightModelGround);			// ̈ʒu
			g_pD3DXEffect->SetFloat(g_hLightBrightness, g_fLightBrightness);		// ̋Px
			g_pD3DXEffect->SetFloat(g_hModelScale, g_fMeshGroundScale);				// fԂ̃XP[
			g_pMeshGround->Render(g_pD3DXEffect, g_hTex, g_hDiffuse, NULL, NULL, NULL, NULL, TRUE, TRUE);
		}

		// _CAO`
		g_DeviceUI.OnRender(fElapsedTime);
		g_StatusUI.OnRender(fElapsedTime);
		g_SampleUI.OnRender(fElapsedTime);

		// V[̕`I
		pd3dDevice->EndScene();
	}
}

// *****************************************
// **** foCX̏֘ÃR[obN֐

// foCX̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceLost(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9LostDevice();
	g_SettingsDlg.OnD3D9LostDevice();

	// bV̏
	if (g_pMesh)
		g_pMesh->InvalidateDeviceObjects();
	if (g_pMeshGround)
		g_pMeshGround->InvalidateDeviceObjects();

	// GtFNg̏
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnLostDevice();

	// _O\eNX`̏
	SAFE_RELEASE(g_pShadowMap);
	SAFE_RELEASE(g_pShadowMapDepth);
}

// foCX̃XgA(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceReset(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr = S_OK;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9ResetDevice() );
	V_RETURN( g_SettingsDlg.OnD3D9ResetDevice() );

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= pBackBufferSurfaceDesc->Width;
	vp.Height	= pBackBufferSurfaceDesc->Height;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	V_RETURN(pd3dDevice->SetViewport(&vp));

	// ʂ̃AXyNg
	g_Aspect = (float)pBackBufferSurfaceDesc->Width / (float)pBackBufferSurfaceDesc->Height;

	// GtFNg̃XgA
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnResetDevice();

	// bṼXgA
	if (g_pMesh)
		g_pMesh->RestoreDeviceObjects(pd3dDevice);
	if (g_pMeshGround)
		g_pMeshGround->RestoreDeviceObjects(pd3dDevice);
	else
		LoadMesh(pd3dDevice, L"Ground.x", &g_pMeshGround, &g_BSCenterGround, &g_BSRadiusGround);

	// _O\eNX`̍쐬
	V_RETURN(D3DXCreateTexture(pd3dDevice, 512, 512, 1, D3DUSAGE_RENDERTARGET,
					D3DFMT_R16F, D3DPOOL_DEFAULT, &g_pShadowMap));
	V_RETURN(pd3dDevice->CreateDepthStencilSurface(512, 512, D3DFMT_D16, D3DMULTISAMPLE_NONE, 0, TRUE,
					&g_pShadowMapDepth, NULL));

	// _CAO̔zu
	g_DeviceUI.SetLocation(pBackBufferSurfaceDesc->Width - 150, 0);     // _CAO̍W(-150, 0)
	g_DeviceUI.SetSize(150, 110);     // _CAȎ傫(150~110)

	g_StatusUI.SetLocation(0, 0);     // _CAO̍W(0, 0)
	g_StatusUI.SetSize(500, 50);      // _CAȎ傫(500~50)

	g_SampleUI.SetLocation(pBackBufferSurfaceDesc->Width  - 150, 
							pBackBufferSurfaceDesc->Height - 130);      // _CAO̍W(-150, -130)
	g_SampleUI.SetSize(150, 130);     // _CAȎ傫(150~130)

	return hr;	// I
}

// *****************************************
// **** foCX폜֘ÃR[obN֐

// foCX폜̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceDestroyed(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9DestroyDevice();
	g_SettingsDlg.OnD3D9DestroyDevice();

	// bV̊J
	SAFE_DELETE(g_pMesh);
	SAFE_DELETE(g_pMeshGround);

	// 擾IuWFNg̊J
	SAFE_RELEASE(g_pD3DXEffect);
}

// *****************************************
// WinMain֐ƃAvP[V֘Ȁ

// AvP[V֘Ȁ
void InitApp(void)
{
	// DXUTɃfBApXݒ肷
	size_t ReturnValue;
	WCHAR sdk_path[MAX_PATH];
	if (_wgetenv_s(&ReturnValue, sdk_path, MAX_PATH, L"DXSDK_DIR") == 0) {
		StringCbCat(sdk_path, MAX_PATH, L"\\Samples\\Media");
		DXUTSetMediaSearchPath(sdk_path);
	}

	// GUI\[XǗ(_CAȌ)
	g_SettingsDlg.Init( &g_DialogResourceManager );
	g_DeviceUI.Init( &g_DialogResourceManager );
	g_StatusUI.Init( &g_DialogResourceManager );
	g_SampleUI.Init( &g_DialogResourceManager );

	// Windows 2000pɓ{tHgݒ(Vista,XPł͕sv)B
	g_DeviceUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );
	g_SampleUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );

	// GUIRg[̃bZ[W󂯎R[obN֐_CAOɓo^
	g_DeviceUI.SetCallback(DXUTCallbackGUIEvent);
	g_SampleUI.SetCallback(DXUTCallbackGUIEvent);

	// GUIRg[_CAOɓo^
	int iY = 10;
	g_DeviceUI.AddButton(ID_DISPLAYMODE,  L"ʃ[h",   10, iY,       125, 22);
	g_DeviceUI.AddButton(ID_HALREF,       L"foCX",     10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_CHANGEDEVICE, L"foCXݒ", 10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_PAUSE,        L"ꎞ~",     10, iY += 24, 125, 22);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_StatusUI.AddStatic(ID_DEVICESTATUS, L"", 10, iY,       490, 22);
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,255,0,255), DT_LEFT | DT_VCENTER);
	g_StatusUI.AddStatic(ID_FRAMESTATUS,  L"", 10, iY += 24, 490, 22);
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,0,255,255), DT_LEFT | DT_VCENTER);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_SampleUI.AddEditBox(ID_EDIT1, L"Dwarf\\Dwarf.x",  10, iY,       125, 32);
	g_SampleUI.AddButton(ID_BUTTON1, L"ǂݍ",       10, iY += 34, 125, 22);
	g_SampleUI.AddButton(ID_BUTTON2, L"ShadowMapۑ",  10, iY += 24, 125, 22);
	g_SampleUI.AddButton(ID_BUTTON3, L"Screenshotۑ", 10, iY += 24, 125, 22);
	g_SampleUI.AddCheckBox(ID_CHECKBOX1, L"e",     10, iY += 24, 125, 22, TRUE);
}

// **** WinMain֐
int WINAPI wWinMain(HINSTANCE, HINSTANCE, LPWSTR, int)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// ** R[obN֐̓o^ **
	// foCX쐬̏
	DXUTSetCallbackD3D9DeviceCreated(DXUTCallbackDeviceCreated);
	// EChEEbZ[W̏
	DXUTSetCallbackMsgProc(DXUTCallbackMsgProc);
	// V[̍XV
	DXUTSetCallbackFrameMove(DXUTCallbackFrameMove);
	// V[̕`
	DXUTSetCallbackD3D9FrameRender(DXUTCallbackFrameRender);
	// foCX̏
	DXUTSetCallbackD3D9DeviceLost(DXUTCallbackDeviceLost);
	// foCX̃XgA
	DXUTSetCallbackD3D9DeviceReset(DXUTCallbackDeviceReset);
	// foCX폜̏
	DXUTSetCallbackD3D9DeviceDestroyed(DXUTCallbackDeviceDestroyed);

	// p\ȃfoCX̗
	DXUTSetCallbackD3D9DeviceAcceptable(DXUTCallbackIsDeviceAcceptable);
	// 쐬foCXݒ̕ύX
	DXUTSetCallbackDeviceChanging(DXUTCallbackModifyDeviceSettings);

	// tXN[E[hŃ}EXEJ[\\
	DXUTSetCursorSettings(true, true);

	// **  **
	InitApp();				// AvP[V֘Ȁ

	DXUTInit(true, true);                     // TvEt[[N̏
	DXUTSetHotkeyHandling(true);              // zbgEL[̐ݒ
	DXUTCreateWindow(L"Direct3D 9 Sample28"); // EChE̍쐬

	DXUTCreateDevice(true, 640, 480);  // foCX̍쐬(R[obN֐̎s)

	// ** CE[v **
	DXUTMainLoop();    // bZ[WE[vs

	return DXUTGetExitCode();  // I
}
