/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample26.cpp
		usX^bNgTvv
--------------------------------------------------------------*/

#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓnȂ
#define DXUT_AUTOLIB		// DXUTŕKvȃCu(dsound.libȊO)IɃN
#include "DXUT.h"			// DXUTg
#include "SDKmisc.h"		// DXUT Optionalg
#include "DXUTgui.h"		// DXUT OptionalGUIg
#include "DXUTSettingsDlg.h"	//DXUT OptionalCD3DSettingsDlgNXg	
#include "resource.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// *****************************************
// **** O[oϐ

// J
D3DXVECTOR3 g_vEye(0.0f, 2.1f, -2.0f);		// J̍W
D3DXVECTOR3 g_vAt(0.0f, 0.1f, 0.0f);		// _
D3DXVECTOR3 g_vUp(0.0f, 1.0f, 0.0f);		// J̏xNg

D3DXMATRIX g_matViewProj;					// r[~ϊs
float      g_Aspect;						// ʂ̃AXyNg

// 
D3DXVECTOR3 g_vLight(2.5, 2.5f, -2.5f);		// ̍W
float       g_fLightBrightness = 25.0f;		// ̋Px

// GtFNg
LPD3DXEFFECT g_pD3DXEffect = NULL;			// `ɎgGtFNg

D3DXHANDLE g_hMatStack_Tech = NULL;			// GtFNg̕`ɎgeNjbN

D3DXHANDLE g_hWorldViewProj   = NULL;	// ϊs
D3DXHANDLE g_hLightPos        = NULL;	// ̈ʒu(f)
D3DXHANDLE g_hLightBrightness = NULL;	// ̋Px
D3DXHANDLE g_hModelScale      = NULL;	// fԂ̃XP[

// bV
LPD3DXMESH g_pMeshHand = NULL;
LPD3DXMESH g_pMeshFingerA = NULL;
LPD3DXMESH g_pMeshFingerB = NULL;
LPD3DXMESH g_pMeshFingerC = NULL;
float      g_fMeshScale = 1.0f;				// bṼXP[

// sX^bN
LPD3DXMATRIXSTACK g_pMatStack = NULL;
D3DXMATRIX g_matFinger1, g_matFinger2, g_matFinger3, g_matFinger4, g_matFinger5;
D3DXMATRIX g_matFingerA, g_matFingerB, g_matFingerC;

// *****************************************
// **** O[oϐ(GUI@\)

// GUI\[XǗ
CDXUTDialogResourceManager	g_DialogResourceManager; // _CAÕ\[XǗ
CD3DSettingsDlg				g_SettingsDlg;           // foCXݒ_CAO

// foCX֘Aݒ_CAO(E)
enum { ID_DISPLAYMODE = 0, ID_HALREF, ID_CHANGEDEVICE, ID_PAUSE }; // Rg[ID
CDXUTDialog  g_DeviceUI;    // _CAO

// Xe[^X\_CAO()
enum { ID_DEVICESTATUS = 50, ID_FRAMESTATUS }; // Rg[ID
CDXUTDialog  g_StatusUI;    // _CAO

// _CAO@(ݒBE)
enum {  ID_SLIDER1 = 100, ID_SLIDER2, ID_SLIDER3, ID_SLIDER4, ID_SLIDER5, ID_SLIDER6 }; // Rg[ID
CDXUTDialog  g_SampleUI;   // _CAO@

// *****************************************
// **** GUI֘Å֐

// _CAOĂяoR[obN֐
void CALLBACK DXUTCallbackGUIEvent(UINT nEvent, int nControlID, CDXUTControl* pControl, void* pUserContext)
{
	switch (nControlID)
	{
	// foCX֘Aݒ_CAO
	case ID_DISPLAYMODE:	// ʃ[h؂ւ(EChEE[hƃtXN[E[h)
		DXUTToggleFullScreen();
		break;
	case ID_HALREF:			// foCX؂ւ(REFHAL)
		DXUTToggleREF();
		break;
	case ID_CHANGEDEVICE:	// foCXݒʂ̕\
		g_SettingsDlg.SetActive(!g_SettingsDlg.IsActive());
		break;
	case ID_PAUSE:			// ꎞ~
		DXUTPause(!DXUTIsTimePaused(), false);
		break;
	}
}

// *****************************************
// **** foCX쐬֘ÃR[obN֐

// p\ȃfoCX̗(R[obN֐)
bool CALLBACK DXUTCallbackIsDeviceAcceptable(
		D3DCAPS9 *pCaps, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, bool bWindowed, void* pUserContext)

{
	if (pCaps->MaxPrimitiveCount < 0xFFFF)		// v~eBu
		return false;
	if (pCaps->MaxVertexIndex < 0xFFF0)			// CfbNX
		return false;
	if (pCaps->PixelShaderVersion < D3DPS_VERSION(2, 0))	// sNZEVF[_
		return false;

	return true;	// ̃foCX̎gpe
}

// 쐬foCXݒ̕ύX(R[obN֐)
bool CALLBACK DXUTCallbackModifyDeviceSettings(
		DXUTDeviceSettings *pDeviceSettings, void* pUserContext)
{
	// Direct3D 9foCXg邱ƂmF
	if( pDeviceSettings->ver == DXUT_D3D9_DEVICE )
	{
		// D3D9foCX̔\͂擾
		D3DCAPS9 caps;
		DXUTGetD3D9DeviceCaps( pDeviceSettings, &caps );

		// ŏɃt@X foCXIꂽƂɁAx\
		static bool s_bFirstTime = true;
		if( s_bFirstTime )
		{
			s_bFirstTime = false;
			if( pDeviceSettings->d3d9.DeviceType == D3DDEVTYPE_REF )
				DXUTDisplaySwitchingToREFWarning(pDeviceSettings->ver);
		}

		// o[W2.0̒_VF[_n[hEFAŃT|[gĂȂꍇ́A\tgEFAg
		if ((caps.DevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) == 0 ||
				caps.VertexShaderVersion < D3DVS_VERSION(2, 0))
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_HARDWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_PUREDEVICE;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_SOFTWARE_VERTEXPROCESSING;	// \tgEFA_
		}
		else
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_SOFTWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_HARDWARE_VERTEXPROCESSING;	//n[hEFA_
		}

		// Avdouble^g(x͒ቺ)
		pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_FPU_PRESERVE;
	}

	return true;
}

// foCX쐬̏(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceCreated(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9CreateDevice( pd3dDevice ) );
	V_RETURN( g_SettingsDlg.OnD3D9CreateDevice( pd3dDevice ) );

	// **** GtFNg̍쐬 ****
	// fxt@Č
	WCHAR fxFileName[MAX_PATH];
	DXUTFindDXSDKMediaFileCch(fxFileName, MAX_PATH, L"Shader10.fx");

	// ID3DXEffectC^[tFCX̍쐬
	V_RETURN(D3DXCreateEffectFromFile(
		pd3dDevice,				// GtFNgfoCX
		fxFileName,				// GtFNgEt@C
		NULL,
		NULL,
		0,						// RpCEIvV
		NULL,
		&g_pD3DXEffect,			// GtFNg󂯎ϐ
		NULL));

	// nh̎擾
	g_hMatStack_Tech = g_pD3DXEffect->GetTechniqueByName("MatStack_Tech");

	g_hWorldViewProj   = g_pD3DXEffect->GetParameterByName(NULL, "WorldViewProj");
	g_hLightPos        = g_pD3DXEffect->GetParameterByName(NULL, "LightPos");
	g_hLightBrightness = g_pD3DXEffect->GetParameterByName(NULL, "LightBrightness");
	g_hModelScale      = g_pD3DXEffect->GetParameterByName(NULL, "ModelScale");

	// Ǝw\郁bV̍쐬
	V_RETURN(D3DXCreateBox(pd3dDevice,      0.4f, 0.1f, 0.5f, &g_pMeshHand, NULL));  // ̂Ђ
	V_RETURN(D3DXCreateCylinder(pd3dDevice, 0.05f, 0.05f, 0.2f, 16, 4, &g_pMeshFingerA, NULL));  // w̑1
	V_RETURN(D3DXCreateCylinder(pd3dDevice, 0.05f, 0.05f, 0.1f, 16, 4, &g_pMeshFingerB, NULL));  // w̑2
	V_RETURN(D3DXCreateCylinder(pd3dDevice, 0.05f, 0.05f, 0.1f, 16, 4, &g_pMeshFingerC, NULL));  // w̑3

	D3DXMatrixTranslation(&g_matFinger1, -0.15f, 0.0f, 0.25f);
	D3DXMatrixTranslation(&g_matFinger2, -0.05f, 0.0f, 0.25f);
	D3DXMatrixTranslation(&g_matFinger3,  0.05f, 0.0f, 0.25f);
	D3DXMatrixTranslation(&g_matFinger4,  0.15f, 0.0f, 0.25f);
	D3DXMATRIX mat1, mat2, mat3;
	D3DXMatrixRotationZ(&mat1, D3DX_PI / 5.0f);
	D3DXMatrixRotationY(&mat2, D3DX_PI / 5.0f);
	D3DXMatrixTranslation(&mat3,  0.25f, 0.0f, 0.0f);
	g_matFinger5 = mat1 * mat2 * mat3;

	D3DXMatrixTranslation(&g_matFingerA, 0.0f, 0.0f, 0.1f);
	D3DXMatrixTranslation(&g_matFingerB, 0.0f, 0.0f, 0.05f);
	D3DXMatrixTranslation(&g_matFingerC, 0.0f, 0.0f, 0.05f);

	// sX^bN̍쐬
	V_RETURN(D3DXCreateMatrixStack(0, &g_pMatStack));

	return hr;
}

// *****************************************
// **** bZ[W֘ÃR[obN֐

// EChEEbZ[W̏(R[obN֐)
LRESULT CALLBACK DXUTCallbackMsgProc(
			HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, bool *pbNoFurtherProcessing, void* pUserContext)
{
	// GUI\[XǗ
	*pbNoFurtherProcessing = g_DialogResourceManager.MsgProc( hWnd, uMsg, wParam, lParam );
	if( *pbNoFurtherProcessing )
		return 0;

	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.MsgProc( hWnd, uMsg, wParam, lParam );
		return 0;
	}

	// foCX֘A_CAÕbZ[W
	*pbNoFurtherProcessing = g_DeviceUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// Xe[^X\_CAÕbZ[W
	*pbNoFurtherProcessing = g_StatusUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// _CAO@̃bZ[W
	*pbNoFurtherProcessing = g_SampleUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	*pbNoFurtherProcessing = false;  // t[[NŃbZ[W
	return 0;
}

// *****************************************
// **** V[`֘ÃR[obN֐

// V[̍XV(R[obN֐)
void CALLBACK DXUTCallbackFrameMove(
		double fTime, float fElapsedTime, void* pUserContext)
{
	// Xe[^X̕\
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->SetText(DXUTGetDeviceStats());
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->SetText(DXUTGetFrameStats(true));

	// V[̕`pϊs
	D3DXMATRIX matWorld, matView, matProj;
	FLOAT ry = (float)fTime * D3DX_PI;					// ]px(2b1])
	D3DXMatrixRotationY(&matWorld, ry);					// [hϊs(Y𒆐Sɉ])

	D3DXMatrixLookAtLH(&matView, &g_vEye, &g_vAt, &g_vUp);	// r[ϊs

	D3DXMatrixPerspectiveFovLH(&matProj,				// eϊ
				D3DX_PI / 6.0f,							// p30x
				g_Aspect,	// AXyNg
				0.1f,		// Oeʂ܂ł̋
				10.0f);		// eʂ܂ł̋

	g_matViewProj = matView * matProj;
}

// V[̕`(R[obN֐)
void RenderFinger(float fFinger, const D3DXMATRIX &matFinger,
			const D3DXMATRIX &matFingerA, const D3DXMATRIX &matFingerB, const D3DXMATRIX &matFingerC);
void RenderMesh(LPD3DXMESH pMesh);

void CALLBACK DXUTCallbackFrameRender(
		LPDIRECT3DDEVICE9 pd3dDevice, double fTime, float fElapsedTime, void* pUserContext)
{
	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.OnRender( fElapsedTime );
		return;
	}

	// V[̃NA
	pd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
						D3DCOLOR_XRGB(0, 0, 255), 1.0f, 0);

	// V[̕`Jn
	if (SUCCEEDED(pd3dDevice->BeginScene()))
	{
		// GtFNgŎgeNjbNI
		g_pD3DXEffect->SetTechnique(g_hMatStack_Tech);    // eNjbNg

		// ̕`
		float fHand = g_SampleUI.GetSlider(ID_SLIDER1)->GetValue() * D3DX_PI / -200.0f;
		float fFinger1 = g_SampleUI.GetSlider(ID_SLIDER2)->GetValue() * D3DX_PI / -200.0f;
		float fFinger2 = g_SampleUI.GetSlider(ID_SLIDER3)->GetValue() * D3DX_PI / -200.0f;
		float fFinger3 = g_SampleUI.GetSlider(ID_SLIDER4)->GetValue() * D3DX_PI / -200.0f;
		float fFinger4 = g_SampleUI.GetSlider(ID_SLIDER5)->GetValue() * D3DX_PI / -200.0f;
		float fFinger5 = g_SampleUI.GetSlider(ID_SLIDER6)->GetValue() * D3DX_PI / -200.0f;

		D3DXMATRIX matWorld, mat;

		// Y𒆐Sɉ]
		FLOAT ry = (float)fTime * D3DX_PI;		// ]px(2b1])
		D3DXMatrixRotationY(&matWorld, ry);		// [hϊs

		// ̉]s
		D3DXMatrixRotationX(&mat, fHand);
		mat = mat * matWorld;
		g_pMatStack->Push();
		g_pMatStack->MultMatrixLocal(&mat);
		RenderMesh(g_pMeshHand);

		RenderFinger(fFinger1, g_matFinger1, g_matFingerA, g_matFingerB, g_matFingerC); // w
		RenderFinger(fFinger2, g_matFinger2, g_matFingerA, g_matFingerB, g_matFingerC); // w
		RenderFinger(fFinger3, g_matFinger3, g_matFingerA, g_matFingerB, g_matFingerC); // w
		RenderFinger(fFinger4, g_matFinger4, g_matFingerA, g_matFingerB, g_matFingerC); // lw
		RenderFinger(fFinger5, g_matFinger5, g_matFingerA, g_matFingerB, g_matFingerC); // ew

		g_pMatStack->Pop();

		// _CAO`
		g_DeviceUI.OnRender(fElapsedTime);
		g_StatusUI.OnRender(fElapsedTime);
		g_SampleUI.OnRender(fElapsedTime);

		// V[̕`I
		pd3dDevice->EndScene();
	}
}

void RenderFinger(float fFinger, const D3DXMATRIX &matFinger,
			const D3DXMATRIX &matFingerA, const D3DXMATRIX &matFingerB, const D3DXMATRIX &matFingerC)
{
	D3DXMATRIX mat, matRotat;
	D3DXMatrixRotationX(&matRotat, fFinger);  // ew֐߂̉]s

	// ֐
	g_pMatStack->Push();
	mat = matFingerA * matRotat * matFinger;
	g_pMatStack->MultMatrixLocal(&mat);
	RenderMesh(g_pMeshFingerA);

	// ֐
	g_pMatStack->Push();
	mat = matFingerB * matRotat * matFingerA;
	g_pMatStack->MultMatrixLocal(&mat);
	RenderMesh(g_pMeshFingerB);

	// O֐
	g_pMatStack->Push();
	mat = matFingerC * matRotat * matFingerB;
	g_pMatStack->MultMatrixLocal(&mat);
	RenderMesh(g_pMeshFingerC);

	g_pMatStack->Pop();
	g_pMatStack->Pop();
	g_pMatStack->Pop();
}

void RenderMesh(LPD3DXMESH pMesh)
{
	HRESULT hr;

	// [hϊs
	D3DXMATRIX *matWorld = g_pMatStack->GetTop();

	// ϊs
	D3DXMATRIX matWVP = (*matWorld) * g_matViewProj;
	g_pD3DXEffect->SetMatrix(g_hWorldViewProj, &matWVP);

	// fԂł̌̈ʒu
	D3DXMATRIX mat;
	D3DXVECTOR4 vLightModel;
	D3DXMatrixInverse(&mat, NULL, matWorld);				// [hԁfԂւ̕ϊs
	D3DXVec3Transform(&vLightModel, &g_vLight, &mat);

	// ̈ʒuݒ
	g_pD3DXEffect->SetVector(g_hLightPos, &vLightModel);				// ̈ʒu(f)
	g_pD3DXEffect->SetFloat(g_hLightBrightness, g_fLightBrightness);	// ̋Px
	g_pD3DXEffect->SetFloat(g_hModelScale, g_fMeshScale);				// fԂ̃XP[

	// eNjbN̊Jn
	UINT numPass;
	g_pD3DXEffect->Begin(&numPass, 0);      //eNjbN̊Jn(Xe[gۑ)

	// eNjbÑpXs
	for (UINT iPass = 0; iPass < numPass; iPass++)
	{
		V(g_pD3DXEffect->BeginPass(iPass));     // iPassԖڂ̃pX̎sJn
		if (FAILED(hr))
			break;   // pX̎sɎs

		pMesh->DrawSubset(0);					// bV`

		g_pD3DXEffect->EndPass();				// pX̎sI
	}

	// eNjbN̏I
	g_pD3DXEffect->End();             // eNjbN̏I(ۑXe[g𕜌)
}

// *****************************************
// **** foCX̏֘ÃR[obN֐

// foCX̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceLost(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9LostDevice();
	g_SettingsDlg.OnD3D9LostDevice();

	// GtFNg̏
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnLostDevice();
}

// foCX̃XgA(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceReset(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr = S_OK;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9ResetDevice() );
	V_RETURN( g_SettingsDlg.OnD3D9ResetDevice() );

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= pBackBufferSurfaceDesc->Width;
	vp.Height	= pBackBufferSurfaceDesc->Height;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	V_RETURN(pd3dDevice->SetViewport(&vp));

	// ʂ̃AXyNg
	g_Aspect = (float)pBackBufferSurfaceDesc->Width / (float)pBackBufferSurfaceDesc->Height;

	// GtFNg̃XgA
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnResetDevice();

	// _CAO̔zu
	g_DeviceUI.SetLocation(pBackBufferSurfaceDesc->Width - 150, 0);     // _CAO̍W(-150, 0)
	g_DeviceUI.SetSize(150, 110);     // _CAȎ傫(150~110)

	g_StatusUI.SetLocation(0, 0);     // _CAO̍W(0, 0)
	g_StatusUI.SetSize(500, 50);      // _CAȎ傫(500~50)

	g_SampleUI.SetLocation(pBackBufferSurfaceDesc->Width  - 150, 
							pBackBufferSurfaceDesc->Height - 150);      // _CAO̍W(-150, -150)
	g_SampleUI.SetSize(150, 150);     // _CAȎ傫(150~150)

	return hr;	// I
}

// *****************************************
// **** foCX폜֘ÃR[obN֐

// foCX폜̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceDestroyed(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9DestroyDevice();
	g_SettingsDlg.OnD3D9DestroyDevice();

	// 擾IuWFNg̊J
	SAFE_RELEASE(g_pMatStack);
	SAFE_RELEASE(g_pMeshHand);
	SAFE_RELEASE(g_pMeshFingerA);
	SAFE_RELEASE(g_pMeshFingerB);
	SAFE_RELEASE(g_pMeshFingerC);
	SAFE_RELEASE(g_pD3DXEffect);
}

// *****************************************
// WinMain֐ƃAvP[V֘Ȁ

// AvP[V֘Ȁ
void InitApp(void)
{
	// GUI\[XǗ(_CAȌ)
	g_SettingsDlg.Init( &g_DialogResourceManager );
	g_DeviceUI.Init( &g_DialogResourceManager );
	g_StatusUI.Init( &g_DialogResourceManager );
	g_SampleUI.Init( &g_DialogResourceManager );

	// Windows 2000pɓ{tHgݒ(Vista,XPł͕sv)B
	g_DeviceUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );
	g_SampleUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );

	// GUIRg[̃bZ[W󂯎R[obN֐_CAOɓo^
	g_DeviceUI.SetCallback(DXUTCallbackGUIEvent);
	g_SampleUI.SetCallback(DXUTCallbackGUIEvent);

	// GUIRg[_CAOɓo^
	int iY = 10;
	g_DeviceUI.AddButton(ID_DISPLAYMODE,  L"ʃ[h",   10, iY,       125, 22);
	g_DeviceUI.AddButton(ID_HALREF,       L"foCX",     10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_CHANGEDEVICE, L"foCXݒ", 10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_PAUSE,        L"ꎞ~",     10, iY += 24, 125, 22);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_StatusUI.AddStatic(ID_DEVICESTATUS, L"", 10, iY,       490, 22);
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,255,0,255), DT_LEFT | DT_VCENTER);
	g_StatusUI.AddStatic(ID_FRAMESTATUS,  L"", 10, iY += 24, 490, 22);
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,0,255,255), DT_LEFT | DT_VCENTER);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_SampleUI.AddSlider(ID_SLIDER1, 10, iY,       125, 22);
	g_SampleUI.AddSlider(ID_SLIDER2, 10, iY += 24, 125, 22);
	g_SampleUI.AddSlider(ID_SLIDER3, 10, iY += 24, 125, 22);
	g_SampleUI.AddSlider(ID_SLIDER4, 10, iY += 24, 125, 22);
	g_SampleUI.AddSlider(ID_SLIDER5, 10, iY += 24, 125, 22);
	g_SampleUI.AddSlider(ID_SLIDER6, 10, iY += 24, 125, 22);
}

// **** WinMain֐
int WINAPI wWinMain(HINSTANCE, HINSTANCE, LPWSTR, int)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// ** R[obN֐̓o^ **
	// foCX쐬̏
	DXUTSetCallbackD3D9DeviceCreated(DXUTCallbackDeviceCreated);
	// EChEEbZ[W̏
	DXUTSetCallbackMsgProc(DXUTCallbackMsgProc);
	// V[̍XV
	DXUTSetCallbackFrameMove(DXUTCallbackFrameMove);
	// V[̕`
	DXUTSetCallbackD3D9FrameRender(DXUTCallbackFrameRender);
	// foCX̏
	DXUTSetCallbackD3D9DeviceLost(DXUTCallbackDeviceLost);
	// foCX̃XgA
	DXUTSetCallbackD3D9DeviceReset(DXUTCallbackDeviceReset);
	// foCX폜̏
	DXUTSetCallbackD3D9DeviceDestroyed(DXUTCallbackDeviceDestroyed);

	// p\ȃfoCX̗
	DXUTSetCallbackD3D9DeviceAcceptable(DXUTCallbackIsDeviceAcceptable);
	// 쐬foCXݒ̕ύX
	DXUTSetCallbackDeviceChanging(DXUTCallbackModifyDeviceSettings);

	// tXN[E[hŃ}EXEJ[\\
	DXUTSetCursorSettings(true, true);

	// **  **
	InitApp();				// AvP[V֘Ȁ

	DXUTInit(true, true);                     // TvEt[[N̏
	DXUTSetHotkeyHandling(true);              // zbgEL[̐ݒ
	DXUTCreateWindow(L"Direct3D 9 Sample26"); // EChE̍쐬

	DXUTCreateDevice(true, 640, 480);  // foCX̍쐬(R[obN֐̎s)

	// ** CE[v **
	DXUTMainLoop();    // bZ[WE[vs

	return DXUTGetExitCode();  // I
}
