/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample16.cpp
		ubVǂݍރvOv
--------------------------------------------------------------*/

#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓnȂ
#define DXUT_AUTOLIB		// DXUTŕKvȃCu(dsound.libȊO)IɃN
#include "DXUT.h"			// DXUTg
#include "SDKmisc.h"		// DXUT Optionalg
#include "DXUTgui.h"		// DXUT OptionalGUIg
#include "DXUTSettingsDlg.h"	//DXUT OptionalCD3DSettingsDlgNXg	
#include <strsafe.h>		// StringCbCat֐g
#include "resource.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// *****************************************
// **** O[oϐ

// J
D3DXVECTOR3 g_vEye(0.0f, 1.0f, -2.0f);		// J̍W
D3DXVECTOR3 g_vAt(0.0f, 0.0f, 0.0f);		// _
D3DXVECTOR3 g_vUp(0.0f, 1.0f, 0.0f);		// J̏xNg

D3DXMATRIX g_matWorldViewProj;				// [h~r[~ϊs
float g_Aspect;								// ʂ̃AXyNg

// 
D3DXVECTOR3 g_vLight(2.0, 2.0f, -2.0f);		// ̍W
float       g_fLightBrightness = 15.0f;		// ̋Px

D3DXVECTOR4 g_vLightModel;					// ̍W(f)

// GtFNg
LPD3DXEFFECT g_pD3DXEffect = NULL;			// `ɎgGtFNg
const int    MAX_TECH = 16;
D3DXHANDLE   g_hTech[MAX_TECH];				// eNjbNEnh

D3DXHANDLE g_hWorldViewProj   = NULL;	// ϊs̐ݒ
D3DXHANDLE g_hLightPos        = NULL;	// ̈ʒu
D3DXHANDLE g_hLightBrightness = NULL;	// ̋Px
D3DXHANDLE g_hModelScale      = NULL;	// fԂ̃XP[
D3DXHANDLE g_hTex             = NULL;	// GtFNg̃eNX`ϐ
D3DXHANDLE g_hDiffuse         = NULL;	// GtFNg̃fBt[YFϐ

// bV
LPD3DXMESH          g_pD3DXMesh = NULL;		// bṼC^[tFCX
DWORD               g_dwNumMaterials = 0;	// }eȂ
D3DCOLORVALUE*      g_pMeshColor = NULL;	// }eA(F)
LPDIRECT3DTEXTURE9* g_pMeshTexture = NULL;	// }eA(eNX`)
D3DXVECTOR3 g_BSCenter(0.0f, 0.0f, 0.0f);	// E̒SW
FLOAT       g_BSRadius = 1.0f;				// E̔a
float       g_fMeshScale = 1.0f;			// bṼXP[

// *****************************************
// **** O[oϐ(GUI@\)

// GUI\[XǗ
CDXUTDialogResourceManager	g_DialogResourceManager; // _CAÕ\[XǗ
CD3DSettingsDlg				g_SettingsDlg;           // foCXݒ_CAO

// foCX֘Aݒ_CAO(E)
enum { ID_DISPLAYMODE = 0, ID_HALREF, ID_CHANGEDEVICE, ID_PAUSE }; // Rg[ID
CDXUTDialog  g_DeviceUI;    // _CAO

// Xe[^X\_CAO()
enum { ID_DEVICESTATUS = 50, ID_FRAMESTATUS }; // Rg[ID
CDXUTDialog  g_StatusUI;    // _CAO

// _CAO@(ݒBE)
enum {  ID_EDIT1 = 100, ID_BUTTON1, ID_LISTBOX1 }; // Rg[ID
CDXUTDialog  g_SampleUI;   // _CAO@

// *****************************************
// **** bV֘Å֐

// bV̊J
void ReleaseMesh(void)
{
	if (g_pMeshTexture)
	{
		for (DWORD i=0; i<g_dwNumMaterials; i++)
			SAFE_RELEASE(g_pMeshTexture[i]);    // e}eÃeNX`J
	}

	SAFE_DELETE_ARRAY(g_pMeshColor);     // }eÃfBt[YFJ
	SAFE_DELETE_ARRAY(g_pMeshTexture);   // }eÃeNX`pJ
	g_dwNumMaterials = 0;
	SAFE_RELEASE(g_pD3DXMesh);           // bVJ
}

// bV̓ǂݍ
HRESULT LoadMesh(LPCTSTR pFileName)
{
	LPDIRECT3DDEVICE9 pD3DDevice = DXUTGetD3D9Device();
	HRESULT hr;

	// ̃bVJ
	ReleaseMesh();

	// ǂݍXt@Č
	WCHAR XFileName[MAX_PATH];
	V_RETURN(DXUTFindDXSDKMediaFileCch(XFileName, MAX_PATH, pFileName));

	// bVǂݍ
	LPD3DXBUFFER pD3DXMtrlBuffer;           // }eA󂯎ϐ
	LPD3DXBUFFER pD3DXAdjacencyBuffer;		// אڐ󂯎ϐ
	V_RETURN(D3DXLoadMeshFromX(
				XFileName,             // ǂݍXt@C
				D3DXMESH_SYSTEMMEM,    // _/CfbNXEobt@VXeEɍ
				pD3DDevice,            // bV̕`ɎgfoCX
				&pD3DXAdjacencyBuffer, // Xt@C̗אڐ󂯎(œKp)
				&pD3DXMtrlBuffer,      // Xt@C̃}eA󂯎
				NULL,
				&g_dwNumMaterials,     // }eA̐
				&g_pD3DXMesh));        // bV󂯎

	// VbV̒_vf
	D3DVERTEXELEMENT9 decl[] = 
	{
		{ 0,  0, D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },
		{ 0, 12, D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_NORMAL,   0 },
		{ 0, 24, D3DDECLTYPE_FLOAT2, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0 },
		D3DDECL_END()   // z̏I
	};

	// VbV̍쐬
	LPD3DXMESH pNewMesh;    // VbV󂯎ϐ
	V_RETURN(g_pD3DXMesh->CloneMesh(D3DXMESH_MANAGED, decl, pD3DDevice, &pNewMesh));

	SAFE_RELEASE(g_pD3DXMesh);
	g_pD3DXMesh = pNewMesh;

	// e_̖@xNgvZ
	V_RETURN(D3DXComputeNormals(g_pD3DXMesh, (DWORD*)pD3DXAdjacencyBuffer->GetBufferPointer()));

	// bV̍œK
	V(g_pD3DXMesh->OptimizeInplace(
				D3DXMESHOPT_COMPACT | D3DXMESHOPT_ATTRSORT | D3DXMESHOPT_VERTEXCACHE,
				(DWORD*)pD3DXAdjacencyBuffer->GetBufferPointer(), NULL, NULL, NULL));
	SAFE_RELEASE(pD3DXAdjacencyBuffer);   // ̎_ŗאڐ͕KvȂȂ
	if (FAILED(hr))
	    return hr; // G[

	// eNX`pɁAJgEfBNgύX
	// @@(eNX`Xt@CƓtH_ɂ邱Ƃz)
	WCHAR* p = wcsrchr(XFileName, '\\');
	if (p != NULL) 
	{
		p[1] = NULL;
		SetCurrentDirectory(XFileName);
	}

	// }eAۑpz̊m
	SAFE_DELETE_ARRAY(g_pMeshColor);
	SAFE_DELETE_ARRAY(g_pMeshTexture);
	g_pMeshColor	= new D3DCOLORVALUE[g_dwNumMaterials];
	g_pMeshTexture	= new LPDIRECT3DTEXTURE9[g_dwNumMaterials];

	// }eAobt@̃|C^擾
	D3DXMATERIAL* d3dxMaterials = (D3DXMATERIAL*)pD3DXMtrlBuffer->GetBufferPointer();

	// e}eAۑ
	for (DWORD i=0; i<g_dwNumMaterials; i++)
	{
		// bV̐F
		g_pMeshColor[i] = d3dxMaterials[i].MatD3D.Diffuse;
		// eNX`̓ǂݍ
		if (d3dxMaterials[i].pTextureFilename == NULL)
			g_pMeshTexture[i] = NULL; // eNX`Ȃ
		else 
		{
			// }`oCgUNICODEɕϊ
			WCHAR strTexture[MAX_PATH];
			MultiByteToWideChar(CP_ACP, 0, d3dxMaterials[i].pTextureFilename, -1, strTexture, MAX_PATH);
			strTexture[MAX_PATH - 1] = 0;

			// eNX`ǂݍ
			hr = D3DXCreateTextureFromFile(pD3DDevice, strTexture, &g_pMeshTexture[i]);
			if (FAILED(hr))
				g_pMeshTexture[i] = NULL; // eNX`Ȃ
		}
	}

	// Xt@Cǂݍ񂾃}eÃobt@J
	SAFE_RELEASE(pD3DXMtrlBuffer);

	// bV̒_obt@bN
	LPVOID pBuffer;
	V_RETURN(g_pD3DXMesh->LockVertexBuffer(D3DLOCK_READONLY, &pBuffer));

	// bV̋E߂
	V_RETURN(D3DXComputeBoundingSphere((D3DXVECTOR3 *)pBuffer,
			g_pD3DXMesh->GetNumVertices(),       // bV̒_
			g_pD3DXMesh->GetNumBytesPerVertex(), // bV̒_f[^̑傫
			&g_BSCenter, &g_BSRadius));

	// bN_obt@AbN
	V_RETURN(g_pD3DXMesh->UnlockVertexBuffer());

	return hr;
}

// *****************************************
// **** GUI֘Å֐

// _CAOĂяoR[obN֐
void CALLBACK DXUTCallbackGUIEvent(UINT nEvent, int nControlID, CDXUTControl* pControl, void* pUserContext)
{
	HRESULT hr;
	WCHAR Path[MAX_PATH];

	switch (nControlID)
	{
	// foCX֘Aݒ_CAO
	case ID_DISPLAYMODE:	// ʃ[h؂ւ(EChEE[hƃtXN[E[h)
		DXUTToggleFullScreen();
		break;
	case ID_HALREF:			// foCX؂ւ(REFHAL)
		DXUTToggleREF();
		break;
	case ID_CHANGEDEVICE:	// foCXݒʂ̕\
		g_SettingsDlg.SetActive(!g_SettingsDlg.IsActive());
		break;
	case ID_PAUSE:			// ꎞ~
		DXUTPause(!DXUTIsTimePaused(), false);
		break;

	case ID_BUTTON1:	// Xt@C̓ǂݍ
		GetCurrentDirectory(MAX_PATH, Path);
		hr = LoadMesh(g_SampleUI.GetEditBox(ID_EDIT1)->GetText());
		SetCurrentDirectory(Path);
		if (FAILED(hr))
			ReleaseMesh();
	}
}

// *****************************************
// **** foCX쐬֘ÃR[obN֐

// p\ȃfoCX̗(R[obN֐)
bool CALLBACK DXUTCallbackIsDeviceAcceptable(
		D3DCAPS9 *pCaps, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, bool bWindowed, void* pUserContext)

{
	if (pCaps->MaxPrimitiveCount < 0xFFFF)		// v~eBu
		return false;
	if (pCaps->MaxVertexIndex < 0xFFF0)			// CfbNX
		return false;
	if (pCaps->PixelShaderVersion < D3DPS_VERSION(2, 0))	// sNZEVF[_
		return false;

	return true;	// ̃foCX̎gpe
}

// 쐬foCXݒ̕ύX(R[obN֐)
bool CALLBACK DXUTCallbackModifyDeviceSettings(
		DXUTDeviceSettings *pDeviceSettings, void* pUserContext)
{
	// Direct3D 9foCXg邱ƂmF
	if( pDeviceSettings->ver == DXUT_D3D9_DEVICE )
	{
		// D3D9foCX̔\͂擾
		D3DCAPS9 caps;
		DXUTGetD3D9DeviceCaps( pDeviceSettings, &caps );

		// ŏɃt@X foCXIꂽƂɁAx\
		static bool s_bFirstTime = true;
		if( s_bFirstTime )
		{
			s_bFirstTime = false;
			if( pDeviceSettings->d3d9.DeviceType == D3DDEVTYPE_REF )
				DXUTDisplaySwitchingToREFWarning(pDeviceSettings->ver);
		}

		// o[W2.0̒_VF[_n[hEFAŃT|[gĂȂꍇ́A\tgEFAg
		if ((caps.DevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) == 0 ||
				caps.VertexShaderVersion < D3DVS_VERSION(2, 0))
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_HARDWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_PUREDEVICE;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_SOFTWARE_VERTEXPROCESSING;	// \tgEFA_
		}
		else
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_SOFTWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_HARDWARE_VERTEXPROCESSING;	//n[hEFA_
		}

		// Avdouble^g(x͒ቺ)
		pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_FPU_PRESERVE;
	}

	return true;
}

// foCX쐬̏(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceCreated(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9CreateDevice( pd3dDevice ) );
	V_RETURN( g_SettingsDlg.OnD3D9CreateDevice( pd3dDevice ) );

	// XgE{bNX̃NA
	g_SampleUI.GetListBox(ID_LISTBOX1)->RemoveAllItems();

	// **** GtFNg̍쐬 ****
	// fxt@Č
	WCHAR fxFileName[MAX_PATH];
	DXUTFindDXSDKMediaFileCch(fxFileName, MAX_PATH, L"Shader2.fx");

	// ID3DXEffectC^[tFCX̍쐬
	V_RETURN(D3DXCreateEffectFromFile(
		pd3dDevice,				// GtFNgfoCX
		fxFileName,				// GtFNgEt@C
		NULL,
		NULL,
		0,						// RpCEIvV
		NULL,
		&g_pD3DXEffect,			// GtFNg󂯎ϐ
		NULL));

	// eNjbN̗
	D3DXHANDLE hTech = NULL;    // ݂̃eNjbÑnh
	D3DXHANDLE hTechNext;       // ̃eNjbÑnh
	for (int i=0; i<MAX_TECH; i++)
	{
		hr = g_pD3DXEffect->FindNextValidTechnique(hTech, &hTechNext);
		if (FAILED(hr))
			break;	// G[
		if (hTechNext == NULL)
			break;

		// eNjbÑnh(hTechNext)擾
		hTech = hTechNext;

		// eNjbN̑Ó`FbN
		V_RETURN(g_pD3DXEffect->ValidateTechnique(hTech));

		// eNjbNo^
		g_hTech[i] = hTech;

		// eNjbNXgE{bNXɓo^
		D3DXTECHNIQUE_DESC TechDesc;
		g_pD3DXEffect->GetTechniqueDesc(hTech, &TechDesc);  // eNjbN̖O
		WCHAR strTechName[256];
		MultiByteToWideChar(CP_ACP, 0, TechDesc.Name, -1, strTechName, 256);  // ANSIUNICODE
		strTechName[255] = 0;
		g_SampleUI.GetListBox(ID_LISTBOX1)->AddItem(strTechName, NULL);
	}
	g_SampleUI.GetListBox(ID_LISTBOX1)->SelectItem(0);

	// nh̎擾
	g_hWorldViewProj   = g_pD3DXEffect->GetParameterByName(NULL, "WorldViewProj");
	g_hLightPos        = g_pD3DXEffect->GetParameterByName(NULL, "LightPos");
	g_hLightBrightness = g_pD3DXEffect->GetParameterByName(NULL, "LightBrightness");
	g_hModelScale      = g_pD3DXEffect->GetParameterByName(NULL, "ModelScale");
	g_hTex             = g_pD3DXEffect->GetParameterByName(NULL, "Tex");
	g_hDiffuse         = g_pD3DXEffect->GetParameterByName(NULL, "Diffuse");

	return hr;
}

// *****************************************
// **** bZ[W֘ÃR[obN֐

// EChEEbZ[W̏(R[obN֐)
LRESULT CALLBACK DXUTCallbackMsgProc(
			HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, bool *pbNoFurtherProcessing, void* pUserContext)
{
	// GUI\[XǗ
	*pbNoFurtherProcessing = g_DialogResourceManager.MsgProc( hWnd, uMsg, wParam, lParam );
	if( *pbNoFurtherProcessing )
		return 0;

	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.MsgProc( hWnd, uMsg, wParam, lParam );
		return 0;
	}

	// foCX֘A_CAÕbZ[W
	*pbNoFurtherProcessing = g_DeviceUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// Xe[^X\_CAÕbZ[W
	*pbNoFurtherProcessing = g_StatusUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// _CAO@̃bZ[W
	*pbNoFurtherProcessing = g_SampleUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	*pbNoFurtherProcessing = false;  // t[[NŃbZ[W
	return 0;
}

// *****************************************
// **** V[`֘ÃR[obN֐

// V[̍XV(R[obN֐)
void CALLBACK DXUTCallbackFrameMove(
		double fTime, float fElapsedTime, void* pUserContext)
{
	// Xe[^X̕\
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->SetText(DXUTGetDeviceStats());
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->SetText(DXUTGetFrameStats(true));

	// V[̕`pϊs
	D3DXMATRIX matWorld, matView, matProj;
	D3DXMATRIX mat1, mat2, mat3;
	D3DXMatrixTranslation(&mat1, -g_BSCenter.x, -g_BSCenter.y, -g_BSCenter.z); // bV̒S֕sړ
	g_fMeshScale = 1.0f / g_BSRadius;
	D3DXMatrixScaling(&mat2, g_fMeshScale, g_fMeshScale, g_fMeshScale);		// bV̑傫ɍ킹ăXP[O
	FLOAT ry = (float)fTime * D3DX_PI;					// ]px(2b1])
	D3DXMatrixRotationY(&mat3, ry);						// [hϊs(Y𒆐Sɉ])
	matWorld = mat1 * mat2 * mat3;

	D3DXMatrixLookAtLH(&matView, &g_vEye, &g_vAt, &g_vUp);	// r[ϊs

	D3DXMatrixPerspectiveFovLH(&matProj,				// eϊ
				D3DX_PI/3.0f,							// p60x
				g_Aspect,	// AXyNg
				0.1f,		// Oeʂ܂ł̋
				4.0f);		// eʂ܂ł̋

	g_matWorldViewProj = matWorld * matView * matProj;

	// fԂł̌W
	D3DXMatrixInverse(&mat1, NULL, &matWorld);
	D3DXVec3Transform(&g_vLightModel, &g_vLight, &mat1);
}

// V[̕`(R[obN֐)
void RenderMesh(LPDIRECT3DDEVICE9 pd3dDevice);
void CALLBACK DXUTCallbackFrameRender(
		LPDIRECT3DDEVICE9 pd3dDevice, double fTime, float fElapsedTime, void* pUserContext)
{
	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.OnRender( fElapsedTime );
		return;
	}

	// V[̃NA
	pd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0, 0, 255), 1.0f, 0);

	// V[̕`Jn
	if (SUCCEEDED(pd3dDevice->BeginScene()))
	{
		// bV`
		if (g_pD3DXMesh)
			RenderMesh(pd3dDevice);

		// _CAO`
		g_DeviceUI.OnRender(fElapsedTime);
		g_StatusUI.OnRender(fElapsedTime);
		g_SampleUI.OnRender(fElapsedTime);

		// V[̕`I
		pd3dDevice->EndScene();
	}
}

// bV̕`
void RenderMesh(LPDIRECT3DDEVICE9 pd3dDevice)
{
	HRESULT hr;

	// VF[_̃O[oϐ̐ݒ
	g_pD3DXEffect->SetMatrix(g_hWorldViewProj, &g_matWorldViewProj);  // ϊs̐ݒ

	g_pD3DXEffect->SetVector(g_hLightPos, &g_vLightModel);           // ̈ʒu
	g_pD3DXEffect->SetFloat(g_hLightBrightness, g_fLightBrightness);	// ̋Px
	g_pD3DXEffect->SetFloat(g_hModelScale, g_fMeshScale);			// fԂ̃XP[

	// VF[_ŎgeNjbNI
	int TechNum = g_SampleUI.GetListBox(ID_LISTBOX1)->GetSelectedIndex();
	TechNum = TechNum < 0 ? TechNum = 0 : (TechNum >= MAX_TECH ? MAX_TECH - 1 : TechNum);
	g_pD3DXEffect->SetTechnique(g_hTech[TechNum]);    // XgE{bNXőIĂeNjbNg

	// eNjbN̊Jn
	UINT numPass;
	g_pD3DXEffect->Begin(&numPass, 0);      //eNjbN̊Jn(Xe[gۑ)

	// eNjbÑpXs
	for (UINT iPass = 0; iPass < numPass; iPass++)
	{
		V(g_pD3DXEffect->BeginPass(iPass));     // iPassԖڂ̃pX̎sJn
		if (FAILED(hr))
			break;   // pX̎sɎs

		// bV}eAʂɕ`
		for (DWORD i=0; i<g_dwNumMaterials; i++)
		{
			// GtFNǵuDiffusevϐɁAfBt[YFݒ
			g_pD3DXEffect->SetVector(g_hDiffuse, (D3DXVECTOR4*)(g_pMeshColor + i));

			// GtFNǵuTexvϐɁAeNX`ݒ
			g_pD3DXEffect->SetTexture(g_hTex, g_pMeshTexture[i]);

			// BeginPasšŁAGtFNgSet`\bhsꍇɕKv
			g_pD3DXEffect->CommitChanges();

			// }eA`
			g_pD3DXMesh->DrawSubset(i);
		}

		g_pD3DXEffect->EndPass();				// pX̎sI
	}

	// eNjbN̏I
	g_pD3DXEffect->End();             // eNjbN̏I(ۑXe[g𕜌)
}
// *****************************************
// **** foCX̏֘ÃR[obN֐

// foCX̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceLost(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9LostDevice();
	g_SettingsDlg.OnD3D9LostDevice();

	// GtFNg̏
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnLostDevice();

}

// foCX̃XgA(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceReset(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr = S_OK;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9ResetDevice() );
	V_RETURN( g_SettingsDlg.OnD3D9ResetDevice() );

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= pBackBufferSurfaceDesc->Width;
	vp.Height	= pBackBufferSurfaceDesc->Height;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	V_RETURN(pd3dDevice->SetViewport(&vp));

	// ʂ̃AXyNg
	g_Aspect = (float)pBackBufferSurfaceDesc->Width / (float)pBackBufferSurfaceDesc->Height;

	// GtFNg̃XgA
	if (g_pD3DXEffect)
		g_pD3DXEffect->OnResetDevice();

	// _CAO̔zu
	g_DeviceUI.SetLocation(pBackBufferSurfaceDesc->Width - 150, 0);     // _CAO̍W(-150, 0)
	g_DeviceUI.SetSize(150, 110);     // _CAȎ傫(150~110)

	g_StatusUI.SetLocation(0, 0);     // _CAO̍W(0, 0)
	g_StatusUI.SetSize(500, 50);      // _CAȎ傫(500~50)

	g_SampleUI.SetLocation(pBackBufferSurfaceDesc->Width  - 150, 
							pBackBufferSurfaceDesc->Height - 190);      // _CAO̍W(-150, -190)
	g_SampleUI.SetSize(150, 190);     // _CAȎ傫(150~190)

	return hr;	// I
}

// *****************************************
// **** foCX폜֘ÃR[obN֐

// foCX폜̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceDestroyed(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9DestroyDevice();
	g_SettingsDlg.OnD3D9DestroyDevice();

	// bV̊J
	ReleaseMesh();

	// 擾IuWFNg̊J
	SAFE_RELEASE(g_pD3DXEffect);
}

// *****************************************
// WinMain֐ƃAvP[V֘Ȁ

// AvP[V֘Ȁ
void InitApp(void)
{
	// DXUTɃfBApXݒ肷
	size_t ReturnValue;
	WCHAR sdk_path[MAX_PATH];
	if (_wgetenv_s(&ReturnValue, sdk_path, MAX_PATH, L"DXSDK_DIR") == 0) {
		StringCbCat(sdk_path, MAX_PATH, L"\\Samples\\Media");
		DXUTSetMediaSearchPath(sdk_path);
	}

	// GUI\[XǗ(_CAȌ)
	g_SettingsDlg.Init( &g_DialogResourceManager );
	g_DeviceUI.Init( &g_DialogResourceManager );
	g_StatusUI.Init( &g_DialogResourceManager );
	g_SampleUI.Init( &g_DialogResourceManager );

	// Windows 2000pɓ{tHgݒ(Vista,XPł͕sv)B
	g_DeviceUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );
	g_SampleUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );

	// GUIRg[̃bZ[W󂯎R[obN֐_CAOɓo^
	g_DeviceUI.SetCallback(DXUTCallbackGUIEvent);
	g_SampleUI.SetCallback(DXUTCallbackGUIEvent);

	// GUIRg[_CAOɓo^
	int iY = 10;
	g_DeviceUI.AddButton(ID_DISPLAYMODE,  L"ʃ[h",   10, iY,       125, 22);
	g_DeviceUI.AddButton(ID_HALREF,       L"foCX",     10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_CHANGEDEVICE, L"foCXݒ", 10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_PAUSE,        L"ꎞ~",     10, iY += 24, 125, 22);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_StatusUI.AddStatic(ID_DEVICESTATUS, L"", 10, iY,       490, 22);
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,255,0,255), DT_LEFT | DT_VCENTER);
	g_StatusUI.AddStatic(ID_FRAMESTATUS,  L"", 10, iY += 24, 490, 22);
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,0,255,255), DT_LEFT | DT_VCENTER);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_SampleUI.AddEditBox(ID_EDIT1, L"Dwarf\\Dwarf.x",   10, iY,       125, 32);
	g_SampleUI.AddButton(ID_BUTTON1, L"ǂݍ", 10, iY += 34, 125, 22);
	g_SampleUI.AddListBox(ID_LISTBOX1, 10, iY += 24, 125, 88);
	iY += 10;
}

// **** WinMain֐
int WINAPI wWinMain(HINSTANCE, HINSTANCE, LPWSTR, int)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// ** R[obN֐̓o^ **
	// foCX쐬̏
	DXUTSetCallbackD3D9DeviceCreated(DXUTCallbackDeviceCreated);
	// EChEEbZ[W̏
	DXUTSetCallbackMsgProc(DXUTCallbackMsgProc);
	// V[̍XV
	DXUTSetCallbackFrameMove(DXUTCallbackFrameMove);
	// V[̕`
	DXUTSetCallbackD3D9FrameRender(DXUTCallbackFrameRender);
	// foCX̏
	DXUTSetCallbackD3D9DeviceLost(DXUTCallbackDeviceLost);
	// foCX̃XgA
	DXUTSetCallbackD3D9DeviceReset(DXUTCallbackDeviceReset);
	// foCX폜̏
	DXUTSetCallbackD3D9DeviceDestroyed(DXUTCallbackDeviceDestroyed);

	// p\ȃfoCX̗
	DXUTSetCallbackD3D9DeviceAcceptable(DXUTCallbackIsDeviceAcceptable);
	// 쐬foCXݒ̕ύX
	DXUTSetCallbackDeviceChanging(DXUTCallbackModifyDeviceSettings);

	// tXN[E[hŃ}EXEJ[\\
	DXUTSetCursorSettings(true, true);

	// **  **
	InitApp();				// AvP[V֘Ȁ

	DXUTInit(true, true);                     // TvEt[[N̏
	DXUTSetHotkeyHandling(true);              // zbgEL[̐ݒ
	DXUTCreateWindow(L"Direct3D 9 Sample16"); // EChE̍쐬

	DXUTCreateDevice(true, 640, 480);  // foCX̍쐬(R[obN֐̎s)

	// ** CE[v **
	DXUTMainLoop();    // bZ[WE[vs

	return DXUTGetExitCode();  // I
}
