/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample12.cpp
		uDXUT֗̕ȋ@\gvOv
--------------------------------------------------------------*/

#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓnȂ
#define DXUT_AUTOLIB		// DXUTŕKvȃCu(dsound.libȊO)IɃN
#include "DXUT.h"			// DXUTg
#include "SDKmisc.h"		// DXUT Optionalg
#include "DXUTgui.h"		// DXUT OptionalGUIg
#include "DXUTSettingsDlg.h"	//DXUT OptionalCD3DSettingsDlgNXg	
#include "resource.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// *****************************************
// **** O[oϐ

// XvCg@\
LPD3DXSPRITE			g_pD3DXSprite  = NULL;	// XvCg
LPDIRECT3DTEXTURE9		g_pD3DTexture1 = NULL;	// XvCgɎgeNX`@
LPDIRECT3DTEXTURE9		g_pD3DTexture2 = NULL;	// XvCgɎgeNX`A
WCHAR g_SpriteFileName1[MAX_PATH] = L"";		// XvCgɎg摜t@C@
WCHAR g_SpriteFileName2[MAX_PATH] = L"";		// XvCgɎg摜t@CA

// \ݒ
D3DCOLOR g_SpriteColor = 0xFFFFFFFF;			// XvCg̐F
bool  g_SpriteTexture1 = true;					// XvCgɃeNX`@g
float g_SpriteAngle = 0.0f;						// XvCg̕\px
POINT g_SpritePoint = { 320, 240 };				// XvCg̕\ʒu
D3DXMATRIX g_SpriteMatrix;						// XvCg\pϊs

// *****************************************
// **** O[oϐ(GUI@\)

// GUI\[XǗ
CDXUTDialogResourceManager	g_DialogResourceManager; // _CAÕ\[XǗ
CD3DSettingsDlg				g_SettingsDlg;           // foCXݒ_CAO

// foCX֘Aݒ_CAO(E)
enum { ID_DISPLAYMODE = 0, ID_HALREF, ID_CHANGEDEVICE, ID_PAUSE }; // Rg[ID
CDXUTDialog  g_DeviceUI;    // _CAO

// Xe[^X\_CAO()
enum { ID_DEVICESTATUS = 50, ID_FRAMESTATUS }; // Rg[ID
CDXUTDialog  g_StatusUI;    // _CAO

// _CAO@(ݒBE)
enum { ID_BTN1 = 100, ID_BTN2, ID_BTN3, ID_BTN4, ID_CHECKBOX1, ID_CHECKBOX2, 
		ID_CHECKBOX3, ID_SLIDER1, ID_SLIDER2,
		ID_RADIOBTN1G1, ID_RADIOBTN2G1, ID_RADIOBTN3G2, ID_RADIOBTN4G2 }; // Rg[ID
CDXUTDialog  g_SampleUI1;   // _CAO@

// _CAOA(Rg[ETv\pB)
enum { ID_STATIC = 200, ID_BUTTON, ID_CHECKBOX, ID_RADIOBTN1, ID_RADIOBTN2,
		ID_COMBOBOX, ID_SLIDER, ID_EDITBOX, ID_LISTBOX };   // Rg[ID
CDXUTDialog  g_SampleUI2;   // _CAO@

// *****************************************
// **** GUI֘Å֐

// _CAOĂяoR[obN֐
void CALLBACK DXUTCallbackGUIEvent(UINT nEvent, int nControlID, CDXUTControl* pControl, void* pUserContext)
{
	switch (nControlID)
	{
	// foCX֘Aݒ_CAO
	case ID_DISPLAYMODE:	// ʃ[h؂ւ(EChEE[hƃtXN[E[h)
		DXUTToggleFullScreen();
		break;
	case ID_HALREF:			// foCX؂ւ(REFHAL)
		DXUTToggleREF();
		break;
	case ID_CHANGEDEVICE:	// foCXݒʂ̕\
		g_SettingsDlg.SetActive(!g_SettingsDlg.IsActive());
		break;
	case ID_PAUSE:			// ꎞ~
		DXUTPause(!DXUTIsTimePaused(), false);
		break;

	// _CAO@(ݒ_CAO)
	case ID_BTN1:	// \
		g_SampleUI2.SetVisible(!g_SampleUI2.GetVisible());
		break;
	case ID_BTN2:	// wiF@
		g_SampleUI2.SetBackgroundColors(D3DCOLOR_ARGB(128,255,0,255));
		break;
	case ID_BTN3:	// wiFA
		g_SampleUI2.SetBackgroundColors(D3DCOLOR_ARGB(128,255,0,0), D3DCOLOR_ARGB(128,0,255,0),
				D3DCOLOR_ARGB(128,0,0,255), D3DCOLOR_ARGB(128,255,0,255));
		break;
	case ID_BTN4:	// wiFȂ
		g_SampleUI2.SetBackgroundColors(D3DCOLOR_ARGB(0,0,0,0));
		break;
	case ID_CHECKBOX1:	// ŏ
		g_SampleUI2.SetMinimized(g_SampleUI1.GetCheckBox(ID_CHECKBOX1)->GetChecked());
		break;
	case ID_CHECKBOX2:	// LvV
		g_SampleUI2.SetCaptionText(g_SampleUI2.GetEditBox(ID_EDITBOX)->GetText());
		g_SampleUI2.EnableCaption(g_SampleUI1.GetCheckBox(ID_CHECKBOX2)->GetChecked());
		break;
	case ID_CHECKBOX3:	// _CAOÃXgE{bNX̗LE؂ւ
		g_SampleUI2.SetControlEnabled(ID_LISTBOX, g_SampleUI1.GetCheckBox(ID_CHECKBOX3)->GetChecked());
		break;
	}
}

// *****************************************
// **** foCX쐬֘ÃR[obN֐

// p\ȃfoCX̗(R[obN֐)
bool CALLBACK DXUTCallbackIsDeviceAcceptable(
		D3DCAPS9 *pCaps, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, bool bWindowed, void* pUserContext)

{
	if (pCaps->MaxPrimitiveCount < 0xFFFF)		// v~eBu
		return false;
	if (pCaps->MaxVertexIndex < 0xFFF0)			// CfbNX
		return false;
	if (pCaps->PixelShaderVersion < D3DPS_VERSION(2, 0))	// sNZEVF[_
		return false;

	return true;	// ̃foCX̎gpe
}

// 쐬foCXݒ̕ύX(R[obN֐)
bool CALLBACK DXUTCallbackModifyDeviceSettings(
		DXUTDeviceSettings *pDeviceSettings, void* pUserContext)
{
	// Direct3D 9foCXg邱ƂmF
	if( pDeviceSettings->ver == DXUT_D3D9_DEVICE )
	{
		// D3D9foCX̔\͂擾
		D3DCAPS9 caps;
		DXUTGetD3D9DeviceCaps( pDeviceSettings, &caps );

		// ŏɃt@X foCXIꂽƂɁAx\
		static bool s_bFirstTime = true;
		if( s_bFirstTime )
		{
			s_bFirstTime = false;
			if( pDeviceSettings->d3d9.DeviceType == D3DDEVTYPE_REF )
				DXUTDisplaySwitchingToREFWarning(pDeviceSettings->ver);
		}

		// o[W2.0̒_VF[_n[hEFAŃT|[gĂȂꍇ́A\tgEFAg
		if ((caps.DevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) == 0 ||
				caps.VertexShaderVersion < D3DVS_VERSION(2, 0))
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_HARDWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_PUREDEVICE;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_SOFTWARE_VERTEXPROCESSING;	// \tgEFA_
		}
		else
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_SOFTWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_HARDWARE_VERTEXPROCESSING;	//n[hEFA_
		}

		// Avdouble^g(x͒ቺ)
		pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_FPU_PRESERVE;
	}

	return true;
}

// foCX쐬̏(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceCreated(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9CreateDevice( pd3dDevice ) );
	V_RETURN( g_SettingsDlg.OnD3D9CreateDevice( pd3dDevice ) );

	// XvCgɎg摜t@Č
	V_RETURN(DXUTFindDXSDKMediaFileCch(g_SpriteFileName1, MAX_PATH, L"canvas1.dds"));
	V_RETURN(DXUTFindDXSDKMediaFileCch(g_SpriteFileName2, MAX_PATH, L"canvas2.dds"));

	// XvCgɕ\eNX`̏
	V_RETURN(D3DXCreateTextureFromFile(pd3dDevice, g_SpriteFileName1, &g_pD3DTexture1));
	V_RETURN(D3DXCreateTextureFromFile(pd3dDevice, g_SpriteFileName2, &g_pD3DTexture2));

	// XvCg@\̏
	V_RETURN(D3DXCreateSprite(pd3dDevice, &g_pD3DXSprite));

	return hr;
}

// *****************************************
// **** bZ[W֘ÃR[obN֐

// EChEEbZ[W̏(R[obN֐)
LRESULT CALLBACK DXUTCallbackMsgProc(
			HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, bool *pbNoFurtherProcessing, void* pUserContext)
{
	// GUI\[XǗ
	*pbNoFurtherProcessing = g_DialogResourceManager.MsgProc( hWnd, uMsg, wParam, lParam );
	if( *pbNoFurtherProcessing )
		return 0;

	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.MsgProc( hWnd, uMsg, wParam, lParam );
		return 0;
	}

	// foCX֘A_CAÕbZ[W
	*pbNoFurtherProcessing = g_DeviceUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// Xe[^X\_CAÕbZ[W
	*pbNoFurtherProcessing = g_StatusUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// _CAO@̃bZ[W
	*pbNoFurtherProcessing = g_SampleUI1.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// _CAOÃbZ[W
	*pbNoFurtherProcessing = g_SampleUI2.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	*pbNoFurtherProcessing = false;  // t[[NŃbZ[W
	return 0;
}

// *****************************************
// **** V[`֘ÃR[obN֐

// V[̍XV(R[obN֐)
void CALLBACK DXUTCallbackFrameMove(
		double fTime, float fElapsedTime, void* pUserContext)
{
	// Xe[^X̕\
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->SetText(DXUTGetDeviceStats());
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->SetText(DXUTGetFrameStats(true));

	// XvCg̐FƃeNX`I
	g_SpriteColor     = D3DCOLOR_ARGB(g_SampleUI1.GetSlider(ID_SLIDER2)->GetValue(),255,255,255);
	g_SpriteTexture1  = g_SampleUI1.GetRadioButton(ID_RADIOBTN3G2)->GetChecked();

	// XvCg]
	float SpriteSpeed = (g_SampleUI1.GetSlider(ID_SLIDER1)->GetValue() * fElapsedTime) / (D3DX_1BYPI * 250.0f);
	bool  SpriteClock = g_SampleUI1.GetRadioButton(ID_RADIOBTN1G1)->GetChecked();
	g_SpriteAngle    += SpriteClock ? SpriteSpeed : -SpriteSpeed;

	D3DXMATRIX mat1, mat2;
	D3DXMatrixTranslation(&mat1, (float)g_SpritePoint.x, (float)g_SpritePoint.y, 0);   // g_SpritePointɈړ
	D3DXMatrixRotationZ(&mat2, g_SpriteAngle);   // z𒆐Sɉ]
	g_SpriteMatrix = mat2 * mat1;                // Z
}

// V[̕`(R[obN֐)
void CALLBACK DXUTCallbackFrameRender(
		LPDIRECT3DDEVICE9 pd3dDevice, double fTime, float fElapsedTime, void* pUserContext)
{
	// foCXݒ_CAO
	if( g_SettingsDlg.IsActive() )
	{
		g_SettingsDlg.OnRender( fElapsedTime );
		return;
	}

	// V[̃NA
	pd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0, 0, 255), 1.0f, 0);

	// V[̕`Jn
	if (SUCCEEDED(pd3dDevice->BeginScene()))
	{
		// V[̕`(XvCg̕`)
		g_pD3DXSprite->Begin(D3DXSPRITE_ALPHABLEND | D3DXSPRITE_DONOTSAVESTATE);
		g_pD3DXSprite->SetTransform(&g_SpriteMatrix);                                // ϊsݒ
		LPDIRECT3DTEXTURE9 tex = g_SpriteTexture1 ? g_pD3DTexture1 : g_pD3DTexture2; // \eNX`̑I
		D3DXVECTOR3 Center(256,32,0);							// XvCg̒S̈ʒu(256,32,0)
		g_pD3DXSprite->Draw(tex, NULL, &Center, NULL, g_SpriteColor);                // \o^
		g_pD3DXSprite->End();

		// _CAO`
		g_DeviceUI.OnRender(fElapsedTime);
		g_StatusUI.OnRender(fElapsedTime);
		g_SampleUI1.OnRender(fElapsedTime);
		g_SampleUI2.OnRender(fElapsedTime);

		// V[̕`I
		pd3dDevice->EndScene();
	}
}

// *****************************************
// **** foCX̏֘ÃR[obN֐

// foCX̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceLost(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9LostDevice();
	g_SettingsDlg.OnD3D9LostDevice();

	// XvCg̏
	if (g_pD3DXSprite)
		g_pD3DXSprite->OnLostDevice();
}

// foCX̃XgA(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceReset(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9ResetDevice() );
	V_RETURN( g_SettingsDlg.OnD3D9ResetDevice() );

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= pBackBufferSurfaceDesc->Width;
	vp.Height	= pBackBufferSurfaceDesc->Height;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	V_RETURN(pd3dDevice->SetViewport(&vp));

	// _CAO̔zu
	g_DeviceUI.SetLocation(pBackBufferSurfaceDesc->Width - 150, 0);     // _CAO̍W(-150, 0)
	g_DeviceUI.SetSize(150, 110);     // _CAȎ傫(150~110)

	g_StatusUI.SetLocation(0, 0);     // _CAO̍W(0, 0)
	g_StatusUI.SetSize(500, 50);      // _CAȎ傫(500~50)

	g_SampleUI1.SetLocation(pBackBufferSurfaceDesc->Width  - 150, 
							pBackBufferSurfaceDesc->Height - 325);      // _CAO̍W(-150, -325)
	g_SampleUI1.SetSize(150, 325);     // _CAȎ傫(150~325)

	g_SampleUI2.SetLocation(0, pBackBufferSurfaceDesc->Height - 330);   // _CAO̍W(0, -330)
	g_SampleUI2.SetSize(150, 320);     // _CAȎ傫(150~320)

	// XvCg̏
	if (g_pD3DXSprite)
		g_pD3DXSprite->OnResetDevice();
	g_SpritePoint.x = pBackBufferSurfaceDesc->Width / 2;
	g_SpritePoint.y = pBackBufferSurfaceDesc->Height / 2;

	return hr;	// I
}

// *****************************************
// **** foCX폜֘ÃR[obN֐

// foCX폜̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceDestroyed(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9DestroyDevice();
	g_SettingsDlg.OnD3D9DestroyDevice();

	// 擾IuWFNg̊J
	SAFE_RELEASE(g_pD3DXSprite);
	SAFE_RELEASE(g_pD3DTexture2);
	SAFE_RELEASE(g_pD3DTexture1);
}

// *****************************************
// WinMain֐ƃAvP[V֘Ȁ

// AvP[V֘Ȁ
void InitApp(void)
{
	// GUI\[XǗ(_CAȌ)
	g_SettingsDlg.Init( &g_DialogResourceManager );
	g_DeviceUI.Init( &g_DialogResourceManager );
	g_StatusUI.Init( &g_DialogResourceManager );
	g_SampleUI1.Init( &g_DialogResourceManager );
	g_SampleUI2.Init( &g_DialogResourceManager );

	// Windows 2000pɓ{tHgݒ(Vista,XPł͕sv)B
	g_DeviceUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );
	g_SampleUI1.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );
	g_SampleUI2.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );

	// GUIRg[̃bZ[W󂯎R[obN֐_CAOɓo^
	g_DeviceUI.SetCallback(DXUTCallbackGUIEvent);
	g_SampleUI1.SetCallback(DXUTCallbackGUIEvent);

	// GUIRg[_CAOɓo^
	int iY = 10;
	g_DeviceUI.AddButton(ID_DISPLAYMODE,  L"ʃ[h",   10, iY,       125, 22);
	g_DeviceUI.AddButton(ID_HALREF,       L"foCX",     10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_CHANGEDEVICE, L"foCXݒ", 10, iY += 24, 125, 22);
	g_DeviceUI.AddButton(ID_PAUSE,        L"ꎞ~",     10, iY += 24, 125, 22);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_StatusUI.AddStatic(ID_DEVICESTATUS, L"", 10, iY,       490, 22);
	g_StatusUI.GetStatic(ID_DEVICESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,255,0,255), DT_LEFT | DT_VCENTER);
	g_StatusUI.AddStatic(ID_FRAMESTATUS,  L"", 10, iY += 24, 490, 22);
	g_StatusUI.GetStatic(ID_FRAMESTATUS)->GetElement(0)->SetFont(0, D3DCOLOR_ARGB(255,0,255,255), DT_LEFT | DT_VCENTER);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_SampleUI1.AddButton(ID_BTN1, L"\",     10, iY,       125, 22);
	g_SampleUI1.AddButton(ID_BTN2, L"wiF@",     10, iY += 24, 125, 22);
	g_SampleUI1.AddButton(ID_BTN3, L"wiFA",     10, iY += 24, 125, 22);
	g_SampleUI1.AddButton(ID_BTN4, L"wiFȂ",   10, iY += 24, 125, 22);
	g_SampleUI1.AddCheckBox(ID_CHECKBOX1, L"ŏ", 10, iY += 24, 125, 22);
	g_SampleUI1.AddCheckBox(ID_CHECKBOX2, L"LvV", 10, iY += 24, 125, 22);
	g_SampleUI1.AddCheckBox(ID_CHECKBOX3, L"Xg{bNXL", 10, iY += 24, 125, 22, true); // `FbN
	iY += 10;
	g_SampleUI1.AddSlider(ID_SLIDER1,              10, iY += 24, 125, 22);
	g_SampleUI1.AddSlider(ID_SLIDER2,              10, iY += 24, 125, 22, 0, 255, 255);
	g_SampleUI1.AddRadioButton(ID_RADIOBTN1G1, 1, L"v",   10, iY += 24, 125, 22, true); // `FbN
	g_SampleUI1.AddRadioButton(ID_RADIOBTN2G1, 1, L"v", 10, iY += 24, 125, 22);
	g_SampleUI1.AddRadioButton(ID_RADIOBTN3G2, 2, L"Texture1", 10, iY += 24, 125, 22, true);   // `FbN
	g_SampleUI1.AddRadioButton(ID_RADIOBTN4G2, 2, L"Texture2", 10, iY += 24, 125, 22);

	// GUIRg[_CAOɓo^
	iY = 0;
	g_SampleUI2.AddStatic(ID_STATIC, L"eLXg",     10, iY,       125, 22);
	g_SampleUI2.AddButton(ID_BUTTON, L"Button",       10, iY += 24, 125, 22);
	g_SampleUI2.AddCheckBox(ID_CHECKBOX, L"CheckBox", 10, iY += 24, 125, 22);
	g_SampleUI2.AddRadioButton(ID_RADIOBTN1, 1, L"Radio1", 10, iY += 24, 125, 22, true);
	g_SampleUI2.AddRadioButton(ID_RADIOBTN2, 1, L"Radio2", 10, iY += 24, 125, 22);
	g_SampleUI2.AddComboBox(ID_COMBOBOX, 10, iY += 24, 125, 22);
	g_SampleUI2.GetComboBox(ID_COMBOBOX)->AddItem(L"ڇ@", NULL);
	g_SampleUI2.GetComboBox(ID_COMBOBOX)->AddItem(L"ڇA", NULL);
	g_SampleUI2.GetComboBox(ID_COMBOBOX)->AddItem(L"ڇB", NULL);
	g_SampleUI2.AddSlider(ID_SLIDER,     10, iY += 24, 125, 22);
	g_SampleUI2.AddEditBox(ID_EDITBOX, L"GfBbg{bNX", 10, iY += 24, 125, 32);
	g_SampleUI2.AddListBox(ID_LISTBOX,   10, iY += 35, 125, 85);
	g_SampleUI2.GetListBox(ID_LISTBOX)->AddItem(L"ڇC", NULL);
	g_SampleUI2.GetListBox(ID_LISTBOX)->AddItem(L"ڇD", NULL);
	g_SampleUI2.GetListBox(ID_LISTBOX)->AddItem(L"ڇE", NULL);
}

// **** WinMain֐
int WINAPI wWinMain(HINSTANCE, HINSTANCE, LPWSTR, int)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// ** R[obN֐̓o^ **
	// foCX쐬̏
	DXUTSetCallbackD3D9DeviceCreated(DXUTCallbackDeviceCreated);
	// EChEEbZ[W̏
	DXUTSetCallbackMsgProc(DXUTCallbackMsgProc);
	// V[̍XV
	DXUTSetCallbackFrameMove(DXUTCallbackFrameMove);
	// V[̕`
	DXUTSetCallbackD3D9FrameRender(DXUTCallbackFrameRender);
	// foCX̏
	DXUTSetCallbackD3D9DeviceLost(DXUTCallbackDeviceLost);
	// foCX̃XgA
	DXUTSetCallbackD3D9DeviceReset(DXUTCallbackDeviceReset);
	// foCX폜̏
	DXUTSetCallbackD3D9DeviceDestroyed(DXUTCallbackDeviceDestroyed);

	// p\ȃfoCX̗
	DXUTSetCallbackD3D9DeviceAcceptable(DXUTCallbackIsDeviceAcceptable);
	// 쐬foCXݒ̕ύX
	DXUTSetCallbackDeviceChanging(DXUTCallbackModifyDeviceSettings);

	// tXN[E[hŃ}EXEJ[\\
	DXUTSetCursorSettings(true, true);

	// **  **
	InitApp();				// AvP[V֘Ȁ

	DXUTInit(true, true);                     // TvEt[[N̏
	DXUTSetHotkeyHandling(true);              // zbgEL[̐ݒ
	DXUTCreateWindow(L"Direct3D 9 Sample12"); // EChE̍쐬

	DXUTCreateDevice(true, 640, 480);  // foCX̍쐬(R[obN֐̎s)

	// ** CE[v **
	DXUTMainLoop();    // bZ[WE[vs

	return DXUTGetExitCode();  // I
}
