/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample09.cpp
		uV[`悷vOv
--------------------------------------------------------------*/

#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓnȂ
#define DXUT_AUTOLIB		// DXUTŕKvȃCu(dsound.libȊO)IɃN
#include "DXUT.h"			// DXUTg
#include "SDKmisc.h"		// DXUT Optionalg
#include "resource.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// *****************************************
// **** O[oϐ

// XvCg@\
LPD3DXSPRITE			g_pD3DXSprite = NULL;	// XvCg
LPDIRECT3DTEXTURE9		g_pD3DTexture = NULL;	// XvCgɎgeNX`
WCHAR g_SpriteFileName[MAX_PATH] = L"";			// XvCgɎg摜t@C

// *****************************************
// **** foCX쐬֘ÃR[obN֐

// p\ȃfoCX̗(R[obN֐)
bool CALLBACK DXUTCallbackIsDeviceAcceptable(
		D3DCAPS9 *pCaps, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, bool bWindowed, void* pUserContext)

{
	if (pCaps->MaxPrimitiveCount < 0xFFFF)		// v~eBu
		return false;
	if (pCaps->MaxVertexIndex < 0xFFF0)			// CfbNX
		return false;
	if (pCaps->PixelShaderVersion < D3DPS_VERSION(2, 0))	// sNZEVF[_
		return false;

	return true;	// ̃foCX̎gpe
}

// 쐬foCXݒ̕ύX(R[obN֐)
bool CALLBACK DXUTCallbackModifyDeviceSettings(
		DXUTDeviceSettings *pDeviceSettings, void* pUserContext)
{
	// Direct3D 9foCXg邱ƂmF
	if( pDeviceSettings->ver == DXUT_D3D9_DEVICE )
	{
		// D3D9foCX̔\͂擾
		D3DCAPS9 caps;
		DXUTGetD3D9DeviceCaps( pDeviceSettings, &caps );

		// ŏɃt@X foCXIꂽƂɁAx\
		static bool s_bFirstTime = true;
		if( s_bFirstTime )
		{
			s_bFirstTime = false;
			if( pDeviceSettings->d3d9.DeviceType == D3DDEVTYPE_REF )
				DXUTDisplaySwitchingToREFWarning(pDeviceSettings->ver);
		}

		// o[W2.0̒_VF[_n[hEFAŃT|[gĂȂꍇ́A\tgEFAg
		if ((caps.DevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) == 0 ||
				caps.VertexShaderVersion < D3DVS_VERSION(2, 0))
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_HARDWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_PUREDEVICE;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_SOFTWARE_VERTEXPROCESSING;	// \tgEFA_
		}
		else
		{
			pDeviceSettings->d3d9.BehaviorFlags &= ~D3DCREATE_SOFTWARE_VERTEXPROCESSING;
			pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_HARDWARE_VERTEXPROCESSING;	//n[hEFA_
		}

		// Avdouble^g(x͒ቺ)
		pDeviceSettings->d3d9.BehaviorFlags |= D3DCREATE_FPU_PRESERVE;
	}

	return true;
}

// foCX쐬̏(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceCreated(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// XvCgɎg摜t@Č
	V_RETURN(DXUTFindDXSDKMediaFileCch(g_SpriteFileName, MAX_PATH, L"canvas.dds"));

	// XvCgɕ\eNX`̏
	V_RETURN(D3DXCreateTextureFromFile(pd3dDevice, g_SpriteFileName, &g_pD3DTexture));

	// XvCg@\̏
	V_RETURN(D3DXCreateSprite(pd3dDevice, &g_pD3DXSprite));

	return hr;
}

// *****************************************
// **** V[`֘ÃR[obN֐

// V[̍XV(R[obN֐)
void CALLBACK DXUTCallbackFrameMove(
		double fTime, float fElapsedTime, void* pUserContext)
{
}

// V[̕`(R[obN֐)
void CALLBACK DXUTCallbackFrameRender(
		LPDIRECT3DDEVICE9 pd3dDevice, double fTime, float fElapsedTime, void* pUserContext)
{
	// V[̃NA
	pd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0, 0, 255), 1.0f, 0);

	// V[̕`Jn
	if (SUCCEEDED(pd3dDevice->BeginScene()))
	{
		// V[̕`(XvCg̕`)
		static int alpha=0;
		g_pD3DXSprite->Begin(D3DXSPRITE_ALPHABLEND | D3DXSPRITE_DONOTSAVESTATE);
		g_pD3DXSprite->Draw(g_pD3DTexture, NULL, NULL, NULL,
				D3DCOLOR_ARGB(alpha>255?511-alpha:alpha,255,255,255));
		alpha++; alpha &= 0x1FF;
		g_pD3DXSprite->End();

		// V[̕`I
		pd3dDevice->EndScene();
	}
}

// *****************************************
// **** foCX̏֘ÃR[obN֐

// foCX̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceLost(void* pUserContext)
{
	// XvCg̏
	if (g_pD3DXSprite)
		g_pD3DXSprite->OnLostDevice();
}

// foCX̃XgA(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceReset(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= pBackBufferSurfaceDesc->Width;
	vp.Height	= pBackBufferSurfaceDesc->Height;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	V_RETURN(pd3dDevice->SetViewport(&vp));

	// XvCg̏
	if (g_pD3DXSprite)
		g_pD3DXSprite->OnResetDevice();

	return hr;	// I
}

// *****************************************
// **** foCX폜֘ÃR[obN֐

// foCX폜̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceDestroyed(void* pUserContext)
{
	// 擾IuWFNg̊J
	SAFE_RELEASE(g_pD3DXSprite);
	SAFE_RELEASE(g_pD3DTexture);
}

// *****************************************
// WinMain֐ƃAvP[V֘Ȁ

// **** WinMain֐
int WINAPI wWinMain(HINSTANCE, HINSTANCE, LPWSTR, int)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// ** R[obN֐̓o^ **
	// foCX쐬̏
	DXUTSetCallbackD3D9DeviceCreated(DXUTCallbackDeviceCreated);
	// V[̍XV
	DXUTSetCallbackFrameMove(DXUTCallbackFrameMove);
	// V[̕`
	DXUTSetCallbackD3D9FrameRender(DXUTCallbackFrameRender);
	// foCX̏
	DXUTSetCallbackD3D9DeviceLost(DXUTCallbackDeviceLost);
	// foCX̃XgA
	DXUTSetCallbackD3D9DeviceReset(DXUTCallbackDeviceReset);
	// foCX폜̏
	DXUTSetCallbackD3D9DeviceDestroyed(DXUTCallbackDeviceDestroyed);

	// p\ȃfoCX̗
	DXUTSetCallbackD3D9DeviceAcceptable(DXUTCallbackIsDeviceAcceptable);
	// 쐬foCXݒ̕ύX
	DXUTSetCallbackDeviceChanging(DXUTCallbackModifyDeviceSettings);

	// **  **
	DXUTInit(true, true);                     // TvEt[[N̏
	DXUTSetHotkeyHandling(true);              // zbgEL[̐ݒ
	DXUTCreateWindow(L"Direct3D 9 Sample09"); // EChE̍쐬

	DXUTCreateDevice(true, 640, 480);  // foCX̍쐬(R[obN֐̎s)

	// ** CE[v **
	DXUTMainLoop();    // bZ[WE[vs

	return DXUTGetExitCode();  // I
}
