/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample03.cpp
		uEChEE[hƃtXN[E[h؂ւvOv
--------------------------------------------------------------*/

#define STRICT				// ^`FbNɍsȂ
#define WIN32_LEAN_AND_MEAN	// wb_[炠܂gȂ֐Ȃ
#define WINVER        0x501	// Windows XPȍ~
#define _WIN32_WINNT  0x501 

#define SAFE_RELEASE(x)  { if(x) { (x)->Release(); (x)=NULL; } }

#define D3D_DEBUG_INFO		// Direct3DfobO̗L
#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓn

#include <windows.h>
#include <crtdbg.h>
#include <d3dx9.h>
#include <dxerr.h>

#include "resource.h"

// KvȃCuN
#pragma comment( lib, "d3d9.lib" )
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "d3dx9d.lib" )
#else
#pragma comment( lib, "d3dx9.lib" )
#endif
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "dxguid.lib" )
#pragma comment( lib, "Imm32.lib" )

/*-------------------------------------------
	O[oϐ(AvP[V֘A)
--------------------------------------------*/
HINSTANCE	g_hInstance		= NULL;	// CX^XEnh
HWND		g_hWindow		= NULL;	// EChEEnh
HMENU		g_hMenu			= NULL;	// j[Enh

WCHAR		g_szAppTitle[]	= L"Direct3D 9 Sample03";
WCHAR		g_szWndClass[]	= L"D3D9S03";

RECT		g_rectWindow;							// EChEE[hł̍Ō̈ʒu

// N̕`̈TCY
bool		g_bWindow = true;						// N̉ʃ[h

SIZE		g_sizeWindowMode	= { 640, 480 };		// EChEE[h

SIZE		g_sizeFullMode	= { 1024, 768 };		// tXN[E[h
D3DFORMAT	g_formatFull	= D3DFMT_X8R8G8B8;		// fBXvC(obNEobt@)EtH[}bg

// AvP[V̓tO
bool		g_bActive		= false;	// ANeBu

/*-------------------------------------------
	O[oϐ(DirectX֘A)
--------------------------------------------*/

// C^[tFCX
LPDIRECT3D9				g_pD3D			= NULL; // Direct3DC^[tFCX
LPDIRECT3DDEVICE9		g_pD3DDevice	= NULL; // Direct3DDeviceC^[tFCX
D3DPRESENT_PARAMETERS	g_D3DPP;				// D3DDevice̐ݒ()

D3DPRESENT_PARAMETERS	g_D3DPPWindow;			// D3DDevice̐ݒ(EChEE[hp)
D3DPRESENT_PARAMETERS	g_D3DPPFull;			// D3DDevice̐ݒ(tXN[E[hp)

bool g_bDeviceLost = false;						// foCX̏tO

// XvCg@\
LPD3DXSPRITE			g_pD3DXSprite = NULL;	// XvCg
LPDIRECT3DTEXTURE9		g_pD3DTexture = NULL;	// XvCgɎgeNX`
WCHAR g_szSpriteFile[] = L"..\\..\\Media\\canvas.dds";	// XvCgɎg摜t@C

/*-------------------------------------------
	֐`
--------------------------------------------*/

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[ViŏɈxĂ΂j
--------------------------------------------*/
HRESULT InitApp(HINSTANCE hInst)
{
	// AvP[ṼCX^XEnhۑ
	g_hInstance = hInst;

	// IME֎~
	ImmDisableIME(-1);	// ̃Xbhŋ֎~(imm32.libN)

	// EChEENX̓o^
	WNDCLASS wc;
	wc.style			= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc		= (WNDPROC)MainWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInst;
	wc.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wc.lpszMenuName		= g_bWindow ? MAKEINTRESOURCE(IDR_MENU1) : NULL;
	wc.lpszClassName	= g_szWndClass;

	if (!RegisterClass(&wc))
		return DXTRACE_ERR(L"InitApp", GetLastError());

	// CEEChE쐬
	g_rectWindow.top	= 0;
	g_rectWindow.left	= 0;
	g_rectWindow.right	= g_sizeWindowMode.cx;
	g_rectWindow.bottom	= g_sizeWindowMode.cy;
	AdjustWindowRect(&g_rectWindow, WS_OVERLAPPEDWINDOW, TRUE);
	g_rectWindow.right	= g_rectWindow.right - g_rectWindow.left;
	g_rectWindow.bottom	= g_rectWindow.bottom - g_rectWindow.top;
	g_rectWindow.top	= 0;
	g_rectWindow.left	= 0;

	RECT rect;
	if (g_bWindow)
	{
		// (EChEE[hp)
		rect.top	= CW_USEDEFAULT;
		rect.left	= CW_USEDEFAULT;
		rect.right	= g_rectWindow.right;
		rect.bottom	= g_rectWindow.bottom;
	}
	else
	{
		// (tXN[E[hp)
		rect.top	= 0;
		rect.left	= 0;
		rect.right	= g_sizeFullMode.cx;
		rect.bottom	= g_sizeFullMode.cy;

		g_hMenu = LoadMenu(g_hInstance, MAKEINTRESOURCE(IDR_MENU1));
	}

	g_hWindow = CreateWindow(g_szWndClass, g_szAppTitle,
		g_bWindow ? WS_OVERLAPPEDWINDOW : WS_POPUP,
			rect.left, rect.top, rect.right, rect.bottom,
			NULL, NULL, hInst, NULL);
	if (g_hWindow == NULL)
		return DXTRACE_ERR(L"InitApp", GetLastError());

	// EChE\
	ShowWindow(g_hWindow, SW_SHOWNORMAL);
	UpdateWindow(g_hWindow);

	return S_OK;
}

/*-------------------------------------------
	DirectX Graphics
--------------------------------------------*/
HRESULT InitDXGraphics(void)
{
	// Direct3DIuWFNg̍쐬
	g_pD3D = Direct3DCreate9(D3D_SDK_VERSION);
	if (g_pD3D == NULL)
		return DXTRACE_ERR(L"InitDXGraphics Direct3DCreate9", E_FAIL);

	// D3DDeviceIuWFNg̐ݒ(EChEE[hp)
	ZeroMemory(&g_D3DPPWindow, sizeof(g_D3DPPWindow));

	g_D3DPPWindow.BackBufferWidth			= 0;
	g_D3DPPWindow.BackBufferHeight			= 0;
	g_D3DPPWindow.BackBufferFormat			= D3DFMT_UNKNOWN;
	g_D3DPPWindow.BackBufferCount			= 1;
	g_D3DPPWindow.MultiSampleType			= D3DMULTISAMPLE_NONE;
	g_D3DPPWindow.MultiSampleQuality		= 0;
	g_D3DPPWindow.SwapEffect				= D3DSWAPEFFECT_DISCARD;
	g_D3DPPWindow.hDeviceWindow				= g_hWindow;
	g_D3DPPWindow.Windowed					= TRUE;
	g_D3DPPWindow.EnableAutoDepthStencil	= FALSE;
	g_D3DPPWindow.AutoDepthStencilFormat	= D3DFMT_UNKNOWN;
	g_D3DPPWindow.Flags						= 0;
	g_D3DPPWindow.FullScreen_RefreshRateInHz= 0;
	g_D3DPPWindow.PresentationInterval		= D3DPRESENT_INTERVAL_IMMEDIATE;
//	g_D3DPPWindow.PresentationInterval		= D3DPRESENT_INTERVAL_ONE;

	// D3DDeviceIuWFNg̐ݒ(tXN[E[h)
	ZeroMemory(&g_D3DPPFull, sizeof(g_D3DPPFull));

	g_D3DPPFull.BackBufferWidth				= g_sizeFullMode.cx;
	g_D3DPPFull.BackBufferHeight			= g_sizeFullMode.cy;
	g_D3DPPFull.BackBufferFormat			= g_formatFull;
	g_D3DPPFull.BackBufferCount				= 1;
	g_D3DPPFull.MultiSampleType				= D3DMULTISAMPLE_NONE;
	g_D3DPPFull.MultiSampleQuality			= 0;
	g_D3DPPFull.SwapEffect					= D3DSWAPEFFECT_DISCARD;
	g_D3DPPFull.hDeviceWindow				= g_hWindow;
	g_D3DPPFull.Windowed					= FALSE;
	g_D3DPPFull.EnableAutoDepthStencil		= FALSE;
	g_D3DPPFull.AutoDepthStencilFormat		= D3DFMT_UNKNOWN;
	g_D3DPPFull.Flags						= 0;
	g_D3DPPFull.FullScreen_RefreshRateInHz	= 0;
	g_D3DPPFull.PresentationInterval		= D3DPRESENT_INTERVAL_IMMEDIATE;
//	g_D3DPPFull.PresentationInterval		= D3DPRESENT_INTERVAL_ONE;

	// D3DDeviceIuWFNg̍쐬
	if (g_bWindow)
		g_D3DPP = g_D3DPPWindow;
	else
		g_D3DPP = g_D3DPPFull;

	HRESULT hr = g_pD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWindow,
						D3DCREATE_HARDWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice);
	if (FAILED(hr))
	{
		hr = g_pD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWindow,
						D3DCREATE_SOFTWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice);
		if (FAILED(hr))
		{
			hr = g_pD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, g_hWindow,
							D3DCREATE_SOFTWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice);
			if (FAILED(hr))
				return DXTRACE_ERR(L"InitDXGraphics CreateDevice", hr);
		}
	}

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= g_D3DPP.BackBufferWidth;
	vp.Height	= g_D3DPP.BackBufferHeight;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	hr = g_pD3DDevice->SetViewport(&vp);
	if (FAILED(hr))
		return DXTRACE_ERR(L"InitDXGraphics SetViewport", hr);

	// XvCgɕ\eNX`̏
	hr = D3DXCreateTextureFromFile(g_pD3DDevice, g_szSpriteFile, &g_pD3DTexture);
	if (FAILED(hr))
		return DXTRACE_ERR(L"InitDXGraphics D3DXCreateTextureFromFile", hr);

	// XvCg@\̏
	hr = D3DXCreateSprite(g_pD3DDevice, &g_pD3DXSprite);
	if (FAILED(hr))
		return DXTRACE_ERR(L"InitDXGraphics D3DXCreateSprite", hr);

	return S_OK;
}

/*-------------------------------------------
	D3DɊǗȂIuWFNg̏
--------------------------------------------*/
HRESULT InitD3DObject(void)
{
	// XvCg̏
	if (g_pD3DXSprite)
		g_pD3DXSprite->OnResetDevice();

	return S_OK;
}

/*--------------------------------------------
	ʂ̕`揈
--------------------------------------------*/
HRESULT Render(void)
{
	// V[̃NA
	g_pD3DDevice->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0, 0, 255), 1.0f, 0);

	// V[̕`Jn
	if (SUCCEEDED(g_pD3DDevice->BeginScene()))
	{
		// V[̕`(XvCg̕`)
		static int alpha=0;
		g_pD3DXSprite->Begin(D3DXSPRITE_ALPHABLEND | D3DXSPRITE_DONOTSAVESTATE);
		g_pD3DXSprite->Draw(g_pD3DTexture, NULL, NULL, NULL,
				D3DCOLOR_ARGB(alpha>255?511-alpha:alpha,255,255,255));
		alpha++; alpha &= 0x1FF;
		g_pD3DXSprite->End();

		// V[̕`I
		g_pD3DDevice->EndScene();
	}

	// V[̕\
	return g_pD3DDevice->Present(NULL, NULL, NULL, NULL);
}

/*-------------------------------------------
	D3DɊǗȂIuWFNg̏I
--------------------------------------------*/
HRESULT CleanupD3DObject(void)
{
	// XvCg̏
	if (g_pD3DXSprite)
		g_pD3DXSprite->OnLostDevice();

	return S_OK;
}

/*-------------------------------------------
	EChEETCY̕ύX
--------------------------------------------*/
HRESULT ChangeWindowSize(void)
{
	// EChẼNCAg̈ɍ킹
	CleanupD3DObject();

	HRESULT hr = g_pD3DDevice->Reset(&g_D3DPP);
	if (FAILED(hr))
	{
		if (hr == D3DERR_DEVICELOST)
			g_bDeviceLost = true;
		else
			DestroyWindow(g_hWindow);
		return DXTRACE_ERR(L"ChangeWindowSize Reset", hr);
	}
	hr = InitD3DObject();
	if (FAILED(hr))
	{
		DestroyWindow(g_hWindow);
		return DXTRACE_ERR(L"ChangeWindowSize InitD3DObject", hr);
	}

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= g_D3DPP.BackBufferWidth;
	vp.Height	= g_D3DPP.BackBufferHeight;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	hr = g_pD3DDevice->SetViewport(&vp);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"ChangeWindowSize SetViewport", hr);
		DestroyWindow(g_hWindow);
	}
	return hr;
}

/*-------------------------------------------
	ʃ[h̕ύX
--------------------------------------------*/
void ChangeDisplayMode(void)
{
	g_bWindow = !g_bWindow;

	CleanupD3DObject();

	if (g_bWindow)
	{
		g_D3DPP = g_D3DPPWindow;
	}
	else
	{
		g_D3DPP = g_D3DPPFull;
		GetWindowRect(g_hWindow, &g_rectWindow);
	}

	HRESULT hr = g_pD3DDevice->Reset(&g_D3DPP);
	if (FAILED(hr))
	{
		if (hr == D3DERR_DEVICELOST)
			g_bDeviceLost = true;
		else
			DestroyWindow(g_hWindow);
		DXTRACE_ERR(L"ChangeDisplayMode Reset", hr);
		return;
	}

	hr = InitD3DObject();
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"ChangeDisplayMode InitD3DObject", hr);
		DestroyWindow(g_hWindow);
		return;
	}

	if (g_bWindow)
	{
		SetWindowLong(g_hWindow, GWL_STYLE, WS_OVERLAPPEDWINDOW | WS_VISIBLE);
		if(g_hMenu != NULL)
		{
			SetMenu(g_hWindow, g_hMenu);
			g_hMenu = NULL;
		}
		SetWindowPos(g_hWindow, HWND_NOTOPMOST,
				g_rectWindow.left, g_rectWindow.top,
				g_rectWindow.right - g_rectWindow.left,
				g_rectWindow.bottom - g_rectWindow.top,
				SWP_SHOWWINDOW);
	}
	else
	{
		SetWindowLong(g_hWindow, GWL_STYLE, WS_POPUP | WS_VISIBLE);
		if(g_hMenu == NULL)
		{
			g_hMenu = GetMenu(g_hWindow);
			SetMenu(g_hWindow, NULL);
		}
	}
}

/*-------------------------------------------
	DirectX Graphics̏I(ɎsƂĂ΂)
--------------------------------------------*/
bool CleanupDXGraphics(void)
{
	// 擾IuWFNg̊J
	SAFE_RELEASE(g_pD3DXSprite);
	SAFE_RELEASE(g_pD3DTexture);

	SAFE_RELEASE(g_pD3DDevice);
	SAFE_RELEASE(g_pD3D);

	return true;
}

/*-------------------------------------------
	AvP[V̏IiŌɌĂ΂j
--------------------------------------------*/
bool CleanupApp(void)
{
	// j[Enh̍폜
	if (g_hMenu)
		DestroyMenu(g_hMenu);

	// EChEENX̓o^
	UnregisterClass(g_szWndClass, g_hInstance);
	return true;
}

/*-------------------------------------------
	EBhE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc(HWND hWnd, UINT msg, UINT wParam, LONG lParam)
{
	HRESULT hr = S_OK;

	switch(msg)
	{
	case WM_ACTIVATE:
		g_bActive = (LOWORD(wParam) != 0);
		break;

	case WM_DESTROY:
		// D3DɊǗȂIuWFNg̏I
		CleanupD3DObject();
		// DirectX Graphics̏I
		CleanupDXGraphics();
		// EChE
		PostQuitMessage(0);
		g_hWindow = NULL;
		return 0;

	// EChEETCY̕ύX
	case WM_SIZE:
		if (g_D3DPP.Windowed != TRUE)
			break;

		if (!g_pD3DDevice || wParam == SIZE_MINIMIZED)
			break;
		g_D3DPP.BackBufferWidth  = LOWORD(lParam);
		g_D3DPP.BackBufferHeight = HIWORD(lParam);
		if(g_bDeviceLost)
			break;
		if (wParam == SIZE_MAXIMIZED || wParam == SIZE_RESTORED)
			ChangeWindowSize();
		break;

	case WM_SETCURSOR:
		if (g_D3DPP.Windowed != TRUE)
		{
			SetCursor(NULL);
			return 1;
		}
		break;

	case WM_KEYDOWN:
		// L[͂̏
		switch(wParam)
		{
		case VK_ESCAPE:	// [ESCAPE]L[ŃEChE
			PostMessage(hWnd, WM_CLOSE, 0, 0);
			break;

		case 'W':	// ʃ[h̐؂ւ
			ChangeDisplayMode();
			break;
		}
		break;

	case WM_COMMAND:
		// Iꂽj[s
		switch (LOWORD(wParam))
		{
		case ID_FILE_EXIT:
			DestroyWindow(hWnd);
			return 0;
		}
		break;
	}

	// ftHg
	return DefWindowProc(hWnd, msg, wParam, lParam);
}

/*--------------------------------------------
	ACh̏
--------------------------------------------*/
bool AppIdle(void)
{
	if (!g_pD3D || !g_pD3DDevice)
		return false;

	if (!g_bActive)
		return true;

	// foCX̕
	HRESULT hr;
	if (g_bDeviceLost)
	{
		Sleep(100);	// 0.1b҂

		// foCXԂ̃`FbN
		hr  = g_pD3DDevice->TestCooperativeLevel();
		if (FAILED(hr))
		{
			if (hr == D3DERR_DEVICELOST)
				return true;  // foCX͂܂Ă

			if (hr != D3DERR_DEVICENOTRESET)
				return false; // \ʃG[

			CleanupD3DObject(); // Direct3DŊǗĂȂ\[XJ
			hr = g_pD3DDevice->Reset(&g_D3DPP); // ݂
			if (FAILED(hr))
			{
				if (hr == D3DERR_DEVICELOST)
					return true; // foCX͂܂Ă

				DXTRACE_ERR(L"AppIdle Reset", hr);
				return false; // foCX̕Ɏs
			}
			hr = InitD3DObject();  // JDirect3DŊǗĂȂ\[XĎ擾
			if (FAILED(hr))
			{
				DXTRACE_ERR(L"AppIdle InitD3DObject", hr);
				return false;
			}
		}
		// foCX
		g_bDeviceLost = false;
	}

	// ʂ̍XV
	hr = Render();
	if (hr == D3DERR_DEVICELOST)
		g_bDeviceLost = true;	// foCX̏
	else if (FAILED(hr))
		return false;

	return true;
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI wWinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPWSTR lpCmdLine, int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );

	// AvP[VɊւ鏉
	HRESULT hr = InitApp(hInst);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"WinMain InitApp", hr);
		return 0;
	}

	// DirectX Graphics̏
	hr = InitDXGraphics();
	if (FAILED(hr))
		DXTRACE_ERR(L"WinMain InitDXGraphics", hr);
	else
	{
		// D3DɊǗȂIuWFNg̏
		hr = InitD3DObject();
		if (FAILED(hr))
		{
			DXTRACE_ERR(L"WinMain InitD3DObject", hr);
			DestroyWindow(g_hWindow);
		}
	}

	// bZ[WE[v
	MSG msg;
	do
	{
		if (PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
			// ACh
			if (!AppIdle())
				// G[ꍇCAvP[VI
				DestroyWindow(g_hWindow);
		}
	} while (msg.message != WM_QUIT);

	// AvP[V̏I
	CleanupApp();

	return (int)msg.wParam;
}

