﻿//-------------------------------------------------------------------------------------------------
// File : asdxTarget.h
// Desc : Render Target.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <d3d12.h>
#include <asdxRefPtr.h>
#include <asdxDescriptorHeap.h>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// TargetDesc structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct TargetDesc
{
    DescriptorHeap* pHeapRT;
    DescriptorHeap* pHeapSRV;

    uint32_t        Width;
    uint32_t        Height;
    DXGI_FORMAT     Format;
    uint32_t        SampleCount;
    uint32_t        SampleQuality;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// ColorTarget class
///////////////////////////////////////////////////////////////////////////////////////////////////
class ColorTarget
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================
    ColorTarget();
    ~ColorTarget();
    bool Init(ID3D12Device* pDevice, const TargetDesc* pDesc, bool enableSRGB);
    bool Init(
        ID3D12Device*   pDevice,
        DescriptorHeap* pHeapRT,
        IDXGISwapChain* pSwapChain,
        uint32_t        index,
        bool            enableSRGB);
    void Term();
    ID3D12Resource* GetResource() const;
    const Descriptor* GetRTV() const;
    const Descriptor* GetSRV() const;

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    RefPtr<ID3D12Resource>  m_pResource;
    RefPtr<Descriptor>      m_pRTV;
    RefPtr<Descriptor>      m_pSRV;

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// DepthTarget class
///////////////////////////////////////////////////////////////////////////////////////////////////
class DepthTarget
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================
    DepthTarget();
    ~DepthTarget();
    bool Init(ID3D12Device* pDevice, const TargetDesc* pDesc);
    void Term();
    ID3D12Resource* GetResource() const;
    const Descriptor* GetDSV() const;
    const Descriptor* GetSRV() const;

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    RefPtr<ID3D12Resource>  m_pResource;
    RefPtr<Descriptor>      m_pDSV;
    RefPtr<Descriptor>      m_pSRV;

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};

} // namespace asdx
