﻿//-------------------------------------------------------------------------------------------------
// File : asdxCommandList.h
// Desc : Command List Moudle.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <d3d12.h>
#include <cstdint>
#include <vector>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// CommandList class
///////////////////////////////////////////////////////////////////////////////////////////////////
class CommandList
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================
    CommandList();
    ~CommandList();
    bool Init(ID3D12Device* pDevice, D3D12_COMMAND_LIST_TYPE type, uint32_t count);
    void Term();
    ID3D12GraphicsCommandList* Reset();

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    ID3D12GraphicsCommandList*              m_pCmdList;         //!< コマンドリストです.
    std::vector<ID3D12CommandAllocator*>    m_pAllocators;      //!< コマンドアロケータです.
    uint32_t                                m_Index;            //!< アロケータ番号です.

    //=============================================================================================
    // private methods.
    //=============================================================================================
    CommandList     (const CommandList&) = delete;
    void operator = (const CommandList&) = delete;
};

} // namespace asdx
