﻿//-------------------------------------------------------------------------------------------------
// File : asdxILoadable.h
// Desc : ILoadable Interface.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------

#ifndef __ASDX_ILOADABLE_H__
#define __ASDX_ILOADABLE_H__

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxTypedef.h>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// ILoadable interface
///////////////////////////////////////////////////////////////////////////////////////////////////
struct ILoadable
{
    //---------------------------------------------------------------------------------------------
    //! @brief      ファイルから読み込みを行います.
    //!
    //! @param[in]      filename        ファイル名です.
    //! @retval true    読み込みに成功.
    //! @retval false   読み込みに失敗.
    //---------------------------------------------------------------------------------------------
    virtual bool Load( const char16* filename ) = 0;
};


} // namespace asdx


#endif//__ASDX_ILOADABLE_H__
