﻿//-------------------------------------------------------------------------------------------------
// File : asdxResMaterial.h
// Desc : Resource Material Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxMath.h>
#include <vector>
#include <string>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// ResPhong structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct ResPhong
{
    Vector3     Diffuse;        //!< 拡散反射.
    f32         Alpha;          //!< 透過度.
    Vector3     Specular;       //!< 鏡面反射.
    f32         Power;          //!< 鏡面反射強度.
    Vector3     Emissive;       //!< 自己照明.
    u32         TextureId;      //!< テクスチャId
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// ResDisney structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct ResDisney
{
    Vector4     BaseColor;      //!< 基本色.
    f32         Metallic;       //!< 金属度.
    f32         Smoothness;     //!< 平滑度.
    f32         Reflectance;    //!< フレネルリフレクタンス
    u32         TextureId;      //!< テクスチャId.
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// ResMaterialSet structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct ResMaterial
{
    std::vector<std::wstring>   Paths;      //!< テクスチャファイルパスリスト.
    std::vector<ResPhong>       Phong;      //!< Phong BRDF
    std::vector<ResDisney>      Disney;     //!< Disney BRDF
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// MaterialFactory class
///////////////////////////////////////////////////////////////////////////////////////////////////
class MaterialFactory
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      マテリアルリソースを生成します.
    //!
    //! @param[in]      filename        マテリアルセットファイル名です.
    //! @param[out]     pResult         マテリアルセットリソースの格納先です.
    //! @retval true    生成に成功.
    //! @retval false   生成に失敗.
    //---------------------------------------------------------------------------------------------
    static bool Create( const char16* filename, ResMaterial* pResult );

    //---------------------------------------------------------------------------------------------
    //! @brief      マテリアルリソースを破棄します.
    //!
    //! @param[in]      ptr         破棄するマテリアルセットリソースへのポインタです.
    //---------------------------------------------------------------------------------------------
    static void Dispose( ResMaterial*& ptr );
};

} // namespace asdx
