﻿//-------------------------------------------------------------------------------------------------
// File : asdxResource.h
// Desc : Resource Module.
// Copyright(c) Project Asura.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <d3d12.h>
#include <asdxRef.h>
#include <asdxCmdList.h>


namespace asdx {

//-------------------------------------------------------------------------------------------------
//! @brief サブリソースをコピーします.
//-------------------------------------------------------------------------------------------------
void CopySubresource(
    const D3D12_MEMCPY_DEST*        pDst,
    const D3D12_SUBRESOURCE_DATA*   pSrc,
    size_t                          rowSize,
    u32                             rowCounts,
    u32                             sliceCount );

//-------------------------------------------------------------------------------------------------
//! @brief データのアップロードに必要なサイズを取得します.
//-------------------------------------------------------------------------------------------------
u64 GetRequiredIntermediateSize(
    ID3D12Resource* pDstRes,
    u32             firstSubResource,
    u32             subResourceCount );

//-------------------------------------------------------------------------------------------------
//! @brief サブリソースを更新します.
//-------------------------------------------------------------------------------------------------
u64 UpdateSubresources( 
    ID3D12GraphicsCommandList*  pCmdList,
    ID3D12Resource*             pDstResource,
    ID3D12Resource*             pIntermediate,
    u64                         intermediateOffset,
    u32                         firstSubresource,
    u32                         subResourceCount,
    D3D12_SUBRESOURCE_DATA*     pSrcData);


///////////////////////////////////////////////////////////////////////////////////////////////////
// Resource class
///////////////////////////////////////////////////////////////////////////////////////////////////
class Resource
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    static const D3D12_RESOURCE_DESC    DescBuffer;           //!< デフォルトのバッファ構成.
    static const D3D12_RESOURCE_DESC    DescTexture1D;        //!< デフォルトの１次元テクスチャ構成.
    static const D3D12_RESOURCE_DESC    DescTexture2D;        //!< デフォルトの２次元テクスチャ構成.
    static const D3D12_RESOURCE_DESC    DescTexture3D;        //!< デフォルトの３次元テクスチャ構成.
    static const D3D12_HEAP_PROPERTIES  HeapProps;            //!< デフォルトのヒーププロパティです.

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    Resource();

    //---------------------------------------------------------------------------------------------
    //! @brief      デストラクタです.
    //---------------------------------------------------------------------------------------------
    virtual ~Resource();

    //---------------------------------------------------------------------------------------------
    //! @brief      初期化処理を行います.
    //!
    //! @param[in]      pDevice         デバイスです.
    //! @param[in]      pDesc           リソース設定です.
    //! @param[in]      pProps          ヒーププロパティです.
    //! @param[in]      heapFlags       ヒープフラグです.
    //! @param[in]      states          リソースステートです.
    //! @retval true    初期化に成功.
    //! @retval false   初期化に失敗.
    //---------------------------------------------------------------------------------------------
    bool Init( 
        ID3D12Device*                 pDevice,
        const D3D12_RESOURCE_DESC*    pDesc,
        const D3D12_HEAP_PROPERTIES*  pProps,
        const D3D12_HEAP_FLAGS        heapFlags,
        const D3D12_RESOURCE_STATES   states );

    //---------------------------------------------------------------------------------------------
    //! @brief      終了処理を行います.
    //---------------------------------------------------------------------------------------------
    void Term();

    //---------------------------------------------------------------------------------------------
    //! @brief      リソースを取得します.
    //!
    //! @return     リソースを返却します.
    //---------------------------------------------------------------------------------------------
    ID3D12Resource* GetPtr() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      アロー演算子です.
    //---------------------------------------------------------------------------------------------
    ID3D12Resource* operator -> () const;

private:
    //=============================================================================================
    // private variables
    //=============================================================================================
    RefPtr<ID3D12Resource>  m_Resource;      //!< リソースです.

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};



} // namespace asdx
