﻿using System;

namespace NaGet.Tasks
{
	/// <summary>
	/// タスクイベントの種類
	/// </summary>
	public enum TaskEventType
	{
		/// <summary>
		/// 動作進捗・通知のみ
		/// </summary>
		PING,
		/// <summary>
		/// 開始
		/// </summary>
		STARTED,
		/// <summary>
		/// 完了した(すべてを完了)
		/// </summary>
		COMPLETED,
		/// <summary>
		/// 作業がキャンセルされた
		/// </summary>
		CANCELED,
		/// <summary>
		/// エラーを発生し(中断した)
		/// </summary>
		ERROR,
		/// <summary>
		/// エラーが発生したが継続
		/// </summary>
		WARNING,
		/// <summary>
		/// そのほかの情報
		/// </summary>
		INFO,
		/// <summary>
		/// 子作業を開始
		/// </summary>
		STARTED_SUBTASK,
		/// <summary>
		/// 子作業を終了
		/// </summary>
		COMPLETED_SUBTASK,
	}
	
	/// <summary>
	/// タスクのイベント
	/// </summary>
	public class TaskEventArgs : EventArgs
	{
		/// <summary>
		/// タスクイベントの種類
		/// </summary>
		public TaskEventType Type = TaskEventType.PING;
		
		/// <summary>
		/// タスクの進捗状況の百分率表示
		/// </summary>
		public float ProgressPercent = -1;
		
		/// <summary>
		/// タスクの現況のメッセージ
		/// </summary>
		public string TaskMessage;
		
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public TaskEventArgs()
			: this(TaskEventType.PING, null, -1)
		{
		}
		
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public TaskEventArgs(TaskEventType type, string message, float percent)
		{
			this.Type = type;
			this.TaskMessage = message;
			this.ProgressPercent = percent;
		}
	}
}
