﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using NaGet.Tasks;

namespace NaGet.SubCommands
{
	public delegate NaGetTaskQueryResult NaGetTaskQueryHandler(object sender, NaGetTaskQueryArgs e);
	
	public class NaGetTaskQueryArgs
	{
		/// <summary>
		/// タスクの現況のメッセージ
		/// </summary>
		public string Message;
		
		/// <summary>
		/// 回答の種類のフラグ
		/// </summary>
		public NaGetTaskQueryResult SelectionFlag;
		
		public NaGetTaskQueryArgs(string message, NaGetTaskQueryResult selectionFlag)
		{
			this.Message = message;
			this.SelectionFlag = selectionFlag;
		}
	}
	
	/// <summary>
	/// 質問の答え
	/// </summary>
	[Flags()]
	public enum NaGetTaskQueryResult : uint
	{
		/// <summary>
		/// 継続(=OK)
		/// </summary>
		CONTINUE = 0x01,
		/// <summary>
		/// 再試行
		/// </summary>
		RETRY = 0x02,
		/// <summary>
		/// キャンセル、中止
		/// </summary>
		CANCEL = 0x04,
		/// <summary>
		/// 自動的なキャンセル(ユーザの手ではないもの)
		/// </summary>
		CANCELED_AUTOMATICALLY = 0x00,
	}
	
}
