﻿using System;
using System.IO;
using NaGet.Tasks;
using NaGet.Packages;

namespace NaGet.SubCommands.SubTask
{
	public class LocalUpdateSubTask : NaGetSubTask
	{
		private PackageListsManager pkgListMan;
		
		public LocalUpdateSubTask(PackageListsManager pkgListMan)
		{
			this.pkgListMan = pkgListMan;
		}
		
		public override void Run()
		{
			NotifyStarted();
			RaiseTaskSetEvent(TaskEventType.STARTED, "インストール済みファイルリスト更新", 0);
			
			try {
				pkgListMan.DetectInstalledPkgs();
			} catch (PackageInformationFileAccessException e) {
				recoverExceptionAtDetectInstalledPkgs(e);
			}
			pkgListMan.SaveInstalledPackageList();
			RaiseTaskSetEvent(TaskEventType.INFO, string.Format("{0} を更新しました", NaGet.Env.ArchiveInstalledPackageListFile), 50);
			
			pkgListMan.DetectSystemInstalledPkgs();
			pkgListMan.SaveSystemInstalledPackageList();
			RaiseTaskSetEvent(TaskEventType.INFO, string.Format("{0} を更新しました", NaGet.Env.SystemInstalledPackageListFile), 100);
			
			RaiseTaskSetEvent(TaskEventType.COMPLETED, "インストール済みファイルリスト更新", 100);
			NotifyCompleted();
		}
		
		private void recoverExceptionAtDetectInstalledPkgs(PackageInformationFileAccessException e)
		{
			RaiseTaskSetEvent(TaskEventType.WARNING, string.Format("{0} が読み込めませんでした", e.FilePath), -1);
			
			string dirPath = Path.GetDirectoryName(e.FilePath);
			if (Directory.Exists(dirPath)) {
				NaGet.Utils.SetAttributeRecursive(dirPath, FileAttributes.Normal);
				Directory.Delete(dirPath, true);
				RaiseTaskSetEvent(TaskEventType.WARNING, string.Format("{0}を削除しました。", Path.GetDirectoryName(e.FilePath)), -1);
				
				pkgListMan.DetectInstalledPkgs();
			} else {
				throw e;
			}
		}
	}
}
