﻿using System;
using System.Drawing;
using System.Windows.Forms;
using NaGet.Packages;
using NaGet.Packages.Install;
using System.IO;
using System.Collections.Generic;

namespace AppliStation.Util
{
	/// <summary>
	/// ListViewのソートをカプセル化するためのクラス
	/// </summary>
	class ListViewItemSortComparer : System.Collections.IComparer
	{
		SortOrder order = SortOrder.Ascending;
		
		ColumnHeader column = null;
		
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public ListViewItemSortComparer()
		{
		}
		
		/// <summary>
		/// ソートの方向。昇順か?降順か?
		/// </summary>
		public SortOrder Order {
			get { return order; }
			set { order = value; }
		}
		
		/// <summary>
		/// 選択しているコラムを取得・設定する。
		/// nullを設定するとソートが解除される。
		/// </summary>
		public ColumnHeader Column {
			get { return column; }
			set {
				column = value;
				
				if (value == null || value.Index < 0) {
					order = SortOrder.None;
				}
			}
		}
		
		/// <summary>
		/// 選択しているコラムのインデックスを返す。選択されていないときは-1を返す。
		/// </summary>
		public int ColumnIndex {
			get {
				return (column != null)? column.Index : -1;
			}
		}
		
		public int Compare(object x, object y)
		{
			int columnIndex = this.ColumnIndex;
			int result = 0;
			
			if (columnIndex >= 0 && order != SortOrder.None) {
				ListViewItem itemx = (ListViewItem) x;
				ListViewItem itemy = (ListViewItem) y;
				
				result = string.Compare(itemx.SubItems[columnIndex].Text,
				                        itemy.SubItems[columnIndex].Text);
				
				if (order == SortOrder.Descending) {
					result = -result;
				}
			}
			
			return result;
		}
	}
}
