// MyOpenArchive.cpp: COpenArchive NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MyOpenArchive.h"
#include "MainAr.h"
#include "SplitCmdLine.h"
#include "Common/StdOutStream.h"
#include <time.h>

#include "Windows/PropVariant.h"
#include "Windows/PropVariantConversions.h"
#include "Windows/FileDir.h"
#include "../../UI/Common/OpenArchive.h"
#include "../../UI/Common/ArchiveCommandLine.h"
#include "../../UI/Console/OpenCallbackConsole.h"
#include "../../UI/Console/ExtractCallbackConsole.h"
#include "Common/UTFConvert.h"

static COpenArchive* pOATail;

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

COpenArchive::COpenArchive()
{
	m_pOANext = NULL;
	m_pOAPrev = pOATail;
	if (pOATail)
		pOATail->m_pOANext = this;
	pOATail = this;
}

COpenArchive::~COpenArchive()
{
	if (m_pOAPrev)
		m_pOAPrev->m_pOANext = m_pOANext;
	if (m_pOANext)
		m_pOANext->m_pOAPrev = m_pOAPrev;
	if (pOATail == this)
		pOATail = pOATail->m_pOAPrev;

	if (m_pWildcardCensor)
		delete m_pWildcardCensor;
}

// ỸIuWFNg폜
void COpenArchive::RemoveAll()
{
	while (pOATail)
		delete pOATail;
}

// IuWFNg̃|C^
COpenArchive* COpenArchive::FindObject(HARC hArc)
{
	for (COpenArchive* pOA = pOATail; pOA; pOA = pOA->m_pOAPrev)
	{
		if (pOA == (COpenArchive*)hArc)
			return pOA;
	}
	return NULL;
}

HRESULT COpenArchive::OpenCheck(LPCWSTR lpFileName, DWORD dwMode, CArchiveLink &archiveLink, int &nArchiveType)
{
	try
	{
		HRESULT result;
		CCodecs *codecs = new CCodecs;
		CMyComPtr<
			#ifdef EXTERNAL_CODECS
			ICompressCodecsInfo
			#else
			IUnknown
			#endif
			> compressCodecsInfo = codecs;
		RINOK(codecs->Load());
		
		CIntVector formatIndices;
		CStdOutStream stdOut;
		COpenCallbackConsole openCallbackUI;
		openCallbackUI.OutStream = &stdOut;
		openCallbackUI.PasswordIsDefined = (dwMode == CHECKARCHIVE_RAPID);

		if (dwMode == CHECKARCHIVE_FULLCRC)
		{
			// CRCS`FbN[h CHECKARCHIVE_FULLCRC
			CExtractCallbackConsole *ecs = new CExtractCallbackConsole;
			CMyComPtr<IFolderArchiveExtractCallback> extractCallback = ecs;
			
			ecs->OutStream = &stdOut;
			ecs->PasswordIsDefined = false;
			ecs->Init();

			CArchiveCommandLineOptions options;
			CArchiveCommandLineParser parser;
			UStringVector commandStrings;
			commandStrings.Add(L"t");
			commandStrings.Add(lpFileName);
			parser.Parse1(commandStrings, options);
			parser.Parse2(options);

	//		CIntVector formatIndices;
	//		if (!codecs->FindFormatForArchiveType(options.ArcType, formatIndices))
	//			throw E_FAIL;

			CExtractOptions eo;
			eo.StdOutMode = options.StdOutMode;
			eo.PathMode = options.Command.GetPathMode();
			eo.TestMode = options.Command.IsTestMode();
			eo.OverwriteMode = options.OverwriteMode;
			eo.OutputDir = options.OutputDir;
			eo.YesToAll = options.YesToAll;
			#ifdef COMPRESS_MT
			eo.Properties = options.ExtractProperties;
			#endif
			UString errorMessage;
			CDecompressStat stat;
			result = DecompressArchives(
				codecs,
				formatIndices,
				options.ArchivePathsSorted, 
				options.ArchivePathsFullSorted,
				options.WildcardCensor.Pairs.Front().Head, 
				eo, &openCallbackUI, ecs, errorMessage, stat);
			if (ecs->NumArchiveErrors != 0 || ecs->NumFileErrors != 0)
				return E_FAIL;
			return result;
		}

		COpenCallbackImp *openCallbackSpec = new COpenCallbackImp;
		CMyComPtr<IArchiveOpenCallback> openCallback = openCallbackSpec;
		openCallbackSpec->Callback = &openCallbackUI;

		UString fullName;
		int fileNamePartStartIndex;
		::NWindows::NFile::NDirectory::MyGetFullPathName(lpFileName, fullName, fileNamePartStartIndex);
		UString prefix = fullName.Left(fileNamePartStartIndex);
		UString name = fullName.Mid(fileNamePartStartIndex);
		openCallbackSpec->Init(prefix, name);

		result = OpenArchive(codecs, formatIndices, lpFileName, archiveLink, openCallbackSpec);
		if (result != S_OK)
		{
			if (dwMode == CHECKARCHIVE_RAPID && openCallbackUI.PasswordWasAsked)
			{
				nArchiveType = ARCHIVETYPE_7Z;
				return S_OK;
			}
			return result;
		}

		if (codecs->Formats[archiveLink.GetArchiverIndex()].Name.CompareNoCase(L"7z") == 0)
			nArchiveType = ARCHIVETYPE_7Z;
		else if (codecs->Formats[archiveLink.GetArchiverIndex()].Name.CompareNoCase(L"Zip") == 0)
			nArchiveType = ARCHIVETYPE_ZIP;
		else
			nArchiveType = 0;
	}
	catch (...)
	{
		return E_FAIL;
	}
	return S_OK;
}

BOOL COpenArchive::Open(LPCWSTR lpFileName, DWORD dwMode)
{
	m_aItemPos = 0;
	m_ui64ArcOriginalSize = 0;
	m_ui64ArcCompressedSize = 0;
	m_pWildcardCensor = NULL;
	m_dwMode = dwMode;
	m_bSearchMode = false;
	m_bSolid = false;
	if (NWindows::NFile::NFind::FindFile(lpFileName, m_fiArchive) == false)
		return FALSE;
	
	CArchiveLink archiveLink;
	if (OpenCheck(lpFileName, CHECKARCHIVE_BASIC, archiveLink, m_nArchiveType) != S_OK)
		return FALSE;

	m_anArchiveHandler = archiveLink.GetArchive();
	m_strDefaultItemName = archiveLink.GetDefaultItemName();

	if (m_anArchiveHandler->GetNumberOfItems(&m_aNumItems) != S_OK)
		return FALSE;

	if (m_nArchiveType == ARCHIVETYPE_7Z)
	{
		NWindows::NCOM::CPropVariant aPropVariant;
		m_anArchiveHandler->GetArchiveProperty(kpidSolid, &aPropVariant);
		m_bSolid = VARIANT_BOOLToBool(aPropVariant.boolVal);
	}
	return TRUE;
}

int COpenArchive::FindFirst(LPCWSTR lpszWildName, INDIVIDUALINFO *lpSubInfo)
{
	if (m_pWildcardCensor)
		delete m_pWildcardCensor;
	m_pWildcardCensor = new NWildcard::CCensor;

	LPWSTR lpSplit;
	if (lpszWildName)
		lpSplit = _wcsdup(lpszWildName);
	else
		lpSplit = _wcsdup(L"");
	wchar_t* p = lpSplit;
	wchar_t* pToken = NULL;
	wchar_t c;
	while (*p == ' ') ++p;
	while (*p)
	{
		pToken = p;
		c = *p;
		if (c == '\"')
			pToken = ++p;
		else
			c = ' ';
		while (*p != c && *p != '\0') ++p;
		if (*p == '\0')
			m_pWildcardCensor->AddItem(true, pToken, true);
		else
		{
			*p = '\0';
			m_pWildcardCensor->AddItem(true, pToken, true);
			++p;
		}
		while (*p == ' ') ++p;
	}
	if (pToken == NULL)
		m_pWildcardCensor->AddItem(true, L"*", true);
	free(lpSplit);

	m_aItemPos = 0;
	m_ui64ArcOriginalSize = 0;
	m_ui64ArcCompressedSize = 0;
	m_bSearchMode = true;
	return FindNext(lpSubInfo);
}

int COpenArchive::FindNext(INDIVIDUALINFO *lpSubInfo)
{
	if (!m_bSearchMode)
		return ERROR_NOT_SEARCH_MODE;

	NWindows::NCOM::CPropVariant aPropVariant;
	while (TRUE)
	{
		if (m_aItemPos == m_aNumItems)
		{
			m_bSearchMode = false;
			return -1;
		}
		if (GetArchiveItemPath(m_anArchiveHandler, m_aItemPos, m_strDefaultItemName, m_aFileName) != S_OK)
			return -1;
		if (m_pWildcardCensor->CheckPath(m_aFileName, true))
			break;
		++m_aItemPos;
	}
	m_anArchiveHandler->GetProperty(m_aItemPos, kpidIsDir, &aPropVariant);
	if (aPropVariant.boolVal)
	{
		m_aFileName.TrimRight('\\');
		m_aFileName += L"\\";
	}
	m_anArchiveHandler->GetProperty(m_aItemPos, kpidSize, &aPropVariant);
	m_ui64OriginalSize = ConvertPropVariantToUInt64(aPropVariant);
	m_anArchiveHandler->GetProperty(m_aItemPos, kpidPackSize, &aPropVariant);
	m_ui64CompressedSize = m_bSolid ? 0 : ConvertPropVariantToUInt64(aPropVariant);
	m_anArchiveHandler->GetProperty(m_aItemPos, kpidCRC, &aPropVariant);
	m_dwCRC = aPropVariant.vt ? aPropVariant.ulVal : 0;
	FILETIME ft = {0, 0};
	m_anArchiveHandler->GetProperty(m_aItemPos, kpidMTime, &aPropVariant);
	m_ftLastWriteTime = aPropVariant.vt ? aPropVariant.filetime : ft;
	m_anArchiveHandler->GetProperty(m_aItemPos, kpidCTime, &aPropVariant);
	m_ftLastCreateTime = aPropVariant.vt ? aPropVariant.filetime : ft;
	m_anArchiveHandler->GetProperty(m_aItemPos, kpidATime, &aPropVariant);
	m_ftLastAccessTime = aPropVariant.vt ? aPropVariant.filetime : ft;
	m_anArchiveHandler->GetProperty(m_aItemPos, kpidAttrib, &aPropVariant);
	m_dwAttribute = aPropVariant.ulVal;
	m_anArchiveHandler->GetProperty(m_aItemPos, kpidMethod, &aPropVariant);
	m_aMode = aPropVariant.vt ? aPropVariant.bstrVal : L"";
	m_anArchiveHandler->GetProperty(m_aItemPos, kpidEncrypted, &aPropVariant);
	if (aPropVariant.boolVal)
		m_dwAttribute |= FA_ENCRYPTED;

/*	if (m_nArchiveType == ARCHIVETYPE_ZIP)
	{
//		m_anArchiveHandler->GetProperty(m_aItemPos, kpidHostOS, &aPropVariant);
//		m_anArchiveHandler->GetProperty(m_aItemPos, kpidComment, &aPropVariant);
	}*/
	
	if (lpSubInfo)
	{
		lpSubInfo->uFlag = 0;
		lpSubInfo->uOSType = 0;
		lpSubInfo->dwCRC = m_dwCRC;
		lpSubInfo->dwOriginalSize = m_ui64OriginalSize < 0xFFFFFFFF ? (DWORD)m_ui64OriginalSize : -1;
		lpSubInfo->dwCompressedSize = m_ui64CompressedSize < 0xFFFFFFFF ? (DWORD)m_ui64CompressedSize : -1;
		lpSubInfo->wRatio = (m_ui64OriginalSize && !m_bSolid) ? (WORD)(m_ui64CompressedSize * 1000 / m_ui64OriginalSize) : 0;
		FILETIME ftLocal;
		::FileTimeToLocalFileTime(&m_ftLastWriteTime, &ftLocal);
		::FileTimeToDosDateTime(&ftLocal, &lpSubInfo->wDate, &lpSubInfo->wTime);
		g_StdOut.WideCharToMultiByte(m_aFileName, lpSubInfo->szFileName, FNAME_MAX32);
		g_StdOut.WideCharToMultiByte(m_aMode, lpSubInfo->szMode, 8);
		CStdOutStream::GetCompactMethod(m_aMode, m_nArchiveType, lpSubInfo->szMode);
		CStdOutStream::GetAttributesString(m_dwAttribute, true, lpSubInfo->szAttribute);
	}

	m_ui64ArcOriginalSize += m_ui64OriginalSize;
	m_ui64ArcCompressedSize += m_ui64CompressedSize;
	++m_aItemPos;

	return 0;
}

WORD COpenArchive::GetArcDate()
{
	WORD wFatDate;
	WORD wFatTime;
	FILETIME ftLocalFileTime;
	::FileTimeToLocalFileTime(&m_fiArchive.MTime, &ftLocalFileTime);
	::FileTimeToDosDateTime(&ftLocalFileTime, &wFatDate, &wFatTime);
	return wFatDate;
}

WORD COpenArchive::GetArcTime()
{
	WORD wFatDate;
	WORD wFatTime;
	FILETIME ftLocalFileTime;
	::FileTimeToLocalFileTime(&m_fiArchive.MTime, &ftLocalFileTime);
	::FileTimeToDosDateTime(&ftLocalFileTime, &wFatDate, &wFatTime);
	return wFatTime;
}

WORD COpenArchive::GetRatio()
{
	if (!m_bSearchMode)
		return -1;
	if (m_ui64OriginalSize == 0)
		return 0;
	return (WORD)(m_ui64CompressedSize * 1000 / m_ui64OriginalSize);
}

WORD COpenArchive::GetDate()
{
	if (!m_bSearchMode || *(UINT64*)&m_ftLastWriteTime == 0)
		return -1;
	WORD wFatDate;
	WORD wFatTime;
	FILETIME ftLocalFileTime;
	::FileTimeToLocalFileTime(&m_ftLastWriteTime, &ftLocalFileTime);
	::FileTimeToDosDateTime(&ftLocalFileTime, &wFatDate, &wFatTime);
	return wFatDate;
}

WORD COpenArchive::GetTime()
{
	if (!m_bSearchMode || *(UINT64*)&m_ftLastWriteTime == 0)
		return -1;
	WORD wFatDate;
	WORD wFatTime;
	FILETIME ftLocalFileTime;
	::FileTimeToLocalFileTime(&m_ftLastWriteTime, &ftLocalFileTime);
	::FileTimeToDosDateTime(&ftLocalFileTime, &wFatDate, &wFatTime);
	return wFatTime;
}

DWORD COpenArchive::GetWriteTime()
{
	if (!m_bSearchMode || *(ULONGLONG*)&m_ftLastWriteTime == 0)
		return -1;
	return (DWORD)(((*(const ULONGLONG *)&m_ftLastWriteTime) - 0x19DB1DED53E8000) / 10000000);
}

DWORD COpenArchive::GetCreateTime()
{
	if (!m_bSearchMode)
		return -1;
	if (*(ULONGLONG*)&m_ftLastCreateTime == 0)
		return GetWriteTime();
	return (DWORD)(((*(const ULONGLONG *)&m_ftLastCreateTime) - 0x19DB1DED53E8000) / 10000000);
}

DWORD COpenArchive::GetAccessTime()
{
	if (!m_bSearchMode)
		return -1;
	if (*(ULONGLONG*)&m_ftLastAccessTime == 0)
		return GetWriteTime();
	return (DWORD)(((*(const ULONGLONG *)&m_ftLastAccessTime) - 0x19DB1DED53E8000) / 10000000);
}

BOOL COpenArchive::GetWriteTimeEx(FILETIME *lpftLastWriteTime)
{
	if (!m_bSearchMode || *(UINT64*)&m_ftLastWriteTime == 0)
		return FALSE;
	*lpftLastWriteTime = m_ftLastWriteTime;
	return TRUE;
}

BOOL COpenArchive::GetCreateTimeEx(FILETIME *lpftLastCreateTime)
{
	if (!m_bSearchMode)
		return FALSE;
	if (*(UINT64*)&m_ftLastCreateTime == 0)
		return GetWriteTimeEx(lpftLastCreateTime);
	*lpftLastCreateTime = m_ftLastCreateTime;
	return TRUE;
}

BOOL COpenArchive::GetAccessTimeEx(FILETIME *lpftLastAccessTime)
{
	if (!m_bSearchMode)
		return FALSE;
	if (*(UINT64*)&m_ftLastAccessTime == 0)
		return GetWriteTimeEx(lpftLastAccessTime);
	*lpftLastAccessTime = m_ftLastAccessTime;
	return TRUE;
}

BOOL COpenArchive::GetArcCreateTimeEx(FILETIME *lpftCreationTime)
{
	*lpftCreationTime = m_fiArchive.CTime;
	return TRUE;
}

BOOL COpenArchive::GetArcAccessTimeEx(FILETIME *lpftLastAccessTime)
{
	*lpftLastAccessTime = m_fiArchive.MTime;
	return TRUE;
}

BOOL COpenArchive::GetArcWriteTimeEx(FILETIME *lpftLastWriteTime)
{
	*lpftLastWriteTime = m_fiArchive.MTime;
	return TRUE;
}

BOOL COpenArchive::GetArcFileSizeEx(ULHA_INT64* lpllSize)
{
	*lpllSize = m_fiArchive.Size;
	return TRUE;
}

BOOL COpenArchive::GetArcOriginalSizeEx(ULHA_INT64* lpllSize)
{
	*lpllSize = (ULHA_INT64)m_ui64ArcOriginalSize;
	return TRUE;
}

BOOL COpenArchive::GetArcCompressedSizeEx(ULHA_INT64* lpllSize)
{
	*lpllSize = m_bSolid ? -1 : (ULHA_INT64)m_ui64ArcCompressedSize;
	return TRUE;
}

BOOL COpenArchive::GetOriginalSizeEx(ULHA_INT64* lpllSize)
{
	if (!m_bSearchMode)
		return FALSE;
	*lpllSize = (ULHA_INT64)m_ui64OriginalSize;
	return TRUE;
}

BOOL COpenArchive::GetCompressedSizeEx(ULHA_INT64* lpllSize)
{
	if (!m_bSearchMode)
		return FALSE;
	*lpllSize = (ULHA_INT64)m_ui64CompressedSize;
	return TRUE;
}
