/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osdn.pdf_brewer.BrewerData;
import net.osdn.pdf_brewer.Context;
import net.osdn.pdf_brewer.FontLoader;
import net.osdn.pdf_brewer.TextBuffer;
import net.osdn.pdf_brewer.instruction.Instruction;
import net.osdn.pdf_brewer.instruction.text.TextBufferingInstruction;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

public class PdfBrewer {
    private static PDFont FONT_NULL;
    private PDRectangle mediaBox;
    private PDDocument document;
    private PDPage page;
    private PDPageContentStream stream;
    private FontLoader fontLoader;
    private boolean isFontLoaderAutoGenerated;
    private Map<String, PDFont> fonts = new HashMap<String, PDFont>();
    private Set<TrueTypeCollection> ttcLoaded = new HashSet<TrueTypeCollection>();

    public static void main(String[] args) throws Exception {
        new PdfBrewer();
        System.in.read();
    }

    public static String getDefaultProducer() {
        String version;
        Package pkg = PDDocument.class.getPackage();
        String title = pkg.getSpecificationTitle();
        if (title == null || title.trim().length() == 0) {
            title = "Apache PDFBox";
        }
        if ((version = pkg.getSpecificationVersion()) == null) {
            version = "";
        }
        return title + " " + version;
    }

    public static String getDefaultCreator() {
        String version;
        Package pkg = PdfBrewer.class.getPackage();
        String title = pkg.getSpecificationTitle();
        if (title == null || title.trim().length() == 0) {
            title = "PDF Brewer";
        }
        if ((version = pkg.getSpecificationVersion()) == null) {
            version = "";
        }
        return title + " " + version;
    }

    public PdfBrewer() {
        this(FontLoader.getDefaultFontDir().toPath(), null, null);
    }

    public PdfBrewer(Path fontDir, Collection<String> fileNames, Collection<String> fontNames) {
        this(new FontLoader(fontDir.toFile(), fileNames, fontNames));
        this.isFontLoaderAutoGenerated = true;
    }

    public PdfBrewer(FontLoader fontLoader) {
        if (fontLoader == null) {
            throw new IllegalArgumentException("fontLoader is null");
        }
        this.fontLoader = fontLoader;
        this.document = new PDDocument();
        PDDocumentInformation info = this.document.getDocumentInformation();
        info.setProducer(PdfBrewer.getDefaultProducer());
        info.setCreator(PdfBrewer.getDefaultCreator());
    }

    public FontLoader getFontLoader() {
        return this.fontLoader;
    }

    public String getProducer() {
        PDDocumentInformation info = this.document.getDocumentInformation();
        return info.getProducer();
    }

    public void setProducer(String producer) {
        if (producer == null) {
            producer = "";
        }
        PDDocumentInformation info = this.document.getDocumentInformation();
        info.setProducer(producer);
    }

    public String getCreator() {
        PDDocumentInformation info = this.document.getDocumentInformation();
        return info.getCreator();
    }

    public void setCreator(String creator) {
        if (creator == null) {
            creator = "";
        }
        PDDocumentInformation info = this.document.getDocumentInformation();
        info.setCreator(creator);
    }

    public String getTitle() {
        PDDocumentInformation info = this.document.getDocumentInformation();
        return info.getTitle();
    }

    public void setTitle(String title) {
        PDDocumentInformation info = this.document.getDocumentInformation();
        info.setTitle(title);
    }

    public String getAuthor() {
        PDDocumentInformation info = this.document.getDocumentInformation();
        return info.getAuthor();
    }

    public void setAuthor(String author) {
        PDDocumentInformation info = this.document.getDocumentInformation();
        info.setAuthor(author);
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public PDPage getPage() {
        return this.page;
    }

    public PDPageContentStream getContentStream() {
        return this.stream;
    }

    public void newPage() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.page = new PDPage(this.mediaBox);
        this.document.addPage(this.page);
        this.stream = new PDPageContentStream(this.document, this.page);
    }

    public PDFont loadFont(String fontName) throws IOException {
        PDFont font = null;
        TrueTypeFont ttf = this.getFontLoader().getFont(fontName);
        if (ttf != null) {
            font = this.fonts.get(ttf.getName());
            if (font == null) {
                File ttcFile = this.getFontLoader().getTtcFile(ttf);
                if (ttcFile != null) {
                    TrueTypeCollection ttc = new TrueTypeCollection(ttcFile);
                    font = PDType0Font.load((PDDocument)this.document, (TrueTypeFont)ttc.getFontByName(ttf.getName()), (boolean)true);
                    this.ttcLoaded.add(ttc);
                } else {
                    font = PDType0Font.load((PDDocument)this.document, (TrueTypeFont)ttf, (boolean)true);
                }
                this.fonts.put(ttf.getName(), font);
            }
        } else {
            font = FONT_NULL;
        }
        if (font == FONT_NULL) {
            return null;
        }
        return font;
    }

    public void process(BrewerData pb) throws IOException {
        ArrayDeque<Context> stack = new ArrayDeque<Context>();
        this.mediaBox = pb.getMediaBox();
        if (this.mediaBox == null) {
            this.mediaBox = PDRectangle.A4;
        }
        Context context = new Context(new Context(this.getFontLoader(), this.mediaBox), 0);
        TextBuffer textBuffer = new TextBuffer();
        if (pb.getTitle() != null) {
            this.setTitle(pb.getTitle());
        }
        if (pb.getAuthor() != null) {
            this.setAuthor(pb.getAuthor());
        }
        this.newPage();
        List<Instruction> instructions = pb.getInstructions();
        for (Instruction instruction : instructions) {
            while (instruction.getIndent() < context.getIndent()) {
                if (!textBuffer.isEmpty()) {
                    textBuffer.process(this, context);
                    textBuffer.clear();
                }
                context = (Context)stack.pop();
            }
            if (instruction.getIndent() > context.getIndent()) {
                if (!textBuffer.isEmpty()) {
                    textBuffer.process(this, context);
                    textBuffer.clear();
                }
                stack.push(context);
                context = new Context(context, instruction.getIndent());
            }
            if (instruction instanceof TextBufferingInstruction) {
                textBuffer.add((TextBufferingInstruction)instruction);
                continue;
            }
            if (!textBuffer.isEmpty()) {
                textBuffer.process(this, context);
                textBuffer.clear();
            }
            instruction.process(this, context);
        }
        if (!textBuffer.isEmpty()) {
            textBuffer.process(this, context);
            textBuffer.clear();
        }
    }

    public void save(String pathname) throws IOException {
        try (FileOutputStream f = new FileOutputStream(pathname);
             BufferedOutputStream out = new BufferedOutputStream(f);){
            this.save(out);
        }
    }

    public void save(File file) throws IOException {
        try (FileOutputStream f = new FileOutputStream(file);
             BufferedOutputStream out = new BufferedOutputStream(f);){
            this.save(out);
        }
    }

    public void save(Path path) throws IOException {
        try (OutputStream f = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream out = new BufferedOutputStream(f);){
            this.save(out);
        }
    }

    public void save(OutputStream output) throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
        PDDocumentInformation info = this.document.getDocumentInformation();
        Calendar date = Calendar.getInstance();
        info.setCreationDate(date);
        info.setModificationDate(date);
        this.document.save(output);
    }

    public void close() throws IOException {
        if (this.document != null) {
            this.document.close();
            this.document = null;
        }
        for (TrueTypeCollection ttc : this.ttcLoaded) {
            ttc.close();
        }
        this.ttcLoaded.clear();
        if (this.isFontLoaderAutoGenerated) {
            this.fontLoader.close();
        }
    }

    static {
        try {
            FONT_NULL = new PDTrueTypeFont(new COSDictionary());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

