/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans.document;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlDocument;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlEntry;
import com.esotericsoftware.yamlbeans.document.YamlScalar;
import com.esotericsoftware.yamlbeans.emitter.Emitter;
import com.esotericsoftware.yamlbeans.emitter.EmitterException;
import com.esotericsoftware.yamlbeans.parser.Event;
import com.esotericsoftware.yamlbeans.parser.MappingStartEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class YamlMapping
extends YamlElement
implements YamlDocument {
    List<YamlEntry> entries = new LinkedList<YamlEntry>();

    public int size() {
        return this.entries.size();
    }

    public void addEntry(YamlEntry entry) {
        this.entries.add(entry);
    }

    public boolean deleteEntry(String key) {
        for (int index = 0; index < this.entries.size(); ++index) {
            if (!key.equals(this.entries.get(index).getKey().getValue())) continue;
            this.entries.remove(index);
            return true;
        }
        return false;
    }

    public YamlEntry getEntry(String key) throws YamlException {
        for (YamlEntry entry : this.entries) {
            if (!key.equals(entry.getKey().getValue())) continue;
            return entry;
        }
        return null;
    }

    public YamlEntry getEntry(int index) throws YamlException {
        return this.entries.get(index);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.anchor != null) {
            sb.append('&');
            sb.append(this.anchor);
            sb.append(' ');
        }
        if (this.tag != null) {
            sb.append(" !");
            sb.append(this.tag);
        }
        if (!this.entries.isEmpty()) {
            sb.append('{');
            for (YamlEntry entry : this.entries) {
                sb.append(entry.toString());
                sb.append(',');
            }
            sb.setLength(sb.length() - 1);
            sb.append('}');
        }
        return sb.toString();
    }

    public void emitEvent(Emitter emitter, YamlConfig.WriteConfig config) throws EmitterException, IOException {
        emitter.emit(new MappingStartEvent(this.anchor, this.tag, this.tag == null, false));
        for (YamlEntry entry : this.entries) {
            entry.emitEvent(emitter, config);
        }
        emitter.emit(Event.MAPPING_END);
    }

    public void setEntry(String key, boolean value) throws YamlException {
        this.setEntry(key, new YamlScalar(value));
    }

    public void setEntry(String key, Number value) throws YamlException {
        this.setEntry(key, new YamlScalar(value));
    }

    public void setEntry(String key, String value) throws YamlException {
        this.setEntry(key, new YamlScalar(value));
    }

    public void setEntry(String key, YamlElement value) throws YamlException {
        YamlEntry entry = this.getEntry(key);
        if (entry != null) {
            entry.setValue(value);
        } else {
            entry = new YamlEntry(new YamlScalar(key), value);
            this.addEntry(entry);
        }
    }

    public YamlElement getElement(int item) throws YamlException {
        throw new YamlException("Can only get element on sequence!");
    }

    public void deleteElement(int element) throws YamlException {
        throw new YamlException("Can only delete element on sequence!");
    }

    public void setElement(int item, boolean element) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    public void setElement(int item, Number element) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    public void setElement(int item, String element) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    public void setElement(int item, YamlElement element) throws YamlException {
        throw new YamlException("Can only set element on sequence!");
    }

    public void addElement(boolean element) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }

    public void addElement(Number element) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }

    public void addElement(String element) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }

    public void addElement(YamlElement element) throws YamlException {
        throw new YamlException("Can only add element on sequence!");
    }
}

