/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer.ui;

import java.awt.SplashScreen;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.prefs.Preferences;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import net.osdn.pdf_brewer.BrewerData;
import net.osdn.pdf_brewer.PdfBrewer;
import net.osdn.pdf_brewer.ui.PagerButton;
import net.osdn.pdf_brewer.ui.PagerMenu;
import net.osdn.pdf_brewer.ui.PdfPane;
import net.osdn.util.fx.Dialogs;
import net.osdn.util.fx.input.KeyCombinations;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfBrewerMain
extends Application {
    public static String APP_TITLE = "PDF BREWER";
    public static String APP_VERSION;
    public static String APP_WINDOW_TITLE;
    public static final Image IMAGE_APPLICATION_16PX;
    public static final Image IMAGE_FILE_16PX;
    public static final Image IMAGE_SAVE_16PX;
    public static final Image IMAGE_PAGE_FIRST_BLACK_16PX;
    public static final Image IMAGE_PAGE_FIRST_WHITE_16PX;
    public static final Image IMAGE_PAGE_PREVIOUS_BLACK_16PX;
    public static final Image IMAGE_PAGE_PREVIOUS_WHITE_16PX;
    public static final Image IMAGE_PAGE_NEXT_BLACK_16PX;
    public static final Image IMAGE_PAGE_NEXT_WHITE_16PX;
    public static final Image IMAGE_PAGE_LAST_BLACK_16PX;
    public static final Image IMAGE_PAGE_LAST_WHITE_16PX;
    private static final int PREF_PDF_PANE_WIDTH = 612;
    private static final int PREF_PDF_PANE_HEIGHT = 841;
    private static volatile int count;
    private static Stage stage;
    private static Preferences preferences;
    private static File lastSaveDir;
    protected MenuBar menuBar;
    protected MenuItem menuFileOpen;
    protected MenuItem menuFileSave;
    protected MenuItem menuFileExit;
    protected Menu menuPdfFirst;
    protected Menu menuPdfPrevious;
    protected Menu menuPdfNext;
    protected Menu menuPdfLast;
    protected Menu menuPdfPageNumber;
    protected Label pdfPageNumberLabel;
    protected PdfPane pdfPane;
    private File input;
    private PDDocument document;
    private ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private BrewerTask task;

    public static void main(String[] args) {
        if (count++ == 0) {
            int[] version = PdfBrewerMain.getApplicationVersion();
            if (version != null) {
                APP_VERSION = version[2] == 0 ? String.format("%d.%d", version[0], version[1]) : String.format("%d.%d.%d", version[0], version[1], version[2]);
                APP_WINDOW_TITLE = APP_TITLE + " " + APP_VERSION;
            } else {
                APP_WINDOW_TITLE = APP_TITLE;
            }
            PdfBrewerMain.launch((String[])args);
        } else {
            Platform.runLater(() -> {
                if (stage != null) {
                    stage.setIconified(false);
                    stage.toFront();
                }
            });
        }
    }

    public static InputStream getResourceAsStream(String name) {
        return PdfBrewerMain.class.getResourceAsStream(name);
    }

    public static int[] getApplicationVersion() {
        String s = System.getProperty("java.application.version");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        s = s.trim() + ".0.0.0.0";
        String[] array = s.split("\\.", 5);
        int[] version = new int[4];
        for (int i = 0; i < 4; ++i) {
            try {
                version[i] = Integer.parseInt(array[i]);
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (version[0] == 0 && version[1] == 0 && version[2] == 0 && version[3] == 0) {
            return null;
        }
        return version;
    }

    public void start(Stage stage) throws Exception {
        PdfBrewerMain.stage = stage;
        stage.getIcons().add((Object)IMAGE_APPLICATION_16PX);
        stage.setTitle(APP_TITLE + (APP_VERSION != null ? " " + APP_VERSION : ""));
        stage.setMinWidth(256.0);
        stage.setMinHeight(380.0);
        stage.setScene(this.createScene());
        Rectangle2D screen = Screen.getPrimary().getVisualBounds();
        if (screen.getWidth() >= 612.0 && screen.getHeight() >= 841.0) {
            this.pdfPane.setPrefSize(612.0, 841.0);
        } else {
            this.pdfPane.setPrefSize(306.0, 420.0);
        }
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                PdfBrewerMain.this.stage_onCloseRequest(event);
            }
        });
        stage.show();
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (splash != null) {
            splash.close();
        }
    }

    protected Scene createScene() {
        this.menuBar = this.createMenuBar();
        this.pdfPane = new PdfPane();
        this.pdfPane.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                try {
                    PdfBrewerMain.this.pdf_mouseEntered(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.pdfPane.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                try {
                    PdfBrewerMain.this.pdf_mouseExited(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.pdfPane.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                try {
                    PdfBrewerMain.this.pdf_mouseMoved(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.pdfPane.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                try {
                    PdfBrewerMain.this.pdf_mouseClicked(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.pdfPane.scaleProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    PdfBrewerMain.this.pdf_scaleChanged(newValue.floatValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        BorderPane bp1 = new BorderPane();
        bp1.setCenter((Node)this.pdfPane);
        bp1.setTop((Node)this.menuBar);
        Scene scene = new Scene((Parent)bp1);
        scene.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                try {
                    PdfBrewerMain.this.onDragOver(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        scene.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                try {
                    PdfBrewerMain.this.onDragDropped(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.HOME, new KeyCombination.Modifier[0]), (Object)new Runnable(){

            @Override
            public void run() {
                if (!PdfBrewerMain.this.menuPdfFirst.isDisable()) {
                    try {
                        PdfBrewerMain.this.pdf_moveFirstPage();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        scene.getAccelerators().put((Object)new KeyCombinations(new KeyCombination[]{new KeyCodeCombination(KeyCode.PAGE_UP, new KeyCombination.Modifier[0]), new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[0]), new KeyCodeCombination(KeyCode.KP_UP, new KeyCombination.Modifier[0]), new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[0]), new KeyCodeCombination(KeyCode.KP_LEFT, new KeyCombination.Modifier[0])}), (Object)new Runnable(){

            @Override
            public void run() {
                if (!PdfBrewerMain.this.menuPdfPrevious.isDisable()) {
                    try {
                        PdfBrewerMain.this.pdf_movePreviousPage();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        scene.getAccelerators().put((Object)new KeyCombinations(new KeyCombination[]{new KeyCodeCombination(KeyCode.PAGE_DOWN, new KeyCombination.Modifier[0]), new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[0]), new KeyCodeCombination(KeyCode.KP_DOWN, new KeyCombination.Modifier[0]), new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[0]), new KeyCodeCombination(KeyCode.KP_RIGHT, new KeyCombination.Modifier[0])}), (Object)new Runnable(){

            @Override
            public void run() {
                if (!PdfBrewerMain.this.menuPdfNext.isDisable()) {
                    try {
                        PdfBrewerMain.this.pdf_moveNextPage();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.END, new KeyCombination.Modifier[0]), (Object)new Runnable(){

            @Override
            public void run() {
                if (!PdfBrewerMain.this.menuPdfLast.isDisable()) {
                    try {
                        PdfBrewerMain.this.pdf_moveLastPage();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]), (Object)new Runnable(){

            @Override
            public void run() {
                try {
                    PdfBrewerMain.this.data_reopen();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        String pkg = PdfBrewerMain.class.getPackage().getName();
        URL url = PdfBrewerMain.class.getResource("/" + pkg.replace('.', '/') + "/stylesheet.css");
        if (url != null) {
            scene.getStylesheets().add((Object)url.toExternalForm());
        }
        return scene;
    }

    protected MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menuFile = new Menu("\u30d5\u30a1\u30a4\u30eb");
        menuFile.setId("file");
        this.menuFileOpen = new MenuItem("\u958b\u304f...", (Node)new ImageView(IMAGE_FILE_16PX));
        this.menuFileOpen.setId("open");
        this.menuFileOpen.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+O"));
        this.menuFileOpen.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    PdfBrewerMain.this.menu_open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.menuFileSave = new MenuItem("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58...", (Node)new ImageView(IMAGE_SAVE_16PX));
        this.menuFileSave.setId("save");
        this.menuFileSave.setDisable(true);
        this.menuFileSave.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+S"));
        this.menuFileSave.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    PdfBrewerMain.this.menu_save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.menuFileExit = new MenuItem("\u7d42\u4e86");
        this.menuFileExit.setId("exit");
        this.menuFileExit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    PdfBrewerMain.this.menu_exit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        menuFile.getItems().addAll((Object[])new MenuItem[]{this.menuFileOpen, this.menuFileSave, new SeparatorMenuItem(), this.menuFileExit});
        this.pdfPageNumberLabel = new Label("");
        StackPane sp = new StackPane(new Node[]{this.pdfPageNumberLabel});
        sp.setMinWidth(40.0);
        StackPane.setAlignment((Node)this.pdfPageNumberLabel, (Pos)Pos.CENTER);
        this.menuPdfPageNumber = new Menu("", (Node)sp);
        this.menuPdfPageNumber.setId("pdf-page-number");
        PagerButton btnFirst = new PagerButton(IMAGE_PAGE_FIRST_BLACK_16PX, IMAGE_PAGE_FIRST_WHITE_16PX);
        btnFirst.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    PdfBrewerMain.this.pdf_moveFirstPage();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.menuPdfFirst = new PagerMenu(btnFirst);
        PagerButton btnPrevious = new PagerButton(IMAGE_PAGE_PREVIOUS_BLACK_16PX, IMAGE_PAGE_PREVIOUS_WHITE_16PX);
        btnPrevious.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    PdfBrewerMain.this.pdf_movePreviousPage();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.menuPdfPrevious = new PagerMenu(btnPrevious);
        PagerButton btnNext = new PagerButton(IMAGE_PAGE_NEXT_BLACK_16PX, IMAGE_PAGE_NEXT_WHITE_16PX);
        btnNext.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    PdfBrewerMain.this.pdf_moveNextPage();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.menuPdfNext = new PagerMenu(btnNext);
        PagerButton btnLast = new PagerButton(IMAGE_PAGE_LAST_BLACK_16PX, IMAGE_PAGE_LAST_WHITE_16PX);
        btnLast.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    PdfBrewerMain.this.pdf_moveLastPage();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.menuPdfLast = new PagerMenu(btnLast);
        this.menuPdfFirst.setDisable(true);
        this.menuPdfPrevious.setDisable(true);
        this.menuPdfNext.setDisable(true);
        this.menuPdfLast.setDisable(true);
        this.menuPdfPageNumber.setDisable(true);
        this.menuPdfFirst.setVisible(false);
        this.menuPdfPrevious.setVisible(false);
        this.menuPdfNext.setVisible(false);
        this.menuPdfLast.setVisible(false);
        this.menuPdfPageNumber.setVisible(false);
        menuBar.getMenus().addAll((Object[])new Menu[]{menuFile, this.menuPdfFirst, this.menuPdfPrevious, this.menuPdfPageNumber, this.menuPdfNext, this.menuPdfLast});
        return menuBar;
    }

    protected void stage_onCloseRequest(WindowEvent event) {
        if (this.document != null) {
            try {
                this.document.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.document = null;
        }
    }

    protected void onDragOver(DragEvent event) {
        if (event.getDragboard().hasFiles()) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        } else {
            event.consume();
        }
    }

    protected void onDragDropped(DragEvent event) {
        List files;
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasFiles() && (files = db.getFiles()).size() == 1) {
            File file = (File)files.get(0);
            String ext = file.getName().toLowerCase();
            int i = ext.lastIndexOf(46);
            if (i >= 0) {
                ext = ext.substring(i);
            }
            if (ext.equals(".yml") || ext.equals(".yaml") || ext.equals(".pb")) {
                try {
                    this.data_open(file);
                    stage.toFront();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                success = true;
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    protected void menu_open() throws Exception {
        File file;
        File dir;
        FileChooser fc = new FileChooser();
        fc.setTitle("\u958b\u304f");
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("YAML", new String[]{"*.yml", "*.yaml"}));
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PDF Brewer", new String[]{"*.pb"}));
        String s = preferences.get("lastOpenDirectory", null);
        if (s != null && (dir = new File(s)).exists() && dir.isDirectory()) {
            fc.setInitialDirectory(dir);
        }
        if ((file = fc.showOpenDialog((Window)stage)) != null) {
            String ext = file.getName().toLowerCase();
            int i = ext.lastIndexOf(46);
            if (i >= 0) {
                ext = ext.substring(i);
            }
            if (ext.equals(".yml") || ext.equals(".yaml") || ext.equals(".pb")) {
                this.data_open(file);
            }
            preferences.put("lastOpenDirectory", file.getParentFile().getAbsolutePath());
        }
    }

    protected void menu_save() throws Exception {
        if (this.document == null) {
            return;
        }
        FileChooser fc = new FileChooser();
        fc.setTitle("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58");
        if (lastSaveDir != null && lastSaveDir.isDirectory() && lastSaveDir.exists()) {
            fc.setInitialDirectory(lastSaveDir);
        } else {
            lastSaveDir = null;
            if (this.input != null) {
                fc.setInitialDirectory(this.input.getParentFile());
            }
        }
        String defaultName = "output.pdf";
        if (this.input != null) {
            defaultName = this.input.getName();
            int i = defaultName.lastIndexOf(46);
            if (i > 0) {
                defaultName = defaultName.substring(0, i);
            }
            defaultName = defaultName + ".pdf";
        }
        fc.setInitialFileName(defaultName);
        File file = fc.showSaveDialog((Window)stage);
        if (file != null) {
            lastSaveDir = file.getParentFile();
            if (this.document != null) {
                try {
                    this.document.save(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Dialogs.showError((Window)stage, (String)e.getLocalizedMessage());
                }
            }
        }
    }

    protected void menu_exit() throws Exception {
        Platform.exit();
    }

    protected void data_open(File file) throws Exception {
        this.pdfPane.getSpinnerImageView().setVisible(true);
        stage.setTitle(APP_WINDOW_TITLE);
        this.menuFileSave.setDisable(true);
        if (this.task != null) {
            this.task.cancel(false);
        }
        this.input = file;
        this.task = new BrewerTask(new BrewerCallable(this.input));
        this.document = null;
        this.pdfPane.setDocument(this.document);
        this.executor.execute(this.task);
    }

    protected void data_reopen() throws Exception {
        if (this.input != null && !this.input.isDirectory() && this.input.exists()) {
            this.data_open(this.input);
        }
    }

    protected void pdf_moveFirstPage() throws Exception {
        PDDocument document = this.pdfPane.getDocument();
        int pageIndex = 0;
        if (document != null) {
            this.pdfPane.setPage(pageIndex);
        }
        this.updatePagerButtons(document, pageIndex);
    }

    protected void pdf_movePreviousPage() throws Exception {
        PDDocument document = this.pdfPane.getDocument();
        int pageIndex = -1;
        if (document != null && (pageIndex = this.pdfPane.getPageIndex()) > 0) {
            this.pdfPane.setPage(--pageIndex);
        }
        this.updatePagerButtons(document, pageIndex);
    }

    protected void pdf_moveNextPage() throws Exception {
        PDDocument document = this.pdfPane.getDocument();
        int pageIndex = -1;
        if (document != null && (pageIndex = this.pdfPane.getPageIndex()) + 1 < document.getNumberOfPages()) {
            this.pdfPane.setPage(++pageIndex);
        }
        this.updatePagerButtons(document, pageIndex);
    }

    protected void pdf_moveLastPage() throws Exception {
        PDDocument document = this.pdfPane.getDocument();
        int pageIndex = -1;
        if (document != null) {
            pageIndex = document.getNumberOfPages() - 1;
            this.pdfPane.setPage(pageIndex);
        }
        this.updatePagerButtons(document, pageIndex);
    }

    protected void pdf_mouseEntered(MouseEvent event) throws Exception {
    }

    protected void pdf_mouseExited(MouseEvent event) throws Exception {
    }

    protected void pdf_mouseMoved(MouseEvent event) throws Exception {
    }

    protected void pdf_mouseClicked(MouseEvent event) throws Exception {
    }

    protected void pdf_scaleChanged(float scale) throws Exception {
    }

    protected void updatePagerButtons(PDDocument document, int pageIndex) {
        if (document == null || pageIndex < 0) {
            this.menuPdfFirst.setDisable(true);
            this.menuPdfPrevious.setDisable(true);
            this.menuPdfNext.setDisable(true);
            this.menuPdfLast.setDisable(true);
            this.menuPdfPageNumber.setText("");
            this.menuPdfFirst.setVisible(false);
            this.menuPdfPrevious.setVisible(false);
            this.menuPdfNext.setVisible(false);
            this.menuPdfLast.setVisible(false);
            this.menuPdfPageNumber.setVisible(false);
            return;
        }
        this.menuPdfFirst.setVisible(true);
        this.menuPdfPrevious.setVisible(true);
        this.menuPdfNext.setVisible(true);
        this.menuPdfLast.setVisible(true);
        this.menuPdfPageNumber.setVisible(true);
        if (pageIndex > 0) {
            this.menuPdfFirst.setDisable(false);
            this.menuPdfPrevious.setDisable(false);
        } else {
            this.menuPdfFirst.setDisable(true);
            this.menuPdfPrevious.setDisable(true);
        }
        if (pageIndex + 1 < document.getNumberOfPages()) {
            this.menuPdfNext.setDisable(false);
            this.menuPdfLast.setDisable(false);
        } else {
            this.menuPdfNext.setDisable(true);
            this.menuPdfLast.setDisable(true);
        }
        this.pdfPageNumberLabel.setText(pageIndex + 1 + " / " + document.getNumberOfPages());
    }

    static {
        IMAGE_APPLICATION_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/pdf-brewer-icon-16px.png"));
        IMAGE_FILE_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/file-16px.png"));
        IMAGE_SAVE_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/save-16px.png"));
        IMAGE_PAGE_FIRST_BLACK_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/page-first-black-16px.png"));
        IMAGE_PAGE_FIRST_WHITE_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/page-first-white-16px.png"));
        IMAGE_PAGE_PREVIOUS_BLACK_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/page-previous-black-16px.png"));
        IMAGE_PAGE_PREVIOUS_WHITE_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/page-previous-white-16px.png"));
        IMAGE_PAGE_NEXT_BLACK_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/page-next-black-16px.png"));
        IMAGE_PAGE_NEXT_WHITE_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/page-next-white-16px.png"));
        IMAGE_PAGE_LAST_BLACK_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/page-last-black-16px.png"));
        IMAGE_PAGE_LAST_WHITE_16PX = new Image(PdfBrewerMain.getResourceAsStream("/img/page-last-white-16px.png"));
        count = 0;
        preferences = Preferences.userNodeForPackage(PdfBrewerMain.class);
    }

    private class BrewerCallable
    implements Callable<PDDocument> {
        private File input;
        private boolean isCanceled;

        public BrewerCallable(File input) {
            this.input = input;
        }

        @Override
        public PDDocument call() throws Exception {
            try {
                BrewerData pb = new BrewerData(this.input);
                PdfBrewer brewer = new PdfBrewer();
                brewer.process(pb);
                if (this.isCanceled) {
                    return null;
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                brewer.save(output);
                if (this.isCanceled) {
                    return null;
                }
                return PDDocument.load((byte[])output.toByteArray());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private class BrewerTask
    extends FutureTask<PDDocument> {
        private BrewerCallable callable;

        public BrewerTask(BrewerCallable callable) {
            super(callable);
            this.callable = callable;
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (PdfBrewerMain.this.document != null) {
                                try {
                                    PdfBrewerMain.this.document.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                PdfBrewerMain.this.document = null;
                            }
                            PdfBrewerMain.this.document = (PDDocument)BrewerTask.this.get();
                            PdfBrewerMain.this.pdfPane.setDocument(PdfBrewerMain.this.document);
                            PdfBrewerMain.this.pdfPane.setPage(0);
                            if (PdfBrewerMain.this.document != null) {
                                stage.setTitle(BrewerTask.this.callable.input.getAbsolutePath() + " - " + APP_WINDOW_TITLE);
                                PdfBrewerMain.this.menuFileSave.setDisable(false);
                            }
                            PdfBrewerMain.this.updatePagerButtons(PdfBrewerMain.this.document, 0);
                            PdfBrewerMain.this.pdfPane.getSpinnerImageView().setVisible(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PdfBrewerMain.this.updatePagerButtons(PdfBrewerMain.this.document, 0);
                            PdfBrewerMain.this.pdfPane.getSpinnerImageView().setVisible(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.callable.isCanceled = true;
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

