/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShlObj;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;

public class FontLoader {
    private static Map<String, TrueTypeFont> fonts = new HashMap<String, TrueTypeFont>();
    private static Map<TrueTypeFont, File> files = new HashMap<TrueTypeFont, File>();

    public static List<TrueTypeFont> listFonts() {
        ArrayList<TrueTypeFont> list = new ArrayList<TrueTypeFont>(fonts.values());
        Collections.sort(list, new Comparator<TrueTypeFont>(){

            @Override
            public int compare(TrueTypeFont o1, TrueTypeFont o2) {
                try {
                    return o1.getName().compareTo(o2.getName());
                }
                catch (IOException e) {
                    return 0;
                }
            }
        });
        return list;
    }

    public static TrueTypeFont get(String name) {
        TrueTypeFont ttf = fonts.get(FontLoader.normalize(name));
        if (ttf != null) {
            return ttf;
        }
        ttf = fonts.get(FontLoader.normalize(name + "-Regular"));
        if (ttf != null) {
            return ttf;
        }
        ttf = fonts.get(FontLoader.normalize(name + "-\u6a19\u6e96"));
        if (ttf != null) {
            return ttf;
        }
        return null;
    }

    public static File getFile(TrueTypeFont ttf) throws IOException {
        return files.get(ttf);
    }

    public static File getDefaultFontsDir() {
        char[] pszPath = new char[260];
        Shell32.INSTANCE.SHGetFolderPath(null, 20, null, ShlObj.SHGFP_TYPE_CURRENT, pszPath);
        String pathname = Native.toString((char[])pszPath);
        File fontsDir = new File(pathname);
        return fontsDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(File dir) {
        File[] ttcFiles;
        File[] ttfFiles;
        TTFParser parser = new TTFParser();
        for (File file : ttfFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ttf");
            }
        })) {
            try {
                TrueTypeFont ttf = parser.parse(file);
                FontLoader.register(ttf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (final File file : ttcFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ttc");
            }
        })) {
            TrueTypeCollection ttc = null;
            try {
                ttc = new TrueTypeCollection(file);
                ttc.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

                    public void process(TrueTypeFont ttf) throws IOException {
                        FontLoader.register(ttf);
                        files.put(ttf, file);
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (ttc != null) {
                    try {
                        ttc.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void register(TrueTypeFont ttf) throws IOException {
        FontLoader.register(null, ttf);
    }

    public static void register(String name, TrueTypeFont ttf) throws IOException {
        if (name != null) {
            fonts.put(FontLoader.normalize(name), ttf);
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        String fontName = ttf.getName();
        names.add(FontLoader.normalize(fontName));
        NamingTable table = ttf.getNaming();
        String fontFamily = table.getFontFamily();
        String fontSubFamily = table.getFontSubFamily();
        names.add(FontLoader.normalize(fontFamily + "-" + fontSubFamily));
        String postScriptName = table.getPostScriptName();
        names.add(FontLoader.normalize(postScriptName));
        HashSet<Integer> languages = new HashSet<Integer>();
        HashMap<Integer, String> fontFamilies1 = new HashMap<Integer, String>();
        HashMap<Integer, String> fontSubFamilies2 = new HashMap<Integer, String>();
        HashMap<Integer, String> fontFamilies16 = new HashMap<Integer, String>();
        HashMap<Integer, String> fontSubFamilies17 = new HashMap<Integer, String>();
        List records = table.getNameRecords();
        for (NameRecord record : records) {
            if (record.getNameId() == 1) {
                languages.add(record.getLanguageId());
                fontFamilies1.put(record.getLanguageId(), record.getString());
                continue;
            }
            if (record.getNameId() == 2) {
                languages.add(record.getLanguageId());
                fontSubFamilies2.put(record.getLanguageId(), record.getString());
                continue;
            }
            if (record.getNameId() == 16) {
                languages.add(record.getLanguageId());
                fontFamilies16.put(record.getLanguageId(), record.getString());
                continue;
            }
            if (record.getNameId() != 17) continue;
            languages.add(record.getLanguageId());
            fontSubFamilies17.put(record.getLanguageId(), record.getString());
        }
        for (Integer languageId : languages) {
            fontFamily = (String)fontFamilies1.get(languageId);
            if (fontFamily != null) {
                fontSubFamily = (String)fontSubFamilies2.get(languageId);
                if (fontSubFamily != null) {
                    names.add(FontLoader.normalize(fontFamily + "-" + fontSubFamily));
                } else {
                    names.add(FontLoader.normalize(fontFamily));
                }
            }
            if ((fontFamily = (String)fontFamilies16.get(languageId)) == null) continue;
            fontSubFamily = (String)fontSubFamilies17.get(languageId);
            if (fontSubFamily != null) {
                names.add(FontLoader.normalize(fontFamily + "-" + fontSubFamily));
                continue;
            }
            names.add(FontLoader.normalize(fontFamily));
        }
        for (String s : names) {
            fonts.put(s, ttf);
        }
    }

    private static String normalize(String name) {
        String s = name.replace('\t', '-').replace('\u3000', '-').replace(' ', '-').toLowerCase();
        while (s.contains("--")) {
            s = s.replace("--", "-");
        }
        s = Normalizer.normalize(s, Normalizer.Form.NFKC);
        Object[] tokens = s.split("-");
        Arrays.sort(tokens);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            sb.append((String)tokens[i]);
            if (i + 1 >= tokens.length) continue;
            sb.append('-');
        }
        return sb.toString();
    }

    static {
        FontLoader.load(FontLoader.getDefaultFontsDir());
        TrueTypeFont serif = FontLoader.get("YuMincho-Regular");
        TrueTypeFont serifBold = FontLoader.get("YuMincho-Demibold");
        TrueTypeFont sansSerif = FontLoader.get("YuGothic-Regular");
        TrueTypeFont sansSerifBold = FontLoader.get("YuGothic-Bold");
        if (serif != null && serifBold != null && sansSerif != null && sansSerifBold != null) {
            try {
                FontLoader.register("serif", serif);
                FontLoader.register("serif-Bold", serifBold);
                FontLoader.register("sansSerif", sansSerif);
                FontLoader.register("sansSerif-Bold", sansSerifBold);
                FontLoader.register("sans-Serif", sansSerif);
                FontLoader.register("sans-Serif-Bold", sansSerifBold);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

