/**/

#include <anthy/anthy.h>
#include <ruby.h>

static int init_res;

static VALUE eAnthy;
static VALUE mAnthy;
static VALUE cContext;

static void ac_release(struct anthy_context *ac)
{
  anthy_release_context(ac);
}

static VALUE ac_new(VALUE class)
{
  struct anthy_context *ac;
  ac = anthy_create_context();
  if (!ac) {
    rb_raise(eAnthy,"failed to create context");
  }
  return Data_Wrap_Struct(class,0,ac_release, ac);
}

static VALUE ac_set_string(VALUE obj, VALUE str)
{
  char *cstr = STR2CSTR(str);
  struct anthy_context *ac;
  Data_Get_Struct(obj,struct anthy_context, ac);
  anthy_set_string(ac, cstr);
  return Qnil;
}

static VALUE ac_print_context(VALUE obj)
{
  struct anthy_context *ac;
  Data_Get_Struct(obj,struct anthy_context, ac);
  anthy_print_context(ac);
  return Qnil;
}

static VALUE ac_seg_count(VALUE obj)
{
  struct anthy_context *ac;
  struct anthy_conv_stat acs;
  Data_Get_Struct(obj,struct anthy_context, ac);
  anthy_get_stat(ac, &acs);
  return INT2FIX(acs.nr_segment);
}

static VALUE ac_cand_count(VALUE obj, VALUE n)
{
  struct anthy_context *ac;
  int nth = NUM2INT(n);
  struct anthy_segment_stat ass;
  Data_Get_Struct(obj,struct anthy_context, ac);
  anthy_get_segment_stat(ac, nth, &ass);
  return INT2FIX(ass.nr_candidate);
}

static VALUE ac_get_cand(VALUE obj, VALUE s, VALUE c)
{
  struct anthy_context *ac;
  int seg, cand, len;
  char *str;
  seg = NUM2INT(s);
  cand = NUM2INT(c);
  Data_Get_Struct(obj,struct anthy_context, ac);
  len = anthy_get_segment(ac, seg, cand, NULL, 0);
  str = alloca(len + 1);
  len = anthy_get_segment(ac, seg, cand, str, len + 1);
  if (len) {
    return rb_str_new2(str);
  }
  return Qnil;
}

static VALUE ac_seg_len(VALUE obj, VALUE n)
{
  struct anthy_context *ac;
  struct anthy_segment_stat ass;
  int nth = NUM2INT(n);
  Data_Get_Struct(obj,struct anthy_context, ac);
  anthy_get_segment_stat(ac, nth, &ass);
  return INT2FIX(ass.seg_len);
}

void Init_anthy()
{
  init_res = anthy_init();
  mAnthy = rb_define_module("Anthy");
  eAnthy = rb_define_class_under(mAnthy,"Error",rb_eStandardError);
  cContext = rb_define_class_under(mAnthy, "Context", rb_cObject);
  rb_define_singleton_method(cContext, "new", ac_new, 0);
  rb_define_method(cContext,"setString", ac_set_string, 1);
  rb_define_method(cContext,"print", ac_print_context, 0);
  rb_define_method(cContext,"segCount", ac_seg_count, 0);
  rb_define_method(cContext,"candCount", ac_cand_count, 1);
  rb_define_method(cContext,"getCandidate", ac_get_cand, 2);
  rb_define_method(cContext,"segLen", ac_seg_len, 1);
}
