#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#include "context.h"

static FILE *primer = NULL, *primew = NULL;
static int prime_running;
static int prime_pid = 0;
static int prime_active;

static char buf[8192];

extern LISP sym_t;

static char *prime_command = "prime";


/**/
pid_t open_pipe_rw(FILE ** fr, FILE ** fw);
void  myExec(char *command);
void  close_tty(void);

void
init_prime()
{
    prime_active = prime_running;
    if (primer != NULL)
	fclose(primer);
    if (primew != NULL)
	fclose(primew);
    primer = primew = NULL;
    if (prime_pid)
	kill(prime_pid, SIGKILL);
    prime_pid = 0;
}

static int
open_prime(char *prime_command)
{
    prime_pid = open_pipe_rw(&primer, &primew);
    if (prime_pid < 0)
	goto err0;
    if (prime_pid == 0) {
	/* child */
	myExec(prime_command);
    }
    return 1;
  err0:
    prime_pid = 0;
    prime_active = prime_running = 0;
    return 0;
}

static char *
prime_send_command_internal(char *str)
{
  char *tmp = strdup("");
 
  if (primer == NULL || primew == NULL)
    if (open_prime(prime_command) == 0) {
      free(tmp);
      return NULL;
    }

  fprintf( primew, str );

 again:
  if (fflush(primew) != 0) {
    switch (errno) {
    case EINTR:
      goto again;
    default:
      goto err;
    }
  }

  while (fgets (buf, sizeof(buf), primer ) != NULL ) {
    if(strcmp( buf, "\n" ) == 0)
      break;

    tmp = realloc(tmp, strlen(tmp) + strlen(buf) + 1);
    strcat(tmp, buf);
  }
 
  if (strlen(tmp) == 0)
    goto err;

  return tmp;

 err:
  /* XXX: backend prime is not working? */
  free(tmp);
  init_prime();
  prime_active = prime_running = 0;
  return NULL;
  
}


static LISP
prime_send_command(LISP str_)
{
  char *str = get_c_string( str_ );
  char *result;

  result = prime_send_command_internal( str );

  if(result == NULL)
    {
      return NIL;
    }

  return strcons( strlen(result), result );
}

static LISP
init_prime_lib()
{
  int i;
  init_prime();
  open_prime("prime");
  return sym_t;
}


static char **
uim_strsplit(char *splittee, char *splitter)
{
  char *cur, *tmp;
  int nr_token = 0;
  int in_token = 0;
  char **res;
  int len;
  int i;

  if(!splittee || !splitter)
    return NULL;


  /* count the number of token */
  cur = splittee;
  while (*cur) {
    if (strchr(splitter, *cur)) {
      in_token = 0;
    } else {
      if (!in_token) {
	nr_token ++;
      }
      in_token = 1;
    }
    cur ++;
  }
  /* allocate buffer */
  res = (char **)malloc(sizeof(char *) * (nr_token + 1) );
  if (!res) {
    return NULL;
  }
  /**/
  cur = splittee;
  for (i = 0; i < nr_token; i++) {
    /* find current token's start */
    while (strchr(splitter, *cur)) {
      cur ++;
    }
    /* calc length */
    len = 0;
    tmp = cur;
    while (!strchr(splitter, *tmp)) {
      len ++;
      tmp ++;
    }
    /* store */
    res[i] = malloc(sizeof(char *) * (len + 1));
    strncpy(res[i], cur, len);
    res[i][len] = 0;
    cur = tmp;
  }
  /**/
  res[nr_token] = NULL;

  return res;
}

static LISP
prime_split_string(LISP _splittee, LISP _splitter)
{
  char *splittee = get_c_string(_splittee);
  char *splitter = get_c_string(_splitter);
  char **strs;
  LISP l = NIL;
  int i;
  int j;

  if(_splittee == NULL || _splitter == NULL)
    return NIL;

  if(splittee == NULL || splitter == NULL)
    return NIL;

   strs = uim_strsplit(splittee, splitter);

   if(!strs || !*strs)
     return NIL;

   for(j = 0;strs[j] != '\0' ; j++){}

   j--;
   
   for(i = j; i >= 0 ; i--)
     {
       l = cons ( strcons( strlen(strs[i]), strs[i] ), l );
     }
   free(strs);
   return l;
}

pid_t
open_pipe_rw(FILE ** fr, FILE ** fw)
{
    int fdr[2];
    int fdw[2];
    pid_t pid;

    if (fr && pipe(fdr) < 0)
	goto err0;
    if (fw && pipe(fdw) < 0)
	goto err1;

    pid = fork();
    if (pid < 0)
	goto err2;
    if (pid == 0) {
	/* child */
	if (fr) {
	    close(fdr[0]);
	    dup2(fdr[1], 1);
	}
	if (fw) {
	    close(fdw[1]);
	    dup2(fdw[0], 0);
	}
    }
    else {
	if (fr) {
	    close(fdr[1]);
	    if (*fr == stdin)
		dup2(fdr[0], 0);
	    else
		*fr = fdopen(fdr[0], "r");
	}
	if (fw) {
	    close(fdw[0]);
	    if (*fw == stdout)
		dup2(fdw[1], 1);
	    else
		*fw = fdopen(fdw[1], "w");
	}
    }
    return pid;
  err2:
    if (fw) {
	close(fdw[0]);
	close(fdw[1]);
    }
  err1:
    if (fr) {
	close(fdr[0]);
	close(fdr[1]);
    }
  err0:
    return (pid_t) - 1;
}

void
myExec(char *command)
{
    execl("/bin/sh", "sh", "-c", command, NULL);
    exit(127);
}

void
uim_init_prime()
{
  init_subr_0("prime-lib-init", init_prime_lib);
  init_subr_1("prime-lib-send-command", prime_send_command);
  init_subr_2("prime-string-split", prime_split_string);
}
