#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/stat.h>

#define MAX_CLIENT 32
#define BUFFER_SIZE 1024

static int context_id = 0;
static int clientfd[MAX_CLIENT];
static int nclients = 0;
static int focused_context_id;

/*
  prepare file descriptor.
  1.create socket
  2.bind socket & file descriptor
  3.listen file descriptor
*/
int init_serv_fd(char *path)
{
    int foo;
    int fd;
    struct sockaddr_un myhost;

    fd = socket(PF_UNIX, SOCK_STREAM, 0);
    if (fd < 0) {
	perror("failed in socket()");
	return -1;
    }

    myhost.sun_family = PF_UNIX;
    strcpy(myhost.sun_path, path);

    foo = bind(fd,(struct sockaddr *)&myhost,sizeof(myhost.sun_family) + strlen(path));
    if(foo < -1){
	perror("failed in bind()");
	return -1;
    }

    chmod(path, S_IRUSR|S_IWUSR);

    /*Most case, 5 is used instead of SOMAXCONN*/
    foo = listen(fd, SOMAXCONN);
    if ( foo == -1){
	perror("failed in listen()");
	return -1;
    }
    printf("listen at %s\n",path);
    return fd;
}


int uim_helper_server_new_context_id(void)
{
  context_id++;
  return context_id;
}

int proc_func(int fd)
{
  int i,rc;
  char buf[BUFFER_SIZE];

  char *content = NULL;
  FILE *rfile, *wfile;


  /*  rfile = fdopen(fd, "r");
      wfile = fdopen(fd, "w");*/


  /* use both fd and rfile is safe? I'm not sure...*/
  while((i = uim_helpler_fd_readable(fd)) > 0){
    //    fgets(buf, BUFFER_SIZE, rfile );
    printf("fd readable %d\n",fd);
    rc = read(fd,buf, sizeof(buf)-1);
    
    if(rc == 0)
      return -1;

    buf[rc] = '\0';
    
    if(!content)
      content = (char*)malloc(strlen(buf)+1); 
    else
      content = (char*)realloc(content, strlen(content) + strlen(buf)+1);
    /*strlen not include last '\0'*/

    strcat(content, buf);
  }
  
  printf("recieve:%s\n", content);

  if( content ) {
    parse_content(content, fd);
  }
  free(content);

  return 1;
}

static parse_content(char *content, int fd)
{
  char buf[BUFFER_SIZE];
  int i;
  if( strncmp(content,"new_context", 11) == 0 ) {
    
    printf("new context creating\n");
    i = snprintf(buf,BUFFER_SIZE,"new_context:%d\n",
		 uim_helper_server_new_context_id());
    printf("new context created %s\n",buf);
  }
  else {
    for (i = 0; i < nclients; i ++){
      if(clientfd[i] != fd && 
	 uim_helpler_fd_writable(clientfd[i]))
	write(clientfd[i],content,strlen(content));
    }
  strcpy(buf,"OK\n");
  }
  write(fd, buf, strlen(buf));

}

uim_helper_server_process_connection(int serv_fd, int (*proc_func)(int fd) )
{
  int i;
  int fd_biggest = 0;
  fd_set readfds;

  fd_biggest = serv_fd;

  while(1) {
    
    FD_ZERO(&readfds);
    
    FD_SET(serv_fd, &readfds);  
    for (i = 0; i < nclients; i ++) {
      FD_SET(clientfd[i], &readfds);
    }
    
    if ( select(fd_biggest+1, &readfds, NULL, NULL, NULL) < 0 ) {
      perror("select faild");
    }
    
    /* for accept new connection */
    if (FD_ISSET(serv_fd, &readfds)) {
      struct sockaddr_un clientsoc;
      socklen_t len = sizeof(clientsoc);
      int new_fd;
      FILE *file;
      new_fd = accept(serv_fd, (struct sockaddr *)&clientsoc, &len);

      /*Insert error handleng when nclients > MAX_CLIENT !!!*/

      if(new_fd < 0) {
	perror("accpet failed");
	continue;
      }
      if(fd_biggest < new_fd )
	fd_biggest = new_fd;

      file = fdopen(new_fd,"w");

      fputs("OK\n", file);
	
      clientfd[nclients] = new_fd;
      nclients++;
      printf("accept new fd:%d\n",new_fd);
    }    
    
    /* check data from clients are reached */
    for (i = 0; i < nclients; i ++){
      if (FD_ISSET(clientfd[i], &readfds)) {
	int result;
	/* actual process */
	result = (*proc_func)(clientfd[i]);

	if(result < 0) {
	  close( clientfd[i] );
	  clientfd[i] = clientfd[nclients-1];
	  nclients--;
	}
      }
    }

  }
  
}
int
main(int argc, char **argv)
{
  char *path = uim_helper_get_pathname();
  int serv_fd;
  unlink(path);
  serv_fd = init_serv_fd(path);

  if (serv_fd < 0) {
    //    printf("Failed to init unix domain socket\n");
    return 0;
  }
  printf("Waiting for connection at %s\n", path);

  free(path);

  uim_helper_server_process_connection(serv_fd, proc_func);

  return 0;
}


