/* API and ABI is unstable */
#ifndef _uim_h_included_
#define _uim_h_included_

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct uim_context_ *uim_context;

  /* This will be filled later, so ABI is unstable */
  enum UKey {
    UKey_0 = 48,
    UKey_1 = 49,
    UKey_2 = 50,
    UKey_3 = 51,
    UKey_4 = 52,
    UKey_5 = 53,
    UKey_6 = 54,
    UKey_7 = 55,
    UKey_8 = 56,
    UKey_9 = 57,
    UKey_Escape = 256,
    UKey_Tab,
    UKey_Backspace,
    UKey_Delete,
    UKey_Return,
    UKey_Left,
    UKey_Up ,
    UKey_Right ,
    UKey_Down ,
    UKey_Prior , /* page up */
    UKey_Next , /* page down */
    UKey_Home,
    UKey_End,
    UKey_Zenkaku_Hankaku,
    UKey_F1,
    UKey_F2,
    UKey_F3,
    UKey_F4,
    UKey_F5,
    UKey_F6,
    UKey_F7,
    UKey_F8,
    UKey_F9,
    UKey_F10,
    UKey_F11,
    UKey_F12,
    UKey_Other = 1000
  };
  
  enum UKeyModifier {
    UKey_Shift = 1,
    UKey_Control = 2,
    UKey_Alt = 4,
    UKey_Meta = 8,
    UKey_Pseudo0 = 16,
    UKey_Pseudo1 = 32,
  };
  
  enum UPreeditAttr {
    UPeAttr_None = 0,
    UPeAttr_UnderLine = 1,
    UPeAttr_Reverse = 2,
    UPeAttr_Cursor = 4,
};
  
int uim_init();
  uim_context
  uim_create_context(void *ptr,
		     char *enc,
		     char *lang,
		     char *engine,
		     void (*commit_cb)(void *ptr, char *str));
  void
  uim_set_preedit_cb(uim_context uc,
		     void (*clear_cb)(void *ptr),
		     void (*pushback_cb)(void *ptr,
					 int attr,
					 char *str),
		     /* page change cb .. etc will be here */
		     void (*update_cb)(void *ptr));
  void
  uim_release_context(uim_context uc);
  void
  uim_reset_context(uim_context uc);
  /* im list */
  int uim_get_nr_im(uim_context uc);
  /* you should free the result */
  char *uim_get_im_name(uim_context uc, int nth);
  /* you should free the result */
  char *uim_get_im_language(uim_context uc, int nth);
  /* 32 <= key <= 127 */
  int
  uim_press_key(uim_context uc, int key, int state);
  int
  uim_release_key(uim_context uc, int key, int state);
  
  /* mode list */
  int
  uim_get_nr_modes(uim_context uc);
  /* you should free the result */
  char *
  uim_get_mode_name(uim_context uc, int nth);
  void
  uim_set_mode_list_update_cb(uim_context uc,
			      void (*update_cb)(void *ptr));
  
  /* mode */
  int
  uim_get_current_mode(uim_context uc);
  void
  uim_set_mode(uim_context uc, int nth);
  void
  uim_set_mode_cb(uim_context uc, void (*update_cb)(void *ptr,
						    int mode));
  
  int uim_set_candidate_cb(uim_context uc,
			   void (*begin_cb)(void *ptr, int nr, int index),
			   void (*update_cb)(void *ptr, int index),
			   void (*end_cb)(void *ptr));
  /* You should free() the result */
  char *uim_get_candidate(uim_context uc, int index);
  int uim_get_candidate_index(uim_context uc);
  void uim_set_candidate_index(uim_context uc, int index);

#ifdef __cplusplus
}
#endif
#endif
