/**/
#include <canna/jrkanji.h>
#include <stdlib.h>
#include <dlfcn.h>
#include "context.h"

#define MAX_SIZE 256

extern LISP sym_t;

static struct canna_context {
  int used;
  char workbuf[MAX_SIZE];
  jrKanjiStatus ks;
} *context_array;
static int context_array_len;

static struct canna_api {
/*  struct rkfuncs Rk; */
  int (*KanjiControl)(const int, const int, char *);
  int (*KanjiString)(const int, const int, wchar_t *, const int,
                          jrKanjiStatus *);
} api;

static int
get_canna_api()
{
  void *lib;

  lib = dlopen("libcanna.so.1", RTLD_NOW);
  if(!lib) {
    return -1;
  }
  api.KanjiControl = dlsym(lib, "jrKanjiControl");
  api.KanjiString = dlsym(lib, "jrKanjiString");
  if(api.KanjiControl && api.KanjiString) {
    return 0;
  } else {
    return -1;
  }
}

static LISP
init_canna_lib()
{
  if(get_canna_api() == -1) {
    return NIL;
  }
  return sym_t;
}

static int
find_id()
{
  int i;
  for (i = 0; i < context_array_len; i++) {
    if (!context_array[i].used) {
      context_array[i].used = 1;
      return i;
    }
  }
  context_array = realloc(context_array,
			  sizeof(struct canna_context) * i);
  context_array[i].used = 1;
  return i;
}

static LISP
alloc_id()
{
  int id = find_id();
  jrKanjiStatusWithValue ksv;
/*  jrKanjiControl(id, KC_INITIALIZE, 0); */
  api.KanjiControl(id, KC_INITIALIZE, 0);

  ksv.ks = &context_array[id].ks;
  ksv.buffer = context_array[id].workbuf;
  ksv.bytes_buffer = MAX_SIZE;
  ksv.val = CANNA_MODE_HenkanMode;
/*  jrKanjiControl(id, KC_CHANGEMODE, &ksv); */
  api.KanjiControl(id, KC_CHANGEMODE, &ksv);
  return flocons(id);
}

static LISP
release_id(LISP id_)
{
  int id = get_c_long(id_);
/*  jrKanjiControl(id, KC_FINALIZE, 0); */
  api.KanjiControl(id, KC_FINALIZE, 0);
  context_array[id].used = 0;
  return NIL;
}

static LISP
push_key(LISP id_, LISP key_)
{
  int id = get_c_long(id_);
  int kc = 0;
  int res;
  if (FLONUMP(key_)) {
    int key = get_c_long(key_);
    kc = key;
  } else {
    int k = uim_key_sym_to_int(key_);
    if (k == UKey_Return) {
      kc = '\n';
    }
  }
  if (!kc) {
    return NIL;
  }
/* res = jrKanjiString(id, kc,
		      context_array[id].workbuf, MAX_SIZE,
		      &context_array[id].ks); */
  res = api.KanjiString(id, kc,
			context_array[id].workbuf, MAX_SIZE,
			&context_array[id].ks);
  if (res > 0) {
    context_array[id].workbuf[res] = 0;
    printf("*%s*\n",context_array[id].workbuf);
  }
  return NIL;
}

static LISP
get_preedit(LISP id_)
{
  return NIL;
}


void
uim_init_canna()
{
  init_subr_0("canna-lib-init", init_canna_lib);

  init_subr_0("canna-lib-alloc-id", alloc_id);
  init_subr_1("canna-lib-release-id", release_id);
  init_subr_2("canna-lib-push-key", push_key);
  init_subr_1("canna-lib-get-preedit", get_preedit);
}
