/*
 * Word Dictionary
 * եμΥ󥿡ե¸ߤǡ
 * å夵ΤǤǤ¸ߤʤñ
 * ®ˤɬפ롣
 *
 * anthy_word_dic_fill_seq_ent_by_xstr()濴ȤʤؿǤ
 *  ꤷword_dicꤷʸ򥤥ǥåȤƤĥȥ
 *  ղäseq_entɲä
 *
 * a)ηb)񥢥ι®c)եΥ󥳡ǥ
 *  ΥǰäƤΤǤʤʣƤޤ
 *
 * Copyright (C) 2000-2006 TABATA Yusuke
 * Copyright (C) 2005-2006 YOSHIDA Yuichi
 * Copyright (C) 2001-2002 TAKAI Kosuke
 *
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "config.h"
#include <anthy/anthy.h>
#include <anthy/alloc.h>
#include <anthy/dic.h>
#include <anthy/word_dic.h>
#include <anthy/logger.h>
#include <anthy/xstr.h>
#include <anthy/diclib.h>

#include "dic_main.h"
#include "dic_ent.h"

static allocator word_dic_ator;

/* 1Хܤ򸫤ơʸХȤ뤫֤ */
static int
mb_fragment_len(const char *str)
{
  unsigned char c = *((const unsigned char *)str);
  if (c < 0x80) {
    return 1;
  }
  if (c < 0xe0) {
    return 2;
  }
  if (c < 0xf0) {
    return 3;
  }
  if (c < 0xf8) {
    return 4;
  }
  if (c < 0xfc) {
    return 5;
  }
  return 6;
}

static int
is_printable(char *str)
{
  unsigned char *tmp = (unsigned char *)str;
  if (*tmp > 31 && *tmp < 127) {
    return 1;
  }
  if (mb_fragment_len(str) > 1) {
    return 1;
  }
  return 0;
}

/* Υ󥳡ǥ󥰤xchar */
static xchar
form_mb_char(const char *str)
{
  xchar xc;
  anthy_utf8_to_ucs4_xchar(str, &xc);
  return xc;
}

static int
hash(xstr *x)
{
  return anthy_xstr_hash(x)&
    (YOMI_HASH_ARRAY_SIZE*YOMI_HASH_ARRAY_BITS-1);
}

static int
check_hash_ent(struct word_dic *wdic, xstr *xs)
{
  int val = hash(xs);
  int idx = (val>>YOMI_HASH_ARRAY_SHIFT)&(YOMI_HASH_ARRAY_SIZE-1);
  int bit = val & ((1<<YOMI_HASH_ARRAY_SHIFT)-1);
  return wdic->hash_ent[idx] & (1<<bit);
}

static int
wtype_str_len(const char *str)
{
  int i;
  for (i = 0; str[i] && str[i]!= ' '; i++);
  return i;
}

/* ι򥹥󤹤뤿ξݻ */
struct wt_stat {
  wtype_t wt;
  const char *wt_name;
  int feature;
  int freq;
  int order_bonus;/* νˤ٤Υܡʥ */
  int offset;/* ʸΥեå */
  const char *line;
  int encoding;
};
/*
 * #XX*123 ȤCannadicηѡ
 *  #XX
 *  #XX*123
 *  #XX,x*123
 */
static const char *
parse_wtype_str(struct wt_stat *ws)
{
  int len;
  char *buf;
  char *freq_part;
  char *feature_part;
  const char *wt_name;
  /* Хåեإԡ */
  len = wtype_str_len(&ws->line[ws->offset]);
  buf = alloca(len + 1);
  strncpy(buf, &ws->line[ws->offset], len);
  buf[len] = 0;

  /**/
  feature_part = strchr(buf, ',');
  if (feature_part) {
    ws->feature = 1;
  } else {
    ws->feature = 0;
  }

  /* ٤parse */
  freq_part = strchr(buf, '*');
  if (freq_part) {
    *freq_part = 0;
    freq_part ++;
    ws->freq = atoi(freq_part) * FREQ_RATIO;
  } else {
    ws->freq = FREQ_RATIO - 2;
  }

  wt_name = anthy_type_to_wtype(buf, &ws->wt);
  if (!wt_name) {
    ws->wt = anthy_wt_none;
  }
  ws->offset += len;
  return wt_name;
}


static int
normalize_freq(struct wt_stat* ws)
{
  if (ws->freq < 0) {
    ws->freq *= -1;
  }
  return ws->freq + ws->order_bonus;
}

/* '\\'ˤ륨פбԡ */
static void
copy_to_buf(char *buf, const char *src, int char_count)
{
  int pos;
  int i;
  pos = 0;
  for (i = 0; i < char_count; i++){
    if (src[i] == '\\') {
      if (src[i + 1] == ' ') {
	i ++;
      } else if (src[i + 1] == '\\') {
	i ++;
      }
    }
    buf[pos] = src[i];
    pos ++;
  }
  buf[pos] = 0;
}

/** seq_entdic_entɲä */
static int
add_dic_ent(struct seq_ent *seq, struct wt_stat *ws,
	    xstr* yomi, int is_reverse)
{
  int i;
  /* եΥХȿ */
  int char_count;
  char *buf;
  xstr *xs;
  int freq;
  wtype_t w = ws->wt;
  const char *s = &ws->line[ws->offset];

  /* ñʸ׻ */
  for (i = 0, char_count = 0;
       s[i] && (s[i] != ' ') && (s[i] != '#'); i++) {
    char_count ++;
    if (s[i] == '\\') {
      char_count++;
      i++;
    }
  }

  /* ʻ줬ƤʤΤ̵ */
  if (!ws->wt_name) {
    return char_count;
  }

  /* freqʤΤϵѴ */
  if (!is_reverse && ws->freq < 0) {
    return char_count;
  }

  /* bufñ򥳥ԡ */
  buf = alloca(char_count+1);
  copy_to_buf(buf, s, char_count);

  xs = anthy_cstr_to_xstr(buf, ws->encoding);

  /* freqʤΤϽѴ */
  if (is_reverse && ws->freq > 0) {
    /* ѴκݤˡѴѤߤʬ̤ѴʬäƤб٤ˡ
       ʿ̾ΤߤʤʬϽ缭ˤɤߤñ줬dic_ent롣
    */
    if (anthy_get_xstr_type(yomi) & XCT_HIRA) {
      freq = normalize_freq(ws);
      anthy_mem_dic_push_back_dic_ent(seq, 0, yomi, w,
				      ws->wt_name, freq, 0);
    }      
    anthy_free_xstr(xs);
    return char_count;
  }

  freq = normalize_freq(ws);

  anthy_mem_dic_push_back_dic_ent(seq, 0, xs, w, ws->wt_name, freq, 0);
  if (anthy_wtype_get_meisi(w)) {
    /* Ϣѷ̾첽Ĥ̾첽Τɲ */
    w = anthy_get_wtype_with_ct(w, CT_MEISIKA);
    anthy_mem_dic_push_back_dic_ent(seq, 0, xs, w, ws->wt_name, freq, 0);
  }
  anthy_free_xstr(xs);
  return char_count;
}

static int
add_compound_ent(struct seq_ent *seq, struct wt_stat *ws,
		 xstr* yomi,
		 int is_reverse)
{
  int len = wtype_str_len(&ws->line[ws->offset]);
  char *buf = alloca(len);
  xstr *xs;
  int freq;

  (void)yomi;

  /* freqʤΤϵѴ */
  if (!is_reverse && ws->freq < 0) {
    /* ʤѴǤפʤ */
    return len;
  }

  /* freqʤΤϽѴ */
  if (is_reverse && ws->freq > 0) {

    /* ѴκݤˡѴѤߤʬ̤ѴʬäƤб٤ˡ
       ʿ̾ΤߤʤʬϽ缭ˤɤߤñ줬dic_ent롣
    */
    /*
      yomi#_ղäʸɬפ
    if (anthy_get_xstr_type(yomi) & (XCT_HIRA | XCT_KATA)) {
      freq = normalize_freq(ws);
      anthy_mem_dic_push_back_compound_ent(seq, xs, ws->wt, freq);
    }
    */
    return len;
  }

  strncpy(buf, &ws->line[ws->offset + 1], len - 1);
  buf[len - 1] = 0;
  xs = anthy_cstr_to_xstr(buf, ws->encoding);

  freq = normalize_freq(ws);
  anthy_mem_dic_push_back_dic_ent(seq, 1, xs, ws->wt,
				  ws->wt_name, freq, 0);
  anthy_free_xstr(xs);

  return len;
}

static void
init_wt_stat(struct wt_stat *ws, char *line)
{
  ws->wt_name = NULL;
  ws->freq = 0;
  ws->feature = 0;
  ws->order_bonus = 0;
  ws->offset = 0;
  ws->line = line;
  ws->encoding = ANTHY_EUC_JP_ENCODING;
  if (*(ws->line) == 'u') {
    ws->encoding = ANTHY_UTF8_ENCODING;
    ws->line ++;
  }
}

/** Υȥξ򸵤seq_ent򤦤 */
static void
fill_dic_ent(char *line, struct seq_ent *seq, 
	     xstr* yomi, int is_reverse)
{
  struct wt_stat ws;
  init_wt_stat(&ws, line);

  while (ws.line[ws.offset]) {
    if (ws.line[ws.offset] == '#') {
      if (isalpha(ws.line[ws.offset + 1])) {
	/* ʻ* */
	ws.wt_name = parse_wtype_str(&ws);
	/**/
	ws.order_bonus = FREQ_RATIO - 1;
      } else {
	/* ʣ */
	ws.offset += add_compound_ent(seq, &ws,
				      yomi,
				      is_reverse);
      }
    } else {
      /* ñ */
      ws.offset += add_dic_ent(seq, &ws, yomi,
			       is_reverse);
      if (ws.order_bonus > 0) {
	ws.order_bonus --;
      }
    }
    if (ws.line[ws.offset] == ' ') {
      ws.offset++;
    }
  }
}

/*
 * s˽񤫤줿ʸˤäxѹ
 * ֤ͤɤ߿ʤ᤿Хȿ
 */
static int
mkxstr(char *s, xstr *x)
{
  int i, len;
  /* s[0]ˤϴᤷʸ */
  x->len -= (s[0] - 1);
  for (i = 1; is_printable(&s[i]); i ++) {
    len = mb_fragment_len(&s[i]);
    if (len > 1) {
      /* ޥХ */
      x->str[x->len] = form_mb_char(&s[i]);
      x->len ++;
      i += (len - 1);
    } else {
      /* 1Хʸ */
      x->str[x->len] = s[i];
      x->len ++;
    }
  } 
  return i;
}

/** ڡñξĴ٤ */
static int
search_word_in_page(xstr *x, char *s)
{
  int o = 0;
  xchar *buf;
  xstr xs;
  /* ΥڡˤäȤĹñǼĹ */
  buf = alloca(sizeof(xchar)*strlen(s)/2);
  xs.str = buf;
  xs.len = 0;

  while (*s) {
    s += mkxstr(s, &xs);
    if (!anthy_xstrcmp(&xs, x)) {
      return o;
    }
    o ++;
  }
  return -1;
}

/**/
static int
compare_page_index(struct word_dic *wdic, const char *key, int page)
{
  char buf[100];
  char *s = &wdic->page[anthy_dic_ntohl(wdic->page_index[page])];
  int i;
  s++;
  for (i = 0; is_printable(&s[i]);) {
    int j, l = mb_fragment_len(&s[i]);
    for (j = 0; j < l; j++) {
      buf[i+j] = s[i+j];
    }
    i += l;
  }
  buf[i] = 0;
  return strcmp(key ,buf);
}

/* Хʥꥵ򤹤 */
static int
get_page_index_search(struct word_dic *wdic, const char *key, int f, int t)
{
  /* anthy_xstrcmp-1̵ʤäȤõ */
  int c,p;
  c = (f+t)/2;
  if (f+1==t) {
    return c;
  } else {
    p = compare_page_index(wdic, key, c);
    if (p < 0) {
      return get_page_index_search(wdic, key, f, c);
    } else {
      /* c<= <t */
      return get_page_index_search(wdic, key, c, t);
    }
  } 
}

/** keyޤǽΤڡֹ롢
 * ϰϥå򤷤ƥХʥꥵԤget_page_index_searchƤ
 */
static int
get_page_index(struct word_dic *wdic, const char *key)
{
  int page;
  /* ǽΥڡɤߤ⾮ */
  if (compare_page_index(wdic, key, 0) < 0) {
    return -1;
  }
  /* ǸΥڡɤߤ礭ΤǡǸΥڡ˴ޤޤǽ */
  if (compare_page_index(wdic, key, wdic->nr_pages-1) >= 0) {
    return wdic->nr_pages-1;
  }
  /* Хʥꥵ */
  page = get_page_index_search(wdic, key, 0, wdic->nr_pages);
  return page;
}

static int
get_nr_page(struct word_dic *h)
{
  int i;
  for (i = 1; anthy_dic_ntohl(h->page_index[i]); i++);
  return i;
}

static char *
get_section(struct word_dic *wdic, int section)
{
  int *p = (int *)wdic->dic_file;
  int offset = anthy_dic_ntohl(p[section]);
  return &wdic->dic_file[offset];
}

/** եmmapơword_dicγƥΥݥ󥿤 */
static int
get_word_dic_sections(struct word_dic *wdic)
{
  wdic->entry_index = (int *)get_section(wdic, 2);
  wdic->entry = (char *)get_section(wdic, 3);
  wdic->page = (char *)get_section(wdic, 4);
  wdic->page_index = (int *)get_section(wdic, 5);
  wdic->uc_section = (char *)get_section(wdic, 6);
  wdic->hash_ent = (unsigned char *)get_section(wdic, 7);

  return 0;
}

/** ꤵ줿ñμΥǥåĴ٤ */
static int
search_yomi_index(struct word_dic *wdic, xstr *xs)
{
  int p, o;
  int page_number;
  char *key = anthy_xstr_to_cstr(xs, ANTHY_UTF8_ENCODING);

  p = get_page_index(wdic, key);
  free(key);
  if (p == -1) {
    return -1;
  }

  page_number = anthy_dic_ntohl(wdic->page_index[p]);
  o = search_word_in_page(xs, &wdic->page[page_number]);

  if (o == -1) {
    return -1;
  }
  return o + p * WORDS_PER_PAGE;
}

/** word_dicñ򸡺
 * 񥭥å夫ƤФ
 * ꤵ줿Ѥñword_dicõtailղä
 * mem_dic_push_back_dic_entѤơseq_entɲä롥
 */
void
anthy_word_dic_fill_seq_ent_by_xstr(struct word_dic *wdic, xstr *xs,
				    struct seq_ent *se,
				    int is_reverse)
{
  int yomi_index;

  if (xs->len > 31) {
    /* 32ʸʾñˤ̤б */
    return;
  }
  /* hashˤʤʤ */
  if (!check_hash_ent(wdic, xs)) {
    return;
  }
  yomi_index = search_yomi_index(wdic, xs);

  if (yomi_index >= 0) {
    /* ɤߤˤСseq_ent */
    int entry_index = anthy_dic_ntohl(wdic->entry_index[yomi_index]);
    se->seq_type |= ST_WORD;
    fill_dic_ent(&wdic->entry[entry_index],
		 se,
		 xs,
		 is_reverse);

  }
}

char *
anthy_word_dic_get_hashmap_ptr(struct word_dic *wdic)
{
  return get_section(wdic, 8);
}

struct word_dic *
anthy_create_word_dic(void)
{
  struct word_dic *wdic;
  char *p;

  wdic = anthy_smalloc(word_dic_ator);
  memset(wdic, 0, sizeof(*wdic));

  /* եޥåפ */
  wdic->dic_file = anthy_file_dic_get_section("word_dic");

  /* ƥΥݥ󥿤 */
  if (get_word_dic_sections(wdic) == -1) {
    anthy_sfree(word_dic_ator, wdic);
    return 0;
  }
  wdic->nr_pages = get_nr_page(wdic);

  /* 㼭ޥåפ */
  p = wdic->uc_section;
  return wdic;
}

void
anthy_release_word_dic(struct word_dic *wdic)
{
  anthy_sfree(word_dic_ator, wdic);
}

void
anthy_init_word_dic(void)
{
  word_dic_ator = anthy_create_allocator(sizeof(struct word_dic), NULL);
}
