#!/bin/bash


WORKDIR="`pwd`"
DICDIR="${WORKDIR}/parts"
TMPDIR="${WORKDIR}/gendic_tmp"

one2n5="${WORKDIR}/awkfile/one2n5.awk"
one2n3="${WORKDIR}/awkfile/one2n3.awk"

trap 'rm -rf "$TMPDIR"' 0 1 2 15

OLDLANG=${LANG}
LANG=ja_JP.UTF-8; export LANG


echo " Please wait ..."

mkdir "$TMPDIR"

# 自立語辞書 #

 ## 自立語辞書 作成 ##
  for f in "${DICDIR}"/g-*; do
    fn=`basename ${f}`

    if grep -q "^${fn} " "$WORKDIR"/freq.conf ; then
      eval export `grep "^${fn} " "$WORKDIR"/freq.conf | cut -d: -f2`
      ## ランクを頻度に変換
      awk '$3 == "A"{ print $1,$2,'$A'+$4,$5 }
           $3 == "B"{ print $1,$2,'$B'+$4,$5 }
           $3 == "C"{ print $1,$2,'$C'+$4,$5 }
           $3 == "D"{ print $1,$2,'$D'+$4,$5 }
           $3 == "E"{ print $1,$2,'$E'+$4,$5 }
           $3 == "F"{ print $1,$2,'$F'+$4,$5 }' $f |\
      sort -k1,1 -k2,2 -k3nr,3nr -k4,4 |\
      awk -f ${one2n5} > "$TMPDIR"/${fn}.tmp
      ## 変換漏れチェック
      if grep -q " [A-F] " "$TMPDIR"/${fn}.tmp; then
        echo "ERROR!: freq-values remain."
      fi
      unset A B C D E F
    else
      cut -d\  -f1-4 ${f} |\
      sort -k1,1 -k2,2 -k3nr,3nr -k4,4 |\
      awk -f ${one2n5} > "$TMPDIR"/${fn}.tmp
    fi
  done

   ## 「う゛」→「ヴ」の候補を作成 
  sed -n '/^[^ ]*う゛[^ ]* /s/う゛/ヴ/gp' "$TMPDIR"/g-* > "$TMPDIR"/g-vu.tmp

  ## gcanna.ctd 作成 ##
  sed '/^ *$/d' "$TMPDIR"/g-* |\
  sort -k1,1 -k3nr,3nr -k2,2 -k4,4 |\
  sed 's/\(#[^ ]\+\) \([0-9]\+\) /\1*\2 /' |\
  awk -f "${one2n3}" |\
  sed '/^$/d' |\
  iconv -f UTF-8 -t EUC-JP -o "${WORKDIR}"/gcanna.ctd


# 付属語辞書 #
 ## 付属語辞書 原型作成 ##
  cut -d' ' -f1-4 "$DICDIR"/gf-* > "$TMPDIR"/gf.tmp

 ## scim-anthy用「う゛」→「ヴ」 作成 ##
  sed -n '/う゛/s/う゛/ヴ/gp' "$TMPDIR"/gf.tmp |\
  sort -t' ' -k1,1 -k3nr,3nr -k2,2 -k4,4 > "$TMPDIR"/gf-vu.tmp

 ## 付属語辞書 完成 ##
  sort -t' ' -k1,1 -k3nr,3nr -k2,2 -k4,4 "$TMPDIR"/gf* |\
  awk -f "${one2n5}" |\
  sed -e 's/\(#[^ ]\+\) \([0-9]\+\) /\1*\2 /' |\
  awk -f "${one2n3}" |\
  sed '/^$/d' |\
  iconv -f UTF-8 -t EUC-JP -o "${WORKDIR}"/gcannaf.ctd

# 単漢字辞書 #
  cut -d' ' -f1-4 "$DICDIR"/gt-* |\
  sort -k1,1 -k3nr,3nr -k4,4 |\
  awk -f "${one2n5}" |\
  sed -e 's/\(#[^ ]\+\) \([0-9]\+\) /\1*\2 /' |\
  awk -f "${one2n3}" |\
  sed -e '/^$/d' |\
  iconv -f UTF-8 -t EUC-JP -o "${WORKDIR}"/gtankan.ctd


LANG=${OLDLANG}

