;;
(require "japanese.scm")
(require "generic-key.scm")
;;
(define anthy-init-lib-ok? nil)
;; configs
(define anthy-use-candidate-window? #t)
(define anthy-candidate-op-count 3)

;; key defs
(define anthy-on-key
  (lambda (key key-state)
    (or
     (and (= key 106)
	  (control-key-mask key-state))
     (generic-on-key key key-state))))
(define anthy-off-key
  (lambda (key key-state)
    (= key 108)))
(define anthy-begin-conv-key
  (lambda (key key-state)
    (= key 32)))
(define anthy-commit-key
  (lambda (key key-state)
    (or
     (and (= key 106)
	  (control-key-mask key-state))
     (= key 'return))))
(define anthy-extend-segment-key
  (lambda (key key-state)
    (or
     (and
      (control-key-mask key-state)
      (= key 111))
     (and
      (shift-key-mask key-state)
      (= key 'right)))))
(define anthy-shrink-segment-key
  (lambda (key key-state)
    (or
     (and
      (control-key-mask key-state)
      (= key 105))
     (and
      (shift-key-mask key-state)
      (= key 'left)))))
(define anthy-next-candidate-key
  (lambda (key key-state)
    (generic-next-candidate-key key key-state)))
(define anthy-prev-candidate-key
  (lambda (key key-state)
    (generic-prev-candidate-key key key-state)))
(define anthy-cancel-key
  (lambda (key key-state)
    (generic-cancel-key key key-state)))
(define anthy-backspace-key
  (lambda (key key-state)
    (generic-backspace-key key key-state)))
(define anthy-delete-key
  (lambda (key key-state)
    (generic-delete-key key key-state)))
(define anthy-go-left-key
  (lambda (key key-state)
    (generic-go-left-key key key-state)))
(define anthy-go-right-key
  (lambda (key key-state)
    (generic-go-right-key key key-state)))
(define anthy-next-segment-key
  (lambda (key key-state)
    (generic-go-right-key key key-state)))
(define anthy-prev-segment-key
  (lambda (key key-state)
    (generic-go-left-key key key-state)))

;; access
(define anthy-context-on
  (lambda (ac)
    (car (nthcdr 0 ac))))

(define anthy-context-set-on!
  (lambda (ac s)
    (set-car! (nthcdr 0 ac) s)))

(define anthy-context-state
  (lambda (ac)
    (car (nthcdr 1 ac))))

(define anthy-context-set-state!
 (lambda (ac st)
   (set-car! (nthcdr 1 ac) st)))

(define anthy-context-ac-id
  (lambda (ac)
    (car (nthcdr 2 ac))))

(define anthy-context-set-ac-id!
  (lambda (ac id)
    (set-car! (nthcdr 2 ac) id)))

(define anthy-context-left-string
 (lambda (ac)
   (car (nthcdr 3 ac))))

(define anthy-context-set-left-string!
  (lambda (ac str)
    (set-car! (nthcdr 3 ac) str)))

(define anthy-context-right-string
 (lambda (ac)
   (car (nthcdr 4 ac))))

(define anthy-context-set-right-string!
  (lambda (ac str)
    (set-car! (nthcdr 4 ac) str)))

(define anthy-context-rkc
  (lambda (ac)
    (car (nthcdr 5 ac))))

(define anthy-context-set-rkc!
 (lambda (ac rkc)
   (set-car! (nthcdr 5 ac) rkc)))

(define anthy-context-index-list
  (lambda (ac)
    (car (nthcdr 6 ac))))
  
(define anthy-context-set-index-list!
 (lambda (ac lst)
   (set-car! (nthcdr 6 ac) lst)))

(define anthy-context-cur-seg
  (lambda (ac)
    (car (nthcdr 7 ac))))

(define anthy-context-set-cur-seg!
  (lambda (ac seg)
    (set-car! (nthcdr 7 ac) seg)))

(define anthy-context-candidate-window
  (lambda (ac)
    (car (nthcdr 8 ac))))

(define anthy-context-set-candidate-window!
  (lambda (ac f)
    (set-car! (nthcdr 8 ac) f)))

(define anthy-context-candidate-op-count
  (lambda (ac)
    (car (nthcdr 9 ac))))

(define anthy-context-set-candidate-op-count!
  (lambda (ac c)
    (set-car! (nthcdr 9 ac) c)))
;; on/off state(compose,input) anthy-context-id string rkc index-list
;; cur-seg candidate-window
(define anthy-context-new
 (lambda ()
   (let ((c '())
	 (rkc (rk-context-new jp-rk-rule #t #f)))
     (set! c (copy-list '(() () () () () () () () () () ())))
     (anthy-context-set-ac-id!
      c
      (if anthy-init-lib-ok?
	  (anthy-lib-alloc-context)
	  ()))
     (anthy-context-set-rkc! c rkc)
     (anthy-flush c)
     (anthy-context-set-on! c #f)
     c)))

(define anthy-make-string
  (lambda (sl dir)
    (if sl
	(if dir
	    (string-append (anthy-make-string (cdr sl) dir)
			   (caar sl))
	    (string-append (caar sl)
			   (anthy-make-string (cdr sl) dir)))
	"")))

(define anthy-get-candidate
  (lambda (ac nth-seg)
    (let ((id (anthy-context-ac-id ac))
	  (idx (nth (anthy-context-index-list ac) nth-seg)))
      ())))

(define anthy-init-handler
  (lambda (id arg)
    (let ((c (find-context id)))
      (set-context-data! c
			 (anthy-context-new))
      (im-clear-mode-list id)
      (im-pushback-mode-list id "RAW")
      (im-pushback-mode-list id "Ҥ餬")
      (im-update-mode-list id)
      (im-update-mode id 0)
      ())))

(define anthy-release-handler
  (lambda (id)
    (let* ((c (find-context id))
	   (ac (context-data c))
	   (ac-id (anthy-context-ac-id ac)))
      (anthy-lib-free-context ac-id))))

(define anthy-mode-handler
  (lambda (id mode)
    (let* ((c (find-context id))
	   (ac (context-data c)))
      (anthy-flush ac)
      (if (= mode 0)
	  (anthy-context-set-on! ac '())
	  (anthy-context-set-on! ac #t))
      (anthy-update-preedit ac id))
    ()))

(define anthy-flush
  (lambda (ac)
    (rk-flush (anthy-context-rkc ac))
    (anthy-context-set-left-string! ac '())
    (anthy-context-set-right-string! ac '())
    (anthy-context-set-on! ac #t)
    (anthy-context-set-state! ac #f)
    (anthy-context-set-index-list! ac ())
    (anthy-context-set-candidate-window! ac #f)
    (anthy-context-set-candidate-op-count! ac 0)))

(define anthy-begin-input
  (lambda (ac)
    (anthy-context-set-on! ac #t)
    (rk-flush (anthy-context-rkc ac))
    (anthy-context-set-state! ac #f)))

(define anthy-update-preedit
  (lambda (ac id)
    (if (anthy-context-on ac)
	(if (anthy-context-state ac)
	    (anthy-compose-state-preedit ac id)
	    (anthy-input-state-preedit ac id))
	(begin
	  (im-clear-preedit id)
	  (im-update-preedit id)))))

(define anthy-proc-raw-state
  (lambda (c key key-state)
    (let ((id (context-id c))
	  (ac (context-data c)))
      (if (anthy-on-key key key-state)
	  (begin
	    (anthy-begin-input ac)
	    (im-update-mode id 1))
	  (im-commit-raw (context-id c))))))

(define anthy-make-index-list-rec
  (lambda (n)
    (if (> n 0)
	(cons 0
	      (anthy-make-index-list-rec (- n 1)))
	'())))

(define anthy-make-index-list
  (lambda (n old-lst)
    (if (< n (length old-lst))
	(truncate-list old-lst n 1)
	(append old-lst
		(anthy-make-index-list-rec (- n
					      (length old-lst)))))))

(define anthy-begin-conv
  (lambda (ac)
    (let ((ac-id (anthy-context-ac-id ac)))
      (anthy-lib-set-string
       ac-id
       (string-append
	(anthy-make-string (anthy-context-left-string ac) #t)
	(anthy-make-string (anthy-context-right-string ac) #f)))
      (anthy-context-set-index-list!
       ac
       (anthy-make-index-list
	(anthy-lib-get-nr-segments ac-id)
	nil))
      (anthy-context-set-state! ac #t)
      (anthy-context-set-cur-seg! ac 0)
      (rk-flush (anthy-context-rkc ac)))))

(define anthy-proc-input-state-no-preedit
  (lambda (ac id key key-state)
    (let ((rkc (anthy-context-rkc ac))
	  (key-str (charcode->string key)))
      (and
       (if (anthy-off-key key key-state)
	   (begin
	     (anthy-flush ac)
	     (anthy-context-set-on! ac #f)
	     (im-update-mode id 0)
	     #f)
	   #t)
       (if (anthy-backspace-key key key-state)
	   (begin
	     (im-commit-raw id)
	     #f)
	   #t)
       (if (anthy-delete-key key key-state)
	   (begin
	     (im-commit-raw id)
	     #f)
	   #t)
       (if (modifier-key-mask key-state)
	   (begin
	     (im-commit-raw id)
	     #f)
	   #t)
       (if (string-find (rk-expect rkc) key-str)
	   (let ((res))
	     (set! res (rk-push-key! rkc key-str))
	     (if res
		 (anthy-context-set-left-string!
		  ac
		  (cons res (anthy-context-left-string ac))))
	     #f)
	   #t)
       (im-commit-raw id)))))

(define anthy-has-preedit?
  (lambda (ac)
    (or
     (> (length (anthy-context-left-string ac)) 0)
     (> (length (anthy-context-right-string ac)) 0)
     (> (length (rk-pending (anthy-context-rkc ac))) 0))))

(define anthy-proc-input-state-with-preedit
  (lambda (ac id key key-state)
    (let ((rkc (anthy-context-rkc ac))
	  (key-str (charcode->string key)))
      (and
       ;; begin conversion
       (if (and
	    (anthy-begin-conv-key key key-state)
	    anthy-init-lib-ok?)
	   (begin
	     (anthy-begin-conv ac)
	     #f)
	   #t)
       ;; backspace
       (if (anthy-backspace-key key key-state)
	   (begin
	     (if (not (rk-backspace rkc))
		 (if (anthy-context-left-string ac)
		     (anthy-context-set-left-string!
		      ac
		      (cdr (anthy-context-left-string ac)))))
	     #f)
	   #t)
       ;; delete
       (if (anthy-delete-key key key-state)
	   (begin
	     (if (not (rk-delete rkc))
		 (if (anthy-context-right-string ac)
		     (anthy-context-set-right-string!
		      ac
		      (cdr (anthy-context-right-string ac)))))
	     #f)
	   #t)
       ;; cancel
       (if (anthy-cancel-key key key-state)
	   (begin
	     (anthy-flush ac)
	     #f)
	   #t)
       ;;
       (if (anthy-commit-key key key-state)
	   (begin
	     (im-commit
	      id
	      (string-append
	       (anthy-make-string (anthy-context-left-string ac) #t)
	       (anthy-make-string (anthy-context-right-string ac) #f)))
	     (anthy-flush ac)
	     #f)
	   #t)
       ;; left
       (if (anthy-go-left-key key key-state)
	   (begin
	     (if (anthy-context-left-string ac)
		 (let
		     ((c (car (anthy-context-left-string ac))))
		   (anthy-context-set-left-string!
		    ac (cdr (anthy-context-left-string ac)))
		   (anthy-context-set-right-string! ac
						    (cons c
							  (anthy-context-right-string ac)))))
	     #f)
	   #t)
       ;; right
       (if (anthy-go-right-key key key-state)
	   (begin
	     (if (anthy-context-right-string ac)
		 (let
		     ((c (car (anthy-context-right-string ac))))
		   (anthy-context-set-right-string!
		    ac (cdr (anthy-context-right-string ac)))
		   (anthy-context-set-left-string! ac
						   (cons c
							 (anthy-context-left-string ac)))))
	     #f)
	   #t)
       ;; modifiers => ignore
       (if (modifier-key-mask key-state)
	   #f
	   #t)
       (let ((res))
	 (set! res (rk-push-key! rkc key-str))
	 (if res
	     (anthy-context-set-left-string!
	      ac
	      (cons res (anthy-context-left-string ac)))))))))
  

(define anthy-proc-input-state
  (lambda (ac id key key-state)
    (if (anthy-has-preedit? ac)
	(anthy-proc-input-state-with-preedit ac id key key-state)
	(anthy-proc-input-state-no-preedit ac id key key-state))))

(define anthy-pushback-preedit-segment-rec
  (lambda (ac id idx nseg)
    (let ((ac-id (anthy-context-ac-id ac)))
      (if (< idx nseg)
	  (begin
	    (im-pushback-preedit
	     id
	     (if (= idx (anthy-context-cur-seg ac))
		 preedit-reverse
		 preedit-underline)
	     (anthy-lib-get-nth-candidate
	      ac-id idx
	      (nth idx (anthy-context-index-list ac))))
	    (anthy-pushback-preedit-segment-rec ac id (+ idx 1) nseg))))))

(define anthy-compose-state-preedit
  (lambda (ac id)
    (im-clear-preedit id)
    (anthy-pushback-preedit-segment-rec
     ac id
     0 (length (anthy-context-index-list ac)))
    (im-update-preedit id)))

(define anthy-input-state-preedit
  (lambda (ac id)
    (let ((rkc (anthy-context-rkc ac)))
      (im-clear-preedit id)
      (im-pushback-preedit
       id preedit-underline
       (anthy-make-string (anthy-context-left-string ac) #t))
      (im-pushback-preedit id preedit-underline
                           (rk-pending rkc))
      (if (anthy-has-preedit? ac)
	  (im-pushback-preedit id preedit-cursor "|"))
      (im-pushback-preedit
       id preedit-underline
       (anthy-make-string (anthy-context-right-string ac) #f))
      (im-update-preedit id))))

(define anthy-get-commit-string
  (lambda (ac idx nseg)
    (let ((ac-id (anthy-context-ac-id ac)))
      (if (< idx nseg)
	  (string-append
	   (anthy-lib-get-nth-candidate
	    ac-id idx
	    (nth idx (anthy-context-index-list ac)))
	   (anthy-get-commit-string ac (+ idx 1) nseg))
	  ""))))

(define anthy-do-commit
  (lambda (ac id)
    (anthy-reset-candidate-window ac id)
    (im-commit id
	       (anthy-get-commit-string
		ac 0
		(length (anthy-context-index-list ac))))
    (anthy-flush ac)))

(define anthy-move-segment
  (lambda (ac dir)
    (let ((pos (+ (anthy-context-cur-seg ac) dir))
	  (nseg (length  (anthy-context-index-list ac))))
      (if (and
	   (> pos -1)
	   (< pos nseg))
	  (anthy-context-set-cur-seg! ac pos)))))

(define anthy-move-candidate
  (lambda (ac id off)
    (let* ((seg (anthy-context-cur-seg ac))
	   (n (nth seg (anthy-context-index-list ac)))
	   (ac-id (anthy-context-ac-id ac))
	   (max (anthy-lib-get-nr-candidates ac-id seg)))
      (set! n (+ n off))
      (if (>= n max)
	  (set! n 0))
      (if (< n 0)
	  (set! n (- max 1)))
      (set-car! (nthcdr seg (anthy-context-index-list ac)) n)
      (anthy-context-set-candidate-op-count!
       ac
       (+ 1 (anthy-context-candidate-op-count ac)))
      (if (and
	   (= (anthy-context-candidate-op-count ac)
	      anthy-candidate-op-count)
	   anthy-use-candidate-window?)
	  (begin
	    (anthy-context-set-candidate-window! ac #t)
	    (im-begin-candidate
	     id
	     max 0)))
      (if (anthy-context-candidate-window ac)
	  (im-update-candidate id n)))))

(define anthy-reset-candidate-window
  (lambda (ac id)
    (if (anthy-context-candidate-window ac)
	(begin
	  (im-end-candidate id ac)
	  (anthy-context-set-candidate-window! ac #f)))
    (anthy-context-set-candidate-op-count! ac 0)))

(define anthy-resize-segment
  (lambda (ac id cnt)
    (let
	((ac-id (anthy-context-ac-id ac)))
      (anthy-reset-candidate-window ac id)
      (anthy-lib-resize-segment
       ac-id (anthy-context-cur-seg ac) cnt)
      (anthy-context-set-index-list!
       ac
       (anthy-make-index-list
	(anthy-lib-get-nr-segments ac-id)
	(truncate-list
	 (anthy-context-index-list ac)
	 (anthy-context-cur-seg ac))))
      )))

(define anthy-proc-compose-state
  (lambda (ac id key key-state)
    (and
     (if (anthy-commit-key key key-state)
	 (begin
	   (anthy-do-commit ac id)
	   #f)
	 #t)
     (if (anthy-extend-segment-key key key-state)
	 (begin
	   (anthy-resize-segment ac id 1)
	   #f)
	 #t)
     (if (anthy-shrink-segment-key key key-state)
	 (begin
	   (anthy-resize-segment ac id -1)
	   #f)
	 #t)
     (if (anthy-next-segment-key key key-state)
	 (begin
	   (anthy-move-segment ac 1)
	   (anthy-reset-candidate-window ac id)
	   #f)
	 #t)
     (if (anthy-prev-segment-key key key-state)
	 (begin
	   (anthy-move-segment ac -1)
	   (anthy-reset-candidate-window ac id)
	   #f)
	 #t)
     (if (backspace-key key key-state)
	 (begin
	   (anthy-reset-candidate-window ac id)
	   #f)
	 #t)
     (if (anthy-next-candidate-key key key-state)
	 (begin
	   (anthy-move-candidate ac id 1)
	   #f)
	 #t)
     (if (anthy-prev-candidate-key key key-state)
	 (begin
	   (anthy-move-candidate ac id -1)
	   #f)
	 #t)
     (if (anthy-cancel-key key key-state)
	 (begin
	   (anthy-context-set-state! ac #f)
	   (anthy-reset-candidate-window ac id)
	   #f)
	 #t)
     (if (modifier-key-mask key-state)
	 #f
	 #t)
     (begin
       (anthy-do-commit ac id)
       (anthy-proc-input-state ac id key key-state)))
    ()))

(define anthy-press-key-handler
  (lambda (id key key-state)
    (let* ((c (find-context id))
	   (ac (context-data c)))
      (if (anthy-context-on ac)
	  (if (anthy-context-state ac)
	      (anthy-proc-compose-state ac id key key-state)
	      (anthy-proc-input-state ac id key key-state))
	  (anthy-proc-raw-state c key key-state))
      ;; preedit
      (anthy-update-preedit ac id))))


(define anthy-release-key-handler
  (lambda (id key key-state)
    ()))

(define anthy-reset-handler
  (lambda (id)
    ()))

(if (and
     (symbol-bound? 'anthy-lib-init)
     (anthy-lib-init))
    (set! anthy-init-lib-ok? #t))

(define anthy-get-candidate-handler
  (lambda (id idx)
    (let* ((c (find-context id))
	   (ac (context-data c))
	   (ac-id (anthy-context-ac-id ac)))
      (anthy-lib-get-nth-candidate
       ac-id (anthy-context-cur-seg ac)
       idx))))

(define anthy-set-candidate-index-handler
  (lambda (id idx)
    (let* ((c (find-context id))
	   (ac (context-data c))
	   (seg (anthy-context-cur-seg ac))
	   (ac-id (anthy-context-ac-id ac)))
      (set-car! (nthcdr seg (anthy-context-index-list ac)) idx)
      (anthy-update-preedit ac id))))

(register-im
 'anthy
 "ja"
 "EUC-JP"
 nil
 anthy-init-handler
 anthy-release-handler
 anthy-mode-handler
 anthy-press-key-handler
 anthy-release-key-handler
 anthy-reset-handler
 anthy-get-candidate-handler
 anthy-set-candidate-index-handler)
