/*
 * Ȥ줿ƥȤ鸡Ԥ
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dic_main.h"
#include "filemap.h"
#include "textdict.h"

struct textdict {
  char *fn;
  struct filemapping *mapping;
};

struct textdict *
anthy_textdict_open(const char *fn, int create)
{
  struct textdict *td = malloc(sizeof(struct textdict));
  td->fn = strdup(fn);
  td->mapping = NULL;
  return td;
}

void
anthy_textdict_close(struct textdict *td)
{
  if (td->mapping) {
    anthy_munmap(td->mapping);
  }
  free(td->fn);
  free(td);
}

void
anthy_scan_priv_dic(struct textdict *td, int offset, void *ptr,
		    int (*fun)(void *, int, const char *, const char *))
{
  FILE *fp;
  char buf[1024];
  fp = fopen(td->fn, "r");
  if (!fp) {
    return ;
  }
  fseek(fp, offset, SEEK_SET);
  while (fgets(buf, 1024, fp)) {
    char *p = strchr(buf, ' ');
    int len, r;
    len = strlen(buf);
    offset += len;
    buf[len - 1] = 0;
    if (!p) {
      continue;
    }
    *p = 0;
    p++;
    while (*p == ' ') {
      p++;
    }
    /* call it */
    r = fun(ptr, offset, buf, p);
    if (r) {
      break;
    }
  }
  fclose(fp);
}
