#ifndef _iis_h_included_
#define _iis_h_included_

struct input_set;

struct input_line {
  /**/
  double weight;
  double negative_weight;
  /**/
  int nr_features;
  int *features;
  /**/
  struct input_line *next_line;
};

/* iterative scaling */
struct input_set *iis_create(int nr_features);
void iis_init_lambda_and_delta(struct input_set *is);
void iis_set_features(struct input_set *is, int *features,
		      int nr, double strength);
void iis_iterate(struct input_set *is, double rem);
double iis_get_lambda(struct input_set *is, int nth);
double iis_get_z(struct input_set *is);
/**/
void iis_dump(struct input_set *is);

/**/
struct input_line *iis_get_input_line(struct input_set *is);

#endif
