#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "reader.h"
#include "word.h"
#include "storage.h"

struct app_win {
  GtkWidget *top;
  //
  GtkTreeModel *words_model;
  GtkWidget *words_view;
  //
  GtkTreeModel *attr_model;
  GtkWidget *attr_view;
  //
  WordSet ws;
};

static void
do_dump()
{
  system("fossil-backend --dump > tmp-tmp");
}

static GtkTreeModel *
build_words_model()
{
  GtkListStore *model;
  model = gtk_list_store_new(3,
			     G_TYPE_POINTER,
			     G_TYPE_STRING,
			     G_TYPE_STRING);
  return GTK_TREE_MODEL(model);
}

static void
set_word_attrs(app_win *aw, Word *w)
{
  gtk_list_store_clear(GTK_LIST_STORE(aw->attr_model));
  if (!w) {
    return ;
  }
  std::list<Attr *>::iterator it;
  for (it = w->m_attrs.begin(); it != w->m_attrs.end(); it++) {
    Attr *a = *it;
    std::list<Sign *>::iterator jt;
    for (jt = a->m_signs.begin(); jt != a->m_signs.end(); jt++) {
      Sign *s = *jt;
      GtkTreeIter iter;
      char buf[10];
      s->m_stamp.get_str(buf);
      gtk_list_store_append(GTK_LIST_STORE(aw->attr_model), &iter);
      gtk_list_store_set(GTK_LIST_STORE(aw->attr_model), &iter,
			 0, s->m_user,
			 1, buf,
			 2, s->m_is_ok ? "ok" : "no",
			 3, a->m_attr,
			 -1);
    }
  }
}

static void
selection_cb(GtkTreeSelection *selection,
	     app_win *aw)
{
  GtkTreeIter iter;
  GValue value = {0};
  struct Word *w;
  const char *s;
  if (!gtk_tree_selection_get_selected(selection, NULL, &iter)) {
    return ;
  }

  gtk_tree_model_get_value(aw->words_model, &iter,
			   0, &value);
  w = (Word *)g_value_get_pointer(&value);
  g_value_unset(&value);
  if (w) {
    set_word_attrs(aw, w);
  }
}

static GtkTreeModel *
build_attr_model()
{
  // stamp, user, day, approve
  GtkListStore *model;
  model = gtk_list_store_new(4,
			     G_TYPE_STRING,
			     G_TYPE_STRING,
			     G_TYPE_STRING,
			     G_TYPE_STRING);
  return GTK_TREE_MODEL(model);
}

static void
add_word_view_column(struct app_win *aw, GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  /**/
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("Word",
						    renderer,
						    "text", 1,
						    NULL);
  gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
  gtk_tree_view_column_set_sort_column_id(column, 1);
  gtk_tree_view_append_column (treeview, column);
  /**/
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("Index",
						    renderer,
						    "text", 2,
						    NULL);
  gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
  gtk_tree_view_column_set_sort_column_id(column, 2);
  gtk_tree_view_append_column (treeview, column);
}

static void
add_attr_view_column(struct app_win *aw, GtkTreeView *treeview)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  /**/
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("Name",
						    renderer,
						    "text", 0,
						    NULL);
  gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
  gtk_tree_view_column_set_sort_column_id(column, 1);
  gtk_tree_view_append_column (treeview, column);
  /**/
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("Stamp",
						    renderer,
						    "text", 1,
						    NULL);
  gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
  gtk_tree_view_column_set_sort_column_id(column, 1);
  gtk_tree_view_append_column (treeview, column);
  /**/
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("Ok?",
						    renderer,
						    "text", 2,
						    NULL);
  gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
  gtk_tree_view_column_set_sort_column_id(column, 1);
  gtk_tree_view_append_column (treeview, column);
  /**/
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("Attribute",
						    renderer,
						    "text", 3,
						    NULL);
  gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
  gtk_tree_view_column_set_sort_column_id(column, 1);
  gtk_tree_view_append_column (treeview, column);
}

static void
build_tree_view(struct app_win *aw, GtkWidget *box)
{
  GtkWidget *sw;
  sw = gtk_scrolled_window_new(NULL, NULL);


  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
				       GTK_SHADOW_ETCHED_IN);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
				  GTK_POLICY_NEVER,
				  GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (box), sw, TRUE, TRUE, 0);
  aw->words_model = build_words_model();
  aw->words_view = gtk_tree_view_new_with_model(aw->words_model);
  aw->attr_model = build_attr_model();
  aw->attr_view = gtk_tree_view_new_with_model(aw->attr_model);

  add_word_view_column(aw, GTK_TREE_VIEW(aw->words_view));
  add_attr_view_column(aw, GTK_TREE_VIEW(aw->attr_view));

  gtk_container_add(GTK_CONTAINER(sw), aw->words_view);
  gtk_box_pack_start (GTK_BOX (box), aw->attr_view, TRUE, TRUE, 0);

  gtk_widget_show(aw->words_view);
  gtk_widget_show(aw->attr_view);
  gtk_widget_show(sw);

  GtkTreeSelection *selection;
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(aw->words_view));
  g_signal_connect(selection, "changed",
		   G_CALLBACK(selection_cb), aw);
}

static void
build_app_win(struct app_win *aw)
{
  aw->top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  GtkWidget *vbox;
  vbox = gtk_vbox_new(FALSE, 0);
  build_tree_view(aw, vbox);
  gtk_container_add(GTK_CONTAINER(aw->top), vbox);
  gtk_widget_show(vbox);
  gtk_window_set_default_size(GTK_WINDOW(aw->top), 500, 500);
  gtk_widget_show(aw->top);
}

static void
update_model(struct app_win *aw)
{
  std::list<Word *>::iterator it;
  GtkTreeIter iter;

  for (it = aw->ws.m_word_array.begin();
       it != aw->ws.m_word_array.end(); it++) {
    Word *w = *it;

    gtk_list_store_append(GTK_LIST_STORE(aw->words_model), &iter);
    gtk_list_store_set(GTK_LIST_STORE(aw->words_model), &iter,
		       0, w,
		       1, w->m_index,
		       2, w->m_word,
		       -1);

  }
}

static void
read_words(WordSet *ws, const char *fn)
{
  FILE *fp = fopen(fn, "r");
  if (!fp) {
    return ;
  }
  char buf[1024];
  while (fgets(buf, 1024, fp)) {
    DictLine dl(buf);
    if (dl.nr != 6) {
      continue;
    }
    ws->add_word(dl.user, dl.stamp, dl.approve,
		 dl.index, dl.word);
  }
  fclose(fp);
}

int
main(int argc, char **argv)
{
  struct app_win aw;
  do_dump();
  read_words(&aw.ws, "tmp-tmp");
  gtk_init(&argc, &argv);

  build_app_win(&aw);
  update_model(&aw);

  gtk_main();
  return 0;
}
