#include <stdio.h>
#include "fossil.h"

#define CHECKED_ITEM_FILE "checked_words"

static void
output_item(FILE *fp, char *index, char *word, char *wt, char *fix)
{
    char *tail = syusi_tail(wt);
    int top = 0;
    if (!strcmp(fix, "up")) {
	top = 1;
    }
    fprintf(fp, "expect_order(%d, \"%s\", \"%s%s\", \"%s%s\", \"%s\", \"%s\");\n",
	    top, wt, index, tail,
	    word, tail,
	    index, word);
}

static void
output_header(FILE *fout)
{
    fprintf(fout,
	    "#include <anthy/anthy.h>\n"
	    "anthy_context_t ac;\n");
    fprintf(fout,
	    "void\n"
	    "modify(char *idx, char *word, char *wt, int up) {\n"
	    " printf(\"\\\\modify_freq %%s %%s %%s\", idx, wt, word);\n"
	    " if (up) printf(\" up\\n\");\n"
	    " if (!up) printf(\" down\\n\");\n"
	    "}\n");
    fprintf(fout,
	    "void\n"
	    "expect_order(int o, char *wt, char *in, char *ex, char *idx, char *word) {\n"
	    "char buf[1024];\n"
	    "anthy_set_string(ac, in);\n"
	    "anthy_get_segment(ac, 0, 0, buf, 1024);"
	    " if (!strcmp(buf, ex)) {\n"
	    "  if (!o) {\n"
	    "   modify(idx, word, wt, 0);"
	    "  }\n"
	    " } else {\n"
	    "  if (o) {\n"
	    "   modify(idx, word, wt, 1);"
	    "  }\n"
	    " }\n"
	    "}\n");
    fprintf(fout, "int\nmain(int argc, char **argv)\n{\n");
    fprintf(fout,
	    "anthy_init();\n"
	    "ac = anthy_create_context();\n");
}

static void
output_trailer(FILE *fout)
{
    fprintf(fout, "return 0;\n}\n");
}

int
main(int argc, char **argv)
{
    FILE *fp = fopen(CHECKED_ITEM_FILE, "r");
    FILE *fout = stdout;
    char buf[1024];
    if (!fp) {
	fprintf(stderr, "no words\n");
	exit(1);
    }
    output_header(fout);
    while (fgets(buf, 1024, fp)) {
	char index[1024];
	char word[1024];
	char wt[1024];
	char fix[1024];
	if (sscanf(buf, "%s %s %s %s", index, word, wt, fix) != 4) {
	    continue;
	}
	if (!strcmp(fix, "ok")) {
	    continue;
	}
	output_item(fout, index, word, wt, fix);
    }
    output_trailer(fout);
    return 0;
}
