#include <string.h>
#include "fossil.h"

struct syusi_pat {
    char *wt;
    char *tail;
} syusi_pat[] = {
    {"B5", "$B$V(B"},
    {"B5r", "$B$V(B"},
    {"C5r", "$B$/(B"},
    {"G5", "$B$0(B"},
    {"G5r", "$B$0(B"},
    {"K5", "$B$/(B"},
    {"K5r", "$B$/(B"},
    {"KS", "$B$k(B"},
    {"KSr", "$B$k(B"},
    {"KY", "$B$$(B"},
    {"KYT", "$B$$(B"},
    {"KYU", "$B$$(B"},
    {"KYme", "$B$$(B"},
    {"KYmi", "$B$$(B"},
    {"KYmime", "$B$$(B"},
    {"KYna", "$B$$(B"},
    {"L5", "$B$k(B"},
    {"M5", "$B$`(B"},
    {"M5r", "$B$`(B"},
    {"N5", "$B$L(B"},
    {"N5r", "$B$L(B"},
    {"R5", "$B$k(B"},
    {"R5r", "$B$k(B"},
    {"SX", "$B$9$k(B"},
    {"T5", "$B$D(B"},
    {"T5r", "$B$D(B"},
    {"U5", "$B$&(B"},
    {"U5r", "$B$&(B"},
    {"W5", "$B$&(B"},
    {"W5r", "$B$&(B"},
    {"ZX", "$B$:$k(B"},
    {NULL, NULL}
};

char *
syusi_tail(const char *wt)
{
    struct syusi_pat *p;
    for (p = syusi_pat; p->wt; p++) {
	if (!strcmp(p->wt, &wt[1])) {
	    return p->tail;
	}
    }
    return "";
}
