/*
 * ʸι¤seginfoɾ
 *
 * ʸФʣι¤θ򥽡Ȥ
 *
 * $Id: infosort.c,v 1.12 2002/09/14 03:39:10 yusuke Exp $
 */
#include <stdlib.h>

#include <segment.h>
#include <ordering.h>
#include <splitter.h>
#include "sorter.h"

static void eval_seginfo(struct seg_ent *se, struct seg_info *si);
static int seginfo_compare_func(const void *p1, const void *p2);

/*
 * ׻Ƥ¤ˤscore˹¤ˤɾä
 */
static void
eval_seginfo(struct seg_ent *se, struct seg_info *si)
{
  (void)se;
  si->score = si->base_score;
}

static int
seginfo_compare_func(const void *p1, const void *p2)
{
  const struct seg_info * const *s1 = p1;
  const struct seg_info * const *s2 = p2;
  return (*s1)->score - (*s2)->score;
}

void
anthy_sort_seginfo(struct segment_list *seg)
{
  int i;
  for (i = 0; i < seg->nr_segments; i++) {
    struct seg_ent *se;
    int j;
    se = anthy_get_nth_segment(seg, i);
    for (j = 0; j < se->nr_seginfo; j++) {
      eval_seginfo(se, se->si[j]);
    }
  }
  for (i = 0; i < seg->nr_segments; i++) {
    struct seg_ent *se = anthy_get_nth_segment(seg, i);
    qsort(se->si, se->nr_seginfo, sizeof(struct seg_info *),
	  seginfo_compare_func);
  }
}
