/*
 * ʸμΩ(Ƭޤ)³
 * 졢ưʤɤ°Υѥ򸡽Ф
 * ѥϥդȤեѰդ롣
 *
 *
 *  +------+
 *  |      |
 *  |branch+--cond--+--transition--> node
 *  |      |        +--transition--> node
 *  | NODE |
 *  |      |
 *  |branch+--cond-----transition--> node
 *  |      |
 *  |branch+--cond-----transition--> node
 *  |      |
 *  +------+
 *
 * $Id: wordseq.c,v 1.18 2002/07/23 14:27:21 yusuke Exp $
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <conf.h>
#include <ruleparser.h>
#include <xstr.h>
#include <logger.h>
#include <segclass.h>
#include "wordborder.h"

static int nrNodes;

#define WEAK_CONNECTION 8
#define WEAKER_CONNECTION 2
#define NORMAL_CONNECTION 1

struct dep_transition {
  int next_node;/* ΥΡɤֹ */
  int score;/* ܤΥ */
};

struct dep_branch {
  /* ܾ° */
  int nr_strs;/* Ĺ */
  xstr *str;/*  */

  /* ΥΡ */
  int nr_transitions;
  struct dep_transition *transition;
};

static struct dep_node {
  char *cn;/* Ρɤ̾ */

  int nr_branch;
  struct dep_branch *branch;
}*gNodes;

static void parse_transition(char *token, struct dep_branch *db);
static void parse_line(char **, int );
static void match_nodes(struct splitter_context *, struct word_list *,
			xstr xs, int node);
static void match_branch(struct splitter_context *, struct word_list *wl,
			 xstr *xs, struct dep_branch *);
static void check_nodes(void);

/* ʸˡե˶ΥΡɤ뤫å */
static void
check_nodes(void)
{
  int i;
  for (i = 1; i < nrNodes; i++) {
    if (gNodes[i].nr_branch == 0) {
      anthy_log(0, "node %s has no branch.\n", gNodes[i].cn);
    }
  }
}

/*
 * ܤ¹ԤƤߤ
 *
 * tmpl ޤǤ˹word_list
 * xs Ĥʸ
 * db Ĵbranch
 */
static void
match_branch(struct splitter_context *sc,
	     struct word_list *tmpl,
	     xstr *xs, struct dep_branch *db)
{
  int i;
  /* ˥ȥ饤 */
  for (i = 0; i < db->nr_transitions; i++) {
    if (db->transition[i].next_node) {
      /* score򥳥ԡ */
      int conn_score = tmpl->conn_score;
      tmpl->conn_score /= db->transition[i].score;
      if (tmpl->conn_score == 0) {
	/* 0 ǳΤɻ */
	tmpl->conn_score = 1;
      }
      match_nodes(sc, tmpl, *xs, db->transition[i].next_node);
      /* ᤷ */
      tmpl->conn_score = conn_score;
    }else{
      /* 
       * üΡɤãΤǡ
       * word_listȤƥߥå
       */
      struct word_list *wl;
      wl = anthy_alloc_word_list(sc);
      *wl = *tmpl;
      wl->len += wl->dep_len;
      anthy_commit_word_list(sc, wl);
    }
  }
}

/*
 * ƥΡɤˤܾƥȤ
 *
 * wl Ωword_list
 * follow_str Ωʹߤʸ
 * node 롼ֹ
 */
static void
match_nodes(struct splitter_context *sc,
	    struct word_list *wl,
	    xstr follow_str, int node)
{
  struct dep_node *dn = &gNodes[node];
  struct dep_branch *db;
  int i,j;
  /* ƥ롼 */
  for (i = 0; i < dn->nr_branch; i++) {
    db = &dn->branch[i];
    /* ܾ */
    for (j = 0; j < db->nr_strs; j++) {
      if (follow_str.len >= db->str[j].len){
	xstr w;
	w.str = follow_str.str;
	w.len = db->str[j].len;
	if (!anthy_xstrcmp(&w, &db->str[j])) {
	  xstr new_follow;
	  new_follow.str = &follow_str.str[w.len];
	  new_follow.len = follow_str.len - w.len;
	  wl->dep_len += w.len;
	  match_branch(sc, wl, &new_follow, db);
	  wl->dep_len -= w.len;
	}
      }
    }
  }
}

void
anthy_scan_node(struct splitter_context *sc,
		struct word_list *tmpl,
		xstr *follow, int node)
{
  /* °դƤʤ֤鸡򳫻Ϥ */
  match_nodes(sc, tmpl, *follow, node);
}

int
anthy_get_node_id_by_name(const char *name)
{
  int i;
  for (i = 0; i < nrNodes; i++) {
    if (!strcmp(name,gNodes[i].cn)) {
      return i;
    }
  }
  gNodes = realloc(gNodes, sizeof(struct dep_node)*(nrNodes+1));
  gNodes[nrNodes].cn = strdup(name);
  gNodes[nrNodes].nr_branch = 0;
  gNodes[nrNodes].branch = 0;
  nrNodes++;
  return nrNodes-1;
}

/*
 * ܤparse
 * ܤ [:.]@(Ρ̾)
 */
static void
parse_transition(char *token, struct dep_branch *db)
{
  int next_id;
  int conn = NORMAL_CONNECTION;
  /* ³Υץե */
  while (*token != '@') {
    switch(*token){
    case ':':
      conn = WEAKER_CONNECTION;
      break;
    case '.':
      conn = WEAK_CONNECTION;
      break;
    }
    token ++;
  }
  next_id = anthy_get_node_id_by_name(token);
  db->transition = realloc(db->transition,
			   sizeof(struct dep_transition)*(db->nr_transitions+1));
  db->transition[db->nr_transitions].next_node = next_id;
  db->transition[db->nr_transitions].score = conn;
  db->nr_transitions ++;
}

/*
 * Ρ̾ ܾ+ +
 */
static void
parse_line(char **tokens, int nr)
{
  int id, i;
  struct dep_branch *db;
  struct dep_node *dn;

  /* ΡɤȤid */
  id = anthy_get_node_id_by_name(tokens[0]);
  dn = &gNodes[id];

  /* ΥΡɤ˥֥ɲä */
  dn->branch = realloc(dn->branch,sizeof(struct dep_branch)*(dn->nr_branch+1));
  db = &dn->branch[dn->nr_branch];
  dn->nr_branch++;
  db->nr_strs = 0;
  db->str = 0;
  db->nr_transitions = 0;
  db->transition = 0;

  /* Υ֥ܾ°ΥꥹȤɲä */
  for (i = 1; i < nr && tokens[i][0] == '\"'; i++) {
    char *s;
    xstr *xs;
    s = strdup(&tokens[i][1]);
    s[strlen(s)-1] =0;
    xs = anthy_cstr_to_xstr(s);
    db->str = realloc(db->str, sizeof(xstr)*(db->nr_strs+1));
    db->str[db->nr_strs] = *xs;
    db->nr_strs ++;
    free(s);
    free(xs);
  }

  /* ܾ郎ʤϷٹФơܾɲä */
  if (i == 1) {
    char *s;
    xstr *xs;
    anthy_log(0, "node %s has a branch without any transition condition.\n",
	      tokens[0]);
    s = strdup("");
    xs = anthy_cstr_to_xstr(s);
    db->str = malloc(sizeof(xstr));
    db->str[0] = *xs;
    db->nr_strs = 1;
    free(s);
    free(xs);
  }

  /* ΥΡɤɲä */
  for ( ; i < nr; i++){
    parse_transition(tokens[i], db);
  }
}

int
anthy_init_depword_tab()
{
  const char *fn;
  char **tokens;
  int nr;

  /* id 0 Ρɤ˳Ƥ */
  anthy_get_node_id_by_name("@");
  fn = anthy_conf_get_str("DEPWORD");
  if (!fn) {
    anthy_log(0, "Dependent word dictionary is unspecified.\n");
    return -1;
  }
  if (anthy_open_file(fn) == -1) {
    anthy_log(0, "Failed to open dep word dict (%s).\n", fn);
    return -1;
  }
  while (!anthy_read_line(&tokens, &nr)) {
    parse_line(tokens, nr);
    anthy_free_line();
  }
  anthy_close_file();
  check_nodes();
  return 0;
}

void
anthy_release_depword_tab(void)
{
  int i, j, k;
  for (i = 0; i < nrNodes; i++) {
    free(gNodes[i].cn);
    for (j = 0; j < gNodes[i].nr_branch; j++) {
      for (k = 0; k < gNodes[i].branch[j].nr_strs; k++) {
	free(gNodes[i].branch[j].str[k].str);
      }
      free(gNodes[i].branch[j].str);
      free(gNodes[i].branch[j].transition);
    }
    free(gNodes[i].branch);
  }
  free(gNodes);
  gNodes = 0;
}
