/*
 * ʸФƸΥꥹȤ롣
 * make_candidates()contextƤФ롣
 * proc_splitter_info() splitter鼫ΩĹ
 * Ʊ˸Ԥ
 */
/*
 * Funded by IPA̤Ƨեȥ¤ 2001 9/30
 * Copyright (C) 2000-2002 TABATA Yusuke
 * Copyright (C) 2002 UGAWA Tomoharu
 *
 * $Id: compose.c,v 1.18 2002/06/11 12:51:49 yusuke Exp $
 */
#include <stdio.h>
#include <stdlib.h>

#include <dic.h>
#include <splitter.h>
#include "main.h"

static void push_back_noconv_candidate(struct seg_ent *);
static void push_back_singleword_candidate(struct seg_ent *);
static void push_back_candidate(struct seg_ent *, struct cand_ent *e);
static int enum_candidates(struct seg_ent *seg,
			   struct cand_ent *, int, int);
static struct cand_ent *dup_candidate(struct cand_ent *c);
static void proc_splitter_info(struct seg_ent *, struct seg_info *);
static void make_candidate_from_seginfo(struct seg_ent *, struct seg_info *);

/* Ƶ1ñ줺ĸƤƤ */
static int
enum_candidates(struct seg_ent *seg,
		struct cand_ent *c,
		int from, int n)
{
  int i, p;
  struct cand_ent *cand;
  int nr_cands = 0;

  if (n == c->si->nr_word_info) {
    /*  */
    /* ʸβϤʤäʬʸɲ */
    xstr tail;
    tail.len = seg->len - c->si->info_len;
    tail.str = &seg->str.str[c->si->info_len];
    anthy_xstrcat(&c->str, &tail);
    push_back_candidate(seg, dup_candidate(c));
    return 1;
  }

  p = anthy_get_nr_dic_ents(c->elm[n].se, &c->elm[n].str);
  /* ʻξˤ̤ѴǼñعԤ */
  if (anthy_wtype_get_pos(c->si->word_info[n].wt) == POS_INVAL || p == 0) {
    xstr xs;
    xs.len = c->si->word_info[n].len;
    xs.str = &seg->str.str[from];
    cand = dup_candidate(c);
    cand->elm[n].nth = -1;
    anthy_xstrcat(&cand->str, &xs);
    nr_cands = enum_candidates(seg,cand,
			       from+c->si->word_info[n].len,
			       n + 1);
    anthy_release_cand_ent(cand);
    return nr_cands;
  }

  /* ʻ줬ƤƤΤǡʻ˥ޥåΤƤ */
  for (i = 0; i < p; i++) {
    wtype_t wt;
    anthy_get_nth_dic_ent_wtype(c->elm[n].se, &c->str, i, &wt);
    if (anthy_wtypecmp(c->si->word_info[n].wt, wt)) {
      xstr xs, xs2;
      xs2.len = c->si->word_info[n].len;
      xs2.str = &seg->str.str[from];
      cand = dup_candidate(c);
      anthy_get_nth_dic_ent_str(cand->elm[n].se,
				&xs2, i, &xs);
      cand->elm[n].nth = i;
      anthy_xstrcat(&cand->str, &xs);
      /* ʬƵƤӽФ³ꤢƤ */
      nr_cands += enum_candidates(seg, cand, 
				  from + c->si->word_info[n].len,
				  n+1);
      anthy_release_cand_ent(cand);
    }
  }
  return nr_cands;
}

/*
 * ʣ
 */
static struct cand_ent *
dup_candidate(struct cand_ent *c)
{
  struct cand_ent *e;
  int i;
  e = (struct cand_ent *)malloc(sizeof(struct cand_ent));
  e->nr_words = c->nr_words;
  e->str.len = c->str.len;
  e->str.str = anthy_xstr_dup_str(&c->str);
  e->elm = malloc(sizeof(struct cand_elm)*c->nr_words);
  e->flag = c->flag;
  for ( i = 0 ; i < e->nr_words ; i++){
    e->elm[i] = c->elm[i];
  }
  e->si = c->si;
  return e;
}

static void
push_back_candidate(struct seg_ent *se, struct cand_ent *ce)
{
  /* seg_ent˸eɲ */
  se->cand_count++;
  se->cands = (struct cand_ent **)
    realloc(se->cands, sizeof(struct cand_ent *)*se->cand_count);
  se->cands[se->cand_count - 1] = ce;
}

/*
 * ʸΤޤñ(ñޤ)θ
 */
static void
push_back_singleword_candidate(struct seg_ent *seg)
{
  seq_ent_t se;
  struct cand_ent *ce;
  wtype_t wt;
  int i, n;
  xstr xs;

  se = anthy_get_seq_ent_from_xstr(&seg->str);
  n = anthy_get_nr_dic_ents(se, &seg->str);
  /* γƥȥФ */
  for (i = 0; i < n; i++) {
    int ct;
    /* ʻФ */
    anthy_get_nth_dic_ent_wtype(se, &seg->str, i, &wt);
    ct = anthy_wtype_get_ct(wt);
    /* ߷ѤʤΤθʤ */
    if (ct == CT_SYUSI || ct == CT_NONE) {
      ce = (struct cand_ent *)malloc(sizeof(struct cand_ent));
      anthy_get_nth_dic_ent_str(se,&seg->str, i, &xs);
      ce->nr_words = 0;
      ce->str.str = xs.str;
      ce->str.len = xs.len;
      ce->elm = 0;
      ce->flag = CEF_SINGLEWORD;
      ce->si = 0;
      push_back_candidate(seg, ce);
    }
  }
}

static void
push_back_noconv_candidate(struct seg_ent *seg)
{
  /* ̵ѴҲ̾ˤʤʿ̾Τߤˤʤɲ */
  struct cand_ent *e;
  xstr *xs;

  /* Ҥ餬ʤΤ */
  e = (struct cand_ent *)malloc(sizeof(struct cand_ent));
  e->nr_words = 0;
  e->str.str = anthy_xstr_dup_str(&seg->str);
  e->str.len = seg->str.len;
  e->elm = 0;
  e->si = 0;
  e->flag = CEF_HIRAGANA;
  push_back_candidate(seg, e);

  /* ˥ */
  e = (struct cand_ent *)malloc(sizeof(struct cand_ent));
  e->nr_words = 0;
  xs = anthy_xstr_hira_to_kata(&seg->str);
  e->str.str = anthy_xstr_dup_str(xs);
  e->str.len = xs->len;
  e->elm = 0;
  e->flag = CEF_KATAKANA;
  e->si = 0;
  anthy_free_xstr(xs);
  push_back_candidate(seg, e);
}

static void
make_candidate_from_seginfo(struct seg_ent *se,
			    struct seg_info *si)
{
  /*
   * ñʻ줬ꤵ줿֤ǥߥåȤ롣
   */
  struct cand_ent *c;
  int i, from;

  /* ʣ(1ޤ)ñǹʸñƤƤ */
  c = (struct cand_ent *)malloc(sizeof(struct cand_ent));
  c->nr_words = si->nr_word_info;
  c->str.str = 0;
  c->str.len = 0;
  c->elm = malloc(sizeof(struct cand_elm)*c->nr_words);
  c->si = si;
  from = 0;
  /* ʸι¤ξ˥ԡ */
  for (i = 0; i < si->nr_word_info; i++) {
    c->elm[i].wt = si->word_info[i].wt;
    c->elm[i].bias = si->word_info[i].bias;
    c->elm[i].str.str = &se->str.str[from];
    c->elm[i].str.len = si->word_info[i].len;
    c->elm[i].se = anthy_get_seq_ent_from_xstr(&c->elm[i].str);
    from += si->word_info[i].len;
  }
  c->flag = CEF_NONE;
  enum_candidates(se, c, 0, 0);
  anthy_release_cand_ent(c);
}

/*
 * splitterξѤƸ
 */
static void
proc_splitter_info(struct seg_ent *se,
		   struct seg_info *si)
{
  switch (si->type) {
  case SI_NORMAL:
    make_candidate_from_seginfo(se, si);
    break;
  case SI_CAND:
    {
      {
	struct cand_ent *ce;
	ce = (struct cand_ent*)malloc(sizeof(struct cand_ent));
	ce->nr_words = 0;
	ce->str.str = anthy_xstr_dup_str(&si->cand);
	ce->str.len = si->cand.len;
	ce->elm = 0;
	ce->flag = CEF_OCHAIRE;
	ce->si = si;
	if (si->info_len < se->len) {
	  /* seginfoǥСƤʤΰʸդ */
	  xstr xs;
	  xs.str = &se->str.str[si->info_len];
	  xs.len = se->len - si->info_len;
	  anthy_xstrcat(&ce->str ,&xs);
	}
	push_back_candidate(se, ce);
      }
      break;
    }
  }
}

/*
 * context.cƽФäȤʪ
 * İʾθɬ
 */
void
anthy_make_candidates(struct seg_ent *se)
{
  int i, limit = 0;

  if (se->nr_seginfo) {
    limit = se->si[0]->score * 2;
  }

  for (i = 0; i < se->nr_seginfo; i++) {
    if (se->si[i]->score < limit) {
      proc_splitter_info(se, se->si[i]);
    }
  }

  /* ñʤɤθ */
  push_back_singleword_candidate(se);
  /* Ҥ餬ʡʤ̵Ѵȥ */
  push_back_noconv_candidate(se);
}

void
anthy_make_seginfo_array(struct anthy_context *ac,
			 struct seg_ent *se)
{
  int i;
  se->si = 0;
  for (i = se->len; i > 0; i--) {
    int j;
    /* ǸȤĤƤľʸ */
    if (i < se->len &&
	anthy_get_xchar_type(se->str.str[i]) & XCT_PART) {
      /* FIXME Ȥꤨʤ¤Ӥ򤷤Ƥ */
      i--;
      continue ;
    }
    se->nr_seginfo = anthy_get_nr_seginfo(&ac->split_info, se->from, i);
    if (!se->nr_seginfo) {
      continue ;
    }
    /* seginfo˼ */
    se->si = malloc(sizeof(struct seg_info*) * se->nr_seginfo);
    for (j = 0; j < se->nr_seginfo; j++) {
      se->si[j] = anthy_get_nth_seginfo(&ac->split_info, se->from, i, j);
    }
    return ;
  }
}
