#! /usr/bin/ruby
# EUC-JP/ˤۤ
require 'anthy';

Anthy::quit()

Anthy::conf_override("CONFFILE","../anthy-conf")
Anthy::conf_override("DIC_FILE","../mkanthydic/anthy.dic")
Anthy::conf_override("ANTHYDIR",ENV['SRCDIR']+"/depgraph")

Anthy::init()

Anthy::set_personality("")

$ac = Anthy::Context.new();

class Test
  def initialize(n ,s, ex)
    @src_array = s;
    @exp_array = ex;
    @src_str = ""
    for x in @src_array
      @src_str = @src_str + x
    end
  end
  def check(verbose)
    do_conv()
    if (!do_compare()) then
      if (verbose) then
        $ac.print()
      end
      return false
    end
    return true
  end
  def do_conv
    $ac.set_string(@src_str);
  end
  def do_compare
    n = 0
    if (@src_array.length != $ac.get_stat.nr_segment) then
      return false
    end
    for x in @src_array
      if ($ac.get_segment(n, -1) != x) then
        return false
      end
      n = n + 1
    end
    return true
  end
end

class TestManager
  def initialize
    @tests = []
  end
  def add(n, str, ex)
    t = Test.new(n, str, ex);
    @tests.push(t)
  end
  def test(verbose, cond)
    nr = 0
    ng = 0
    for t in @tests
      if (!t.check(verbose)) then
        ng = ng + 1
      end
      nr = nr + 1
    end
    print nr
    print "tests, "
    print (nr-ng)
    print "hits, "
    print ng
    print " misses\n"
    print (nr-ng) * 100 / nr
    print "%\n"
  end
end

m = TestManager.new
m.add(0, ["Ǥʤ","Ф","ޤ"], [])
m.add(0, ["Ǥʤ","դ"], [])
m.add(0, ["꤫Τ","ޤ","뤤","ʤǤ"], [])
m.add(0, ["꤬Ǥ"], [])
m.add(0, ["","","Τ"],[])
m.add(0, ["ä","Ĥ","ʤä"],[])
m.add(0, ["äƤ"],[])
m.add(0, ["줿","ܤ","ʤΤ","ϤäƤ","餤","Τʤ"], [])
m.add(0, ["ʤ","󤼤","褦礯"], [])
m.add(0, ["ĤƤʤ","Ȥ","","ʤƤʤǤɤ"], [])
m.add(0, ["Ϥʤ"], [])
m.add(0, ["",""], [])
m.add(0, ["Ƥ","","դ󤫤","ä","Ǥ","󤬤Ƥޤ"], [])
m.add(0, ["Ȥ"], [])
m.add(0, ["Ϥ","ʤ褦"], [])
m.add(0, ["Ϥ","ʤ"],[])
m.add(0, ["äƤ"], [])
m.add(0, ["äȤ"], [])
m.add(0, ["󤬤Ƥ","Ȥ","äǤ"], [])
m.add(0, ["󤬤ƤߤޤΤ"],[])
m.add(0, ["󤬤ʤ"], [])
m.add(0, ["","ब","礦ۤ",""], [])
m.add(0, ["Ƥ뤫","⤤ޤ"], [])
m.add(0, ["礦","Ƥ"], [])
m.add(0, ["礦"], [])
m.add(0, ["Ĥ", "ߤ", "줤", ""], [])
m.add(0, ["ۤ","󤸤","ؤ󤳤"], [])
m.add(0, ["","call-with-current-continuation",""],[])
m.add(0, ["","դ","ˤ夦礯줿","桼","ʤޤ"], [])
m.add(0, ["󤽡","褦","ˤۤ󤴤ˤ夦礯","פ","餷","С","꡼ޤ"], [])
m.add(0, ["󤷤ʤ",""], [])
m.add(0, ["Ƥ뤫","⤤ޤ"], [])
m.add(0, ["", "Ĥ"], [])
m.add(0, ["褦", ""], [])
m.add(0, ["礷󤷤Ǥ","Ƥ"], [])
m.add(0, ["ʤ",""],[])
m.add(0, ["","Ĥ","ޤ","Ϥ"],[])
m.add(0, ["ä", "", "", "", "ȤӤ", "֤"], [])
m.add(0, ["礦","ƤȤ","֤"], [])
m.add(0, ["Τ"], [])
m.add(0, ["Τ⤢"], [])
m.add(0, ["Ĥ褤","Ҥ"], [])
m.add(0, ["Ǥ","ޤ줿"], [])
m.add(0, ["ɤʤ뤫","󤬤"], [])
m.add(0, ["Ȥʤ"], [])
m.add(0, ["ʤ","ۤ","󤵤","","ʤ"],[])
m.add(0, ["ˤۤ󤸤","󤭤礦ʤ","ruby","ᤤʤǤ礦"], [])
m.add(0, ["ˤۤ","ؤ󤫤","Ƥ"],[])
m.add(0, ["Τ","Ǥ"],[])
m.add(0, ["Τ",""],[])
m.add(0, ["᤬","Ϥʤޤ"], [])
m.add(0, ["ޤ","Ϥ䤤","äΤ"], [])
m.add(0, ["餤","礦"], [])
m.add(0, ["錄",""],[])
m.add(0, ["錄","ʤޤ", "ФǤ"], [])
m.add(0, ["錄","ʤޤ", "ʤΤǤ"], [])
m.add(0, ["ruby","anthy","Ĥ褦ˤʤä"], [])
m.add(0, ["uim-fep","餷","С"], [])
m.add(0, ["100ˤ"],[])
m.add(0, ["3礯"],[])
#
m.add(0, ["礦","Ƥ餦","ȤˤʤǤ"], [])
m.add(0, ["ɤ","Τ","API","ҤĤ褦","ɤ"], [])
m.add(0, ["ߤΤƤޤ"], [])
m.add(0, ["ä","ޤ"], ["ä","ޤ"])
m.add(0, ["ä褦",""],[])
m.add(0, ["Ƥ"],[])
m.add(0, ["錄","碌","äƤΤǤ礦"],[])
m.add(0, ["֤ޤ","դ餰"],[])
m.add(0, ["󤼤","ۤ","狼ޤ"],[])
m.add(0, ["狼ޤ"],[])
m.add(0, ["","褦ȤƤ"],[])
m.add(0, ["ä","ޤ"],[])
m.add(0, ["Ĥ","ۤ"],[])
m.add(0, ["","ä","졼","","Ƥ"],[])
m.add(0, ["ƤʤǤ礦"],[])
m.add(0, ["Ĥ褦","Ф","","礦"],[])
m.add(0, ["Ȥޤ","Ƥޤ"],[])
m.add(0, ["礦","ʤȤ","ҤĤ褦"],[])
m.add(0, ["Ϥʤ","Ȥʤ","ޤ󤷡","Τǡ","ʤ","","ޤ"],[])
m.add(0, ["","Τ","ʤǤ"], [])
m.add(0, ["Τ","Ϥ褦","뤳Ȥ","夦褦"],[])
m.add(0, ["ۤ","äѤĤ","","","ޤ"],[])
m.add(0, ["ȤȤĤ","ˤä","","ߤ褦","äΤ"],[])
m.add(0, ["Ȥʤ"],[])
m.add(0, ["ߤ","Ȥʤ"],[])
m.add(0, ["फ󤷤","褽"],[])
m.add(0, ["Ҥ"],[])
m.add(0, ["󤫤Ƥ"],[])
m.add(0, ["̤ʤ"],[])
m.add(0, ["Ҥ"],[])
m.add(0, ["󤿤ä"],[])
m.add(0, ["ߤʤǤ"],[])
m.add(0, ["ޤä","餷","Ǥ","Τ","Ĥ󤹤"],[])

m.test(1, "all")

m2 = TestManager.new
m2.add(0, ["Ǥʤ","Ф","ޤ"], [])
m2.add(0, ["ĤƤʤ","Ȥ","","ʤƤʤǤɤ"], [])
#m2.test(1, "all")
