/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayMap
extends AbstractMap
implements Map,
Cloneable,
Externalizable {
    static final long serialVersionUID = 1L;
    private static final int INITIAL_CAPACITY = 17;
    private static final float LOAD_FACTOR = 0.75f;
    private transient int threshold;
    private transient Entry[] mapTable;
    private transient Entry[] listTable;
    private transient int size = 0;
    private transient Set entrySet = null;

    public ArrayMap() {
        this(17);
    }

    public ArrayMap(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 17;
        }
        this.mapTable = new Entry[initialCapacity];
        this.listTable = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * 0.75f);
    }

    public ArrayMap(Map map) {
        this((int)((float)map.size() / 0.75f) + 1);
        this.putAll(map);
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.indexOf(value) >= 0;
    }

    public final int indexOf(Object value) {
        if (value != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!value.equals(this.listTable[i].value)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.listTable[i].value != null) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean containsKey(Object key) {
        Entry[] tbl = this.mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % tbl.length;
            Entry e = tbl[index];
            while (e != null) {
                if (e.hashCode == hashCode && key.equals(e.key)) {
                    return true;
                }
                e = e.next;
            }
        } else {
            Entry e = tbl[0];
            while (e != null) {
                if (e.key == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object get(Object key) {
        Entry[] tbl = this.mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % tbl.length;
            Entry e = tbl[index];
            while (e != null) {
                if (e.hashCode == hashCode && key.equals(e.key)) {
                    return e.value;
                }
                e = e.next;
            }
        } else {
            Entry e = tbl[0];
            while (e != null) {
                if (e.key == null) {
                    return e.value;
                }
                e = e.next;
            }
        }
        return null;
    }

    public final Object get(int index) {
        return this.getEntry((int)index).value;
    }

    public final Object getKey(int index) {
        return this.getEntry((int)index).key;
    }

    public final Entry getEntry(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index:" + index + ", Size:" + this.size);
        }
        return this.listTable[index];
    }

    public Object put(Object key, Object value) {
        Entry e;
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % this.mapTable.length;
            e = this.mapTable[index];
            while (e != null) {
                if (e.hashCode == hashCode && key.equals(e.key)) {
                    return this.swapValue(e, value);
                }
                e = e.next;
            }
        } else {
            e = this.mapTable[0];
            while (e != null) {
                if (e.key == null) {
                    return this.swapValue(e, value);
                }
                e = e.next;
            }
        }
        this.ensureCapacity();
        index = (hashCode & Integer.MAX_VALUE) % this.mapTable.length;
        this.mapTable[index] = e = new Entry(hashCode, key, value, this.mapTable[index]);
        this.listTable[this.size++] = e;
        return null;
    }

    public final void set(int index, Object value) {
        this.getEntry(index).setValue(value);
    }

    public Object remove(Object key) {
        Entry e = this.removeMap(key);
        if (e != null) {
            Object value = e.value;
            this.removeList(this.indexOf(e));
            e.clear();
            return value;
        }
        return null;
    }

    public final Object remove(int index) {
        Entry e = this.removeList(index);
        Object value = e.value;
        this.removeMap(e.key);
        e.value = null;
        return value;
    }

    public void putAll(Map map) {
        for (Map.Entry e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public final void clear() {
        int i;
        for (i = 0; i < this.mapTable.length; ++i) {
            this.mapTable[i] = null;
        }
        for (i = 0; i < this.listTable.length; ++i) {
            this.listTable[i] = null;
        }
        this.size = 0;
    }

    public final Object[] toArray() {
        Object[] array = new Object[this.size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public final Object[] toArray(Object[] proto) {
        Object[] array = proto;
        if (proto.length < this.size) {
            array = (Object[])Array.newInstance(proto.getClass().getComponentType(), this.size);
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    @Override
    public final boolean equals(Object o) {
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        ArrayMap e = (ArrayMap)o;
        if (this.size != e.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.listTable[i].equals(e.listTable[i])) continue;
            return false;
        }
        return true;
    }

    public final Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new ArrayMapIterator();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    int index = (entry.hashCode & Integer.MAX_VALUE) % ArrayMap.this.mapTable.length;
                    Entry e = ArrayMap.this.mapTable[index];
                    while (e != null) {
                        if (e.equals(entry)) {
                            return true;
                        }
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    return ArrayMap.this.remove(entry.key) != null;
                }

                @Override
                public int size() {
                    return ArrayMap.this.size;
                }

                @Override
                public void clear() {
                    ArrayMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.listTable.length);
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeObject(this.listTable[i].key);
            out.writeObject(this.listTable[i].value);
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int num = in.readInt();
        this.mapTable = new Entry[num];
        this.listTable = new Entry[num];
        this.threshold = (int)((float)num * 0.75f);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    @Override
    public Object clone() {
        ArrayMap copy = new ArrayMap();
        copy.threshold = this.threshold;
        copy.mapTable = this.mapTable;
        copy.listTable = this.listTable;
        copy.size = this.size;
        return copy;
    }

    private final int indexOf(Entry entry) {
        for (int i = 0; i < this.size; ++i) {
            if (this.listTable[i] != entry) continue;
            return i;
        }
        return -1;
    }

    private final Entry removeMap(Object key) {
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % this.mapTable.length;
            Entry e = this.mapTable[index];
            Entry prev = null;
            while (e != null) {
                if (e.hashCode == hashCode && key.equals(e.key)) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        this.mapTable[index] = e.next;
                    }
                    return e;
                }
                prev = e;
                e = e.next;
            }
        } else {
            Entry e = this.mapTable[index];
            Entry prev = null;
            while (e != null) {
                if (e.hashCode == hashCode && e.key == null) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        this.mapTable[index] = e.next;
                    }
                    return e;
                }
                prev = e;
                e = e.next;
            }
        }
        return null;
    }

    private final Entry removeList(int index) {
        Entry e = this.listTable[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.listTable, index + 1, this.listTable, index, numMoved);
        }
        this.listTable[--this.size] = null;
        return e;
    }

    private final void ensureCapacity() {
        if (this.size >= this.threshold) {
            Entry[] oldTable = this.listTable;
            int newCapacity = oldTable.length * 2 + 1;
            Entry[] newMapTable = new Entry[newCapacity];
            Entry[] newListTable = new Entry[newCapacity];
            this.threshold = (int)((float)newCapacity * 0.75f);
            System.arraycopy(oldTable, 0, newListTable, 0, this.size);
            for (int i = 0; i < this.size; ++i) {
                Entry old = oldTable[i];
                int index = (old.hashCode & Integer.MAX_VALUE) % newCapacity;
                Entry e = old;
                old = old.next;
                e.next = newMapTable[index];
                newMapTable[index] = e;
            }
            this.mapTable = newMapTable;
            this.listTable = newListTable;
        }
    }

    private final Object swapValue(Entry entry, Object value) {
        Object old = entry.value;
        entry.value = value;
        return old;
    }

    private static class Entry
    implements Map.Entry,
    Externalizable {
        private static final long serialVersionUID = -6625980241350717177L;
        transient int hashCode;
        transient Object key;
        transient Object value;
        transient Entry next;

        public Entry(int hashCode, Object key, Object value, Entry next) {
            this.hashCode = hashCode;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = value;
            this.value = value;
            return oldValue;
        }

        public void clear() {
            this.key = null;
            this.value = null;
            this.next = null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Entry e = (Entry)o;
            return (this.key != null ? this.key.equals(e.key) : e.key == null) && (this.value != null ? this.value.equals(e.value) : e.value == null);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public void writeExternal(ObjectOutput s) throws IOException {
            s.writeInt(this.hashCode);
            s.writeObject(this.key);
            s.writeObject(this.value);
            s.writeObject(this.next);
        }

        @Override
        public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
            this.hashCode = s.readInt();
            this.key = s.readObject();
            this.value = s.readObject();
            this.next = (Entry)s.readObject();
        }
    }

    private class ArrayMapIterator
    implements Iterator {
        private int current = 0;
        private int last = -1;

        private ArrayMapIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current != ArrayMap.this.size;
        }

        public Object next() {
            try {
                Entry n = ArrayMap.this.listTable[this.current];
                this.last = this.current++;
                return n;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            ArrayMap.this.remove(this.last);
            if (this.last < this.current) {
                --this.current;
            }
            this.last = -1;
        }
    }
}

