/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.type;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.IOUtil;

public class DefaultValueType
implements ValueType {
    @Override
    public Object get(Class<?> type, ResultSet rs, int columnIndex) throws SQLException {
        if (type == String.class) {
            return rs.getString(columnIndex);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return rs.getInt(columnIndex);
        }
        if (type == Long.class || type == Long.TYPE) {
            return rs.getLong(columnIndex);
        }
        if (type == Short.class || type == Short.TYPE) {
            return rs.getShort(columnIndex);
        }
        if (type == Double.class || type == Double.TYPE) {
            return rs.getDouble(columnIndex);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(rs.getFloat(columnIndex));
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return rs.getBoolean(columnIndex);
        }
        if (type == BigDecimal.class) {
            return rs.getBigDecimal(columnIndex);
        }
        if (type == java.sql.Date.class) {
            return rs.getDate(columnIndex);
        }
        if (type == Date.class) {
            return new Date(rs.getTimestamp(columnIndex).getTime());
        }
        if (type == Time.class) {
            return rs.getTime(columnIndex);
        }
        if (type == Timestamp.class) {
            return rs.getTimestamp(columnIndex);
        }
        if (type.isArray() && type.getComponentType() == Byte.TYPE) {
            return IOUtil.readStream(rs.getBinaryStream(columnIndex));
        }
        throw new RuntimeException("Unsupported type: " + type.getName());
    }

    @Override
    public Object get(Class<?> type, ResultSet rs, String columnName) throws SQLException {
        if (type == String.class) {
            return rs.getString(columnName);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return rs.getInt(columnName);
        }
        if (type == Long.class || type == Long.TYPE) {
            return rs.getLong(columnName);
        }
        if (type == Short.class || type == Short.TYPE) {
            return rs.getShort(columnName);
        }
        if (type == Double.class || type == Double.TYPE) {
            return rs.getDouble(columnName);
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(rs.getFloat(columnName));
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return rs.getBoolean(columnName);
        }
        if (type == BigDecimal.class) {
            return rs.getBigDecimal(columnName);
        }
        if (type == java.sql.Date.class) {
            return rs.getDate(columnName);
        }
        if (type == Date.class) {
            return new Date(rs.getTimestamp(columnName).getTime());
        }
        if (type == Time.class) {
            return rs.getTime(columnName);
        }
        if (type == Timestamp.class) {
            return rs.getTimestamp(columnName);
        }
        if (type.isArray() && type.getComponentType() == Byte.TYPE) {
            return IOUtil.readStream(rs.getBinaryStream(columnName));
        }
        throw new RuntimeException("Unsupported type: " + type.getName());
    }

    @Override
    public void set(Class<?> type, PreparedStatement stmt, Object value, int index) throws SQLException {
        if (type == String.class) {
            stmt.setString(index, (String)value);
        } else if (type == Integer.class || type == Integer.TYPE) {
            stmt.setInt(index, (Integer)value);
        } else if (type == Long.class || type == Long.TYPE) {
            stmt.setLong(index, (Long)value);
        } else if (type == Short.class || type == Short.TYPE) {
            stmt.setShort(index, (Short)value);
        } else if (type == Double.class || type == Double.TYPE) {
            stmt.setDouble(index, (Double)value);
        } else if (type == Float.class || type == Float.TYPE) {
            stmt.setFloat(index, ((Float)value).floatValue());
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            stmt.setBoolean(index, (Boolean)value);
        } else if (type == BigDecimal.class) {
            stmt.setBigDecimal(index, (BigDecimal)value);
        } else if (type == java.sql.Date.class) {
            stmt.setDate(index, (java.sql.Date)value);
        } else if (type == Date.class) {
            stmt.setTimestamp(index, new Timestamp(((Date)value).getTime()));
        } else if (type == Time.class) {
            stmt.setTime(index, (Time)value);
        } else if (type == Timestamp.class) {
            stmt.setTimestamp(index, (Timestamp)value);
        } else if (type.isArray() && type.getComponentType() == Byte.TYPE) {
            stmt.setBinaryStream(index, new ByteArrayInputStream((byte[])value));
        } else {
            throw new RuntimeException("Unsupported type: " + type.getName());
        }
    }

    @Override
    public boolean isSupport(Class<?> type) {
        return type == String.class || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Short.class || type == Short.TYPE || type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE || type == Boolean.class || type == Boolean.TYPE || type == BigDecimal.class || type == Date.class || type == Time.class || type == Timestamp.class || type.isArray() && type.getComponentType() == Byte.TYPE;
    }
}

