/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.session;

import java.sql.Connection;
import java.sql.DriverManager;
import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.SqlManagerImpl;
import jp.sf.amateras.mirage.exception.SessionException;
import jp.sf.amateras.mirage.provider.DefaultConnectionProvider;
import jp.sf.amateras.mirage.session.Session;

public class JDBCSessionImpl
implements Session {
    private SqlManager sqlManager;
    private DefaultConnectionProvider provider;
    private String driver;
    private String url;
    private String user;
    private String password;

    public JDBCSessionImpl(String driver, String url, String user, String password) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        this.sqlManager = new SqlManagerImpl();
        this.provider = new DefaultConnectionProvider();
        this.sqlManager.setConnectionProvider(this.provider);
    }

    @Override
    public void begin() throws SessionException {
        try {
            Class.forName(this.driver);
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            conn.setAutoCommit(false);
            this.provider.setConnection(conn);
        }
        catch (Exception ex) {
            throw new SessionException("Failed to begin transaction.", ex);
        }
    }

    @Override
    public void commit() throws SessionException {
        try {
            this.provider.getConnection().commit();
        }
        catch (Exception ex) {
            throw new SessionException("Failed to commit transaction.", ex);
        }
    }

    @Override
    public SqlManager getSqlManager() throws SessionException {
        return this.sqlManager;
    }

    @Override
    public void release() throws SessionException {
        if (this.provider instanceof DefaultConnectionProvider) {
            this.provider.releaseConnection();
        }
    }

    @Override
    public void rollback() throws SessionException {
        try {
            this.provider.getConnection().rollback();
        }
        catch (Exception ex) {
            throw new SessionException("Failed to rollback transaction.", ex);
        }
    }
}

