/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.provider;

import java.sql.Connection;
import java.util.logging.Logger;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.util.JdbcUtil;

public class DefaultConnectionProvider
implements ConnectionProvider {
    private static final Logger logger = Logger.getLogger(DefaultConnectionProvider.class.getName());
    private ThreadLocal<Connection> threadLocal = new ThreadLocal();

    public void setConnection(Connection conn) {
        this.threadLocal.set(conn);
    }

    public void releaseConnection() {
        Connection conn = this.threadLocal.get();
        if (conn != null) {
            JdbcUtil.close(conn);
            this.threadLocal.remove();
            logger.info("Connection is released.");
        } else {
            logger.info("Connection is not used.");
        }
    }

    @Override
    public Connection getConnection() {
        return this.threadLocal.get();
    }
}

